/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.network;

import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.WritableMessage;
import fuzs.puzzleslib.api.network.v4.message.play.ClientboundPlayMessage;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class ClientboundRemoveMerchantsMessage
implements ClientboundPlayMessage,
WritableMessage<RegistryFriendlyByteBuf> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundRemoveMerchantsMessage> STREAM_CODEC = WritableMessage.streamCodec(ClientboundRemoveMerchantsMessage::new);
    private final int containerId;
    private final IntSet merchantIds;

    public ClientboundRemoveMerchantsMessage(int containerId, IntSet merchantIds) {
        this.containerId = containerId;
        this.merchantIds = merchantIds;
    }

    private ClientboundRemoveMerchantsMessage(RegistryFriendlyByteBuf buf) {
        this.containerId = buf.readVarInt();
        int length = buf.readVarInt();
        IntOpenHashSet merchantIds = new IntOpenHashSet();
        for (int i = 0; i < length; ++i) {
            merchantIds.add(buf.readInt());
        }
        this.merchantIds = merchantIds;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.containerId);
        buf.writeVarInt(this.merchantIds.size());
        IntIterator intIterator = this.merchantIds.iterator();
        while (intIterator.hasNext()) {
            int merchantId = (Integer)intIterator.next();
            buf.writeInt(merchantId);
        }
    }

    public MessageListener<ClientboundPlayMessage.Context> getListener() {
        return new MessageListener<ClientboundPlayMessage.Context>(){

            public void accept(ClientboundPlayMessage.Context context) {
                AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
                if (abstractContainerMenu instanceof TradingPostMenu) {
                    TradingPostMenu menu = (TradingPostMenu)abstractContainerMenu;
                    if (ClientboundRemoveMerchantsMessage.this.containerId == menu.containerId) {
                        abstractContainerMenu = ClientboundRemoveMerchantsMessage.this.merchantIds.iterator();
                        while (abstractContainerMenu.hasNext()) {
                            int merchantId = (Integer)abstractContainerMenu.next();
                            menu.getTraders().removeMerchant(merchantId);
                        }
                    }
                }
            }
        };
    }
}

