/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.entity.npc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.network.ClientboundBuildOffersMessage;
import fuzs.tradingpost.network.ClientboundMerchantDataMessage;
import fuzs.tradingpost.network.ClientboundRemoveMerchantsMessage;
import fuzs.tradingpost.world.entity.npc.LocalMerchant;
import fuzs.tradingpost.world.item.trading.TradingPostOffers;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MerchantCollection
implements Merchant {
    private final Int2ObjectOpenHashMap<Merchant> idToMerchant = new Int2ObjectOpenHashMap();
    private final Set<MerchantOffer> disabledOffers = Sets.newHashSet();
    private final ContainerLevelAccess access;
    private MerchantOffers allOffers = new MerchantOffers();
    private Object2ObjectOpenHashMap<MerchantOffer, Merchant> offerToMerchant;
    private Merchant currentMerchant;

    public MerchantCollection() {
        this(ContainerLevelAccess.NULL);
    }

    public MerchantCollection(ContainerLevelAccess access) {
        this.access = access;
    }

    public void addMerchant(int entityId, Merchant merchant) {
        if (!merchant.getOffers().isEmpty()) {
            this.idToMerchant.put(entityId, (Object)merchant);
        }
    }

    @Nullable
    public Player getTradingPlayer() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.getTradingPlayer();
        }
        return null;
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.idToMerchant.values().forEach(merchant -> merchant.setTradingPlayer(player));
    }

    public MerchantOffers getOffers() {
        return this.allOffers;
    }

    public boolean checkOffer(MerchantOffer offer) {
        return !this.disabledOffers.contains(offer);
    }

    public void overrideOffers(@Nullable MerchantOffers p_213703_1_) {
        TradingPost.LOGGER.error("Set offers to stored merchants directly");
    }

    public void notifyTrade(MerchantOffer offer) {
        if (this.currentMerchant != null) {
            this.currentMerchant.notifyTrade(offer);
            if (!((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).teleportXp) {
                return;
            }
            this.access.execute((level, pos) -> {
                Merchant patt0$temp = this.currentMerchant;
                if (patt0$temp instanceof Entity) {
                    Entity entity = (Entity)patt0$temp;
                    Vec3 merchantPos = entity.position().add(0.0, 0.5, 0.0);
                    double xpWidth = 0.5;
                    double xpHeight = 0.5;
                    List xpRewards = level.getEntitiesOfClass(ExperienceOrb.class, new AABB(merchantPos.add(-0.5, -0.5, -0.5), merchantPos.add(0.5, 0.5, 0.5)), Entity::isAlive);
                    for (ExperienceOrb xpOrb : xpRewards) {
                        level.addFreshEntity((Entity)new ExperienceOrb(level, (double)pos.getX(), (double)pos.getY() + 1.5, (double)pos.getZ(), xpOrb.getValue()));
                        xpOrb.discard();
                    }
                }
            });
        }
    }

    public void notifyTradeUpdated(ItemStack stack) {
        if (this.currentMerchant != null) {
            this.currentMerchant.notifyTradeUpdated(stack);
        }
    }

    public boolean isClientSide() {
        return this.access == ContainerLevelAccess.NULL;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public int getVillagerXp() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.getVillagerXp();
        }
        return 0;
    }

    public Merchant getCurrentMerchant() {
        return this.currentMerchant;
    }

    public boolean canRestock() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.canRestock();
        }
        return false;
    }

    public void overrideXp(int xpValue) {
        if (this.currentMerchant != null) {
            this.currentMerchant.overrideXp(xpValue);
        }
    }

    public boolean showProgressBar() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.showProgressBar();
        }
        return false;
    }

    public SoundEvent getNotifyTradeSound() {
        if (this.currentMerchant != null) {
            return this.currentMerchant.getNotifyTradeSound();
        }
        return SoundEvents.VILLAGER_YES;
    }

    public int getTraderLevel() {
        if (this.currentMerchant != null) {
            Merchant merchant = this.currentMerchant;
            if (merchant instanceof LocalMerchant) {
                return ((LocalMerchant)merchant).getMerchantLevel();
            }
            if (merchant instanceof VillagerDataHolder) {
                return ((VillagerDataHolder)merchant).getVillagerData().level();
            }
        }
        return 0;
    }

    @Nullable
    public Component getDisplayName() {
        if (this.currentMerchant != null) {
            Merchant merchant = this.currentMerchant;
            if (merchant instanceof LocalMerchant) {
                return ((LocalMerchant)merchant).getDisplayName();
            }
            if (merchant instanceof Entity) {
                return ((Entity)merchant).getDisplayName();
            }
        }
        return null;
    }

    public boolean updateAvailableMerchants(ServerPlayer serverPlayer, int containerId, BlockPos pos, boolean testRange) {
        IntOpenHashSet toRemove = new IntOpenHashSet();
        for (Map.Entry entry : this.idToMerchant.int2ObjectEntrySet()) {
            if (!(entry.getValue() instanceof Entity) || ((Merchant)entry.getValue()).getTradingPlayer() == serverPlayer && (!testRange || this.traderInRange((Entity)entry.getValue(), pos))) continue;
            toRemove.add(((Integer)entry.getKey()).intValue());
        }
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this::removeMerchant);
            MessageSender.broadcast((PlayerSet)PlayerSet.ofPlayer((ServerPlayer)serverPlayer), (Message)new ClientboundRemoveMerchantsMessage(containerId, (IntSet)toRemove));
        }
        return !this.idToMerchant.isEmpty();
    }

    private boolean traderInRange(Entity entity, BlockPos pos) {
        return this.traderInRange(entity, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    private boolean traderInRange(Entity entity, double posX, double posY, double posZ) {
        return Math.abs(entity.getX() - posX) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange && Math.abs(entity.getY() - posY) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).verticalRange && Math.abs(entity.getZ() - posZ) <= (double)((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange;
    }

    public void removeMerchant(int merchantId) {
        Merchant merchant = (Merchant)this.idToMerchant.get(merchantId);
        if (merchant != null) {
            this.disabledOffers.addAll((Collection<MerchantOffer>)merchant.getOffers());
            this.idToMerchant.remove(merchantId);
            merchant.setTradingPlayer(null);
            if (this.currentMerchant == merchant) {
                this.currentMerchant = null;
            }
        }
    }

    public void setActiveOffer(MerchantOffer offer) {
        if (this.offerToMerchant != null) {
            this.currentMerchant = offer != null ? (Merchant)this.offerToMerchant.get((Object)offer) : null;
        }
    }

    public void sendMerchantData(ServerPlayer serverPlayer, int containerId) {
        for (Map.Entry entry : this.idToMerchant.int2ObjectEntrySet()) {
            int n;
            Component merchantTitle;
            Merchant merchant = (Merchant)entry.getValue();
            Component component = merchantTitle = merchant instanceof Entity ? ((Entity)merchant).getDisplayName() : TradingPostBlockEntity.CONTAINER_COMPONENT;
            if (merchant instanceof VillagerDataHolder) {
                VillagerDataHolder villagerDataHolder = (VillagerDataHolder)merchant;
                n = villagerDataHolder.getVillagerData().level();
            } else {
                n = 0;
            }
            int merchantLevel = n;
            ClientboundMerchantDataMessage message = new ClientboundMerchantDataMessage(containerId, (Integer)entry.getKey(), merchantTitle, merchant.getOffers(), merchantLevel, merchant.getVillagerXp(), merchant.showProgressBar(), merchant.canRestock());
            MessageSender.broadcast((PlayerSet)PlayerSet.ofPlayer((ServerPlayer)serverPlayer), (Message)message);
        }
        MessageSender.broadcast((PlayerSet)PlayerSet.ofPlayer((ServerPlayer)serverPlayer), (Message)new ClientboundBuildOffersMessage(containerId, this.getIdToOfferCountMap()));
    }

    public Int2IntOpenHashMap getIdToOfferCountMap() {
        return this.idToMerchant.int2ObjectEntrySet().stream().collect(Collectors.toMap(Int2ObjectMap.Entry::getIntKey, entry -> ((Merchant)entry.getValue()).getOffers().size(), (o1, o2) -> o1, Int2IntOpenHashMap::new));
    }

    public void buildOffers(Int2IntOpenHashMap idToOfferCount) {
        ArrayList sortedEntries = Lists.newArrayList((Iterable)idToOfferCount.int2IntEntrySet());
        sortedEntries.sort(Comparator.comparingInt(Int2IntMap.Entry::getIntKey));
        TradingPostOffers allOffers = new TradingPostOffers(this.disabledOffers);
        for (Int2IntMap.Entry entry : sortedEntries) {
            Merchant merchant = (Merchant)this.idToMerchant.get(entry.getIntKey());
            for (int i = 0; i < entry.getIntValue(); ++i) {
                MerchantOffer offer;
                if (merchant != null && i < merchant.getOffers().size()) {
                    offer = (MerchantOffer)merchant.getOffers().get(i);
                } else {
                    offer = MerchantCollection.fakeOffer();
                    this.disabledOffers.add(offer);
                }
                allOffers.add(offer);
            }
        }
        this.allOffers = allOffers;
        this.buildOfferToMerchantMap();
    }

    private void buildOfferToMerchantMap() {
        Object2ObjectOpenHashMap offerToMerchant = new Object2ObjectOpenHashMap();
        for (Merchant merchant : this.idToMerchant.values()) {
            merchant.getOffers().forEach(offer -> offerToMerchant.put(offer, (Object)merchant));
        }
        this.offerToMerchant = offerToMerchant;
    }

    private static MerchantOffer fakeOffer() {
        return new MerchantOffer(new ItemCost((ItemLike)Items.AIR), ItemStack.EMPTY, -1, -1, 0.0f);
    }
}

