/*
 * Decompiled with CFR 0.152.
 */
package net.lugo.lightoverlay;

import net.lugo.lightoverlay.OverlayRenderer;
import net.lugo.lightoverlay.config.ModConfig;
import net.lugo.lightoverlay.renderers.CarpetOverlayRenderer;
import net.lugo.lightoverlay.renderers.CrossOverlayRenderer;
import net.lugo.lightoverlay.renderers.MarkerOverlayRenderer;
import net.lugo.lightoverlay.renderers.NumberOverlayRenderer;
import net.lugo.lightoverlay.util.HudMessage;
import net.lugo.lightoverlay.util.OverlayChecker;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class OverlayManager {
    private static boolean activated = false;
    private static final class_310 MC = class_310.method_1551();

    public static void toggle() {
        activated = !activated;
        class_5250 message = class_2561.method_43471((String)"text.light-overlay.message.toggle.on");
        if (!activated) {
            message = class_2561.method_43471((String)"text.light-overlay.message.toggle.off");
        }
        HudMessage.show(message, class_124.field_1062);
    }

    public static void renderEnd() {
        if (OverlayManager.MC.field_1724 == null || OverlayManager.MC.field_1687 == null || !ModConfig.showWhenPaused && MC.method_1493() || !activated) {
            return;
        }
        class_243 playerPos = new class_243(OverlayManager.MC.field_1724.method_23317(), OverlayManager.MC.field_1724.method_23318(), OverlayManager.MC.field_1724.method_23321());
        OverlayRenderer activeRenderer = ModConfig.rendererType.getRenderer();
        activeRenderer.startBatch();
        for (int x = -ModConfig.scanRadius; x <= ModConfig.scanRadius; ++x) {
            for (int z = -ModConfig.scanRadius; z <= ModConfig.scanRadius; ++z) {
                if (ModConfig.cylinderMode && x * x + z * z > ModConfig.scanRadius * ModConfig.scanRadius) continue;
                for (int y = -ModConfig.scanRadiusY; y <= ModConfig.scanRadiusY; ++y) {
                    class_243 relativePos = new class_243((double)x, (double)y, (double)z);
                    class_243 pos = playerPos.method_1019(relativePos);
                    class_2338 blockPos = class_2338.method_49637((double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350);
                    if (!OverlayChecker.shouldRenderOverlay(blockPos)) continue;
                    activeRenderer.addBlock(OverlayManager.MC.field_1773.method_19418(), blockPos);
                }
            }
        }
        activeRenderer.endBatch();
    }

    public static enum OverlayRendererType {
        CARPET(new CarpetOverlayRenderer()),
        CROSS(new CrossOverlayRenderer()),
        NUMBER(new NumberOverlayRenderer()),
        MARKER(new MarkerOverlayRenderer());

        private final OverlayRenderer renderer;

        private OverlayRendererType(OverlayRenderer renderer) {
            this.renderer = renderer;
        }

        public OverlayRenderer getRenderer() {
            return this.renderer;
        }
    }
}

