/*
 * Decompiled with CFR 0.152.
 */
package bookreader.portable_jukebox;

import bookreader.portable_jukebox.PortableJukebox;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.item.ItemDiscMusic;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.Nullable;
import paulscode.sound.SoundSystem;

@Environment(value=EnvType.CLIENT)
public class SoundUtils {
    public static final String SOUND_CATEGORY = "PortableMusic";
    private static boolean started = false;
    private static boolean paused = false;
    private static ItemDiscMusic current_record;
    private static final Minecraft mc;
    private static final Lock LOCK;

    @Nullable
    private static SoundSystem get_snd() {
        return SoundEngine.getSoundSystem();
    }

    public static boolean playing() {
        SoundSystem s = SoundUtils.get_snd();
        if (s == null) {
            return false;
        }
        return SoundUtils.inLock(() -> s.playing(SOUND_CATEGORY));
    }

    public static void pause() {
        SoundSystem s = SoundUtils.get_snd();
        if (s == null) {
            return;
        }
        SoundUtils.inLock(() -> {
            paused = true;
            s.pause(SOUND_CATEGORY);
            return null;
        });
    }

    public static void unpause() {
        SoundSystem s = SoundUtils.get_snd();
        if (s == null) {
            return;
        }
        SoundUtils.inLock(() -> {
            paused = false;
            s.play(SOUND_CATEGORY);
            return null;
        });
    }

    public static void stop() {
        SoundSystem s = SoundUtils.get_snd();
        if (s == null) {
            return;
        }
        SoundUtils.inLock(() -> {
            paused = false;
            started = false;
            s.stop(SOUND_CATEGORY);
            return null;
        });
    }

    public static boolean started() {
        if (started && !SoundUtils.playing() && !paused) {
            PortableJukebox.LOGGER.info("setting started to false");
            started = false;
        }
        return started;
    }

    public static boolean started_noupdate() {
        return started;
    }

    public static ItemDiscMusic currentRecord() {
        return current_record;
    }

    public static void playRecord(ItemDiscMusic record) {
        SoundSystem snd = SoundUtils.get_snd();
        if (snd == null) {
            return;
        }
        SoundEntry record_sound = SoundRepository.SOUNDS.getSoundEntry(record.recordName);
        try {
            LOCK.lock();
            started = true;
            paused = false;
            current_record = record;
            if (snd.playing(SOUND_CATEGORY)) {
                snd.stop(SOUND_CATEGORY);
            }
            snd.backgroundMusic(SOUND_CATEGORY, record_sound.getURL(), record_sound.name, false);
            snd.setPitch(SOUND_CATEGORY, record_sound.pitch);
            snd.setVolume(SOUND_CATEGORY, SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)SoundUtils.mc.gameSettings) * record_sound.volume);
            snd.play(SOUND_CATEGORY);
        }
        finally {
            LOCK.unlock();
        }
        if (record.recordAuthor != null) {
            SoundUtils.mc.hudIngame.setRecordPlayingMessage(record.recordAuthor + " - " + I18n.getInstance().translateKey(record.recordName));
        } else {
            SoundUtils.mc.hudIngame.setRecordPlayingMessage(I18n.getInstance().translateKey(record.getKey()));
        }
    }

    private static Lock getLock() {
        try {
            Field lock = SoundEngine.class.getDeclaredField("lock");
            lock.setAccessible(true);
            return (Lock)lock.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T inLock(Callable<T> callable) {
        try {
            LOCK.lock();
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            LOCK.unlock();
        }
    }

    static {
        mc = Minecraft.getMinecraft();
        LOCK = SoundUtils.getLock();
    }
}

