/*
 * Decompiled with CFR 0.152.
 */
package bookreader.portable_jukebox.gui.screen;

import bookreader.portable_jukebox.SoundUtils;
import bookreader.portable_jukebox.gui.menu.MenuPortableJukebox;
import bookreader.portable_jukebox.item.PortableJukeboxItem;
import bookreader.portable_jukebox.packet.SongControlPacketC2S;
import bookreader.portable_jukebox.packet.SongControlPacketS2C;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemDiscMusic;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.lwjgl.opengl.GL11;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

@Environment(value=EnvType.CLIENT)
public class ScreenPortableJukebox
extends ScreenContainerAbstract {
    private int top;
    private int left;
    private final Player player;
    private final ItemStack portable_jukebox_item;

    public ScreenPortableJukebox(ContainerInventory inventory, ItemStack portable_jukebox_item) {
        super((MenuAbstract)new MenuPortableJukebox(inventory, portable_jukebox_item));
        this.player = inventory.player;
        this.portable_jukebox_item = portable_jukebox_item;
    }

    public void init() {
        super.init();
        this.left = (this.width - this.xSize) / 2;
        this.top = (this.height - this.ySize) / 2;
        this.buttons.clear();
        this.buttons.add(new ButtonElement(0, this.left + 7 + 18 + 1, this.top + 7, 18, 18, "||"));
        this.buttons.add(new ButtonElement(1, this.left + 7 + 38, this.top + 7, 18, 18, "<"));
    }

    protected void buttonClicked(ButtonElement button) {
        if (button.id == 0) {
            ItemDiscMusic disk = ((PortableJukeboxItem)this.portable_jukebox_item.getItem()).getPlayingDisk(this.portable_jukebox_item);
            if (!SoundUtils.started()) {
                if (disk != null) {
                    NetworkHandler.sendToServer((NetworkMessage)new SongControlPacketC2S(this.player, disk, SongControlPacketS2C.SongAction.START_NEW));
                }
            } else if (SoundUtils.playing()) {
                NetworkHandler.sendToServer((NetworkMessage)new SongControlPacketC2S(this.player, SongControlPacketS2C.SongAction.PAUSE));
            } else {
                NetworkHandler.sendToServer((NetworkMessage)new SongControlPacketC2S(this.player, SongControlPacketS2C.SongAction.RESUME));
            }
        } else if (button.id == 1 && button.enabled) {
            NetworkHandler.sendToServer((NetworkMessage)new SongControlPacketC2S(this.player, SongControlPacketS2C.SongAction.STOP));
        }
        super.buttonClicked(button);
    }

    public void render(int mx, int my, float partialTick) {
        ((ButtonElement)this.buttons.get((int)0)).displayString = !SoundUtils.playing() ? "|>" : "||";
        ((ButtonElement)this.buttons.get((int)1)).enabled = SoundUtils.started_noupdate();
        super.render(mx, my, partialTick);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.loadTexture("/assets/portable_jukebox/textures/gui/container/portable_jukebox_screen.png").bind();
        this.drawTexturedModalRect(this.left, this.top, 0, 0, this.xSize, this.ySize);
    }
}

