/*
 * Decompiled with CFR 0.152.
 */
package bookreader.portable_jukebox.packet;

import bookreader.portable_jukebox.iface.DisplayPortableJukeboxScreen;
import bookreader.portable_jukebox.item.PortableJukeboxItem;
import com.mojang.nbt.tags.CompoundTag;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class OpenGuiPacketS2C
implements NetworkMessage {
    ItemStack stack;
    int windowId;

    public OpenGuiPacketS2C() {
    }

    public OpenGuiPacketS2C(ItemStack stack, int windowId) {
        assert (stack.getItem() instanceof PortableJukeboxItem);
        this.stack = stack;
        this.windowId = windowId;
    }

    @Environment(value=EnvType.SERVER)
    public void encodeToUniversalPacket(@Nonnull UniversalPacket packet) {
        assert (this.stack != null);
        CompoundTag tag = new CompoundTag();
        this.stack.writeToNBT(tag);
        packet.writeCompoundTag(tag);
        packet.writeInt(this.windowId);
    }

    @Environment(value=EnvType.CLIENT)
    public void decodeFromUniversalPacket(@Nonnull UniversalPacket packet) {
        this.stack = ItemStack.readItemStackFromNbt((CompoundTag)packet.readCompoundTag());
        assert (this.stack != null);
        this.windowId = packet.readInt();
    }

    @Environment(value=EnvType.CLIENT)
    public void handle(NetworkMessage.NetworkContext context) {
        assert (this.stack != null);
        Player player = context.player;
        ((DisplayPortableJukeboxScreen)player).bta_portable_jukebox$displayPortableJukeboxScreen(this.stack);
        player.craftingInventory.containerId = this.windowId;
    }
}

