/*
 * Decompiled with CFR 0.152.
 */
package bookreader.portable_jukebox.packet;

import bookreader.portable_jukebox.packet.SongControlPacketS2C;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemDiscMusic;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class SongControlPacketC2S
implements NetworkMessage {
    private String player_username;
    private int disc_id;
    SongControlPacketS2C.SongAction song_action;

    public SongControlPacketC2S() {
    }

    public SongControlPacketC2S(Player player, SongControlPacketS2C.SongAction action) {
        this.player_username = player.username;
        this.song_action = action;
    }

    public SongControlPacketC2S(Player player, ItemDiscMusic disc, SongControlPacketS2C.SongAction action) {
        this.player_username = player.username;
        this.song_action = action;
        this.disc_id = disc.id;
    }

    @Environment(value=EnvType.CLIENT)
    public void encodeToUniversalPacket(@Nonnull UniversalPacket packet) {
        packet.writeString(this.player_username);
        packet.writeInt(this.song_action.ordinal());
        if (this.song_action == SongControlPacketS2C.SongAction.START_NEW) {
            packet.writeInt(this.disc_id);
        }
    }

    @Environment(value=EnvType.SERVER)
    public void decodeFromUniversalPacket(@Nonnull UniversalPacket packet) {
        this.player_username = packet.readString();
        this.song_action = SongControlPacketS2C.SongAction.values()[packet.readInt()];
        if (this.song_action == SongControlPacketS2C.SongAction.START_NEW) {
            this.disc_id = packet.readInt();
        }
    }

    public void handle(NetworkMessage.NetworkContext context) {
        NetworkHandler.sendToAllPlayers((NetworkMessage)new SongControlPacketS2C(this.player_username, this.disc_id, this.song_action));
    }
}

