/*
 * Decompiled with CFR 0.152.
 */
package bookreader.portable_jukebox.packet;

import bookreader.portable_jukebox.SoundUtils;
import bookreader.portable_jukebox.iface.PlayDiscFromPlayer;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemDiscMusic;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class SongControlPacketS2C
implements NetworkMessage {
    private String player_username;
    private int disc_id;
    SongAction song_action;

    public SongControlPacketS2C() {
    }

    public SongControlPacketS2C(String player_username, int disc_id, SongAction action) {
        this.player_username = player_username;
        this.song_action = action;
        this.disc_id = disc_id;
    }

    @Environment(value=EnvType.SERVER)
    public void encodeToUniversalPacket(@Nonnull UniversalPacket packet) {
        packet.writeString(this.player_username);
        packet.writeInt(this.song_action.ordinal());
        if (this.song_action == SongAction.START_NEW) {
            packet.writeInt(this.disc_id);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void decodeFromUniversalPacket(@Nonnull UniversalPacket packet) {
        this.player_username = packet.readString();
        this.song_action = SongAction.values()[packet.readInt()];
        if (this.song_action == SongAction.START_NEW) {
            this.disc_id = packet.readInt();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handle(NetworkMessage.NetworkContext context) {
        if (this.player_username.equals(Minecraft.getMinecraft().thePlayer.username)) {
            switch (this.song_action.ordinal()) {
                case 0: {
                    SoundUtils.playRecord((ItemDiscMusic)Item.getItem((int)this.disc_id));
                    break;
                }
                case 1: {
                    SoundUtils.pause();
                    break;
                }
                case 2: {
                    SoundUtils.unpause();
                    break;
                }
                case 3: {
                    SoundUtils.stop();
                }
            }
        } else {
            PlayDiscFromPlayer snd = (PlayDiscFromPlayer)Minecraft.getMinecraft().sndManager;
            Optional<Player> _player = context.player.world.players.stream().filter(pl -> pl.username.equals(this.player_username)).findFirst();
            if (_player.isEmpty()) {
                return;
            }
            Player player = _player.get();
            switch (this.song_action.ordinal()) {
                case 0: {
                    snd.bta_portable_jukebox$playDiscFrom((ItemDiscMusic)Item.getItem((int)this.disc_id), player);
                    break;
                }
                case 1: 
                case 3: {
                    snd.bta_portable_jukebox$pauseDiscFrom(player);
                    break;
                }
                case 2: {
                    snd.bta_portable_jukebox$resumeDiscFrom(player);
                }
            }
        }
    }

    public static enum SongAction {
        START_NEW,
        PAUSE,
        RESUME,
        STOP;

    }
}

