/*
 * Decompiled with CFR 0.152.
 */
package bookreader.portable_jukebox.gui.container;

import bookreader.portable_jukebox.PortableJukebox;
import bookreader.portable_jukebox.SoundUtils;
import bookreader.portable_jukebox.item.PortableJukeboxItem;
import bookreader.portable_jukebox.packet.SaveNBTPacketC2S;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemDiscMusic;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventorySorter;
import net.minecraft.core.player.inventory.container.Container;
import org.jetbrains.annotations.Nullable;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ContainerPortableJukebox
implements Container {
    private final ItemStack portable_jukebox_item;
    ItemStack[] storage;

    public ContainerPortableJukebox(ItemStack portable_jukebox_item) {
        assert (portable_jukebox_item != null && portable_jukebox_item.getItem() instanceof PortableJukeboxItem);
        this.portable_jukebox_item = portable_jukebox_item;
        this.storage = PortableJukeboxItem.readNbt(this.portable_jukebox_item);
    }

    public int getContainerSize() {
        return this.storage.length;
    }

    @Nullable
    public ItemStack getItem(int i) {
        return this.storage[i];
    }

    public int getMaxStackSize() {
        return 1;
    }

    public String getNameTranslationKey() {
        PortableJukebox.LOGGER.info("TODO: PortableJukeboxContainer.getNameTranslationKey");
        return "container.portable_jukebox.TODO";
    }

    @Nullable
    public ItemStack removeItem(int i, int j) {
        assert (j == this.getMaxStackSize());
        if (this.storage[i] != null) {
            ItemStack s = this.storage[i];
            this.storage[i] = null;
            this.setChanged();
            return s;
        }
        return null;
    }

    public void setChanged() {
        this.writeNbt();
        if (!EnvironmentHelper.isServerEnvironment()) {
            if (this.storage[0] == null || SoundUtils.currentRecord() != null && this.storage[0].getItem().id != SoundUtils.currentRecord().id) {
                SoundUtils.stop();
            }
            if (!EnvironmentHelper.isSinglePlayer()) {
                NetworkHandler.sendToServer((NetworkMessage)new SaveNBTPacketC2S(this.portable_jukebox_item.getData()));
            }
        }
    }

    public void setItem(int i, @Nullable ItemStack item) {
        assert (item == null || item.getItem() instanceof ItemDiscMusic);
        this.storage[i] = item;
        this.setChanged();
    }

    public void sortContainer() {
        InventorySorter.sortInventory((ItemStack[])this.storage, (int)1, (int)(this.storage.length - 1));
    }

    public boolean stillValid(Player player) {
        return player.getHeldItem() != null && ItemStack.areItemStacksEqual((ItemStack)player.getHeldItem(), (ItemStack)this.portable_jukebox_item);
    }

    void writeNbt() {
        CompoundTag itemstack_nbt = this.portable_jukebox_item.getData();
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < this.storage.length; ++i) {
            if (this.storage[i] == null) continue;
            CompoundTag new_nbt = new CompoundTag();
            this.storage[i].writeToNBT(new_nbt);
            items.put(Integer.toString(i), (Tag)new_nbt);
        }
        itemstack_nbt.put("Disks", (Tag)items);
        this.portable_jukebox_item.setData(itemstack_nbt);
    }
}

