/*
 * Decompiled with CFR 0.152.
 */
package bookreader.portable_jukebox.mixin;

import bookreader.portable_jukebox.iface.PlayDiscFromPlayer;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemDiscMusic;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import paulscode.sound.SoundSystem;

@Mixin(value={SoundEngine.class}, remap=false)
public abstract class SoundEngineMixin
implements PlayDiscFromPlayer {
    @Shadow
    private static SoundSystem soundSystem;
    @Shadow
    @Nullable
    private GameSettings options;
    @Shadow
    private static boolean loaded;
    @Shadow
    private Minecraft mc;
    @Unique
    Map<Player, String> listeningDiscsFrom = new HashMap<Player, String>();

    @Shadow
    public void playSoundWithIdAtPos(SoundEntry entry, SoundCategory category, float x, float y, float z, float volume, float pitch, String soundID) {
        throw new AssertionError();
    }

    @Shadow
    protected abstract boolean isLoaded();

    @Override
    public void bta_portable_jukebox$playDiscFrom(ItemDiscMusic record, Player player) {
        Object category_name;
        if (this.listeningDiscsFrom.containsKey(player)) {
            category_name = this.listeningDiscsFrom.get(player);
            if (soundSystem.playing((String)category_name)) {
                soundSystem.stop((String)category_name);
            }
        } else {
            category_name = "PortableMusic" + player.username;
            this.listeningDiscsFrom.put(player, (String)category_name);
        }
        SoundEntry record_sound = SoundRepository.SOUNDS.getSoundEntry(record.recordName);
        assert (record_sound != null);
        if (soundSystem.playing("BgMusic")) {
            soundSystem.stop("BgMusic");
        }
        this.playSoundWithIdAtPos(record_sound, SoundCategory.MUSIC, (float)player.x, (float)player.y, (float)player.z, SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)this.mc.gameSettings) * record_sound.volume, record_sound.pitch, (String)category_name);
        if (record.recordAuthor != null) {
            this.mc.hudIngame.setRecordPlayingMessage(record.recordAuthor + " - " + I18n.getInstance().translateKey(record.recordName));
        } else {
            this.mc.hudIngame.setRecordPlayingMessage(I18n.getInstance().translateKey(record.getKey()));
        }
    }

    @Override
    public void bta_portable_jukebox$pauseDiscFrom(Player player) {
        if (this.listeningDiscsFrom != null && this.listeningDiscsFrom.containsKey(player)) {
            soundSystem.stop(this.listeningDiscsFrom.get(player));
        }
    }

    @Override
    public void bta_portable_jukebox$resumeDiscFrom(Player player) {
        if (this.listeningDiscsFrom.containsKey(player)) {
            soundSystem.play(this.listeningDiscsFrom.get(player));
        }
    }

    @Inject(method={"updateListener(Lnet/minecraft/core/entity/Mob;F)V"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/locks/Lock;unlock()V")})
    void beforeUpdateListenerLock(Mob listener_player, float partialTick, CallbackInfo ci) {
        for (Map.Entry<Player, String> entry : this.listeningDiscsFrom.entrySet()) {
            String category = entry.getValue();
            if (!soundSystem.playing(category)) continue;
            Player player = entry.getKey();
            soundSystem.setPosition(category, (float)player.x, (float)player.y, (float)player.z);
        }
    }

    @WrapOperation(method={"tick()V"}, at={@At(value="INVOKE", target="Lpaulscode/sound/SoundSystem;playing(Ljava/lang/String;)Z")})
    public boolean soundSystemPlaying(SoundSystem system, String name, Operation<Boolean> original) {
        if (Objects.equals(name, "BgMusic")) {
            return (Boolean)original.call(new Object[]{system, name}) != false || system.playing("PortableMusic");
        }
        return (Boolean)original.call(new Object[]{system, name});
    }

    @Inject(method={"stopMusic()V"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/locks/Lock;unlock()V")})
    public void soundSystemStop(CallbackInfo ci) {
        if (this.isLoaded()) {
            soundSystem.stop("PortableMusic");
            for (String disc_cat : this.listeningDiscsFrom.values()) {
                soundSystem.stop(disc_cat);
            }
        }
    }

    @Inject(method={"setMuted(Z)V"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/locks/Lock;unlock()V")})
    public void onSetMuted(boolean muted, CallbackInfo ci) {
        if (!this.isLoaded()) {
            return;
        }
        if (muted) {
            soundSystem.setVolume("PortableMusic", 0.0f);
            for (String disc_cat : this.listeningDiscsFrom.values()) {
                soundSystem.setVolume(disc_cat, 0.0f);
            }
        } else {
            soundSystem.setVolume("PortableMusic", SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)this.options));
            for (String disc_cat : this.listeningDiscsFrom.values()) {
                soundSystem.setVolume(disc_cat, SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)this.options));
            }
        }
    }

    @Inject(method={"updateOptions()V"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/locks/Lock;unlock()V")})
    public void onUpdateOptions(CallbackInfo info) {
        if (soundSystem != null && loaded) {
            soundSystem.setVolume("PortableMusic", SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)this.options));
            for (String disc_cat : this.listeningDiscsFrom.values()) {
                if (!soundSystem.playing(disc_cat)) continue;
                soundSystem.setVolume(disc_cat, SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)this.options));
            }
        }
    }
}

