/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity;

import com.calculusmaster.difficultraids.entity.DifficultRaidsEntityTypes;
import com.calculusmaster.difficultraids.entity.entities.elite.NuaosEliteEntity;
import com.calculusmaster.difficultraids.entity.entities.elite.XydraxEliteEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.TankIllagerEntity;
import com.calculusmaster.difficultraids.items.GMArmorItem;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.setup.DifficultRaidsEnchantments;
import java.util.List;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="difficultraids", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DREntityEvents {
    @SubscribeEvent
    public static void onEntityDamaged(LivingDamageEvent event) {
        int projectileEvasionLevel;
        Random random = new Random();
        Entity source = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        if (!((Boolean)DifficultRaidsConfig.FRIENDLY_FIRE_ARROWS.get()).booleanValue()) {
            Object arrow;
            boolean friendlyFire;
            Entity entity = event.getSource().m_7640_();
            boolean bl = friendlyFire = entity instanceof AbstractArrow && ((arrow = (AbstractArrow)entity).m_19749_() instanceof Raider || source instanceof Raider) && target instanceof Raider;
            if (friendlyFire) {
                event.setAmount(0.0f);
                event.setCanceled(true);
            }
        }
        if (target instanceof NuaosEliteEntity) {
            NuaosEliteEntity nuaos = (NuaosEliteEntity)target;
            if (event.getAmount() > 0.0f) {
                nuaos.increaseChargedDamage(event.getAmount());
                nuaos.resetLastDamageTakenTicks();
            }
        }
        if (event.getAmount() > 0.0f && source instanceof Raider) {
            float dr = 0.0f;
            for (Object armor : target.m_6168_()) {
                Item item = armor.m_41720_();
                if (!(item instanceof GMArmorItem)) continue;
                GMArmorItem gmArmor = (GMArmorItem)item;
                dr += gmArmor.getRaiderDamageReduction();
            }
            if (dr > 0.0f) {
                event.setAmount(event.getAmount() * (1.0f - dr));
            }
        }
        if (random.nextFloat() < 0.1f) {
            int max = 4 * ((Enchantment)DifficultRaidsEnchantments.CRITICAL_RESISTANCE.get()).m_6586_();
            int equipped = 0;
            for (ItemStack stack : target.m_6168_()) {
                equipped += stack.getEnchantmentLevel((Enchantment)DifficultRaidsEnchantments.CRITICAL_RESISTANCE.get());
            }
            if (equipped > max) {
                equipped = max;
            }
            if (equipped > 0) {
                float maxReduction = source instanceof Raider ? 0.8f : 0.7f;
                float reduction = (float)equipped / (float)max * maxReduction;
                event.setAmount(event.getAmount() * (1.0f - reduction));
                target.m_9236_().m_6269_(null, (Entity)target, SoundEvents.f_11986_, SoundSource.PLAYERS, 2.5f, 0.7f);
            }
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268524_) && !event.getSource().m_269533_(DamageTypeTags.f_268490_) && (projectileEvasionLevel = event.getEntity().m_6844_(EquipmentSlot.FEET).getEnchantmentLevel((Enchantment)DifficultRaidsEnchantments.PROJECTILE_EVASION.get())) > 0) {
            float chance;
            switch (projectileEvasionLevel) {
                case 1: {
                    float f = 0.05f;
                    break;
                }
                case 2: {
                    float f = 0.1f;
                    break;
                }
                case 3: {
                    float f = 0.2f;
                    break;
                }
                default: {
                    float f = chance = 0.0f;
                }
            }
            if (random.nextFloat() < chance) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Raider raider;
        LivingEntity strikeLevel2;
        LivingEntity living;
        Random random = new Random();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).m_21205_().m_41619_()) {
            int strikeLevel2 = living.m_21205_().getEnchantmentLevel((Enchantment)DifficultRaidsEnchantments.CRITICAL_STRIKE.get());
            int burstLevel = living.m_21205_().getEnchantmentLevel((Enchantment)DifficultRaidsEnchantments.CRITICAL_BURST.get());
            if (strikeLevel2 > 0 || burstLevel > 0) {
                float minimumChance = 0.035f;
                float chance = 0.05f;
                if (strikeLevel2 > 0) {
                    for (int i = 0; i < 2 && strikeLevel2-- > 0; ++i) {
                        chance += 0.1f;
                    }
                    while (strikeLevel2-- > 0) {
                        chance += 0.125f;
                    }
                }
                float multiplier = 1.25f;
                if (burstLevel > 0) {
                    int i;
                    for (i = 0; i < 3 && burstLevel-- > 0; ++i) {
                        multiplier += 0.2f;
                    }
                    for (i = 0; i < 4 && burstLevel-- > 0; ++i) {
                        multiplier += 0.3f;
                        if (!(chance - 0.015f >= minimumChance)) continue;
                        chance -= 0.015f;
                    }
                    while (burstLevel-- > 0) {
                        multiplier += 0.45f;
                        if (!(chance - 0.025f >= minimumChance)) continue;
                        chance -= 0.025f;
                    }
                }
                if (random.nextFloat() < chance) {
                    event.setAmount(event.getAmount() * multiplier);
                    living.m_9236_().m_6269_(null, (Entity)living, SoundEvents.f_11983_, SoundSource.HOSTILE, 4.25f, 0.65f);
                }
            }
        }
        if ((strikeLevel2 = event.getEntity()) instanceof Raider && !(raider = (Raider)strikeLevel2).m_6095_().equals(DifficultRaidsEntityTypes.TANK_ILLAGER.get())) {
            float shieldedPercent = 0.5f;
            if (raider.m_37886_()) {
                shieldedPercent = switch (RaidDifficulty.get(raider.m_37885_().m_37773_())) {
                    default -> throw new IncompatibleClassChangeError();
                    case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0.5f;
                    case RaidDifficulty.LEGEND -> 0.65f;
                    case RaidDifficulty.MASTER -> 0.75f;
                    case RaidDifficulty.GRANDMASTER -> 0.9f;
                };
            }
            float damage = event.getAmount() * shieldedPercent;
            List<TankIllagerEntity> nearbyTanks = raider.m_9236_().m_45971_(TankIllagerEntity.class, TargetingConditions.f_26872_, (LivingEntity)raider, raider.m_20191_().m_82400_(4.0)).stream().filter(tank -> tank.m_21223_() > damage).toList();
            if (!nearbyTanks.isEmpty()) {
                float splitDamage = damage / (float)nearbyTanks.size();
                for (TankIllagerEntity e : nearbyTanks) {
                    e.m_6469_(event.getSource(), splitDamage);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity target = event.getNewTarget();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (target != null && target.m_21023_(MobEffects.f_19609_)) {
                for (ItemStack slot : target.m_6168_()) {
                    if (slot.getEnchantmentLevel((Enchantment)DifficultRaidsEnchantments.INVISIBILITY.get()) <= 0) continue;
                    mob.m_6710_(null);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        if (event.getEntity() instanceof XydraxEliteEntity) {
            event.setDamageMultiplier(0.0f);
        }
    }
}

