/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.component;

import com.calculusmaster.difficultraids.entity.entities.elite.XydraxEliteEntity;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.setup.DifficultRaidsEffects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindColumnObject {
    private final XydraxEliteEntity owner;
    private final ServerLevel level;
    private BlockPos position;
    private int life;
    private final Random random;
    private AABB pushAABB;
    private final RaidDifficulty raidDifficulty;
    private final int height = 20;

    public WindColumnObject(XydraxEliteEntity owner, BlockPos startPos, int life) {
        this.owner = owner;
        this.level = (ServerLevel)owner.m_9236_();
        this.position = startPos;
        this.life = life;
        this.random = new Random();
        this.rebuildAABB();
        this.raidDifficulty = owner.isInDifficultRaid() ? owner.getRaidDifficulty() : RaidDifficulty.DEFAULT;
    }

    public boolean isComplete() {
        return this.life <= 0;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public int getLife() {
        return this.life;
    }

    public void tick() {
        --this.life;
        if (this.life != 0) {
            this.spawnParticles();
            if (this.life % 20 == 0) {
                this.push();
            }
            if (this.life % 40 == 0 && this.random.nextBoolean()) {
                this.move();
            }
        }
    }

    private void push() {
        this.level.m_6443_(LivingEntity.class, this.pushAABB, e -> {
            Player p;
            return !e.m_7307_((Entity)this.owner) && (!(e instanceof Player) || !(p = (Player)e).m_5833_() && !p.m_7500_());
        }).forEach(this::applyPushTarget);
    }

    private void applyPushTarget(LivingEntity target) {
        float windsCurseChance;
        float dX = this.random.nextFloat() * 4.0f - 2.0f;
        float dY = 1.5f;
        float dZ = this.random.nextFloat() * 4.0f - 2.0f;
        float modifier = switch (this.raidDifficulty) {
            default -> throw new IncompatibleClassChangeError();
            case RaidDifficulty.DEFAULT -> 1.0f;
            case RaidDifficulty.HERO -> 1.15f;
            case RaidDifficulty.LEGEND -> 1.25f;
            case RaidDifficulty.MASTER -> 1.4f;
            case RaidDifficulty.GRANDMASTER -> 1.75f;
        };
        target.m_5997_((double)dX, (double)(dY * modifier), (double)dZ);
        target.f_19864_ = true;
        switch (this.raidDifficulty) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEFAULT: 
            case HERO: 
            case LEGEND: {
                float f = 0.0f;
                break;
            }
            case MASTER: {
                float f = 0.15f;
                break;
            }
            case GRANDMASTER: {
                float f = windsCurseChance = 0.35f;
            }
        }
        if (this.random.nextFloat() < windsCurseChance && !target.m_21023_((MobEffect)DifficultRaidsEffects.WIND_CURSE_EFFECT.get())) {
            int curseAmplifier = switch (this.raidDifficulty) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 0;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 4;
            };
            target.m_7292_(new MobEffectInstance((MobEffect)DifficultRaidsEffects.WIND_CURSE_EFFECT.get(), 200, curseAmplifier));
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < this.height; i += 3) {
            Vec3 particlePos = new Vec3((double)this.position.m_123341_() + 0.5, (double)(this.position.m_123342_() + i), (double)this.position.m_123343_() + 0.5);
            this.level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50041_.m_49966_()), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 1, 0.15, 0.0, 0.15, 2.0);
        }
    }

    private void move() {
        BlockPos target = this.position.m_7918_(this.random.nextInt(7) - 3, 0, this.random.nextInt(7) - 3);
        for (int tries = 0; tries < 3 && !this.level.m_8055_(target).m_60795_(); ++tries) {
            target = target.m_6630_(1);
        }
        this.position = target;
        this.rebuildAABB();
    }

    private void rebuildAABB() {
        this.pushAABB = new AABB(this.position.m_7918_(-1, -2, -1), this.position.m_7918_(1, this.height, 1));
    }
}

