/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.elite;

import com.calculusmaster.difficultraids.config.RaidDifficultyConfig;
import com.calculusmaster.difficultraids.entity.entities.component.WindColumnObject;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.setup.DifficultRaidsEffects;
import com.calculusmaster.difficultraids.util.Compat;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class XydraxEliteEntity
extends AbstractEvokerVariant {
    private final Component ELITE_NAME = Component.m_237115_((String)"com.calculusmaster.difficultraids.elite_event.xydrax");
    private final ServerBossEvent ELITE_EVENT = new ServerBossEvent(this.ELITE_NAME, BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private boolean isHealing = false;
    private final List<WindColumnObject> windColumns = new ArrayList<WindColumnObject>();
    private int vortexTicks = 0;
    private BlockPos vortexFloor = BlockPos.f_121853_;
    private AABB vortexAABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public XydraxEliteEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new XydraxCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new XydraxAvoidEntityGoal(4.0f, 0.7, 0.8));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 4.0f, 0.7, 0.8));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractRecruitEntity.class, 4.0f, 0.7, 0.8));
        }
        this.f_21345_.m_25352_(3, (Goal)new XydraxVortexSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new XydraxWindColumnSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new XydraxBarrageSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new XydraxHealSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Guard.class, true));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractRecruitEntity.class, true));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        if (Compat.WORKERS.isLoaded()) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractWorkerEntity.class, true).m_26146_(300));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsHealing", this.isHealing);
        pCompound.m_128385_("WindColumnData", this.serializeWindColumns());
        pCompound.m_128405_("VortexTicks", this.vortexTicks);
        pCompound.m_128385_("VortexFloorPos", new int[]{this.vortexFloor.m_123341_(), this.vortexFloor.m_123342_(), this.vortexFloor.m_123343_()});
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.isHealing = pCompound.m_128471_("IsHealing");
        this.deserializeWindColumns(pCompound.m_128465_("WindColumnData"));
        this.vortexTicks = pCompound.m_128451_("VortexTicks");
        int[] vortexFloorPos = pCompound.m_128465_("VortexFloorPos");
        BlockPos blockPos = this.vortexFloor = vortexFloorPos.length == 0 ? BlockPos.f_121853_ : new BlockPos(vortexFloorPos[0], vortexFloorPos[1], vortexFloorPos[2]);
        if (this.vortexTicks > 0) {
            this.createVortexAABB();
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.ELITE_EVENT.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        if (pSource.m_7639_() instanceof IronGolem || Compat.GUARD_VILLAGERS.isLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount *= this.config().xydrax.friendlyDamageReduction;
        }
        if ((entity = pSource.m_7640_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if ((double)this.f_19796_.m_188501_() < 0.2) {
                living.m_5997_(0.0, (double)this.f_19796_.m_188501_() * 0.7, 0.0);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    @Override
    public void m_8119_() {
        Vec3 deltaMove;
        super.m_8119_();
        RaidDifficulty raidDifficulty = this.isInDifficultRaid() ? this.getRaidDifficulty() : RaidDifficulty.DEFAULT;
        RaidDifficultyConfig cfg = this.config();
        if (this.isHealing()) {
            deltaMove = this.m_20184_();
            if (!this.isVortexActive() && !this.m_20096_() && deltaMove.m_7098_() < 0.0) {
                this.m_20256_(deltaMove.m_82542_(1.0, 0.55, 1.0));
            }
            if (this.m_20096_()) {
                this.isHealing = false;
            } else if (this.f_19796_.m_188499_()) {
                float currentHealth = this.m_21223_();
                float maxHealth = this.m_21233_();
                if (maxHealth - currentHealth > 0.5f) {
                    float healAmount = this.f_19796_.m_188501_() / 1.5f;
                    this.m_5634_(healAmount);
                }
            }
        }
        if (!this.windColumns.isEmpty()) {
            this.windColumns.removeIf(WindColumnObject::isComplete);
            this.windColumns.forEach(WindColumnObject::tick);
        }
        if (this.isVortexActive()) {
            --this.vortexTicks;
            deltaMove = this.m_20184_();
            if (!this.m_20096_() && deltaMove.m_7098_() < 0.0) {
                this.m_20256_(deltaMove.m_82542_(1.0, 0.1, 1.0));
            }
            for (int i = this.vortexFloor.m_123342_(); i < this.m_20183_().m_123342_(); ++i) {
                Vec3 pos = new Vec3((double)this.vortexFloor.m_123341_() + 0.5, (double)i, (double)this.vortexFloor.m_123343_() + 0.5);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123787_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.05, 0.0, 0.05, 1.0);
            }
            if (this.vortexTicks % cfg.xydrax.vortexPullInterval == 0) {
                this.getVortexTargets().forEach(e -> {
                    Vec3 targetPos = new Vec3(e.m_20182_().m_7096_() + 0.5, e.m_20182_().m_7098_(), e.m_20182_().m_7094_() + 0.5);
                    Vec3 targetVector = new Vec3((double)this.vortexFloor.m_123341_() - targetPos.m_7096_(), (double)this.vortexFloor.m_123342_() - targetPos.m_7098_(), (double)this.vortexFloor.m_123343_() - targetPos.m_7094_()).m_82541_();
                    double force = cfg.xydrax.vortexForce;
                    double kbresistanceModifier = 1.0 - e.m_21133_(Attributes.f_22278_) * 0.5;
                    force = Math.max(force * 0.25, force * kbresistanceModifier);
                    e.m_5997_(targetVector.f_82479_ * force, targetVector.f_82480_, targetVector.f_82481_ * force);
                    e.f_19864_ = true;
                });
            }
            if (this.vortexTicks % cfg.xydrax.vortexDamageInterval == 0) {
                this.getVortexTargets().forEach(e -> {
                    double distance = Math.pow(e.m_20275_((double)this.vortexFloor.m_123341_(), (double)this.vortexFloor.m_123342_(), (double)this.vortexFloor.m_123343_()), 0.5);
                    List<Double> base = cfg.xydrax.vortexBaseDamageThresholds;
                    double damage = distance < 1.0 ? base.get(0) : (distance < 2.0 ? base.get(1) : (distance < 5.0 ? base.get(2).doubleValue() : base.get(3).doubleValue()));
                    if ((damage *= (double)cfg.xydrax.vortexDamageMultiplier) != 0.0) {
                        e.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)damage);
                    }
                });
            }
        }
        if (this.isWindColumnActive() && !this.m_21023_(MobEffects.f_19597_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 1200, 5, false, true));
        } else if (!this.isWindColumnActive() && this.m_21023_(MobEffects.f_19597_)) {
            this.m_21195_(MobEffects.f_19597_);
        }
    }

    public boolean isHealing() {
        return this.isHealing;
    }

    public boolean isWindColumnActive() {
        return this.windColumns.size() > 3;
    }

    public boolean isVortexActive() {
        return this.vortexTicks > 0;
    }

    private int[] serializeWindColumns() {
        int[] data = new int[this.windColumns.size() * 4];
        for (int i = 0; i < data.length; i += 4) {
            WindColumnObject column = this.windColumns.get(i / 4);
            data[i] = column.getPosition().m_123341_();
            data[i + 1] = column.getPosition().m_123342_();
            data[i + 2] = column.getPosition().m_123343_();
            data[i + 3] = column.getLife();
        }
        return data;
    }

    private void deserializeWindColumns(int[] data) {
        for (int i = 0; i < data.length; i += 4) {
            BlockPos pos = new BlockPos(data[i], data[i + 1], data[i + 2]);
            int life = data[i + 3];
            this.windColumns.add(new WindColumnObject(this, pos, life));
        }
    }

    private void createVortexAABB() {
        this.vortexAABB = new AABB(this.vortexFloor).m_82377_(10.0, 0.0, 10.0).m_165893_((double)(this.vortexFloor.m_123342_() + 10)).m_165887_((double)(this.vortexFloor.m_123342_() - 1));
    }

    private void summonWindColumns() {
        BlockPos center = new BlockPos((Vec3i)this.m_20183_());
        RaidDifficulty raidDifficulty = this.isInDifficultRaid() ? this.getRaidDifficulty() : RaidDifficulty.DEFAULT;
        List<BlockPos> windColumnSpawns = switch (raidDifficulty) {
            default -> throw new IncompatibleClassChangeError();
            case RaidDifficulty.DEFAULT -> List.of(center.m_7918_(4, 0, 0), center.m_7918_(-4, 0, 0));
            case RaidDifficulty.HERO -> List.of(center.m_7918_(4, 0, 0), center.m_7918_(-4, 0, 0), center.m_7918_(0, 0, 4), center.m_7918_(0, 0, -4));
            case RaidDifficulty.LEGEND -> List.of(center.m_7918_(4, 0, 0), center.m_7918_(-4, 0, 0), center.m_7918_(0, 0, 4), center.m_7918_(0, 0, -4), center.m_7918_(4, 0, 4), center.m_7918_(4, 0, -4));
            case RaidDifficulty.MASTER -> List.of(center.m_7918_(4, 0, 0), center.m_7918_(-4, 0, 0), center.m_7918_(0, 0, 4), center.m_7918_(0, 0, -4), center.m_7918_(4, 0, 4), center.m_7918_(4, 0, -4), center.m_7918_(-4, 0, 4), center.m_7918_(-4, 0, -4));
            case RaidDifficulty.GRANDMASTER -> List.of(center.m_7918_(4, 0, 0), center.m_7918_(-4, 0, 0), center.m_7918_(0, 0, 4), center.m_7918_(0, 0, -4), center.m_7918_(4, 0, 4), center.m_7918_(4, 0, -4), center.m_7918_(-4, 0, 4), center.m_7918_(-4, 0, -4), center.m_7918_(6, 0, 6), center.m_7918_(-6, 0, 6), center.m_7918_(6, 0, -6), center.m_7918_(-6, 0, -6));
        };
        windColumnSpawns.forEach(pos -> {
            int life = this.f_19796_.m_216339_(raidDifficulty.config().xydrax.windColumnLifetime.get(0).intValue(), raidDifficulty.config().xydrax.windColumnLifetime.get(1) + 1);
            WindColumnObject column = new WindColumnObject(this, (BlockPos)pos, life);
            this.windColumns.add(column);
        });
    }

    private List<LivingEntity> getVortexTargets() {
        return this.m_9236_().m_6443_(LivingEntity.class, this.vortexAABB, e -> {
            if (e.m_7307_((Entity)this)) {
                return false;
            }
            if (e instanceof Player) {
                Player player = (Player)e;
                return !player.m_7500_() && !player.m_5833_();
            }
            return true;
        });
    }

    private boolean isInExtendedSpellState() {
        return this.isHealing() || this.isWindColumnActive() || this.isVortexActive();
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)DifficultRaidsConfig.BOSS_BARS.get()).booleanValue()) {
            this.ELITE_EVENT.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.ELITE_EVENT.m_6539_(pPlayer);
    }

    private class XydraxCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private XydraxCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (XydraxEliteEntity.this.m_5448_() != null) {
                XydraxEliteEntity.this.m_21563_().m_24960_((Entity)XydraxEliteEntity.this.m_5448_(), (float)XydraxEliteEntity.this.m_8085_(), (float)XydraxEliteEntity.this.m_8132_());
            }
        }
    }

    private class XydraxAvoidEntityGoal
    extends AvoidEntityGoal<LivingEntity> {
        public XydraxAvoidEntityGoal(float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super((PathfinderMob)XydraxEliteEntity.this, LivingEntity.class, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier, e -> {
                Player player;
                return e instanceof Player && !(player = (Player)e).m_7500_() && !player.m_5833_() || Compat.GUARD_VILLAGERS.isLoaded() && e instanceof Guard;
            });
        }

        public boolean m_8036_() {
            return super.m_8036_() && !XydraxEliteEntity.this.isInExtendedSpellState() && !XydraxEliteEntity.this.isCastingSpell();
        }
    }

    private class XydraxVortexSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private XydraxVortexSpellGoal() {
            super(new Goal.Flag[0]);
        }

        private boolean isEntityNearby() {
            XydraxEliteEntity xydrax = XydraxEliteEntity.this;
            AABB search = new AABB(xydrax.m_20183_().m_7918_(0, 1, 0)).m_82400_(10.0);
            return !xydrax.m_9236_().m_6443_(LivingEntity.class, search, e -> !e.m_7307_((Entity)XydraxEliteEntity.this)).isEmpty();
        }

        @Override
        protected void castSpell() {
            XydraxEliteEntity xydrax = XydraxEliteEntity.this;
            xydrax.vortexFloor = XydraxEliteEntity.this.m_20183_();
            xydrax.createVortexAABB();
            xydrax.m_5997_(0.0, 1.5, 0.0);
            xydrax.m_6853_(false);
            xydrax.vortexTicks = xydrax.config().xydrax.vortexLifetime;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !XydraxEliteEntity.this.isInExtendedSpellState() && this.isEntityNearby();
        }

        @Override
        protected int getCastingTime() {
            return 80;
        }

        @Override
        protected int getCastingInterval() {
            return 700 + XydraxEliteEntity.this.vortexTicks;
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11781_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.XYDRAX_VORTEX;
        }
    }

    private class XydraxWindColumnSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private XydraxWindColumnSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            XydraxEliteEntity xydrax = XydraxEliteEntity.this;
            xydrax.m_21573_().m_26573_();
            xydrax.summonWindColumns();
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !XydraxEliteEntity.this.isInExtendedSpellState() && XydraxEliteEntity.this.m_20096_();
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 900 + XydraxEliteEntity.this.windColumns.size() * 2 * 20;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11983_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.XYDRAX_WIND_COLUMN;
        }
    }

    private class XydraxBarrageSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private XydraxBarrageSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = XydraxEliteEntity.this.m_5448_();
            if (target != null) {
                final int curseDuration = XydraxEliteEntity.this.config().xydrax.barrageCurseDuration;
                final int curseAmplifier = XydraxEliteEntity.this.config().xydrax.barrageCurseAmplifier;
                for (int i = 0; i < 12; ++i) {
                    Arrow arrow = new Arrow(XydraxEliteEntity.this.m_9236_(), (LivingEntity)XydraxEliteEntity.this){

                        protected void m_8060_(BlockHitResult p_36755_) {
                            super.m_8060_(p_36755_);
                            this.m_146870_();
                        }

                        protected void m_5790_(EntityHitResult pResult) {
                            if (!(pResult.m_82443_() instanceof Raider) || !XydraxEliteEntity.this.m_7307_(pResult.m_82443_())) {
                                super.m_5790_(pResult);
                                Entity entity = pResult.m_82443_();
                                if (entity instanceof LivingEntity) {
                                    LivingEntity living = (LivingEntity)entity;
                                    living.m_7292_(new MobEffectInstance((MobEffect)DifficultRaidsEffects.WIND_CURSE_EFFECT.get(), curseDuration, curseAmplifier));
                                }
                            }
                        }
                    };
                    arrow.m_6034_(XydraxEliteEntity.this.m_146892_().m_7096_(), XydraxEliteEntity.this.m_146892_().m_7098_() - 0.2, XydraxEliteEntity.this.m_146892_().m_7094_());
                    double targetY = target.m_20188_() - 1.1;
                    double targetX = target.m_20185_() - XydraxEliteEntity.this.m_20185_();
                    double targetArrowY = targetY - arrow.m_20186_();
                    double targetZ = target.m_20189_() - XydraxEliteEntity.this.m_20189_();
                    double distanceY = Math.sqrt(targetX * targetX + targetZ * targetZ) * (double)0.2f;
                    arrow.m_6686_(targetX, targetArrowY + distanceY, targetZ, 1.5f, 25.0f);
                    XydraxEliteEntity.this.m_9236_().m_7967_((Entity)arrow);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !XydraxEliteEntity.this.isInExtendedSpellState();
        }

        @Override
        protected int getCastingTime() {
            return 50;
        }

        @Override
        protected int getCastingInterval() {
            return 250;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11865_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.XYDRAX_ARROW_BARRAGE;
        }
    }

    private class XydraxHealSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private XydraxHealSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            XydraxEliteEntity xydrax = XydraxEliteEntity.this;
            xydrax.m_5997_(0.0, 1.0f + xydrax.f_19796_.m_188501_(), 0.0);
            xydrax.m_6853_(false);
            xydrax.isHealing = true;
        }

        @Override
        public boolean m_8036_() {
            XydraxEliteEntity e = XydraxEliteEntity.this;
            return XydraxEliteEntity.this.f_19797_ >= this.spellCooldown && !XydraxEliteEntity.this.isCastingSpell() && !e.isInExtendedSpellState() && (double)e.m_21223_() < (double)e.m_21233_() * 0.5;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 640;
        }

        @Override
        protected int getCastWarmupTime() {
            return 6;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.XYDRAX_HEAL;
        }
    }
}

