/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.config.RaiderConfigs;
import com.calculusmaster.difficultraids.entity.entities.component.AshenadoObject;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.Compat;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class AshenmancerIllagerEntity
extends AbstractEvokerVariant {
    private static final double SUMMON_CHECK_RADIUS = 30.0;
    private static final EntityDataAccessor<Boolean> TURRET_ACTIVE = SynchedEntityData.m_135353_(AshenmancerIllagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> LAST_SKULL_TYPE = SynchedEntityData.m_135353_(AshenmancerIllagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int maxMinions;
    private List<WitherSkeleton> minions = new ArrayList<WitherSkeleton>();
    private String minionTag = IntStream.generate(() -> this.m_217043_().m_188503_(10)).limit(6L).mapToObj(String::valueOf).collect(Collectors.joining()) + "_witherminion";
    private boolean checkMinions = false;
    private AshenadoObject ashenado = null;
    private int ashenadoCooldown = 0;
    private int turretCount = 0;
    private int turretInterval = 0;
    private int ticksNoTarget = 0;

    public AshenmancerIllagerEntity(EntityType<? extends AbstractEvokerVariant> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AshenmancerCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 0.6, 1.0));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 6.0f, 0.7, 1.0));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractRecruitEntity.class, 6.0f, 0.7, 1.0));
        }
        this.f_21345_.m_25352_(3, (Goal)new AshenmancerSummonMinionsSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new AshenmancerWitherSkullTurretSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new AshenmancerShootSkullsSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Guard.class, true).m_26146_(300));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractRecruitEntity.class, true).m_26146_(300));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        if (Compat.WORKERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractWorkerEntity.class, true).m_26146_(300));
        }
    }

    public void m_7895_(int pWave, boolean pUnusedFalse) {
        this.maxMinions = this.config().ashenmancer.maxMinionCount;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("MaxMinions", this.maxMinions);
        pCompound.m_128359_("MinionTag", this.minionTag);
        pCompound.m_128379_("HasMinions", !this.minions.isEmpty());
        pCompound.m_128379_("AshenadoActive", this.ashenado != null);
        if (this.ashenado != null) {
            this.ashenado.save(pCompound);
        }
        pCompound.m_128405_("TurretCount", this.turretCount);
        pCompound.m_128405_("TicksNoTarget", this.ticksNoTarget);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.maxMinions = pCompound.m_128451_("MaxMinions");
        this.minionTag = pCompound.m_128461_("MinionTag");
        this.checkMinions = pCompound.m_128471_("HasMinions");
        this.ashenado = pCompound.m_128471_("AshenadoActive") ? new AshenadoObject(this, pCompound) : null;
        this.turretCount = pCompound.m_128451_("TurretCount");
        this.ticksNoTarget = pCompound.m_128451_("TicksNoTarget");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TURRET_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(LAST_SKULL_TYPE, (Object)WitherSkullType.STANDARD.toString());
    }

    public boolean canSpawnMinion() {
        return this.minions.size() < this.maxMinions;
    }

    public void setMinionTargets(WitherSkeleton minion) {
        minion.f_21346_.m_262460_(goal -> true);
        minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)minion, Player.class, true));
        minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)minion, IronGolem.class, true));
        minion.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)minion, AbstractVillager.class, true));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)minion, Guard.class, true));
        }
    }

    public void setTurretActive(boolean value) {
        this.f_19804_.m_135381_(TURRET_ACTIVE, (Object)value);
    }

    public boolean isTurretActive() {
        return (Boolean)this.f_19804_.m_135370_(TURRET_ACTIVE);
    }

    public void setLastSkullType(WitherSkullType type) {
        this.f_19804_.m_135381_(LAST_SKULL_TYPE, (Object)type.toString());
    }

    public WitherSkullType getLastSkullType() {
        return WitherSkullType.valueOf((String)this.f_19804_.m_135370_(LAST_SKULL_TYPE));
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.checkMinions) {
            this.minions.addAll(this.m_9236_().m_6443_(WitherSkeleton.class, this.m_20191_().m_82400_(30.0), e -> e.m_19880_().contains(this.minionTag)));
            boolean bl = this.checkMinions = this.f_19797_ <= 100 && this.minions.isEmpty();
            if (!this.checkMinions) {
                this.minions.forEach(this::setMinionTargets);
            }
        }
        if (this.f_19797_ % 20 == 0) {
            this.minions.removeIf(LivingEntity::m_21224_);
            for (WitherSkeleton ws : this.minions) {
                if (ws.m_5448_() == null && (double)ws.m_20270_((Entity)this) >= 20.0) {
                    ws.m_21573_().m_5624_((Entity)this, 1.5);
                }
                if (this.f_19797_ % 40 != 0 || !((double)ws.m_21223_() < (double)ws.m_21233_() * 0.75) || !((double)ws.m_20270_((Entity)this) <= 3.0)) continue;
                ws.m_5634_(1.0f);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, ws.m_20185_(), ws.m_20188_() + 0.25, ws.m_20189_(), 3, (double)(this.f_19796_.m_188501_() / 2.0f), (double)(this.f_19796_.m_188501_() / 2.0f), (double)(this.f_19796_.m_188501_() / 2.0f), 0.4);
            }
        }
        if (this.ashenadoCooldown > 0) {
            --this.ashenadoCooldown;
        }
        if (this.ashenado != null) {
            this.ashenado.tick();
            if (this.ashenado.isComplete()) {
                this.ashenado = null;
                this.ashenadoCooldown = 400;
            }
        }
        if (this.turretCount > 0) {
            Level tX2;
            this.m_21573_().m_26573_();
            if (this.turretInterval == 0) {
                this.turretInterval = this.config().ashenmancer.turretInterval;
            }
            if (this.f_19797_ % this.turretInterval == 0 && this.m_5448_() != null) {
                this.ticksNoTarget = 0;
                LivingEntity target = this.m_5448_();
                double tX2 = target.m_20185_();
                double tY = target.m_20186_() + (double)(target.m_20192_() / 2.0f);
                double tZ = target.m_20189_();
                double aX = this.m_20185_();
                double aY = this.m_20188_() + 0.35;
                double aZ = this.m_20189_();
                double dX = tX2 - aX;
                double dY = tY - aY;
                double dZ = tZ - aZ;
                if (Math.abs(dX) > Math.abs(dZ)) {
                    aZ += (double)(this.f_19796_.m_188503_(7) - 3);
                } else {
                    aX += (double)(this.f_19796_.m_188503_(7) - 3);
                }
                dX = tX2 - aX;
                dZ = tZ - aZ;
                final Predicate<Entity> validTarget = e -> !(e instanceof Raider) && !e.m_7307_((Entity)this) && !(e instanceof WitherSkeleton);
                WitherSkull witherSkull = new WitherSkull(this.m_9236_(), (LivingEntity)this, dX, dY, dZ){

                    protected void m_5790_(EntityHitResult pResult) {
                        if (validTarget.test(pResult.m_82443_())) {
                            super.m_5790_(pResult);
                        }
                    }
                };
                witherSkull.m_5602_((Entity)this);
                witherSkull.m_6034_(aX, aY, aZ);
                this.m_9236_().m_7967_((Entity)witherSkull);
                --this.turretCount;
            } else if (this.m_5448_() == null) {
                ++this.ticksNoTarget;
            }
            if (this.ticksNoTarget >= 40 && this.turretCount > 0) {
                this.turretCount = 0;
            }
            if (this.f_19797_ % 5 == 0 && (tX2 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)tX2;
                for (int i = 0; i < 4; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (0.25 - (double)this.f_19796_.m_188501_() * 0.5), this.m_20188_(), this.m_20189_() + (0.25 - (double)this.f_19796_.m_188501_() * 0.5), 1, 0.0, 0.0, 0.0, 0.2);
                }
            }
        } else if (this.isTurretActive() && this.turretCount == 0) {
            this.setTurretActive(false);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Object object;
        if (this.f_19796_.m_188499_() && (object = pSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            for (WitherSkeleton ws : this.minions) {
                if (ws.m_5448_() != null) continue;
                ws.m_21573_().m_5624_((Entity)living, 1.4);
                ws.m_6710_(living);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        this.minions.forEach(LivingEntity::m_6074_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.maxMinions = this.config().ashenmancer.maxMinionCount;
        this.turretInterval = this.config().ashenmancer.turretInterval;
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public AbstractIllager.IllagerArmPose m_6768_() {
        return this.isTurretActive() ? AbstractIllager.IllagerArmPose.SPELLCASTING : super.m_6768_();
    }

    private class AshenmancerCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private AshenmancerCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (AshenmancerIllagerEntity.this.m_5448_() != null) {
                AshenmancerIllagerEntity.this.m_21563_().m_24960_((Entity)AshenmancerIllagerEntity.this.m_5448_(), (float)AshenmancerIllagerEntity.this.m_8085_(), (float)AshenmancerIllagerEntity.this.m_8132_());
            }
        }
    }

    private class AshenmancerSummonMinionsSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private AshenmancerSummonMinionsSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = AshenmancerIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)AshenmancerIllagerEntity.this.m_9236_();
            if (target != null) {
                RandomSource random = AshenmancerIllagerEntity.this.f_19796_;
                RaiderConfigs.Ashenmancer cfg = AshenmancerIllagerEntity.this.config().ashenmancer;
                WitherSkeleton minion = new WitherSkeleton(EntityType.f_20497_, (Level)level){

                    protected boolean m_6125_() {
                        return false;
                    }
                };
                BlockPos pos = AshenmancerIllagerEntity.this.m_20183_().m_7918_(-1 + random.m_188503_(3), 0, -1 + random.m_188503_(3));
                int maxProtection = cfg.minionMaxProtectionLevel;
                Function<Item, ItemStack> buildArmor = item -> {
                    ItemStack out = item.m_7968_();
                    if (maxProtection > 0) {
                        out.m_41663_(Enchantments.f_44965_, maxProtection == 1 ? maxProtection : random.m_216339_(1, maxProtection + 1));
                    }
                    return out;
                };
                minion.m_8061_(EquipmentSlot.HEAD, buildArmor.apply(cfg.getMinionHelmet()));
                minion.m_8061_(EquipmentSlot.CHEST, buildArmor.apply(cfg.getMinionChestplate()));
                minion.m_8061_(EquipmentSlot.LEGS, buildArmor.apply(cfg.getMinionLeggings()));
                minion.m_8061_(EquipmentSlot.FEET, buildArmor.apply(cfg.getMinionBoots()));
                ItemStack sword = cfg.getMinionSword().m_7968_();
                int maxSharpness = cfg.minionMaxSharpnessLevel;
                if (maxSharpness > 0) {
                    sword.m_41663_(Enchantments.f_44977_, maxSharpness == 1 ? maxSharpness : random.m_216339_(1, maxSharpness + 1));
                }
                minion.m_8061_(EquipmentSlot.MAINHAND, sword);
                minion.m_20035_(pos, 0.0f, 0.0f);
                minion.m_6710_(target);
                minion.m_21563_().m_148051_((Entity)target);
                minion.m_20049_(AshenmancerIllagerEntity.this.minionTag);
                AshenmancerIllagerEntity.this.setMinionTargets(minion);
                level.m_7967_((Entity)minion);
                AshenmancerIllagerEntity.this.minions.add(minion);
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && AshenmancerIllagerEntity.this.canSpawnMinion();
        }

        @Override
        protected int getCastingTime() {
            return 50;
        }

        @Override
        protected int getCastingInterval() {
            return 500;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ASHENMANCER_SUMMON_MINIONS;
        }
    }

    private class AshenmancerWitherSkullTurretSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private AshenmancerWitherSkullTurretSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            if (AshenmancerIllagerEntity.this.m_5448_() != null) {
                AshenmancerIllagerEntity.this.turretCount = AshenmancerIllagerEntity.this.config().ashenmancer.turretSkullCount;
                AshenmancerIllagerEntity.this.setTurretActive(true);
            }
        }

        @Override
        protected int getCastingTime() {
            return 70;
        }

        @Override
        protected int getCastingInterval() {
            return 1000;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12554_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ASHENMANCER_TURRET;
        }
    }

    private class AshenmancerShootSkullsSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private AshenmancerShootSkullsSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = AshenmancerIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)AshenmancerIllagerEntity.this.m_9236_();
            final AshenmancerIllagerEntity ashenmancer = AshenmancerIllagerEntity.this;
            ArrayList<WitherSkullType> pool = new ArrayList<WitherSkullType>(List.of(WitherSkullType.values()));
            pool.add(WitherSkullType.STANDARD);
            pool.add(WitherSkullType.STANDARD);
            if (target != null) {
                double tX = target.m_20185_();
                double tY = target.m_20186_() + (double)(target.m_20192_() / 2.0f);
                double tZ = target.m_20189_();
                double aX = ashenmancer.m_20185_();
                double aY = ashenmancer.m_20188_() + 0.35;
                double aZ = ashenmancer.m_20189_();
                final Predicate<Entity> validTarget = e -> !(e instanceof Raider) && !e.m_7307_((Entity)ashenmancer) && !(e instanceof WitherSkeleton);
                final WitherSkullType type = (WitherSkullType)((Object)pool.get(ashenmancer.f_19796_.m_188503_(pool.size())));
                double dX = tX - aX;
                double dY = tY - aY;
                double dZ = tZ - aZ;
                if (type == WitherSkullType.MULTISHOTTER) {
                    int count = AshenmancerIllagerEntity.this.config().ashenmancer.multishotSkullCount;
                    for (int i = 0; i < count; ++i) {
                        if (Math.abs(dX) > Math.abs(dZ)) {
                            aZ += (double)(AshenmancerIllagerEntity.this.f_19796_.m_188503_(7) - 3);
                        } else {
                            aX += (double)(AshenmancerIllagerEntity.this.f_19796_.m_188503_(7) - 3);
                        }
                        if (i != 0) {
                            tX += 0.25 - (double)AshenmancerIllagerEntity.this.f_19796_.m_188501_() * 0.5;
                            tZ += 0.25 - (double)AshenmancerIllagerEntity.this.f_19796_.m_188501_() * 0.5;
                        }
                        dX = tX - aX;
                        dZ = tZ - aZ;
                        WitherSkull witherSkull = new WitherSkull((Level)level, (LivingEntity)ashenmancer, dX, dY, dZ){

                            protected void m_5790_(EntityHitResult pResult) {
                                if (validTarget.test(pResult.m_82443_())) {
                                    super.m_5790_(pResult);
                                }
                            }
                        };
                        witherSkull.m_5602_((Entity)ashenmancer);
                        witherSkull.m_6034_(aX, aY, aZ);
                        level.m_7967_((Entity)witherSkull);
                    }
                } else {
                    if (type == WitherSkullType.SPEEDER) {
                        dX = (tX += 0.125 - (double)AshenmancerIllagerEntity.this.f_19796_.m_188501_() * 0.25) - aX;
                        dY = tY - aY;
                        dZ = (tZ += 0.125 - (double)AshenmancerIllagerEntity.this.f_19796_.m_188501_() * 0.25) - aZ;
                    }
                    WitherSkull witherSkull = new WitherSkull((Level)level, (LivingEntity)ashenmancer, dX, dY, dZ){

                        protected void m_5790_(EntityHitResult pResult) {
                            if (validTarget.test(pResult.m_82443_())) {
                                Entity entity;
                                super.m_5790_(pResult);
                                if (ashenmancer.ashenado != null) {
                                    Vec3 dir = new Vec3(pResult.m_82443_().m_20185_() - (double)ashenmancer.ashenado.getCenter().m_123341_(), pResult.m_82443_().m_20186_() - (double)ashenmancer.ashenado.getCenter().m_123342_(), pResult.m_82443_().m_20189_() - (double)ashenmancer.ashenado.getCenter().m_123343_()).m_82541_();
                                    float force = type == WitherSkullType.PUSHER ? ashenmancer.config().ashenmancer.pusherSkullForce : 1.25f;
                                    pResult.m_82443_().m_5997_(dir.m_7096_() * (double)force, dir.m_7098_() * (double)force, dir.m_7094_() * (double)force);
                                    pResult.m_82443_().f_19864_ = true;
                                } else if (type == WitherSkullType.PUSHER) {
                                    float force = ashenmancer.config().ashenmancer.pusherSkullForce;
                                    pResult.m_82443_().m_5997_((double)this.f_19796_.m_188501_(), (double)force, (double)this.f_19796_.m_188501_());
                                    pResult.m_82443_().f_19864_ = true;
                                } else if (type == WitherSkullType.FLAMER) {
                                    pResult.m_82443_().m_20254_(ashenmancer.config().ashenmancer.flamerSkullFireDuration);
                                } else if (type == WitherSkullType.BLINDER && (entity = pResult.m_82443_()) instanceof LivingEntity) {
                                    LivingEntity living = (LivingEntity)entity;
                                    living.m_7292_(new MobEffectInstance(MobEffects.f_216964_, ashenmancer.config().ashenmancer.blinderSkullBlindnessDuration, 0, false, true));
                                }
                            }
                        }

                        protected float m_6884_() {
                            return type == WitherSkullType.SPEEDER ? AshenmancerIllagerEntity.this.config().ashenmancer.speederSkullSpeed : super.m_6884_();
                        }
                    };
                    witherSkull.m_5602_((Entity)ashenmancer);
                    witherSkull.m_6034_(aX, aY, aZ);
                    AshenmancerIllagerEntity.this.setLastSkullType(type);
                    level.m_7967_((Entity)witherSkull);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !AshenmancerIllagerEntity.this.isTurretActive();
        }

        @Override
        protected int getCastingTime() {
            return 30;
        }

        @Override
        protected int getCastingInterval() {
            return 60;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12558_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ASHENMANCER_SUMMON_MINIONS;
        }
    }

    public static enum WitherSkullType {
        PUSHER,
        FLAMER,
        MULTISHOTTER,
        SPEEDER,
        STANDARD,
        BLINDER;

    }

    private class AshenmancerAshenadoSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private AshenmancerAshenadoSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            AshenmancerIllagerEntity ashenmancer = AshenmancerIllagerEntity.this;
            LivingEntity target = ashenmancer.m_5448_();
            if (target != null) {
                BlockPos targetCenter = target.m_20183_().m_7918_(-3 + ashenmancer.f_19796_.m_188503_(7), 0, -3 + ashenmancer.f_19796_.m_188503_(7));
                Vec3 center = Vec3.m_82512_((Vec3i)targetCenter).m_82492_(0.0, -0.5, 0.0);
                Vec3i center_int = new Vec3i((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_);
                ashenmancer.ashenado = new AshenadoObject(ashenmancer, ashenmancer.isInDifficultRaid() ? ashenmancer.getRaidDifficulty() : RaidDifficulty.DEFAULT, center_int, ashenmancer.config().ashenmancer.ashenadoDuration);
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && AshenmancerIllagerEntity.this.ashenado == null && AshenmancerIllagerEntity.this.ashenadoCooldown == 0;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 1500;
        }

        @Override
        protected int getCastWarmupTime() {
            return 30;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12554_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ASHENMANCER_ASHENADO;
        }
    }
}

