/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.config.RaiderConfigs;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.util.Compat;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class NecromancerIllagerEntity
extends AbstractEvokerVariant {
    private static final double SUMMON_CHECK_RADIUS = 30.0;
    private static final String MINION_TAG_EXTENSION = "_minion";
    private static final String HORDE_TAG_EXTENSION = "_horde";
    private static final EntityDataAccessor<Integer> MINION_CHARGES = SynchedEntityData.m_135353_(NecromancerIllagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private List<Monster> activeHorde = new ArrayList<Monster>();
    private int hordeLifetimeTicks = 0;
    private List<Monster> activeMinions = new ArrayList<Monster>();
    private boolean checkMinions = false;
    private boolean checkHorde = false;
    private String summonTag = IntStream.generate(() -> this.m_217043_().m_188503_(10)).limit(6L).mapToObj(String::valueOf).collect(Collectors.joining());

    public NecromancerIllagerEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new NecromancerCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.6, 1.0));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractRecruitEntity.class, 8.0f, 0.6, 1.0));
        }
        this.f_21345_.m_25352_(4, (Goal)new NecromancerSummonMinionsSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new NecromancerBuryTargetGoal());
        this.f_21345_.m_25352_(5, (Goal)new NecromancerSummonHordeSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        if (Compat.WORKERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractWorkerEntity.class, true).m_26146_(300));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Guard.class, true).m_26146_(300));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractRecruitEntity.class, true).m_26146_(300));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    @Override
    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("SummonTag", this.summonTag);
        pCompound.m_128405_("ActiveHordeLifetimeTicks", this.hordeLifetimeTicks);
        pCompound.m_128379_("HasHorde", !this.activeHorde.isEmpty());
        pCompound.m_128379_("HasMinions", !this.activeMinions.isEmpty());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.summonTag = pCompound.m_128461_("SummonTag");
        this.hordeLifetimeTicks = pCompound.m_128451_("ActiveHordeLifetimeTicks");
        this.checkMinions = pCompound.m_128471_("HasMinions");
        this.checkHorde = pCompound.m_128471_("HasHorde");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MINION_CHARGES, (Object)0);
    }

    public int getMinionCharges() {
        return (Integer)this.f_19804_.m_135370_(MINION_CHARGES);
    }

    public void addMinionCharge() {
        this.f_19804_.m_135381_(MINION_CHARGES, (Object)(this.getMinionCharges() + 1));
    }

    public void removeMinionCharge() {
        int current = this.getMinionCharges();
        if (current > 0) {
            this.f_19804_.m_135381_(MINION_CHARGES, (Object)(current - 1));
        }
    }

    public void setMinionTargets(Mob minion) {
        minion.f_21346_.m_262460_(goal -> true);
        minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(minion, Player.class, true));
        minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(minion, IronGolem.class, true));
        minion.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(minion, AbstractVillager.class, true));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(minion, Guard.class, true));
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof LivingEntity && !this.activeMinions.isEmpty() && pAmount > 1.0f && this.f_19796_.m_188501_() < 0.33f) {
            float deflectedDamage = pAmount * this.config().necromancer.reflectedDamagePercentage;
            Monster target = this.activeMinions.get(this.f_19796_.m_188503_(this.activeMinions.size()));
            if (target.m_21223_() > deflectedDamage) {
                target.m_6469_(pSource, deflectedDamage);
                pAmount -= deflectedDamage;
                this.m_5496_(SoundEvents.f_11986_, 1.5f, 0.9f);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        this.activeHorde.forEach(LivingEntity::m_6074_);
        this.activeMinions.forEach(LivingEntity::m_6074_);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (!this.activeHorde.isEmpty()) {
            this.activeHorde.removeIf(LivingEntity::m_21224_);
            if (this.activeHorde.isEmpty()) {
                this.hordeLifetimeTicks = 0;
            }
        }
        if (!this.activeMinions.isEmpty()) {
            this.activeMinions.removeIf(LivingEntity::m_21224_);
        }
        if (this.hordeLifetimeTicks > 0) {
            --this.hordeLifetimeTicks;
            if (this.hordeLifetimeTicks == 0) {
                this.activeHorde.forEach(LivingEntity::m_6074_);
                this.activeHorde.clear();
            }
        }
        if (this.f_19797_ % 20 == 0 && !this.activeMinions.isEmpty() && this.m_5448_() != null) {
            for (Monster minion : this.activeMinions) {
                if (minion.m_5448_() != null) continue;
                minion.m_6710_(this.m_5448_());
            }
        }
        if (this.f_19797_ % 30 == 0) {
            this.activeMinions.stream().filter(m -> m.m_20270_((Entity)this) >= 40.0f).forEach(m -> m.m_21573_().m_5624_((Entity)this, 1.2));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.checkMinions) {
                this.activeMinions.addAll(serverLevel.m_6443_(Monster.class, this.m_20191_().m_82400_(30.0), e -> e.m_19880_().contains(this.summonTag + MINION_TAG_EXTENSION)));
                boolean bl = this.checkMinions = this.f_19797_ <= 100 && this.activeMinions.isEmpty();
                if (!this.checkMinions) {
                    this.activeMinions.forEach(this::setMinionTargets);
                }
            }
            if (this.checkHorde) {
                this.activeHorde.addAll(serverLevel.m_6443_(Monster.class, this.m_20191_().m_82400_(30.0), e -> e.m_19880_().contains(this.summonTag + HORDE_TAG_EXTENSION)));
                boolean bl = this.checkHorde = this.f_19797_ <= 100 && this.activeHorde.isEmpty();
                if (!this.checkHorde) {
                    this.activeHorde.forEach(this::setMinionTargets);
                }
            }
        }
    }

    private class NecromancerCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private NecromancerCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (NecromancerIllagerEntity.this.m_5448_() != null) {
                NecromancerIllagerEntity.this.m_21563_().m_24960_((Entity)NecromancerIllagerEntity.this.m_5448_(), (float)NecromancerIllagerEntity.this.m_8085_(), (float)NecromancerIllagerEntity.this.m_8132_());
            }
        }
    }

    private class NecromancerSummonMinionsSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private NecromancerSummonMinionsSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = NecromancerIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)NecromancerIllagerEntity.this.m_9236_();
            if (target != null) {
                Random random = new Random();
                RaiderConfigs.Necromancer cfg = NecromancerIllagerEntity.this.config().necromancer;
                int summons = cfg.minionChargeSummonCount;
                for (int i = 0; i < summons; ++i) {
                    Entity entity = cfg.getMinionType().m_20615_((Level)level);
                    if (!(entity instanceof Mob)) continue;
                    Mob minion = (Mob)entity;
                    BlockPos summonPos = target.m_20183_().m_7918_(-4 + random.nextInt(9), 0, -4 + random.nextInt(9));
                    List<Item> armor = List.of(cfg.getMinionHelmet(), cfg.getMinionChestplate(), cfg.getMinionLeggings(), cfg.getMinionBoots());
                    int protectionLevel = cfg.minionMaxProtectionLevel;
                    List<EquipmentSlot> slots = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
                    for (Item item : armor) {
                        ItemStack armorStack = new ItemStack((ItemLike)item);
                        if (protectionLevel != 0) {
                            armorStack.m_41663_(Enchantments.f_44965_, protectionLevel == 1 ? 1 : random.nextInt(1, protectionLevel));
                        }
                        EquipmentSlot current = slots.get(armor.indexOf(item));
                        minion.m_8061_(current, armorStack);
                        minion.m_21409_(current, 0.0f);
                    }
                    minion.m_20035_(summonPos, 0.0f, 0.0f);
                    minion.m_6710_(target);
                    minion.m_21563_().m_148051_((Entity)target);
                    minion.m_20049_(NecromancerIllagerEntity.this.summonTag + NecromancerIllagerEntity.MINION_TAG_EXTENSION);
                    NecromancerIllagerEntity.this.setMinionTargets(minion);
                    level.m_7967_((Entity)minion);
                    if (minion instanceof Monster) {
                        Monster monster = (Monster)minion;
                        NecromancerIllagerEntity.this.activeMinions.add(monster);
                    }
                    NecromancerIllagerEntity.this.removeMinionCharge();
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && NecromancerIllagerEntity.this.getMinionCharges() > 0 && NecromancerIllagerEntity.this.hordeLifetimeTicks < 40;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 500;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.NECROMANCER_SUMMON_MINIONS;
        }
    }

    private class NecromancerBuryTargetGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private NecromancerBuryTargetGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = NecromancerIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)NecromancerIllagerEntity.this.m_9236_();
            boolean raid = NecromancerIllagerEntity.this.isInRaid();
            if (target != null) {
                if (raid) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1));
                }
                target.m_5496_(SoundEvents.f_11816_, 5.0f, 0.75f);
                int buryDistance = 2 + Mth.m_14167_((float)target.m_20206_()) * (target.m_20096_() ? 1 : 2);
                target.m_6027_((double)target.m_146903_(), (double)(target.m_146904_() - buryDistance), (double)target.m_146907_());
                Vec3i eye_pos = new Vec3i((int)target.m_146892_().f_82479_, (int)target.m_146892_().f_82480_, (int)target.m_146892_().f_82481_);
                if (!level.m_8055_(new BlockPos(eye_pos)).m_60795_() && target instanceof AbstractVillager) {
                    AbstractVillager villager = (AbstractVillager)target;
                    villager.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 1));
                }
            }
        }

        @Override
        public boolean m_8036_() {
            try {
                Level level = NecromancerIllagerEntity.this.m_9236_();
                LivingEntity target = NecromancerIllagerEntity.this.m_5448_();
                Vec3i eye_pos = new Vec3i((int)target.m_146892_().f_82479_, (int)target.m_146892_().f_82480_, (int)target.m_146892_().f_82481_);
                return super.m_8036_() && level.m_8055_(new BlockPos(eye_pos)).m_60795_() && Math.pow(NecromancerIllagerEntity.this.m_20183_().m_123331_((Vec3i)target.m_20183_()), 0.5) < 4.0;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        protected int getCastingTime() {
            return 30;
        }

        @Override
        protected int getCastingInterval() {
            return NecromancerIllagerEntity.this.m_21223_() < NecromancerIllagerEntity.this.m_21233_() / 5.0f ? 100 : 600;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11865_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.NECROMANCER_BURY_TARGET;
        }
    }

    private class NecromancerSummonHordeSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private NecromancerSummonHordeSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = NecromancerIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)NecromancerIllagerEntity.this.m_9236_();
            if (target != null) {
                Random random = new Random();
                int size = NecromancerIllagerEntity.this.config().necromancer.hordeSize;
                if (size > 6) {
                    size = NecromancerIllagerEntity.this.f_19796_.m_216339_(size - 4, size + 5);
                }
                int life = NecromancerIllagerEntity.this.config().necromancer.hordeLifetime;
                NecromancerIllagerEntity.this.m_5496_(SoundEvents.f_11900_, 7.0f, 1.0f);
                BlockPos currentPos = NecromancerIllagerEntity.this.m_20183_();
                for (int i = 0; i < size; ++i) {
                    Skeleton hordeMember = new Skeleton(EntityType.f_20524_, (Level)level){

                        protected boolean m_6125_() {
                            return false;
                        }
                    };
                    hordeMember.m_7292_(new MobEffectInstance(MobEffects.f_19596_, life, 2, false, false));
                    hordeMember.m_21153_(hordeMember.m_21233_() / 2.0f);
                    hordeMember.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
                    hordeMember.m_6710_(target);
                    hordeMember.m_21563_().m_148051_((Entity)target);
                    hordeMember.m_20049_(NecromancerIllagerEntity.this.summonTag + NecromancerIllagerEntity.HORDE_TAG_EXTENSION);
                    NecromancerIllagerEntity.this.setMinionTargets((Mob)hordeMember);
                    BlockPos summonPos = currentPos.m_7918_(-10 + random.nextInt(21), 0, -10 + random.nextInt(21));
                    hordeMember.m_20035_(summonPos, 0.0f, 0.0f);
                    level.m_7967_((Entity)hordeMember);
                    NecromancerIllagerEntity.this.activeHorde.add((Monster)hordeMember);
                }
                NecromancerIllagerEntity.this.hordeLifetimeTicks = life;
            }
        }

        @Override
        public boolean m_8036_() {
            int minionThreshold = 2;
            return super.m_8036_() && NecromancerIllagerEntity.this.activeMinions.size() <= minionThreshold && NecromancerIllagerEntity.this.activeHorde.isEmpty();
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 700;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.NECROMANCER_SUMMON_HORDE;
        }
    }
}

