/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.entities.component.ShamanDebuffBulletEntity;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.util.Compat;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class ShamanIllagerEntity
extends AbstractEvokerVariant {
    public ShamanIllagerEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ShamanCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.6, 1.0));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractRecruitEntity.class, 8.0f, 0.6, 1.0));
        }
        this.f_21345_.m_25352_(3, (Goal)new ShamanMoveToRaidersGoal());
        this.f_21345_.m_25352_(4, (Goal)new ShamanAttackBoostSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new ShamanDefenseBoostSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new ShamanDebuffSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new ShamanInvisibilitySpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        if (Compat.WORKERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractWorkerEntity.class, true).m_26146_(300));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Guard.class, true).m_26146_(300));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractRecruitEntity.class, true).m_26146_(300));
        }
    }

    private List<Raider> getNearbyRaiders(double distance) {
        return this.m_9236_().m_45971_(Raider.class, TargetingConditions.m_148353_().m_26883_(distance), (LivingEntity)this, new AABB(this.m_20183_()).m_82400_(distance));
    }

    private Raider getNearestRaider() {
        return this.m_37885_() == null ? null : (Raider)this.m_9236_().m_45963_(Raider.class, TargetingConditions.m_148353_().m_148355_(), (LivingEntity)this, (double)this.m_20183_().m_123341_(), (double)this.m_20183_().m_123342_(), (double)this.m_20183_().m_123343_(), new AABB(this.m_20183_()).m_82400_(Math.sqrt(9216.0)));
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    private class ShamanCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private ShamanCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (ShamanIllagerEntity.this.m_5448_() != null) {
                ShamanIllagerEntity.this.m_21563_().m_24960_((Entity)ShamanIllagerEntity.this.m_5448_(), (float)ShamanIllagerEntity.this.m_8085_(), (float)ShamanIllagerEntity.this.m_8132_());
            }
        }
    }

    private class ShamanMoveToRaidersGoal
    extends Goal {
        private Raider target;

        private ShamanMoveToRaidersGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = ShamanIllagerEntity.this.getNearestRaider();
            return ShamanIllagerEntity.this.getNearbyRaiders(5.0).isEmpty() && this.target != null;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.target.m_6084_();
        }

        public void m_8056_() {
            ShamanIllagerEntity.this.m_21573_().m_5624_((Entity)this.target, 1.3);
        }

        public void m_8041_() {
            ShamanIllagerEntity.this.m_21573_().m_26573_();
        }
    }

    private class ShamanAttackBoostSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ShamanAttackBoostSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && ShamanIllagerEntity.this.isInRaid();
        }

        @Override
        protected void castSpell() {
            ServerLevel level = (ServerLevel)ShamanIllagerEntity.this.m_9236_();
            AABB buffAABB = new AABB(ShamanIllagerEntity.this.m_20183_()).m_82400_((double)ShamanIllagerEntity.this.config().shaman.allyBuffRadius);
            Predicate<AbstractIllager> canReceiveBuff = illager -> !illager.m_7306_((Entity)ShamanIllagerEntity.this) && !illager.m_21023_(MobEffects.f_19600_);
            List raiders = level.m_6443_(AbstractIllager.class, buffAABB, canReceiveBuff);
            int duration = ShamanIllagerEntity.this.config().shaman.allyStrengthDuration;
            int amplifier = ShamanIllagerEntity.this.config().shaman.allyStrengthAmplifier;
            raiders.forEach(r -> {
                r.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration < 40 ? duration : ShamanIllagerEntity.this.f_19796_.m_216339_(duration - 20, duration + 21), amplifier));
                r.m_5496_(SoundEvents.f_11772_, 0.5f, 1.0f);
            });
            ShamanIllagerEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration / 2, amplifier / 2));
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 400;
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12551_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.SHAMAN_ATTACK_BOOST;
        }
    }

    private class ShamanDefenseBoostSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ShamanDefenseBoostSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && ShamanIllagerEntity.this.isInRaid();
        }

        @Override
        protected void castSpell() {
            ServerLevel level = (ServerLevel)ShamanIllagerEntity.this.m_9236_();
            AABB buffAABB = new AABB(ShamanIllagerEntity.this.m_20183_()).m_82400_((double)ShamanIllagerEntity.this.config().shaman.allyBuffRadius);
            Predicate<AbstractIllager> canReceiveBuff = illager -> !illager.m_7306_((Entity)ShamanIllagerEntity.this) && !illager.m_21023_(MobEffects.f_19606_);
            List raiders = level.m_6443_(AbstractIllager.class, buffAABB, canReceiveBuff);
            int duration = ShamanIllagerEntity.this.config().shaman.allyResistanceDuration;
            int amplifier = ShamanIllagerEntity.this.config().shaman.allyResistanceAmplifier;
            raiders.forEach(r -> {
                r.m_7292_(new MobEffectInstance(MobEffects.f_19606_, duration < 40 ? duration : ShamanIllagerEntity.this.f_19796_.m_216339_(duration - 20, duration + 21), amplifier));
                r.m_5496_(SoundEvents.f_11772_, 0.5f, 1.0f);
            });
            ShamanIllagerEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, duration / 2, amplifier / 2));
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 400;
        }

        @Override
        protected int getCastWarmupTime() {
            return 40;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12551_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.SHAMAN_DEFENSE_BOOST;
        }
    }

    private class ShamanDebuffSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ShamanDebuffSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            ServerLevel level = (ServerLevel)ShamanIllagerEntity.this.m_9236_();
            LivingEntity target = ShamanIllagerEntity.this.m_5448_();
            Random random = new Random();
            ArrayList<MobEffect> debuffPool = new ArrayList<MobEffect>(ShamanIllagerEntity.this.config().shaman.getEffectPool());
            if (target != null) {
                int debuffCount = ShamanIllagerEntity.this.config().shaman.maxDebuffCount;
                HashSet<MobEffect> apply = new HashSet<MobEffect>();
                MobEffect mainEffect = (MobEffect)debuffPool.get(random.nextInt(debuffPool.size()));
                apply.add(mainEffect);
                debuffPool.remove(mainEffect);
                for (int i = 0; i < debuffCount - 1 && !debuffPool.isEmpty() && ShamanIllagerEntity.this.f_19796_.m_188501_() < ShamanIllagerEntity.this.config().shaman.additionalDebuffChance; ++i) {
                    MobEffect effect2 = (MobEffect)debuffPool.get(random.nextInt(debuffPool.size()));
                    apply.add(effect2);
                    debuffPool.remove(effect2);
                }
                ShamanDebuffBulletEntity projectile = ShamanDebuffBulletEntity.create((Level)level, (LivingEntity)ShamanIllagerEntity.this, (Entity)target, ShamanIllagerEntity.this.m_6350_().m_122434_());
                apply.forEach(effect -> {
                    int duration = ShamanIllagerEntity.this.config().shaman.debuffDuration;
                    int amplifier = ShamanIllagerEntity.this.config().shaman.debuffAmplifier;
                    projectile.loadDebuff(new MobEffectInstance(effect, duration, amplifier));
                });
                ShamanIllagerEntity shaman = ShamanIllagerEntity.this;
                Vec3i eye_pos = new Vec3i((int)shaman.m_146892_().f_82479_, (int)shaman.m_146892_().f_82480_, (int)shaman.m_146892_().f_82481_);
                projectile.m_20035_(new BlockPos(eye_pos).m_7918_(0, (int)ShamanIllagerEntity.this.m_20192_() + 1, 0), 0.0f, 0.0f);
                level.m_7967_((Entity)projectile);
                ShamanIllagerEntity.this.m_5496_(SoundEvents.f_12417_, 2.0f, 1.0f);
            }
        }

        @Override
        protected int getCastingTime() {
            return 10;
        }

        @Override
        protected int getCastingInterval() {
            return 120;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12551_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.SHAMAN_DEBUFF;
        }
    }

    private class ShamanInvisibilitySpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ShamanInvisibilitySpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            int duration = ShamanIllagerEntity.this.config().shaman.invisibilityDuration;
            ShamanIllagerEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, duration, 1));
        }

        @Override
        public boolean m_8036_() {
            if (ShamanIllagerEntity.this.m_21223_() < ShamanIllagerEntity.this.m_21233_() / 2.0f) {
                if (ShamanIllagerEntity.this.isCastingSpell()) {
                    return false;
                }
                return ShamanIllagerEntity.this.f_19797_ >= this.spellCooldown;
            }
            return false;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 600;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12054_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.SHAMAN_INVISIBILITY;
        }
    }
}

