/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.setup;

import com.calculusmaster.difficultraids.config.RaidDifficultyConfig;
import com.calculusmaster.difficultraids.config.RaiderConfigs;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class DifficultRaidsConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ForgeConfigSpec.IntValue WAVE_COUNT_EASY;
    public static ForgeConfigSpec.IntValue WAVE_COUNT_NORMAL;
    public static ForgeConfigSpec.IntValue WAVE_COUNT_HARD;
    public static ForgeConfigSpec.EnumValue<DifficultRaidsUtil.OverflowHandlingMode> OVERFLOW_MODE;
    public static ForgeConfigSpec.BooleanValue RESTRICTIVE_MODE;
    public static ForgeConfigSpec.DoubleValue BELL_SEARCH_RADIUS;
    public static ForgeConfigSpec.BooleanValue FRIENDLY_FIRE_ARROWS;
    public static ForgeConfigSpec.IntValue HIGHLIGHT_THRESHOLD;
    public static ForgeConfigSpec.BooleanValue BOSS_BARS;
    public static ForgeConfigSpec.BooleanValue SHOW_WAVE_INFORMATION;
    public static ForgeConfigSpec.BooleanValue INSANITY_MODE;
    public static ForgeConfigSpec.DoubleValue INSANITY_COUNT_MULTIPLIER;
    public static ForgeConfigSpec.BooleanValue DISPLAY_INSANITY_MODE;
    public static Map<String, ForgeConfigSpec.BooleanValue> ENABLED_RAIDERS;
    public static RaidDifficultyConfig DEFAULT;
    public static RaidDifficultyConfig HERO;
    public static RaidDifficultyConfig LEGEND;
    public static RaidDifficultyConfig MASTER;
    public static RaidDifficultyConfig GRANDMASTER;
    public static TagKey<EntityType<?>> WINDS_CURSE_IMMUNE;

    public static void initializeConfigs() {
        DEFAULT.init();
        HERO.init();
        LEGEND.init();
        MASTER.init();
        GRANDMASTER.init();
    }

    public static void register() {
        ForgeConfigSpec.Builder GENERAL = new ForgeConfigSpec.Builder();
        GENERAL.push("Wave Amounts");
        WAVE_COUNT_EASY = GENERAL.comment("Number of waves in a Raid on Easy difficulty.").defineInRange("waveCountEasy", 3, 1, Integer.MAX_VALUE);
        WAVE_COUNT_NORMAL = GENERAL.comment("Number of waves in a Raid on Normal difficulty.").defineInRange("waveCountNormal", 5, 1, Integer.MAX_VALUE);
        WAVE_COUNT_HARD = GENERAL.comment("Number of waves in a Raid on Hard difficulty.").defineInRange("waveCountHard", 7, 1, Integer.MAX_VALUE);
        OVERFLOW_MODE = GENERAL.comment("Advanced config. Only edit if you're working with the datapack configuration!").comment("Determines how the mod will handle the case where a raider does not have a spawn count defined for a wave.").comment("This can happen if the number of waves is changed, but the spawn counts list for a raider is not updated.").comment("ZERO: The raider will not spawn if it does not have a spawn count defined for the current wave.").comment("REPEAT: The raider will spawn with the last wave's (whatever the last registered wave is for it) spawn count for the current wave.").defineEnum("arrayOverflowMode", (Enum)DifficultRaidsUtil.OverflowHandlingMode.ZERO, (Enum[])new DifficultRaidsUtil.OverflowHandlingMode[]{DifficultRaidsUtil.OverflowHandlingMode.ZERO, DifficultRaidsUtil.OverflowHandlingMode.REPEAT});
        RESTRICTIVE_MODE = GENERAL.comment("If enabled, this will make it so that if a raider is not registered implicitly by DifficultRaids, or a datapack, it will not spawn in higher difficulty raids.").comment("This can be used if you want full control over raid spawns, and do not want other mods to inject their raiders if not registered by DifficultRaids or a datapack.").define("restrictiveMode", false);
        GENERAL.pop();
        GENERAL.push("Raid Mechanics");
        BELL_SEARCH_RADIUS = GENERAL.comment("Search radius of the Bell when hit.").comment("WARNING: This can cause a decent bit of lag at high radius values because it will search more and more blocks around the village center.").comment("Vanilla Minecraft uses a radius of 48 blocks.").defineInRange("bellSearchRadius", 256.0, 0.0, 2.147483647E9);
        FRIENDLY_FIRE_ARROWS = GENERAL.comment("Toggles whether arrows fired by Raiders (such as Pillagers) can deal damage to other Raiders.").define("friendlyFireArrowsEnabled", false);
        GENERAL.pop();
        GENERAL.push("UI");
        HIGHLIGHT_THRESHOLD = GENERAL.comment("If there are fewer raiders alive than this threshold, they will be highlighted permanently. Set to 0 to disable highlighting.").defineInRange("highlightThreshold", 3, 0, Integer.MAX_VALUE);
        BOSS_BARS = GENERAL.comment("Toggles whether Boss Bars for Elite Raiders/Bosses will show up during Raids.").comment(new String[]{"Enabling this will create Boss Event Bars for:", "DifficultRaids: Nuaos, Xydrax, Voldon, Modur", "Illage & Spillage: Freakager, Magispeller, Spiritcaller", "Dungeons Mobs: Redstone Golem", "Leo's Illagers: Lightningcaller, Clownager"}).define("bossBarsEnabled", true);
        SHOW_WAVE_INFORMATION = GENERAL.comment("Determines if wave information will show up in the Raid Event title.").define("showWaveInformation", true);
        GENERAL.pop();
        GENERAL.push("Insanity Mode");
        INSANITY_MODE = GENERAL.comment("Activate Insanity mode.").comment("'Detecting hundreds of raiders in the region. Are you certain whatever you're doing is worth it?'").define("insanityMode", false);
        INSANITY_COUNT_MULTIPLIER = GENERAL.comment("The multiplier for the number of raiders spawned in Insanity mode.").comment("This gets applied on top of whatever difficulty a Raid is at. This will not apply to Default Raids.").defineInRange("insanityCountMultiplier", 3.0, 1.0, Double.MAX_VALUE);
        DISPLAY_INSANITY_MODE = GENERAL.comment("Toggles whether or not to display 'Insane' on the raid").define("displayInsanityMode", true);
        GENERAL.pop();
        GENERAL.comment("Customize which Raiders will show up in Raids. A game restart is required.").push("Enabled Raiders");
        GENERAL.push("Vanilla Raiders");
        ENABLED_RAIDERS.put("VINDICATOR", GENERAL.define("enableVindicators", true));
        ENABLED_RAIDERS.put("EVOKER", GENERAL.define("enableEvokers", true));
        ENABLED_RAIDERS.put("PILLAGER", GENERAL.define("enablePillagers", true));
        ENABLED_RAIDERS.put("WITCH", GENERAL.define("enableWitches", true));
        ENABLED_RAIDERS.put("RAVAGER", GENERAL.define("enableRavagers", true));
        GENERAL.pop().push("DifficultRaids");
        ENABLED_RAIDERS.put("ILLUSIONER_MC", GENERAL.define("enableIllusioners", true));
        ENABLED_RAIDERS.put("WARRIOR_ILLAGER", GENERAL.define("enableWarriors", true));
        ENABLED_RAIDERS.put("DART_ILLAGER", GENERAL.define("enableDarts", true));
        ENABLED_RAIDERS.put("ELECTRO_ILLAGER", GENERAL.define("enableConductors", true));
        ENABLED_RAIDERS.put("NECROMANCER_ILLAGER", GENERAL.define("enableNecromancers", true));
        ENABLED_RAIDERS.put("SHAMAN_ILLAGER", GENERAL.define("enableShamans", true));
        ENABLED_RAIDERS.put("TANK_ILLAGER", GENERAL.define("enableTanks", true));
        ENABLED_RAIDERS.put("ASSASSIN_ILLAGER", GENERAL.define("enableAssassins", true));
        ENABLED_RAIDERS.put("FROST_ILLAGER", GENERAL.define("enableFrostmages", true));
        ENABLED_RAIDERS.put("ASHENMANCER_ILLAGER", GENERAL.define("enableAshenmancers", true));
        GENERAL.pop().push("Requires HuntersReturn");
        ENABLED_RAIDERS.put("hunters_return", GENERAL.define("enableHunters", true));
        GENERAL.pop().push("Requires EnchantWithMob");
        ENABLED_RAIDERS.put("enchanter", GENERAL.define("enableEnchanters", true));
        GENERAL.pop().push("Requires It Takes a Pillage");
        ENABLED_RAIDERS.put("ARCHER", GENERAL.define("enableArchers", true));
        ENABLED_RAIDERS.put("SKIRMISHER", GENERAL.define("enableSkirmishers", true));
        ENABLED_RAIDERS.put("LEGIONER", GENERAL.define("enableLegioners", true));
        GENERAL.pop().push("Requires Illage & Spillage");
        ENABLED_RAIDERS.put("entity.illageandspillage.igniter", GENERAL.define("enableIgniters", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.twittollager", GENERAL.define("enableTwittollagers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.preserver", GENERAL.define("enablePreservers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.absorber", GENERAL.define("enableAbsorbers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.crocofang", GENERAL.define("enableCrocofangs", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.engineer", GENERAL.define("enableEngineers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.magispeller", GENERAL.define("enableMagispellers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.spiritcaller", GENERAL.define("enableSpiritcallers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.freakager", GENERAL.define("enableFreakagers", true));
        ENABLED_RAIDERS.put("entity.illageandspillage.boss_randomizer", GENERAL.define("enableBossRandomizers", true));
        GENERAL.pop().push("Requires Savage and Ravage");
        ENABLED_RAIDERS.put("GRIEFER", GENERAL.define("enableGriefers", true));
        ENABLED_RAIDERS.put("SR_EXECUTIONER", GENERAL.define("enableExecutioners", true));
        ENABLED_RAIDERS.put("TRICKSTER", GENERAL.define("enableTricksters", true));
        ENABLED_RAIDERS.put("SR_ICEOLOGER", GENERAL.define("enableSavageRavageIceologers", true));
        GENERAL.pop().push("Requires Leo's Illagers");
        ENABLED_RAIDERS.put("entity.leosillagers.vindicator_with_shield", GENERAL.define("enableShieldVindicator", true));
        ENABLED_RAIDERS.put("entity.leosillagers.lightning_caller", GENERAL.define("enableLightningCaller", true));
        ENABLED_RAIDERS.put("entity.leosillagers.clownager", GENERAL.define("enableClownager", true));
        ENABLED_RAIDERS.put("entity.leosillagers.confuser", GENERAL.define("enableConfuser", true));
        ENABLED_RAIDERS.put("entity.leosillagers.meteorite_caller", GENERAL.define("enableMeteoriteCaller", true));
        ENABLED_RAIDERS.put("entity.leosillagers.snowolager", GENERAL.define("enableSnowolager", true));
        ENABLED_RAIDERS.put("entity.leosillagers.necromancer", GENERAL.define("enableNecromancerLeo", true));
        ENABLED_RAIDERS.put("entity.leosillagers.summoner", GENERAL.define("enableSummoner", true));
        ENABLED_RAIDERS.put("entity.leosillagers.troublemaker", GENERAL.define("enableTroublemaker", true));
        GENERAL.pop().push("Requires Dungeon Mobs");
        ENABLED_RAIDERS.put("mountaineer", GENERAL.define("enableMountaineers", true));
        ENABLED_RAIDERS.put("royal_guard", GENERAL.define("enableRoyalGuards", true));
        ENABLED_RAIDERS.put("geomancer", GENERAL.define("enableGeomancers", true));
        ENABLED_RAIDERS.put("dungeon_mage", GENERAL.define("enableMages", true));
        ENABLED_RAIDERS.put("DM_ICEOLOGER", GENERAL.define("enableDungeonMobsIceologers", true));
        ENABLED_RAIDERS.put("windcaller", GENERAL.define("enableWindcallers", true));
        ENABLED_RAIDERS.put("squall_golem", GENERAL.define("enableSquallGolems", true));
        ENABLED_RAIDERS.put("redstone_golem", GENERAL.define("enableRedstoneGolems", true));
        GENERAL.pop().push("Requires The Conjurer");
        ENABLED_RAIDERS.put("conjurer", GENERAL.define("enableConjurer", false));
        GENERAL.pop().push("Requires Necromancer Mod Port");
        ENABLED_RAIDERS.put("necromancer_mod", GENERAL.define("enableModNecromancer", true));
        GENERAL.pop().push("Requires Werden's Illagers +");
        ENABLED_RAIDERS.put("sinister", GENERAL.define("enableSinister", true));
        ENABLED_RAIDERS.put("shadomancer", GENERAL.define("enableShadomancer", true));
        GENERAL.pop().push("Requires Guard Illagers");
        ENABLED_RAIDERS.put("guard_illager", GENERAL.define("enableGuardillager", true));
        GENERAL.pop().push("Requires MobZ");
        ENABLED_RAIDERS.put("spider_mage", GENERAL.define("enableSpiderMage", true));
        ENABLED_RAIDERS.put("zombie_mage", GENERAL.define("enableZombieMage", true));
        ENABLED_RAIDERS.put("pillager_boss", GENERAL.define("enablePillagerBoss", true));
        ENABLED_RAIDERS.put("illusioner_mobz", GENERAL.define("enableMobZIllusioner", true));
        ENABLED_RAIDERS.put("baby_ravager", GENERAL.define("enableBabyRavager", true));
        GENERAL.pop().push("Requires Illager Invasion");
        ENABLED_RAIDERS.put("ILLAGERINVASION_PROVOKER", GENERAL.define("enablePovoker", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_INQUISITOR", GENERAL.define("enableInquisitor", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_MARAUDER", GENERAL.define("enableMarauder", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_BASHER", GENERAL.define("enableBasher", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_FIRECALLER", GENERAL.define("enableFirecaller", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_NECROMANCER", GENERAL.define("enableInvasionNecromancer", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_ALCHEMIST", GENERAL.define("enableAlchemist", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_SORCERER", GENERAL.define("enableSorcerer", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_ARCHIVIST", GENERAL.define("enableArchivist", true));
        ENABLED_RAIDERS.put("ILLAGERINVASION_INVOKER", GENERAL.define("enableInvoker", true));
        GENERAL.pop().push("Requires Goety");
        GENERAL.comment("Those settings can be overwritten by Goety");
        ENABLED_RAIDERS.put("GOETY_WARLOCK", GENERAL.define("enableWarlock", true));
        ENABLED_RAIDERS.put("GOETY_MAVERICK", GENERAL.define("enableMaverick", true));
        ENABLED_RAIDERS.put("GOETY_HERETIC", GENERAL.define("enableHeretic", true));
        ENABLED_RAIDERS.put("GOETY_PIKER", GENERAL.define("enablePiker", true));
        ENABLED_RAIDERS.put("GOETY_RIPPER", GENERAL.define("enableRipper", true));
        ENABLED_RAIDERS.put("GOETY_CRUSHER", GENERAL.define("enableCrusher", true));
        ENABLED_RAIDERS.put("GOETY_STORM_CASTER", GENERAL.define("enableStorm_caster", true));
        ENABLED_RAIDERS.put("GOETY_CRYOLOGER", GENERAL.define("enableCryologer", true));
        ENABLED_RAIDERS.put("GOETY_PREACHER", GENERAL.define("enablePreacher", true));
        ENABLED_RAIDERS.put("GOETY_CONQUILLAGER", GENERAL.define("enableConquillager", true));
        ENABLED_RAIDERS.put("GOETY_INQUILLAGER", GENERAL.define("enableInquillager", true));
        ENABLED_RAIDERS.put("GOETY_ENVIOKER", GENERAL.define("enableEnvioker", true));
        ENABLED_RAIDERS.put("GOETY_SORCERER", GENERAL.define("enableGoetySorcerer", true));
        ENABLED_RAIDERS.put("GOETY_MINISTER", GENERAL.define("enableMinister", true));
        ENABLED_RAIDERS.put("GOETY_TRAMPLER", GENERAL.define("enableTrampler", true));
        ENABLED_RAIDERS.put("GOETY_VIZIER", GENERAL.define("enableVizier", false));
        ENABLED_RAIDERS.put("GOETY_APOSTLE", GENERAL.define("enableApostle", false));
        GENERAL.comment("If you enable Redstone Golem and Redstone Monstrosity, make sure to enable them in Goety config");
        ENABLED_RAIDERS.put("GOETY_HOSTILE_RED_GOLEM", GENERAL.define("enableRedstoneGolemGoety", false));
        ENABLED_RAIDERS.put("GOETY_HOSTILE_RED_MONSTER", GENERAL.define("enableRedstoneMonstrosity", false));
        GENERAL.pop().push("Requires The Summoner Illager Port");
        ENABLED_RAIDERS.put("summoner", GENERAL.define("enableSummoner", true));
        ENABLED_RAIDERS.put("summoner_boss", GENERAL.define("enableSummonerBoss", true));
        GENERAL.pop().push("Requires Bones Update");
        ENABLED_RAIDERS.put("NECROMANCER_BONES", GENERAL.define("enableBonesNecromancer", true));
        GENERAL.pop().push("Requires Illager Additions");
        GENERAL.comment("Those settings can be overwritten by Illager Additions");
        ENABLED_RAIDERS.put("royal_longaxe_guard", GENERAL.define("enableRoyalGuardSpear", true));
        ENABLED_RAIDERS.put("zaaaaguard", GENERAL.define("enableSpearman", true));
        ENABLED_RAIDERS.put("samurai", GENERAL.define("enableSamurai", true));
        ENABLED_RAIDERS.put("blastioner", GENERAL.define("enableBeamloger", true));
        GENERAL.comment("If you enable Cowboy or Shogun, make sure to enable them in Illager Additions config");
        ENABLED_RAIDERS.put("cowboy_IA", GENERAL.define("enableCowboy", false));
        ENABLED_RAIDERS.put("shogun", GENERAL.define("enableShogun", false));
        GENERAL.pop().push("Requires The Modifiger");
        ENABLED_RAIDERS.put("modifiger", GENERAL.define("enableModifiger", true));
        GENERAL.pop().push("Requires Musketeer Illager");
        ENABLED_RAIDERS.put("marksman", GENERAL.define("enableMarksman", true));
        GENERAL.pop().push("Requires The Masquerader");
        GENERAL.comment("If you change the spawn rate of this mob, make sure no other bosses from Illage & Spillage spawn in the same wave, or they will have infinite force field.");
        ENABLED_RAIDERS.put("masquerader", GENERAL.define("enableMasquerader", true));
        GENERAL.pop().push("Requires Bagus Mob");
        ENABLED_RAIDERS.put("tengu", GENERAL.define("enableTengu", true));
        ENABLED_RAIDERS.put("ninjar", GENERAL.define("enableNinjar", true));
        GENERAL.pop().push("Requires Illager Revolution");
        ENABLED_RAIDERS.put("illager_beast_tamer", GENERAL.define("enableBeastTamer", true));
        ENABLED_RAIDERS.put("blade_knight", GENERAL.define("enableBladeKnight", true));
        ENABLED_RAIDERS.put("illager_scavenger", GENERAL.define("enableScavenger", true));
        ENABLED_RAIDERS.put("soul_sage", GENERAL.define("enableSoulSage", true));
        GENERAL.pop().push("Requires Raided");
        ENABLED_RAIDERS.put("raided:necromancer", GENERAL.define("enableRaidedNecromancer", true));
        ENABLED_RAIDERS.put("raided:electromancer", GENERAL.define("enableRaidedElectromancer", true));
        ENABLED_RAIDERS.put("raided:savager", GENERAL.define("enableSavager", true));
        ENABLED_RAIDERS.put("raided:incinerator", GENERAL.define("enableIncinerator", true));
        ENABLED_RAIDERS.put("raided:inquisitor", GENERAL.define("enableRaidedInquisitor", true));
        GENERAL.pop().push("Requires More Illagers");
        ENABLED_RAIDERS.put("gunillager", GENERAL.define("enableGunillager", true));
        ENABLED_RAIDERS.put("illgeve", GENERAL.define("enableIlligeve", true));
        ENABLED_RAIDERS.put("surpriser", GENERAL.define("enableSurpriser", true));
        ENABLED_RAIDERS.put("rocketillager", GENERAL.define("enableRocketillager", true));
        ENABLED_RAIDERS.put("creepillager", GENERAL.define("enableCreepillager", true));
        ENABLED_RAIDERS.put("monsterillager", GENERAL.define("enableMonsterillager", true));
        GENERAL.pop().push("Requires Slash Illager");
        ENABLED_RAIDERS.put("blade_master", GENERAL.define("enableBladeMaster", true));
        GENERAL.pop().push("Requires Friends & Foes");
        ENABLED_RAIDERS.put("ICEOLOGER_FF", GENERAL.define("enableFriendsAndFoesIceologer", true));
        GENERAL.pop().push("Requires Mo' Features");
        ENABLED_RAIDERS.put("pillager_brute", GENERAL.define("enablePillagerBrute", true));
        GENERAL.pop().push("Requires Brazier");
        ENABLED_RAIDERS.put("crazed", GENERAL.define("enableCrazed", false));
        GENERAL.pop().push("Requires Ravage & Cabbage");
        ENABLED_RAIDERS.put("cabbager", GENERAL.define("enableCabbager", true));
        GENERAL.pop().push("Requires CrimsonSteve's more mobs");
        ENABLED_RAIDERS.put("phantom_tamer", GENERAL.define("enablePhamtomTamer", true));
        ENABLED_RAIDERS.put("t_rabus_boss", GENERAL.define("enableTRabus", true));
        ENABLED_RAIDERS.put("modid:cyborg_vindicator", GENERAL.define("enableCyborgVindicator", true));
        ENABLED_RAIDERS.put("crude_redstone_golem", GENERAL.define("enableCrudeRedstoneGolem", true));
        ENABLED_RAIDERS.put("crude_redstone_monstrosity", GENERAL.define("enableCrudeRedstoneMonstrosity", true));
        ENABLED_RAIDERS.put("original_redstone_monstrosity", GENERAL.define("enableCrimsonStevesRedstoneMonstrosity", true));
        ENABLED_RAIDERS.put("mini_crude_redstone_golem", GENERAL.define("enableMiniCrudeRedstoneGolem", true));
        GENERAL.pop().push("Requires All Bark, All Bite");
        ENABLED_RAIDERS.put("houndmaster", GENERAL.define("enableHoundmaster", true));
        GENERAL.pop().push("Requires Karate Illager");
        ENABLED_RAIDERS.put("karate_illager", GENERAL.define("enableKarateIllager", true));
        GENERAL.pop().push("Requires Illager Brute");
        ENABLED_RAIDERS.put("illagerbrute", GENERAL.define("enableIllagerBrute", true));
        GENERAL.pop().push("Requires Sorcerer Illager");
        ENABLED_RAIDERS.put("sorcererillager", GENERAL.define("enableSorcererIllager", true));
        GENERAL.pop().push("Requires Wandering Illager");
        ENABLED_RAIDERS.put("wanderingillager", GENERAL.define("enableWanderingIllager", true));
        GENERAL.pop().push("Requires Expado's Illagers");
        ENABLED_RAIDERS.put("brasher", GENERAL.define("enableBrasher", true));
        ENABLED_RAIDERS.put("knocker", GENERAL.define("enableKnocker", true));
        ENABLED_RAIDERS.put("wrecker", GENERAL.define("enableWrecker", true));
        ENABLED_RAIDERS.put("hackle", GENERAL.define("enableHackle", true));
        ENABLED_RAIDERS.put("juggernaut", GENERAL.define("enableJuggernaut", true));
        ENABLED_RAIDERS.put("bludgeoner", GENERAL.define("enableBludgeoner", true));
        ENABLED_RAIDERS.put("pikeloger", GENERAL.define("enablePikeloger", true));
        ENABLED_RAIDERS.put("expado_grindicator", GENERAL.define("enableGrindicator", true));
        GENERAL.pop().push("Requires Francis Illagers");
        ENABLED_RAIDERS.put("patrologer", GENERAL.define("enablePatrologer", true));
        ENABLED_RAIDERS.put("chefager", GENERAL.define("enableChefager", true));
        ENABLED_RAIDERS.put("francis_grindicator", GENERAL.define("enableFrancisGrindicator", true));
        ENABLED_RAIDERS.put("francis_mage", GENERAL.define("enableFrancisMage", true));
        ENABLED_RAIDERS.put("chefologer", GENERAL.define("enableChefologer", true));
        ENABLED_RAIDERS.put("pyrobandit", GENERAL.define("enablePyrobandit", true));
        ENABLED_RAIDERS.put("fireologer", GENERAL.define("enableFireologer", true));
        ENABLED_RAIDERS.put("vrincitador", GENERAL.define("enableVrincitador", true));
        ENABLED_RAIDERS.put("sandologer", GENERAL.define("enableSandologer", true));
        ENABLED_RAIDERS.put("grummicator", GENERAL.define("enableGrummicator", true));
        GENERAL.pop().push("Requires Earth Mobs");
        ENABLED_RAIDERS.put("viler_witch", GENERAL.define("enableVilerWitch", true));
        GENERAL.pop().push("Requires Illager World War");
        ENABLED_RAIDERS.put("pillager_car", GENERAL.define("enablePillagerCar", true));
        ENABLED_RAIDERS.put("pillager_soldier_armed", GENERAL.define("enableArmedSoldier", true));
        ENABLED_RAIDERS.put("pillager_soldier_with_flamethrower", GENERAL.define("enableVindicatorFlameThrower", true));
        ENABLED_RAIDERS.put("assault_pillager_soldier", GENERAL.define("enableAssaultPillager", true));
        ENABLED_RAIDERS.put("plane_avec_pillager_soldier", GENERAL.define("enablePlanePillager", true));
        ENABLED_RAIDERS.put("cannon_with_soldier_pillager", GENERAL.define("enableCannonPillager", true));
        GENERAL.pop().push("Requires Colds: Wandering Trader");
        ENABLED_RAIDERS.put("wandering_traitor", GENERAL.define("enableWanderingTraitor", true));
        GENERAL.pop().push("Requires Just Illagers");
        ENABLED_RAIDERS.put("druski", GENERAL.define("enableDruski", true));
        ENABLED_RAIDERS.put("guard", GENERAL.define("enableLacher", true));
        ENABLED_RAIDERS.put("crisko", GENERAL.define("enableCrisko", true));
        ENABLED_RAIDERS.put("blaker", GENERAL.define("enableBlaker", true));
        ENABLED_RAIDERS.put("toxicist", GENERAL.define("enableToxicist", true));
        ENABLED_RAIDERS.put("reverant", GENERAL.define("enableRevenant", true));
        ENABLED_RAIDERS.put("ampi", GENERAL.define("enableAmpi", true));
        GENERAL.pop().push("Requires Illager Universe");
        ENABLED_RAIDERS.put("upgrader", GENERAL.define("enableUpgrader", true));
        ENABLED_RAIDERS.put("upgrader_gold", GENERAL.define("enableUpgraderGold", true));
        ENABLED_RAIDERS.put("upgrader_diamond", GENERAL.define("enableUpgraderDiamond", true));
        ENABLED_RAIDERS.put("shadow_goat", GENERAL.define("enableShadowGoar", true));
        ENABLED_RAIDERS.put("prinzologer", GENERAL.define("enablePrinzologer", true));
        ENABLED_RAIDERS.put("callologer", GENERAL.define("enableCallologer", true));
        GENERAL.pop().push("Requires Pillager Boss");
        ENABLED_RAIDERS.put("pillagerboss", GENERAL.define("enablePillagerBossMod", true));
        GENERAL.pop().push("Requires Virtuso's Grand Battle");
        ENABLED_RAIDERS.put("virtuoso_of_variety", GENERAL.define("enableVirtuosoOfVariety", true));
        GENERAL.pop().push("Requires Mischief Illagers");
        ENABLED_RAIDERS.put("mischiever", GENERAL.define("enableMischiever", true));
        ENABLED_RAIDERS.put("withermancer", GENERAL.define("enableWithermancer", true));
        ENABLED_RAIDERS.put("doodler", GENERAL.define("enableDoodler", true));
        ENABLED_RAIDERS.put("fangclaw", GENERAL.define("enableFangclaw", true));
        ENABLED_RAIDERS.put("sparkologer", GENERAL.define("enableSparkologer", true));
        ENABLED_RAIDERS.put("libravoker", GENERAL.define("enableLibravoker", true));
        ENABLED_RAIDERS.put("bubbleologer", GENERAL.define("enableBubbleologer", true));
        ENABLED_RAIDERS.put("bass_blaster", GENERAL.define("enableBassBlaster", true));
        ENABLED_RAIDERS.put("imprecator", GENERAL.define("enableImprecator", true));
        ENABLED_RAIDERS.put("magnetizer", GENERAL.define("enableMagnetizer", true));
        ENABLED_RAIDERS.put("photographer", GENERAL.define("enablePhotographer", true));
        ENABLED_RAIDERS.put("partyger", GENERAL.define("enablePartyger", true));
        GENERAL.pop().push("Requires Burning Illagers");
        ENABLED_RAIDERS.put("micromancer", GENERAL.define("enableMicromancer", true));
        ENABLED_RAIDERS.put("disvoker", GENERAL.define("enableDisvoker", true));
        ENABLED_RAIDERS.put("gharzul", GENERAL.define("enableGharzul", true));
        ENABLED_RAIDERS.put("ravamage", GENERAL.define("enableRavamage", true));
        GENERAL.pop().push("Requires Pillagers Plus");
        ENABLED_RAIDERS.put("sword_pillager", GENERAL.define("enableSwordPillager", true));
        ENABLED_RAIDERS.put("spear_pillager", GENERAL.define("enableSpearIllager", true));
        ENABLED_RAIDERS.put("hog_rider", GENERAL.define("enableHogRider", true));
        GENERAL.pop().push("Requires Immersive Engineering");
        ENABLED_RAIDERS.put("commando", GENERAL.define("enableCommando", true));
        ENABLED_RAIDERS.put("fusilier", GENERAL.define("enableFusilier", true));
        ENABLED_RAIDERS.put("bulwark", GENERAL.define("enableBulwark", true));
        GENERAL.pop().push("Requires Kamilskis Additions");
        ENABLED_RAIDERS.put("balloon_pillager", GENERAL.define("enableBalloonPillager", true));
        ENABLED_RAIDERS.put("silverfish_wrangler", GENERAL.define("enableSilverfishWrangler", true));
        GENERAL.pop().push("Requires Born in Chaos");
        ENABLED_RAIDERS.put("missionary_raider", GENERAL.define("enableMissionary", true));
        GENERAL.pop().push("Requires Eidolon: Repraised");
        ENABLED_RAIDERS.put("eidolon:necromancer", GENERAL.define("enableEidolonNecromancer", true));
        GENERAL.pop().push("Requires From the Shadows");
        ENABLED_RAIDERS.put("fromtheshadows", GENERAL.define("enableCleric", true));
        GENERAL.pop().push("Requires Rats");
        ENABLED_RAIDERS.put("RATS_PIPER", GENERAL.define("enablePiedPiper", true));
        GENERAL.pop().push("Requires Wild Delight");
        ENABLED_RAIDERS.put("wild_chef", GENERAL.define("enableWildChef", true));
        GENERAL.pop().push("Requires Jerotes Village");
        GENERAL.comment("Everything is disabled in Jerotes Village config");
        GENERAL.comment("If you want to enable something, enable it here and in Jerotes Village config");
        ENABLED_RAIDERS.put("TRUMPETER", GENERAL.define("enableTrumpeter", false));
        ENABLED_RAIDERS.put("BLASTER", GENERAL.define("enableBlaster", false));
        ENABLED_RAIDERS.put("DEFECTOR", GENERAL.define("enableDefector", false));
        ENABLED_RAIDERS.put("MAPMAKER", GENERAL.define("enableMapmaker", false));
        ENABLED_RAIDERS.put("BANNER_BEARER", GENERAL.define("enablebannerBearer", false));
        ENABLED_RAIDERS.put("EXECUTIONER_JEROTES", GENERAL.define("enableJerotesExecutioner", false));
        ENABLED_RAIDERS.put("EXPLORER", GENERAL.define("enableExplorer", false));
        ENABLED_RAIDERS.put("SLAVERY_SUPERVISOR", GENERAL.define("enableSlaverySupervisor", false));
        ENABLED_RAIDERS.put("CYCLONER", GENERAL.define("enableCycloner", false));
        ENABLED_RAIDERS.put("JAVELIN_THROWER", GENERAL.define("enableJavelinThrower", false));
        ENABLED_RAIDERS.put("ZOMBIE_KEEPER", GENERAL.define("enableZombieKeeper", false));
        ENABLED_RAIDERS.put("WILD_FINDER", GENERAL.define("enableWildFinder", false));
        ENABLED_RAIDERS.put("SUBMARINER", GENERAL.define("enableSubmariner", false));
        ENABLED_RAIDERS.put("SPIRVE", GENERAL.define("enableSpirve", false));
        ENABLED_RAIDERS.put("TELEPORTER", GENERAL.define("enableTeleporter", false));
        ENABLED_RAIDERS.put("LAMP_WIZARD", GENERAL.define("enableLampWizard", false));
        ENABLED_RAIDERS.put("BITTER_COLD_SORCERER", GENERAL.define("enableBitterColdSorcerer", false));
        ENABLED_RAIDERS.put("FIRE_SPITTER", GENERAL.define("enableFireSpitter", false));
        ENABLED_RAIDERS.put("PURPLE_SAND_WITCH", GENERAL.define("enablePurpleSandWitch", false));
        ENABLED_RAIDERS.put("WITCH_SCHOLAR", GENERAL.define("enableWitchScholar", false));
        ENABLED_RAIDERS.put("AX_CRAZY", GENERAL.define("enableAxCrazy", false));
        ENABLED_RAIDERS.put("PURPLE_SAND_HAG", GENERAL.define("enablePurpleSandHag", false));
        ENABLED_RAIDERS.put("NECROMANCY_WARLOCK", GENERAL.define("enableNecromancyWarlock", false));
        ENABLED_RAIDERS.put("GAVILER", GENERAL.define("enableGaviler", false));
        ENABLED_RAIDERS.put("BIG_WITCH", GENERAL.define("enableBigWitch", false));
        ENABLED_RAIDERS.put("FIREPOWER_POURER", GENERAL.define("enableFirepowerPourer", false));
        ENABLED_RAIDERS.put("OMINOUS_BANNER_PROJECTION", GENERAL.define("enableOminousBannerProjection", false));
        ENABLED_RAIDERS.put("HAG", GENERAL.define("enableCohortHag", false));
        GENERAL.pop().push("Requires NO IXAPI");
        GENERAL.comment("Those settings can be overwritten by NO.IXAPI");
        ENABLED_RAIDERS.put("bugler", GENERAL.define("enableBugler", true));
        ENABLED_RAIDERS.put("armorer", GENERAL.define("enableArmorer", true));
        ENABLED_RAIDERS.put("APIBiologist", GENERAL.define("enableBiologist", true));
        ENABLED_RAIDERS.put("APIHunter", GENERAL.define("enableAPIHunter", true));
        ENABLED_RAIDERS.put("mourner", GENERAL.define("enableMourner", true));
        GENERAL.comment("If you enable the following mobs, make sure to enable them in NO.IXAPI config");
        ENABLED_RAIDERS.put("abomination", GENERAL.define("enableAbomination", false));
        ENABLED_RAIDERS.put("drunkenness", GENERAL.define("enableDrunkenness", false));
        ENABLED_RAIDERS.put("flagman", GENERAL.define("enableFlagman", false));
        ENABLED_RAIDERS.put("intruder", GENERAL.define("enableIntruder", false));
        ENABLED_RAIDERS.put("grave_keeper", GENERAL.define("enableGraveKeeper", false));
        GENERAL.pop().push("Requires Roost2");
        ENABLED_RAIDERS.put("roost_rider", GENERAL.define("enableRoostRider", true));
        GENERAL.pop().push("Requires Snow's Bosses: Mechasent");
        ENABLED_RAIDERS.put("mechasent", GENERAL.define("enableMechasent", true));
        GENERAL.pop();
        GENERAL.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)GENERAL.build(), "difficultraids/general.toml");
        block7: for (RaidDifficulty rd : RaidDifficulty.values()) {
            RaidDifficultyConfig config = new RaidDifficultyConfig();
            ForgeConfigSpec.Builder spec = new ForgeConfigSpec.Builder();
            if (rd == RaidDifficulty.DEFAULT) {
                spec.comment("Note: Changing values in this config will have no impact on the game. Default Raids are Vanilla and do not feature anything from this mod. The config file exists for consistency within the code.\n");
            } else {
                spec.comment("Edit config values for " + rd.getFormattedName() + " Raids.\n");
            }
            spec.push("General Settings");
            config.elitesEnabled = spec.comment("Determines if Elite Raiders will show up in Raids.").define("elitesEnabled", true);
            config.playerHealthBoostAmount = spec.comment("Extra health that Raiders will receive per additional player in the Raid. 0 to disable Raiders receiving extra health.").defineInRange("playerHealthBoostAmount", 2.0, 0.0, Double.MAX_VALUE);
            spec.pop();
            spec.push("Vindicator Settings");
            config.vindicator = new RaiderConfigs.Vindicator(rd, spec);
            spec.pop();
            spec.push("Evoker Settings");
            config.evoker = new RaiderConfigs.Evoker(rd, spec);
            spec.pop();
            spec.push("Pillager Settings");
            config.pillager = new RaiderConfigs.Pillager(rd, spec);
            spec.pop();
            spec.push("Ravager Settings");
            config.ravager = new RaiderConfigs.Ravager(rd, spec);
            spec.pop();
            spec.push("Warrior Settings");
            config.warrior = new RaiderConfigs.Warrior(rd, spec);
            spec.pop();
            spec.push("Dart Settings");
            config.dart = new RaiderConfigs.Dart(rd, spec);
            spec.pop();
            spec.push("Conductor Settings");
            config.conductor = new RaiderConfigs.Conductor(rd, spec);
            spec.pop();
            spec.push("Necromancer Settings");
            config.necromancer = new RaiderConfigs.Necromancer(rd, spec);
            spec.pop();
            spec.push("Shaman Settings");
            config.shaman = new RaiderConfigs.Shaman(rd, spec);
            spec.pop();
            spec.push("Tank Settings");
            config.tank = new RaiderConfigs.Tank(rd, spec);
            spec.pop();
            spec.push("Assassin Settings");
            config.assassin = new RaiderConfigs.Assassin(rd, spec);
            spec.pop();
            spec.push("Frostmage Settings");
            config.frostmage = new RaiderConfigs.Frostmage(rd, spec);
            spec.pop();
            spec.push("Ashenmancer Settings");
            config.ashenmancer = new RaiderConfigs.Ashenmancer(rd, spec);
            spec.pop();
            spec.push("Elite Raiders");
            spec.push("Nuaos Settings");
            config.nuaos = new RaiderConfigs.Nuaos(rd, spec);
            spec.pop();
            spec.push("Xydrax Settings");
            config.xydrax = new RaiderConfigs.Xydrax(rd, spec);
            spec.pop();
            spec.push("Modur Settings");
            config.modur = new RaiderConfigs.Modur(rd, spec);
            spec.pop();
            spec.push("Voldon Settings");
            config.voldon = new RaiderConfigs.Voldon(rd, spec);
            spec.pop();
            spec.pop();
            spec.push("Compatibility");
            spec.comment("REQUIRES 'Hunters Return'").push("Hunter Illager Settings");
            config.hunter = new RaiderConfigs.Hunter(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'It Takes a Pillage'").push("Archer Settings");
            config.archer = new RaiderConfigs.Archer(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'It Takes a Pillage'").push("Skirmisher Settings");
            config.skirmisher = new RaiderConfigs.Skirmisher(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'It Takes a Pillage'").push("Legioner Settings");
            config.legioner = new RaiderConfigs.Legioner(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'Savage and Ravage'").push("Executioner Settings");
            config.executioner = new RaiderConfigs.Executioner(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'Dungeon Mobs'").push("Mountaineer Settings");
            config.mountaineer = new RaiderConfigs.Mountaineer(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'Dungeon Mobs'").push("Royal Guard Settings");
            config.royalguard = new RaiderConfigs.RoyalGuard(rd, spec);
            spec.pop();
            spec.comment("REQUIRES 'Leo's Illagers'").push("Vindicator With Shield Settings");
            config.vindicatorWithShield = new RaiderConfigs.VindicatorWithShield(rd, spec);
            spec.pop();
            spec.pop();
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec.build(), "difficultraids/raid-" + rd.toString().toLowerCase() + ".toml");
            switch (rd) {
                case DEFAULT: {
                    DEFAULT = config;
                    continue block7;
                }
                case HERO: {
                    HERO = config;
                    continue block7;
                }
                case LEGEND: {
                    LEGEND = config;
                    continue block7;
                }
                case MASTER: {
                    MASTER = config;
                    continue block7;
                }
                case GRANDMASTER: {
                    GRANDMASTER = config;
                }
            }
        }
    }

    static {
        ENABLED_RAIDERS = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        WINDS_CURSE_IMMUNE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("difficultraids:winds_curse_immune"));
    }
}

