/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.config;

import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class RaiderConfigs {

    private static abstract class RaiderConfig {
        protected RaidDifficulty rd;

        RaiderConfig(RaidDifficulty rd) {
            this.rd = rd;
        }

        public abstract void initialize();
    }

    public static class VindicatorWithShield
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue sharpnessLevel_config;
        public int sharpnessLevel;
        private final ForgeConfigSpec.IntValue criticalBurstLevel_config;
        public int criticalBurstLevel;
        private final ForgeConfigSpec.IntValue criticalStrikeLevel_config;
        public int criticalStrikeLevel;
        private final ForgeConfigSpec.DoubleValue axeDropChance_config;
        public float axeDropChance;

        public VindicatorWithShield(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Shielded Vindicator axes will be enchanted with. 0 to disable.");
            this.sharpnessLevel_config = builder.defineInRange("shieldVindicator_sharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 0;
                case RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Critical Burst that Shielded Vindicator axes will be enchanted with. 0 to disable.");
            this.criticalBurstLevel_config = builder2.defineInRange("shieldVindicator_criticalBurstLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 6;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Level of Critical Strike that Shielded Vindicator axes will be enchanted with. 0 to disable.");
            this.criticalStrikeLevel_config = builder3.defineInRange("shieldVindicator_criticalStrikeLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 0;
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 2;
            }, 0, Integer.MAX_VALUE);
            this.axeDropChance_config = spec.comment("Chance that a Shielded Vindicator will drop their axe upon death. 0 to disable.").defineInRange("shieldVindicator_axeDropChance", 0.0, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.sharpnessLevel = (Integer)this.sharpnessLevel_config.get();
            this.criticalBurstLevel = (Integer)this.criticalBurstLevel_config.get();
            this.criticalStrikeLevel = (Integer)this.criticalStrikeLevel_config.get();
            this.axeDropChance = ((Double)this.axeDropChance_config.get()).floatValue();
        }
    }

    public static class RoyalGuard
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue axeSharpnessLevel_config;
        public int axeSharpnessLevel;
        private final ForgeConfigSpec.IntValue axeCriticalBurstLevel_config;
        public int axeCriticalBurstLevel;
        private final ForgeConfigSpec.IntValue axeCriticalStrikeLevel_config;
        public int axeCriticalStrikeLevel;
        private final ForgeConfigSpec.DoubleValue axeDropChance_config;
        public float axeDropChance;

        public RoyalGuard(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Royal Guard axes will be enchanted with. 0 to disable.");
            this.axeSharpnessLevel_config = builder.defineInRange("royalguard_axeSharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 3;
                case RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Critical Burst that Royal Guard axes will be enchanted with. 0 to disable.");
            this.axeCriticalBurstLevel_config = builder2.defineInRange("royalguard_axeCriticalBurstLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 5;
                case RaidDifficulty.LEGEND -> 6;
                case RaidDifficulty.MASTER -> 8;
                case RaidDifficulty.GRANDMASTER -> 10;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Level of Critical Strike that Royal Guard axes will be enchanted with. 0 to disable.");
            this.axeCriticalStrikeLevel_config = builder3.defineInRange("royalguard_axeCriticalStrikeLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 4;
            }, 0, Integer.MAX_VALUE);
            this.axeDropChance_config = spec.comment("Chance that Royal Guards will drop their axe when killed.").defineInRange("royalguard_axeDropChance", (double)0.085f, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.axeSharpnessLevel = (Integer)this.axeSharpnessLevel_config.get();
            this.axeCriticalBurstLevel = (Integer)this.axeCriticalBurstLevel_config.get();
            this.axeCriticalStrikeLevel = (Integer)this.axeCriticalStrikeLevel_config.get();
            this.axeDropChance = ((Double)this.axeDropChance_config.get()).floatValue();
        }
    }

    public static class Mountaineer
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue pickSharpnessLevel_config;
        public int pickSharpnessLevel;
        private final ForgeConfigSpec.IntValue pickCriticalBurstLevel_config;
        public int pickCriticalBurstLevel;
        private final ForgeConfigSpec.DoubleValue pickDropChance_config;
        public float pickDropChance;

        public Mountaineer(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Mountaineer picks will be enchanted with. 0 to disable.");
            this.pickSharpnessLevel_config = builder.defineInRange("mountaineer_pickSharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 4;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Critical Burst that Mountaineer picks will be enchanted with. 0 to disable.");
            this.pickCriticalBurstLevel_config = builder2.defineInRange("mountaineer_pickCriticalBurstLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 3;
                case RaidDifficulty.LEGEND -> 5;
                case RaidDifficulty.MASTER -> 6;
                case RaidDifficulty.GRANDMASTER -> 8;
            }, 0, Integer.MAX_VALUE);
            this.pickDropChance_config = spec.comment("Chance that Mountaineers will drop their pick when killed.").defineInRange("mountaineer_pickDropChance", 0.25, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.pickSharpnessLevel = (Integer)this.pickSharpnessLevel_config.get();
            this.pickCriticalBurstLevel = (Integer)this.pickCriticalBurstLevel_config.get();
            this.pickDropChance = ((Double)this.pickDropChance_config.get()).floatValue();
        }
    }

    public static class Executioner
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue cleaverSharpnessLevel_config;
        public int cleaverSharpnessLevel;
        private final ForgeConfigSpec.IntValue cleaverCriticalBurstLevel_config;
        public int cleaverCriticalBurstLevel;
        private final ForgeConfigSpec.DoubleValue cleaverDropChance_config;
        public float cleaverDropChance;

        public Executioner(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Executioner cleavers will be enchanted with. 0 to disable.");
            this.cleaverSharpnessLevel_config = builder.defineInRange("executioner_cleaverSharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 3;
                case RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Critical Burst that Executioner cleavers will be enchanted with. 0 to disable.");
            this.cleaverCriticalBurstLevel_config = builder2.defineInRange("executioner_cleaverCriticalBurstLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 5;
                case RaidDifficulty.LEGEND -> 6;
                case RaidDifficulty.MASTER -> 8;
                case RaidDifficulty.GRANDMASTER -> 10;
            }, 0, Integer.MAX_VALUE);
            this.cleaverDropChance_config = spec.comment("Chance that Executioners will drop their cleaver when killed.").defineInRange("executioner_cleaverDropChance", (double)0.15f, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.cleaverSharpnessLevel = (Integer)this.cleaverSharpnessLevel_config.get();
            this.cleaverCriticalBurstLevel = (Integer)this.cleaverCriticalBurstLevel_config.get();
            this.cleaverDropChance = ((Double)this.cleaverDropChance_config.get()).floatValue();
        }
    }

    public static class Legioner
    extends RaiderConfig {
        public static final TagKey<Item> TAG_SWORDS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:legioner/swords_hero"));
        public static final TagKey<Item> TAG_SWORDS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:legioner/swords_legend"));
        public static final TagKey<Item> TAG_SWORDS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:legioner/swords_master"));
        public static final TagKey<Item> TAG_SWORDS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:legioner/swords_grandmaster"));
        private final ForgeConfigSpec.IntValue swordSharpnessLevel_config;
        public int swordSharpnessLevel;
        private final ForgeConfigSpec.IntValue swordFireAspectLevel_config;
        public int swordFireAspectLevel;
        private final ForgeConfigSpec.IntValue swordKnockbackLevel_config;
        public int swordKnockbackLevel;
        private final ForgeConfigSpec.IntValue swordCriticalStrikeLevel_config;
        public int swordCriticalStrikeLevel;
        private final ForgeConfigSpec.DoubleValue swordDropChance_config;
        public float swordDropChance;

        public Legioner(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Legioner swords will be enchanted with. 0 to disable.");
            this.swordSharpnessLevel_config = builder.defineInRange("legioner_swordSharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Fire Aspect that Legioner swords will be enchanted with. 0 to disable.");
            this.swordFireAspectLevel_config = builder2.defineInRange("legioner_swordFireAspectLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0;
                case RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Level of Knockback that Legioner swords will be enchanted with. 0 to disable.");
            this.swordKnockbackLevel_config = builder3.defineInRange("legioner_swordKnockbackLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0;
                case RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder4 = spec.comment("Level of Critical Strike that Legioner swords will be enchanted with. 0 to disable.");
            this.swordCriticalStrikeLevel_config = builder4.defineInRange("legioner_swordCriticalStrikeLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 0;
                case RaidDifficulty.MASTER -> 1;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            this.swordDropChance_config = spec.comment("Chance that Legioners will drop their sword when killed.").defineInRange("legioner_swordDropChance", 0.25, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.swordSharpnessLevel = (Integer)this.swordSharpnessLevel_config.get();
            this.swordFireAspectLevel = (Integer)this.swordFireAspectLevel_config.get();
            this.swordKnockbackLevel = (Integer)this.swordKnockbackLevel_config.get();
            this.swordCriticalStrikeLevel = (Integer)this.swordCriticalStrikeLevel_config.get();
            this.swordDropChance = ((Double)this.swordDropChance_config.get()).floatValue();
        }

        public Item getSword() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_SWORDS_HERO;
                case RaidDifficulty.LEGEND -> TAG_SWORDS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_SWORDS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_SWORDS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42383_);
        }
    }

    public static class Skirmisher
    extends RaiderConfig {
        public static final TagKey<Item> TAG_AXES_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:skirmisher/axes_hero"));
        public static final TagKey<Item> TAG_AXES_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:skirmisher/axes_legend"));
        public static final TagKey<Item> TAG_AXES_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:skirmisher/axes_master"));
        public static final TagKey<Item> TAG_AXES_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:skirmisher/axes_grandmaster"));
        private final ForgeConfigSpec.IntValue axeSharpnessLevel_config;
        public int axeSharpnessLevel;
        private final ForgeConfigSpec.IntValue axeCriticalBurstLevel_config;
        public int axeCriticalBurstLevel;
        private final ForgeConfigSpec.IntValue axeCriticalStrikeLevel_config;
        public int axeCriticalStrikeLevel;
        private final ForgeConfigSpec.DoubleValue axeDropChance_config;
        public float axeDropChance;

        public Skirmisher(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Skirmisher axes will be enchanted with. 0 to disable.");
            this.axeSharpnessLevel_config = builder.defineInRange("skirmisher_axeSharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Critical Burst that Skirmisher axes will be enchanted with. 0 to disable.");
            this.axeCriticalBurstLevel_config = builder2.defineInRange("skirmisher_axeCriticalBurstLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 6;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Level of Critical Strike that Skirmisher axes will be enchanted with. 0 to disable.");
            this.axeCriticalStrikeLevel_config = builder3.defineInRange("skirmisher_axeCriticalStrikeLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 2;
            }, 0, Integer.MAX_VALUE);
            this.axeDropChance_config = spec.comment("Chance that Skirmishers will drop their axe when killed.").defineInRange("skirmisher_axeDropChance", (double)0.33f, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.axeSharpnessLevel = (Integer)this.axeSharpnessLevel_config.get();
            this.axeCriticalBurstLevel = (Integer)this.axeCriticalBurstLevel_config.get();
            this.axeCriticalStrikeLevel = (Integer)this.axeCriticalStrikeLevel_config.get();
            this.axeDropChance = ((Double)this.axeDropChance_config.get()).floatValue();
        }

        public Item getAxe() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_AXES_HERO;
                case RaidDifficulty.LEGEND -> TAG_AXES_LEGEND;
                case RaidDifficulty.MASTER -> TAG_AXES_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_AXES_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42386_);
        }
    }

    public static class Archer
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue bowPowerLevel_config;
        public int bowPowerLevel;
        private final ForgeConfigSpec.IntValue bowPunchLevel_config;
        public int bowPunchLevel;
        private final ForgeConfigSpec.DoubleValue bowDropChance_config;
        public float bowDropChance;

        public Archer(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Power that Archer bows will be enchanted with. 0 to disable.");
            this.bowPowerLevel_config = builder.defineInRange("archer_bowPowerLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Punch that Archer bows will be enchanted with. 0 to disable.");
            this.bowPunchLevel_config = builder2.defineInRange("archer_bowPunchLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 0;
                case RaidDifficulty.MASTER -> 1;
                case RaidDifficulty.GRANDMASTER -> 2;
            }, 0, Integer.MAX_VALUE);
            this.bowDropChance_config = spec.comment("Chance that Archers will drop their bow when killed.").defineInRange("archer_bowDropChance", (double)0.33f, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.bowPowerLevel = (Integer)this.bowPowerLevel_config.get();
            this.bowPunchLevel = (Integer)this.bowPunchLevel_config.get();
            this.bowDropChance = ((Double)this.bowDropChance_config.get()).floatValue();
        }
    }

    public static class Hunter
    extends RaiderConfig {
        public static final TagKey<Item> TAG_SWORDS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:hunter/swords_hero"));
        public static final TagKey<Item> TAG_SWORDS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:hunter/swords_legend"));
        public static final TagKey<Item> TAG_SWORDS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:hunter/swords_master"));
        public static final TagKey<Item> TAG_SWORDS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:hunter/swords_grandmaster"));
        private final ForgeConfigSpec.IntValue bowPowerLevel_config;
        public int bowPowerLevel;
        private final ForgeConfigSpec.IntValue swordSharpnessLevel_config;
        public int swordSharpnessLevel;
        private final ForgeConfigSpec.DoubleValue bowPunchChance_config;
        public float bowPunchChance;
        private final ForgeConfigSpec.IntValue bowPunchLevel_config;
        public int bowPunchLevel;
        private final ForgeConfigSpec.DoubleValue swordKnockbackChance_config;
        public float swordKnockbackChance;
        private final ForgeConfigSpec.IntValue swordKnockbackLevel_config;
        public int swordKnockbackLevel;
        private final ForgeConfigSpec.DoubleValue boomerangLoyaltyChance_config;
        public float boomerangLoyaltyChance;
        private final ForgeConfigSpec.IntValue boomerangSharpnessLevel_config;
        public int boomerangSharpnessLevel;
        private final ForgeConfigSpec.IntValue foodCount_config;
        public int foodCount;
        private final ForgeConfigSpec.DoubleValue foodGoldenAppleChance_config;
        public float foodGoldenAppleChance;
        private final ForgeConfigSpec.DoubleValue mainItemDropChance_config;
        public float mainItemDropChance;
        private final ForgeConfigSpec.DoubleValue boomerangDropChance_config;
        public float boomerangDropChance;

        public Hunter(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Power that Hunter bows will be enchanted with. 0 to disable.");
            this.bowPowerLevel_config = builder.defineInRange("hunter_bowPowerLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Sharpness that Hunter swords will be enchanted with. 0 to disable.");
            this.swordSharpnessLevel_config = builder2.defineInRange("hunter_swordSharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Chance that Hunter bows will be enchanted with Punch. 0 to disable.");
            this.bowPunchChance_config = builder3.defineInRange("hunter_bowPunchChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0.25;
                case RaidDifficulty.LEGEND -> 0.5;
                case RaidDifficulty.MASTER -> 0.75;
                case RaidDifficulty.GRANDMASTER -> 1.0;
            }, 0.0, 1.0);
            ForgeConfigSpec.Builder builder4 = spec.comment("Level of Punch that Hunter bows will be enchanted with. 0 to disable.");
            this.bowPunchLevel_config = builder4.defineInRange("hunter_bowPunchLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Chance that Hunter swords will be enchanted with Knockback. 0 to disable.");
            this.swordKnockbackChance_config = builder5.defineInRange("hunter_swordKnockbackChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0.25;
                case RaidDifficulty.LEGEND -> 0.5;
                case RaidDifficulty.MASTER -> 0.75;
                case RaidDifficulty.GRANDMASTER -> 1.0;
            }, 0.0, 1.0);
            ForgeConfigSpec.Builder builder6 = spec.comment("Level of Knockback that Hunter swords will be enchanted with. 0 to disable.");
            this.swordKnockbackLevel_config = builder6.defineInRange("hunter_swordKnockbackLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder7 = spec.comment("Chance that Hunter boomerangs will be enchanted with Loyalty. 0 to disable.");
            this.boomerangLoyaltyChance_config = builder7.defineInRange("hunter_boomerangLoyaltyChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0.33;
                case RaidDifficulty.LEGEND -> 0.45;
                case RaidDifficulty.MASTER -> 0.75;
                case RaidDifficulty.GRANDMASTER -> 1.0;
            }, 0.0, 1.0);
            ForgeConfigSpec.Builder builder8 = spec.comment("Level of Sharpness that Hunter boomerangs will be enchanted with. 0 to disable.");
            this.boomerangSharpnessLevel_config = builder8.defineInRange("hunter_boomerangSharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder9 = spec.comment("Number of cooked food items that Hunters will be given.");
            this.foodCount_config = builder9.defineInRange("hunter_foodCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 6;
                case RaidDifficulty.LEGEND -> 8;
                case RaidDifficulty.MASTER -> 10;
                case RaidDifficulty.GRANDMASTER -> 20;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder10 = spec.comment("Chance that Hunters will be given Golden Apples rather than their normal cooked food item.");
            this.foodGoldenAppleChance_config = builder10.defineInRange("hunter_foodGoldenAppleChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0.15;
                case RaidDifficulty.LEGEND -> 0.2;
                case RaidDifficulty.MASTER -> 0.4;
                case RaidDifficulty.GRANDMASTER -> 0.75;
            }, 0.0, 1.0);
            this.mainItemDropChance_config = spec.comment("Chance that Hunters will drop their main hand item (bow or sword) when killed.").defineInRange("hunter_mainItemDropChance", 0.25, 0.0, 1.0);
            this.boomerangDropChance_config = spec.comment("Chance that Hunters will drop their boomerang when killed.").defineInRange("hunter_boomerangDropChance", 0.5, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.bowPowerLevel = (Integer)this.bowPowerLevel_config.get();
            this.swordSharpnessLevel = (Integer)this.swordSharpnessLevel_config.get();
            this.bowPunchChance = ((Double)this.bowPunchChance_config.get()).floatValue();
            this.bowPunchLevel = (Integer)this.bowPunchLevel_config.get();
            this.swordKnockbackChance = ((Double)this.swordKnockbackChance_config.get()).floatValue();
            this.swordKnockbackLevel = (Integer)this.swordKnockbackLevel_config.get();
            this.boomerangLoyaltyChance = ((Double)this.boomerangLoyaltyChance_config.get()).floatValue();
            this.boomerangSharpnessLevel = (Integer)this.boomerangSharpnessLevel_config.get();
            this.foodCount = (Integer)this.foodCount_config.get();
            this.foodGoldenAppleChance = ((Double)this.foodGoldenAppleChance_config.get()).floatValue();
            this.mainItemDropChance = ((Double)this.mainItemDropChance_config.get()).floatValue();
            this.boomerangDropChance = ((Double)this.boomerangDropChance_config.get()).floatValue();
        }

        public Item getSword() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_SWORDS_HERO;
                case RaidDifficulty.LEGEND -> TAG_SWORDS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_SWORDS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_SWORDS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42383_);
        }
    }

    public static class Voldon
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue familiarSummonCooldown_config;
        public int familiarSummonCooldown;
        private final ForgeConfigSpec.DoubleValue friendlyDamageReduction_config;
        public float friendlyDamageReduction;
        private final ForgeConfigSpec.IntValue fireballCount_config;
        public int fireballCount;
        private final ForgeConfigSpec.IntValue sacrificeBuffDuration_config;
        public int sacrificeBuffDuration;
        private final ForgeConfigSpec.IntValue familiarSummonCount_config;
        public int familiarSummonCount;
        private final ForgeConfigSpec.BooleanValue familiarWeaknessOnDeath_config;
        public boolean familiarWeaknessOnDeath;
        private final ForgeConfigSpec.DoubleValue familiarAttackDamageMultiplier_config;
        public float familiarAttackDamageMultiplier;
        private final ForgeConfigSpec.DoubleValue familiarHealthMultiplier_config;
        public float familiarHealthMultiplier;

        public Voldon(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            this.familiarSummonCooldown_config = spec.comment("Cooldown (in ticks) after all Voldon's familiars are dead. Voldon will not summon more familiars until this cooldown is over.").defineInRange("voldon_familiarSummonCooldown", 300, 0, Integer.MAX_VALUE);
            this.friendlyDamageReduction_config = spec.comment("Multiplier on the damage Voldon takes from player-friendly mobs (Iron Golems & Guards). 1 to remove this feature.").defineInRange("voldon_friendlyDamageReduction", 0.4, 0.0, 1.0);
            ForgeConfigSpec.Builder builder = spec.comment("Number of fireballs Voldon will shoot at once during his fireball attack.");
            this.fireballCount_config = builder.defineInRange("voldon_fireballCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 4;
                case RaidDifficulty.MASTER -> 5;
                case RaidDifficulty.GRANDMASTER -> 6;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Duration (in ticks) of the buff Voldon gives himself after sacrificing a familiar.");
            this.sacrificeBuffDuration_config = builder2.defineInRange("voldon_sacrificeBuffDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 400;
                case RaidDifficulty.LEGEND -> 500;
                case RaidDifficulty.MASTER -> 800;
                case RaidDifficulty.GRANDMASTER -> 1200;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Number of familiars Voldon will summon at once.");
            this.familiarSummonCount_config = builder3.defineInRange("voldon_familiarSummonCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 4;
                case RaidDifficulty.LEGEND -> 6;
                case RaidDifficulty.MASTER -> 8;
                case RaidDifficulty.GRANDMASTER -> 12;
            }, 0, Integer.MAX_VALUE);
            this.familiarWeaknessOnDeath_config = spec.comment("Whether Voldon's familiars will give the entity that killed them the weakness effect.").define("voldon_familiarWeaknessOnDeath", true);
            ForgeConfigSpec.Builder builder4 = spec.comment("Multiplier on the damage Voldon's familiars deal. 1 to remove this feature.");
            this.familiarAttackDamageMultiplier_config = builder4.defineInRange("voldon_familiarAttackDamageMultiplier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1.25;
                case RaidDifficulty.LEGEND -> 1.75;
                case RaidDifficulty.MASTER -> (double)2.4f;
                case RaidDifficulty.GRANDMASTER -> 3.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Multiplier on the health Voldon's familiars have. 1 to remove this feature.");
            this.familiarHealthMultiplier_config = builder5.defineInRange("voldon_familiarHealthMultiplier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1.0;
                case RaidDifficulty.MASTER -> 2.0;
                case RaidDifficulty.GRANDMASTER -> 2.5;
            }, 0.01, Double.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.familiarSummonCooldown = (Integer)this.familiarSummonCooldown_config.get();
            this.friendlyDamageReduction = ((Double)this.friendlyDamageReduction_config.get()).floatValue();
            this.fireballCount = (Integer)this.fireballCount_config.get();
            this.sacrificeBuffDuration = (Integer)this.sacrificeBuffDuration_config.get();
            this.familiarSummonCount = (Integer)this.familiarSummonCount_config.get();
            this.familiarWeaknessOnDeath = (Boolean)this.familiarWeaknessOnDeath_config.get();
            this.familiarAttackDamageMultiplier = ((Double)this.familiarAttackDamageMultiplier_config.get()).floatValue();
            this.familiarHealthMultiplier = ((Double)this.familiarHealthMultiplier_config.get()).floatValue();
        }
    }

    public static class Modur
    extends RaiderConfig {
        private final ForgeConfigSpec.DoubleValue friendlyDamageReduction_config;
        public float friendlyDamageReduction;
        private final ForgeConfigSpec.DoubleValue projectileDamageReduction_config;
        public float projectileDamageReduction;
        private final ForgeConfigSpec.DoubleValue basicLightningStrikeDamage_config;
        public float basicLightningStrikeDamage;
        private final ForgeConfigSpec.IntValue stormStrikesPerTick_config;
        public int stormStrikesPerTick;
        private final ForgeConfigSpec.DoubleValue stormStrikeDamage_config;
        public float stormStrikeDamage;
        private final ForgeConfigSpec.IntValue stormDuration_config;
        public int stormDuration;
        private final ForgeConfigSpec.DoubleValue stormRadius_config;
        public float stormRadius;
        private final ForgeConfigSpec.IntValue chargedBoltCount_config;
        public int chargedBoltCount;
        private final ForgeConfigSpec.DoubleValue chargedBoltDamage_config;
        public float chargedBoltDamage;
        private final ForgeConfigSpec.DoubleValue homingBoltDamage_config;
        public float homingBoltDamage;
        private final ForgeConfigSpec.IntValue homingBoltTime_config;
        public int homingBoltTime;
        private final ForgeConfigSpec.DoubleValue zapBoltDamage_config;
        public float zapBoltDamage;

        public Modur(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            this.friendlyDamageReduction_config = spec.comment("Multiplier on the damage Modur takes from player-friendly mobs (Iron Golems & Guards). 1 to remove this feature.").defineInRange("modur_friendlyDamageReduction", 0.4, 0.0, 1.0);
            this.projectileDamageReduction_config = spec.comment("Multiplier on the damage Modur takes from projectiles. 1 to remove this feature.").defineInRange("modur_projectileDamageReduction", 0.8, 0.0, 1.0);
            ForgeConfigSpec.Builder builder = spec.comment("Damage dealt by Modur's basic lightning strike ranged attack.");
            this.basicLightningStrikeDamage_config = builder.defineInRange("modur_basicLightningStrikeDamage", switch (rd) {
                case RaidDifficulty.HERO -> 7.0;
                case RaidDifficulty.LEGEND -> 12.0;
                case RaidDifficulty.MASTER -> 16.0;
                case RaidDifficulty.GRANDMASTER -> 20.0;
                default -> 5.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Number of lightning strikes Modur summons per tick during his storm attack.").comment("Warning: This can be very loud if set too high!");
            this.stormStrikesPerTick_config = builder2.defineInRange("modur_stormStrikesPerTick", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 2;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Damage dealt by each lightning strike during Modur's storm attack.");
            this.stormStrikeDamage_config = builder3.defineInRange("modur_stormStrikeDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 10.0;
                case RaidDifficulty.LEGEND -> 15.0;
                case RaidDifficulty.MASTER -> 20.0;
                case RaidDifficulty.GRANDMASTER -> 30.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder4 = spec.comment("Duration of Modur's storm attack, in ticks.");
            this.stormDuration_config = builder4.defineInRange("modur_stormDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 140;
                case RaidDifficulty.LEGEND -> 240;
                case RaidDifficulty.MASTER -> 320;
                case RaidDifficulty.GRANDMASTER -> 400;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Radius of Modur's storm attack.");
            this.stormRadius_config = builder5.defineInRange("modur_stormRadius", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 12.0;
                case RaidDifficulty.LEGEND -> 18.0;
                case RaidDifficulty.MASTER -> 20.0;
                case RaidDifficulty.GRANDMASTER -> 25.0;
            }, 0.0, Double.MAX_VALUE);
            this.chargedBoltCount_config = spec.comment("Number of lightning strikes that comprise Modur's charged bolt attack.").comment("Warning: These will all happen simultaneously, so this can be very loud if set too high!").defineInRange("modur_chargedBoltCount", 10, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder6 = spec.comment("Damage dealt by each lightning strike in Modur's charged bolt attack.");
            this.chargedBoltDamage_config = builder6.defineInRange("modur_chargedBoltDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 25.0;
                case RaidDifficulty.LEGEND -> 40.0;
                case RaidDifficulty.MASTER -> 60.0;
                case RaidDifficulty.GRANDMASTER -> 100.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder7 = spec.comment("Damage dealt by lightning strikes during Modur's homing bolt attack.");
            this.homingBoltDamage_config = builder7.defineInRange("modur_homingBoltDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 8.0;
                case RaidDifficulty.LEGEND -> 11.0;
                case RaidDifficulty.MASTER -> 15.0;
                case RaidDifficulty.GRANDMASTER -> 20.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder8 = spec.comment("Duration of Modur's homing bolt attack.");
            this.homingBoltTime_config = builder8.defineInRange("modur_homingBoltTime", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 80;
                case RaidDifficulty.LEGEND -> 140;
                case RaidDifficulty.MASTER -> 200;
                case RaidDifficulty.GRANDMASTER -> 300;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder9 = spec.comment("Damage dealt by lightning strikes during Modur's lightning zap attack.");
            this.zapBoltDamage_config = builder9.defineInRange("modur_zapDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 12.0;
                case RaidDifficulty.LEGEND -> 15.0;
                case RaidDifficulty.MASTER -> 18.0;
                case RaidDifficulty.GRANDMASTER -> 22.0;
            }, 0.0, Double.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.friendlyDamageReduction = ((Double)this.friendlyDamageReduction_config.get()).floatValue();
            this.projectileDamageReduction = ((Double)this.projectileDamageReduction_config.get()).floatValue();
            this.basicLightningStrikeDamage = ((Double)this.basicLightningStrikeDamage_config.get()).floatValue();
            this.stormStrikesPerTick = (Integer)this.stormStrikesPerTick_config.get();
            this.stormStrikeDamage = ((Double)this.stormStrikeDamage_config.get()).floatValue();
            this.stormDuration = (Integer)this.stormDuration_config.get();
            this.stormRadius = ((Double)this.stormRadius_config.get()).floatValue();
            this.chargedBoltCount = (Integer)this.chargedBoltCount_config.get();
            this.chargedBoltDamage = ((Double)this.chargedBoltDamage_config.get()).floatValue();
            this.homingBoltDamage = ((Double)this.homingBoltDamage_config.get()).floatValue();
            this.homingBoltTime = (Integer)this.homingBoltTime_config.get();
            this.zapBoltDamage = ((Double)this.zapBoltDamage_config.get()).floatValue();
        }
    }

    public static class Xydrax
    extends RaiderConfig {
        private final ForgeConfigSpec.DoubleValue friendlyDamageReduction_config;
        public float friendlyDamageReduction;
        private final ForgeConfigSpec.IntValue vortexPullInterval_config;
        public int vortexPullInterval;
        private final ForgeConfigSpec.DoubleValue vortexForce_config;
        public float vortexForce;
        private final ForgeConfigSpec.IntValue vortexDamageInterval_config;
        public int vortexDamageInterval;
        private final ForgeConfigSpec.ConfigValue<List<? extends Double>> vortexBaseDamageThresholds_config;
        public List<Double> vortexBaseDamageThresholds;
        private final ForgeConfigSpec.DoubleValue vortexDamageMultiplier_config;
        public float vortexDamageMultiplier;
        private final ForgeConfigSpec.ConfigValue<List<? extends Integer>> windColumnLifetime_config;
        public List<Integer> windColumnLifetime;
        private final ForgeConfigSpec.IntValue vortexLifetime_config;
        public int vortexLifetime;
        private final ForgeConfigSpec.IntValue barrageCurseDuration_config;
        public int barrageCurseDuration;
        private final ForgeConfigSpec.IntValue barrageCurseAmplifier_config;
        public int barrageCurseAmplifier;

        public Xydrax(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            this.friendlyDamageReduction_config = spec.comment("Multiplier on the damage Xydrax takes from player-friendly mobs (Iron Golems & Guards). 1 to remove this feature.").defineInRange("xydrax_friendlyDamageReduction", 0.4, 0.0, 1.0);
            this.vortexPullInterval_config = spec.comment("Interval (in ticks) between each pull event of Xydrax's vortex attack.").defineInRange("xydrax_vortexPullInterval", 20, 1, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder = spec.comment("Force applied during Xydrax's vortex attack.");
            this.vortexForce_config = builder.defineInRange("xydrax_vortexForce", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 1.25;
                case RaidDifficulty.HERO -> 1.75;
                case RaidDifficulty.LEGEND -> 2.5;
                case RaidDifficulty.MASTER -> 3.75;
                case RaidDifficulty.GRANDMASTER -> 5.0;
            }, 0.0, Double.MAX_VALUE);
            this.vortexDamageInterval_config = spec.comment("Interval (in ticks) between each damage event of Xydrax's vortex attack.").defineInRange("xydrax_vortexDamageInterval", 40, 1, Integer.MAX_VALUE);
            this.vortexBaseDamageThresholds_config = spec.comment("Base damage dealt by Xydrax's vortex attack at each threshold.").comment("The list is in this order: [ <1 block, <2 blocks, <5 blocks, >=5 blocks ].").defineList("xydrax_vortexDamageThresholds", List.of(Double.valueOf(17.5), Double.valueOf(10.0), Double.valueOf(4.0), Double.valueOf(1.0)), o -> o instanceof Double);
            ForgeConfigSpec.Builder builder2 = spec.comment("Multiplier on the damage dealt by Xydrax's vortex attack.");
            this.vortexDamageMultiplier_config = builder2.defineInRange("xydrax_vortexDamageMultiplier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1.0;
                case RaidDifficulty.LEGEND -> (double)1.05f;
                case RaidDifficulty.MASTER -> (double)1.2f;
                case RaidDifficulty.GRANDMASTER -> 2.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Lifetime of one of Xydrax's wind columns (in ticks).").comment("The first element is the minimum life, the second element is the maximum life. The actual lifetime will be randomly selected between the two values when summoned.");
            this.windColumnLifetime_config = builder3.defineList("xydrax_windColumnLifetime", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> List.of(Integer.valueOf(100), Integer.valueOf(300));
                case RaidDifficulty.HERO -> List.of(Integer.valueOf(140), Integer.valueOf(340));
                case RaidDifficulty.LEGEND -> List.of(Integer.valueOf(180), Integer.valueOf(340));
                case RaidDifficulty.MASTER -> List.of(Integer.valueOf(200), Integer.valueOf(400));
                case RaidDifficulty.GRANDMASTER -> List.of(Integer.valueOf(300), Integer.valueOf(500));
            }, o -> o instanceof Integer);
            ForgeConfigSpec.Builder builder4 = spec.comment("Lifetime of Xydrax's vortex (in ticks).");
            this.vortexLifetime_config = builder4.defineInRange("xydrax_vortexLifetime", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 240;
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 400;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 600;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Duration (in ticks) of the Curse of the Winds effect applied by Xydrax's barrage attack.");
            this.barrageCurseDuration_config = builder5.defineInRange("xydrax_barrageCurseDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 200;
                case RaidDifficulty.LEGEND -> 400;
                case RaidDifficulty.MASTER -> 600;
                case RaidDifficulty.GRANDMASTER -> 800;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder6 = spec.comment("Amplifier of the Curse of the Winds effect applied by Xydrax's barrage attack.");
            this.barrageCurseAmplifier_config = builder6.defineInRange("xydrax_barrageCurseAmplifier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 4;
            }, 0, Integer.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.friendlyDamageReduction = ((Double)this.friendlyDamageReduction_config.get()).floatValue();
            this.vortexPullInterval = (Integer)this.vortexPullInterval_config.get();
            this.vortexForce = ((Double)this.vortexForce_config.get()).floatValue();
            this.vortexDamageInterval = (Integer)this.vortexDamageInterval_config.get();
            List vortexBaseDamageThresholdRaw = (List)this.vortexBaseDamageThresholds_config.get();
            this.vortexBaseDamageThresholds = new ArrayList<Double>();
            this.vortexBaseDamageThresholds.addAll(vortexBaseDamageThresholdRaw.size() == 4 ? vortexBaseDamageThresholdRaw : (Collection)this.vortexBaseDamageThresholds_config.getDefault());
            this.vortexDamageMultiplier = ((Double)this.vortexDamageMultiplier_config.get()).floatValue();
            List windColumnLifetimeRaw = (List)this.windColumnLifetime_config.get();
            this.windColumnLifetime = new ArrayList<Integer>();
            this.windColumnLifetime.addAll(windColumnLifetimeRaw.size() == 2 && (Integer)windColumnLifetimeRaw.get(1) > (Integer)windColumnLifetimeRaw.get(0) ? windColumnLifetimeRaw : (Collection)this.windColumnLifetime_config.getDefault());
            this.vortexLifetime = (Integer)this.vortexLifetime_config.get();
            this.barrageCurseDuration = (Integer)this.barrageCurseDuration_config.get();
            this.barrageCurseAmplifier = (Integer)this.barrageCurseAmplifier_config.get();
        }
    }

    public static class Nuaos
    extends RaiderConfig {
        private final ForgeConfigSpec.DoubleValue friendlyDamageReduction_config;
        public float friendlyDamageReduction;
        private final ForgeConfigSpec.IntValue sharpnessLevel_config;
        public int sharpnessLevel;
        private final ForgeConfigSpec.IntValue criticalStrikeLevel_config;
        public int criticalStrikeLevel;
        private final ForgeConfigSpec.IntValue criticalBurstLevel_config;
        public int criticalBurstLevel;
        private final ForgeConfigSpec.DoubleValue swordDropChance_config;
        public float swordDropChance;
        private final ForgeConfigSpec.DoubleValue maxChargeDamage_config;
        public float maxChargeDamage;
        private final ForgeConfigSpec.DoubleValue shockwaveRadius_config;
        public float shockwaveRadius;
        private final ForgeConfigSpec.DoubleValue buffAuraRadius_config;
        public float buffAuraRadius;
        private final ForgeConfigSpec.IntValue buffAuraStrengthLevel_config;
        public int buffAuraStrengthLevel;
        private final ForgeConfigSpec.ConfigValue<List<? extends Double>> chargedDamageBoost_config;
        public List<Double> chargedDamageBoost;
        private final ForgeConfigSpec.BooleanValue chargeDecay_config;
        public boolean chargeDecay;

        public Nuaos(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            this.friendlyDamageReduction_config = spec.comment("Multiplier on the damage Nuaos takes from player-friendly mobs (Iron Golems & Guards). 1 to remove this feature.").defineInRange("nuaos_friendlyDamageReduction", 0.4, 0.0, 1.0);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Nuaos' sword will be enchanted with. 0 to disable.");
            this.sharpnessLevel_config = builder.defineInRange("nuaos_sharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Critical Strike that Nuaos' sword will be enchanted with. 0 to disable.");
            this.criticalStrikeLevel_config = builder2.defineInRange("nuaos_criticalStrikeLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 0;
                case RaidDifficulty.MASTER -> 1;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Level of Critical Burst that Nuaos' sword will be enchanted with. 0 to disable.");
            this.criticalBurstLevel_config = builder3.defineInRange("nuaos_criticalBurstLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 5;
                case RaidDifficulty.LEGEND -> 6;
                case RaidDifficulty.MASTER -> 8;
                case RaidDifficulty.GRANDMASTER -> 10;
            }, 0, Integer.MAX_VALUE);
            this.swordDropChance_config = spec.comment("Chance that Nuaos will drop his sword. 0 to disable.").defineInRange("nuaos_swordDropChance", 0.25, 0.0, 1.0);
            this.maxChargeDamage_config = spec.comment("Amount of damage Nuaos can charge before he explodes.").defineInRange("nuaos_maxChargeDamage", 50.0, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder4 = spec.comment("Radius of the shockwave Nuaos creates when he explodes.");
            this.shockwaveRadius_config = builder4.defineInRange("nuaos_shockwaveRadius", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 4.0;
                case RaidDifficulty.MASTER -> 5.0;
                case RaidDifficulty.GRANDMASTER -> 7.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Radius of the constant aura Nuaos creates around himself, buffing nearby Raiders.");
            this.buffAuraRadius_config = builder5.defineInRange("nuaos_buffAuraRadius", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 8.0;
                case RaidDifficulty.MASTER -> 10.0;
                case RaidDifficulty.GRANDMASTER -> 12.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder6 = spec.comment("Amplifier of Strength that Raiders within Nuaos' aura will receive. 0 to disable.");
            this.buffAuraStrengthLevel_config = builder6.defineInRange("nuaos_buffAuraStrengthLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            this.chargedDamageBoost_config = spec.comment("Damage multiplier that Nuaos receives when he is charged, depending on the charge amount.").comment("The list is in order: [No Charge, Low Charge, High Charge, Max Charge].").defineList("nuaos_chargedDamageBoost", List.of(Double.valueOf(1.0), Double.valueOf(1.25), Double.valueOf(1.75), Double.valueOf(2.25)), o -> o instanceof Double);
            this.chargeDecay_config = spec.comment("Whether Nuaos' stored charge should decay over time (if Nuaos is not actively taking damage).").define("nuaos_chargeDecay", true);
        }

        @Override
        public void initialize() {
            this.friendlyDamageReduction = ((Double)this.friendlyDamageReduction_config.get()).floatValue();
            this.sharpnessLevel = (Integer)this.sharpnessLevel_config.get();
            this.criticalStrikeLevel = (Integer)this.criticalStrikeLevel_config.get();
            this.criticalBurstLevel = (Integer)this.criticalBurstLevel_config.get();
            this.swordDropChance = ((Double)this.swordDropChance_config.get()).floatValue();
            this.maxChargeDamage = ((Double)this.maxChargeDamage_config.get()).floatValue();
            this.shockwaveRadius = ((Double)this.shockwaveRadius_config.get()).floatValue();
            this.buffAuraRadius = ((Double)this.buffAuraRadius_config.get()).floatValue();
            this.buffAuraStrengthLevel = (Integer)this.buffAuraStrengthLevel_config.get();
            List chargedDamageBoostRaw = (List)this.chargedDamageBoost_config.get();
            this.chargedDamageBoost = new ArrayList<Double>();
            this.chargedDamageBoost.addAll(chargedDamageBoostRaw.size() == 4 ? chargedDamageBoostRaw : (Collection)this.chargedDamageBoost_config.getDefault());
            this.chargeDecay = (Boolean)this.chargeDecay_config.get();
        }
    }

    public static class Ashenmancer
    extends RaiderConfig {
        public static final TagKey<Item> TAG_SWORDS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/swords_hero"));
        public static final TagKey<Item> TAG_SWORDS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/swords_legend"));
        public static final TagKey<Item> TAG_SWORDS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/swords_master"));
        public static final TagKey<Item> TAG_SWORDS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/swords_grandmaster"));
        public static final TagKey<Item> TAG_HELMETS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/helmets_hero"));
        public static final TagKey<Item> TAG_HELMETS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/helmets_legend"));
        public static final TagKey<Item> TAG_HELMETS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/helmets_master"));
        public static final TagKey<Item> TAG_HELMETS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/helmets_grandmaster"));
        public static final TagKey<Item> TAG_CHESTPLATES_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/chestplates_hero"));
        public static final TagKey<Item> TAG_CHESTPLATES_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/chestplates_legend"));
        public static final TagKey<Item> TAG_CHESTPLATES_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/chestplates_master"));
        public static final TagKey<Item> TAG_CHESTPLATES_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/chestplates_grandmaster"));
        public static final TagKey<Item> TAG_LEGGINGS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/leggings_hero"));
        public static final TagKey<Item> TAG_LEGGINGS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/leggings_legend"));
        public static final TagKey<Item> TAG_LEGGINGS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/leggings_master"));
        public static final TagKey<Item> TAG_LEGGINGS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/leggings_grandmaster"));
        public static final TagKey<Item> TAG_BOOTS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/boots_hero"));
        public static final TagKey<Item> TAG_BOOTS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/boots_legend"));
        public static final TagKey<Item> TAG_BOOTS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/boots_master"));
        public static final TagKey<Item> TAG_BOOTS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:ashenmancer/boots_grandmaster"));
        private final ForgeConfigSpec.IntValue maxMinionCount_config;
        public int maxMinionCount;
        private final ForgeConfigSpec.IntValue minionMaxProtectionLevel_config;
        public int minionMaxProtectionLevel;
        private final ForgeConfigSpec.IntValue minionMaxSharpnessLevel_config;
        public int minionMaxSharpnessLevel;
        private final ForgeConfigSpec.BooleanValue allowMobGriefing_config;
        public boolean allowMobGriefing;
        private final ForgeConfigSpec.DoubleValue witherSkullWitherTickDamage_config;
        public float witherSkullWitherTickDamage;
        private final ForgeConfigSpec.IntValue ashenadoDuration_config;
        public int ashenadoDuration;
        private final ForgeConfigSpec.DoubleValue pusherSkullForce_config;
        public float pusherSkullForce;
        private final ForgeConfigSpec.IntValue flamerSkullFireDuration_config;
        public int flamerSkullFireDuration;
        private final ForgeConfigSpec.IntValue multishotSkullCount_config;
        public int multishotSkullCount;
        private final ForgeConfigSpec.DoubleValue speederSkullSpeed_config;
        public float speederSkullSpeed;
        private final ForgeConfigSpec.IntValue blinderSkullBlindnessDuration_config;
        public int blinderSkullBlindnessDuration;
        private final ForgeConfigSpec.IntValue turretSkullCount_config;
        public int turretSkullCount;
        private final ForgeConfigSpec.IntValue turretInterval_config;
        public int turretInterval;

        public Ashenmancer(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Maximum number of Ashenmancer minions that can be spawned at once.");
            this.maxMinionCount_config = builder.defineInRange("ashenmancer_maxMinionCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 6;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Maximum level of Protection that Ashenmancer minions can have on their armor.");
            this.minionMaxProtectionLevel_config = builder2.defineInRange("ashenmancer_minionMaxProtectionLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 6;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Maximum level of Sharpness that Ashenmancer minions can have on their swords.");
            this.minionMaxSharpnessLevel_config = builder3.defineInRange("ashenmancer_minionMaxSharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 3;
                case RaidDifficulty.LEGEND -> 4;
                case RaidDifficulty.MASTER -> 5;
                case RaidDifficulty.GRANDMASTER -> 6;
            }, 0, Integer.MAX_VALUE);
            this.allowMobGriefing_config = spec.comment("Whether or not Ashenmancer minions are allowed to grief blocks. Enabling this will cause Ashenmancer wither skulls to explode.").define("ashenmancer_allowMobGriefing", false);
            ForgeConfigSpec.Builder builder4 = spec.comment("Damage dealt by the Wither effect applied by Ashenmancer Wither Skulls. Warning: This ignores armor!");
            this.witherSkullWitherTickDamage_config = builder4.defineInRange("ashenmancer_witherSkullWitherTickDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1.0;
                case RaidDifficulty.LEGEND -> 2.0;
                case RaidDifficulty.MASTER -> 4.0;
                case RaidDifficulty.GRANDMASTER -> 7.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Duration (in ticks) of the Ashenmancer's Ashenado.");
            this.ashenadoDuration_config = builder5.defineInRange("ashenmancer_ashenadoDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 200;
                case RaidDifficulty.LEGEND -> 320;
                case RaidDifficulty.MASTER -> 440;
                case RaidDifficulty.GRANDMASTER -> 600;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder6 = spec.comment("Force applied by the Ashenmancer's Pusher Wither Skulls.");
            this.pusherSkullForce_config = builder6.defineInRange("ashenmancer_pusherSkullForce", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1.5;
                case RaidDifficulty.LEGEND -> 2.0;
                case RaidDifficulty.MASTER -> 3.0;
                case RaidDifficulty.GRANDMASTER -> 5.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder7 = spec.comment("Duration (in ticks) enemies will be set on fire by the Ashenmancer's Flamer Wither Skulls.");
            this.flamerSkullFireDuration_config = builder7.defineInRange("ashenmancer_flamerSkullFireDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 100;
                case RaidDifficulty.LEGEND -> 160;
                case RaidDifficulty.MASTER -> 240;
                case RaidDifficulty.GRANDMASTER -> 320;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder8 = spec.comment("Number of Wither Skulls that will be fired by the Ashenmancer's Multishot Wither Skull attack.");
            this.multishotSkullCount_config = builder8.defineInRange("ashenmancer_multishotSkullCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 3;
                case RaidDifficulty.LEGEND -> 5;
                case RaidDifficulty.MASTER -> 7;
                case RaidDifficulty.GRANDMASTER -> 9;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder9 = spec.comment("Speed of the Ashenmancer's Speeder Wither Skulls.");
            this.speederSkullSpeed_config = builder9.defineInRange("ashenmancer_speederSkullSpeed", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> (double)1.15f;
                case RaidDifficulty.LEGEND -> (double)1.35f;
                case RaidDifficulty.MASTER -> 1.75;
                case RaidDifficulty.GRANDMASTER -> 2.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder10 = spec.comment("Duration (in ticks) enemies will be affected with Darkness by the Ashenmancer's Blinder Wither Skulls.");
            this.blinderSkullBlindnessDuration_config = builder10.defineInRange("ashenmancer_blinderSkullBlindnessDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 60;
                case RaidDifficulty.LEGEND -> 80;
                case RaidDifficulty.MASTER -> 120;
                case RaidDifficulty.GRANDMASTER -> 160;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder11 = spec.comment("Total number of Wither Skulls fired during the Ashenmancer's Turret attack.");
            this.turretSkullCount_config = builder11.defineInRange("ashenmancer_turretSkullCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 16;
                case RaidDifficulty.LEGEND -> 24;
                case RaidDifficulty.MASTER -> 32;
                case RaidDifficulty.GRANDMASTER -> 48;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder12 = spec.comment("Interval (in ticks) between each Wither Skull fired during the Ashenmancer's Turret attack. Warning: This can cause a lot of lag at short intervals!");
            this.turretInterval_config = builder12.defineInRange("ashenmancer_turretInterval", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 15;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 12;
            }, 1, Integer.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.minionMaxProtectionLevel = (Integer)this.minionMaxProtectionLevel_config.get();
            this.maxMinionCount = (Integer)this.maxMinionCount_config.get();
            this.minionMaxSharpnessLevel = (Integer)this.minionMaxSharpnessLevel_config.get();
            this.allowMobGriefing = (Boolean)this.allowMobGriefing_config.get();
            this.witherSkullWitherTickDamage = ((Double)this.witherSkullWitherTickDamage_config.get()).floatValue();
            this.ashenadoDuration = (Integer)this.ashenadoDuration_config.get();
            this.pusherSkullForce = ((Double)this.pusherSkullForce_config.get()).floatValue();
            this.flamerSkullFireDuration = (Integer)this.flamerSkullFireDuration_config.get();
            this.multishotSkullCount = (Integer)this.multishotSkullCount_config.get();
            this.speederSkullSpeed = ((Double)this.speederSkullSpeed_config.get()).floatValue();
            this.blinderSkullBlindnessDuration = (Integer)this.blinderSkullBlindnessDuration_config.get();
            this.turretSkullCount = (Integer)this.turretSkullCount_config.get();
            this.turretInterval = (Integer)this.turretInterval_config.get();
        }

        public Item getMinionSword() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_SWORDS_HERO;
                case RaidDifficulty.LEGEND -> TAG_SWORDS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_SWORDS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_SWORDS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42388_);
        }

        public Item getMinionHelmet() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_HELMETS_HERO;
                case RaidDifficulty.LEGEND -> TAG_HELMETS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_HELMETS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_HELMETS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42472_);
        }

        public Item getMinionChestplate() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_CHESTPLATES_HERO;
                case RaidDifficulty.LEGEND -> TAG_CHESTPLATES_LEGEND;
                case RaidDifficulty.MASTER -> TAG_CHESTPLATES_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_CHESTPLATES_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42473_);
        }

        public Item getMinionLeggings() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_LEGGINGS_HERO;
                case RaidDifficulty.LEGEND -> TAG_LEGGINGS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_LEGGINGS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_LEGGINGS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42474_);
        }

        public Item getMinionBoots() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_BOOTS_HERO;
                case RaidDifficulty.LEGEND -> TAG_BOOTS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_BOOTS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_BOOTS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42475_);
        }
    }

    public static class Frostmage
    extends RaiderConfig {
        private final ForgeConfigSpec.DoubleValue slownessAuraRadius_config;
        public float slownessAuraRadius;
        private final ForgeConfigSpec.DoubleValue barrageSnowballDamage_config;
        public float barrageSnowballDamage;
        private final ForgeConfigSpec.IntValue barrageDuration_config;
        public int barrageDuration;
        private final ForgeConfigSpec.DoubleValue snowballBlastDamage_config;
        public float snowballBlastDamage;
        private final ForgeConfigSpec.IntValue freezeDuration_config;
        public int freezeDuration;

        public Frostmage(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Radius of the aura around Frostmages in which enemies will be slowed.");
            this.slownessAuraRadius_config = builder.defineInRange("frostmage_slownessAuraRadius", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 4.0;
                case RaidDifficulty.LEGEND -> 4.5;
                case RaidDifficulty.MASTER -> 5.0;
                case RaidDifficulty.GRANDMASTER -> 6.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Damage dealt by each snowball in the Frostmages' Barrage attack.");
            this.barrageSnowballDamage_config = builder2.defineInRange("frostmage_barrageSnowballDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> (double)1.8f;
                case RaidDifficulty.LEGEND -> (double)2.2f;
                case RaidDifficulty.MASTER -> (double)2.8f;
                case RaidDifficulty.GRANDMASTER -> 3.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Duration (in ticks) of the Frostmages' Barrage attack.");
            this.barrageDuration_config = builder3.defineInRange("frostmage_barrageDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 40;
                case RaidDifficulty.LEGEND -> 60;
                case RaidDifficulty.MASTER -> 120;
                case RaidDifficulty.GRANDMASTER -> 180;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder4 = spec.comment("Damage dealt by each snowball in the Frostmages' Snowball Blast attack.");
            this.snowballBlastDamage_config = builder4.defineInRange("frostmage_snowballBlastDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 4.0;
                case RaidDifficulty.LEGEND -> 6.5;
                case RaidDifficulty.MASTER -> 10.0;
                case RaidDifficulty.GRANDMASTER -> 14.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Duration (in ticks) of the Frostmages' Freeze attack.");
            this.freezeDuration_config = builder5.defineInRange("frostmage_freezeDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 40;
                case RaidDifficulty.LEGEND -> 60;
                case RaidDifficulty.MASTER -> 80;
                case RaidDifficulty.GRANDMASTER -> 100;
            }, 0, Integer.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.slownessAuraRadius = ((Double)this.slownessAuraRadius_config.get()).floatValue();
            this.barrageSnowballDamage = ((Double)this.barrageSnowballDamage_config.get()).floatValue();
            this.snowballBlastDamage = ((Double)this.snowballBlastDamage_config.get()).floatValue();
        }
    }

    public static class Assassin
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue invisibilityCooldown_config;
        public int invisibilityCooldown;
        private final ForgeConfigSpec.IntValue teleportCooldown_config;
        public int teleportCooldown;

        public Assassin(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Cooldown (in ticks) after an Assassin locks onto a target, before they go invisible again.");
            this.invisibilityCooldown_config = builder.defineInRange("assassin_invisibilityCooldown", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 3600;
                case RaidDifficulty.LEGEND -> 2400;
                case RaidDifficulty.MASTER -> 1200;
                case RaidDifficulty.GRANDMASTER -> 600;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Cooldown (in ticks) after an Assassin teleports to a target, before they can teleport again.");
            this.teleportCooldown_config = builder2.defineInRange("assassin_teleportCooldown", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 3600;
                case RaidDifficulty.LEGEND -> 2400;
                case RaidDifficulty.MASTER -> 1200;
                case RaidDifficulty.GRANDMASTER -> 600;
            }, 0, Integer.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.invisibilityCooldown = (Integer)this.invisibilityCooldown_config.get();
            this.teleportCooldown = (Integer)this.teleportCooldown_config.get();
        }
    }

    public static class Tank
    extends RaiderConfig {
        private final ForgeConfigSpec.DoubleValue extraArmor_config;
        public float extraArmor;
        private final ForgeConfigSpec.DoubleValue extraArmorToughness_config;
        public float extraArmorToughness;
        private final ForgeConfigSpec.DoubleValue thornsChance_config;
        public float thornsChance;

        public Tank(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Extra armor points Tanks receive.");
            this.extraArmor_config = builder.defineInRange("tank_extraArmor", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 7.5;
                case RaidDifficulty.HERO -> 11.0;
                case RaidDifficulty.LEGEND -> 15.0;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 20.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Extra armor toughness Tanks receive.");
            this.extraArmorToughness_config = builder2.defineInRange("tank_extraArmorToughness", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND, RaidDifficulty.MASTER -> 0.0;
                case RaidDifficulty.GRANDMASTER -> 15.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Chance for Tanks to spawn with armor enchanted with Thorns.");
            this.thornsChance_config = builder3.defineInRange("tank_thornsChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0.0;
                case RaidDifficulty.LEGEND -> 0.1;
                case RaidDifficulty.MASTER -> 0.3;
                case RaidDifficulty.GRANDMASTER -> 0.8;
            }, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.extraArmor = ((Double)this.extraArmor_config.get()).floatValue();
            this.extraArmorToughness = ((Double)this.extraArmorToughness_config.get()).floatValue();
            this.thornsChance = ((Double)this.thornsChance_config.get()).floatValue();
        }
    }

    public static class Shaman
    extends RaiderConfig {
        public static final TagKey<MobEffect> TAG_EFFECTS_HERO = ForgeRegistries.MOB_EFFECTS.tags().createTagKey(new ResourceLocation("difficultraids:shaman/effects_hero"));
        public static final TagKey<MobEffect> TAG_EFFECTS_LEGEND = ForgeRegistries.MOB_EFFECTS.tags().createTagKey(new ResourceLocation("difficultraids:shaman/effects_legend"));
        public static final TagKey<MobEffect> TAG_EFFECTS_MASTER = ForgeRegistries.MOB_EFFECTS.tags().createTagKey(new ResourceLocation("difficultraids:shaman/effects_master"));
        public static final TagKey<MobEffect> TAG_EFFECTS_GRANDMASTER = ForgeRegistries.MOB_EFFECTS.tags().createTagKey(new ResourceLocation("difficultraids:shaman/effects_grandmaster"));
        private final ForgeConfigSpec.IntValue invisibilityDuration_config;
        public int invisibilityDuration;
        private final ForgeConfigSpec.IntValue maxDebuffCount_config;
        public int maxDebuffCount;
        private final ForgeConfigSpec.DoubleValue additionalDebuffChance_config;
        public float additionalDebuffChance;
        private final ForgeConfigSpec.IntValue debuffDuration_config;
        public int debuffDuration;
        private final ForgeConfigSpec.IntValue debuffAmplifier_config;
        public int debuffAmplifier;
        private final ForgeConfigSpec.DoubleValue allyBuffRadius_config;
        public float allyBuffRadius;
        private final ForgeConfigSpec.IntValue allyResistanceDuration_config;
        public int allyResistanceDuration;
        private final ForgeConfigSpec.IntValue allyResistanceAmplifier_config;
        public int allyResistanceAmplifier;
        private final ForgeConfigSpec.IntValue allyStrengthDuration_config;
        public int allyStrengthDuration;
        private final ForgeConfigSpec.IntValue allyStrengthAmplifier_config;
        public int allyStrengthAmplifier;

        public Shaman(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Duration (in ticks) of Invisibility Shamans can apply to themselves.");
            this.invisibilityDuration_config = builder.defineInRange("shaman_invisibilityDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 60;
                case RaidDifficulty.LEGEND -> 80;
                case RaidDifficulty.MASTER -> 100;
                case RaidDifficulty.GRANDMASTER -> 120;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Maximum number of debuff effects Shamans can apply to players with each attack.");
            this.maxDebuffCount_config = builder2.defineInRange("shaman_debuffCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Chance (from 0 to 1) of Shamans applying an additional debuff effect to players with each attack.").comment("If successful, this chance will be checked again to add another debuff, up to the specified maximum.");
            this.additionalDebuffChance_config = builder3.defineInRange("shaman_additionalDebuffChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> (double)0.2f;
                case RaidDifficulty.LEGEND -> (double)0.3f;
                case RaidDifficulty.MASTER -> 0.5;
                case RaidDifficulty.GRANDMASTER -> 0.75;
            }, 0.0, 1.0);
            ForgeConfigSpec.Builder builder4 = spec.comment("Duration (in ticks) of the random debuff effect Shamans can apply to players.");
            this.debuffDuration_config = builder4.defineInRange("shaman_debuffDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 80;
                case RaidDifficulty.LEGEND -> 100;
                case RaidDifficulty.MASTER -> 120;
                case RaidDifficulty.GRANDMASTER -> 200;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Amplifier of the random debuff effect Shamans can apply to players.");
            this.debuffAmplifier_config = builder5.defineInRange("shaman_debuffAmplifier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 0;
                case RaidDifficulty.MASTER -> 1;
                case RaidDifficulty.GRANDMASTER -> 2;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder6 = spec.comment("Radius (in blocks) of the Resistance and Strength effects Shamans can apply to ally Raiders.");
            this.allyBuffRadius_config = builder6.defineInRange("shaman_allyBuffRadius", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 8.0;
                case RaidDifficulty.LEGEND -> 10.0;
                case RaidDifficulty.MASTER -> 12.0;
                case RaidDifficulty.GRANDMASTER -> 16.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder7 = spec.comment("Duration (in ticks) of the Resistance effect Shamans can apply to ally Raiders.");
            this.allyResistanceDuration_config = builder7.defineInRange("shaman_allyResistanceDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 140;
                case RaidDifficulty.LEGEND -> 180;
                case RaidDifficulty.MASTER -> 220;
                case RaidDifficulty.GRANDMASTER -> 300;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder8 = spec.comment("Amplifier of the Resistance effect Shamans can apply to ally Raiders.");
            this.allyResistanceAmplifier_config = builder8.defineInRange("shaman_allyResistanceAmplifier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 0;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 2;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder9 = spec.comment("Duration (in ticks) of the Strength effect Shamans can apply to ally Raiders.");
            this.allyStrengthDuration_config = builder9.defineInRange("shaman_allyStrengthDuration", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 140;
                case RaidDifficulty.LEGEND -> 180;
                case RaidDifficulty.MASTER -> 220;
                case RaidDifficulty.GRANDMASTER -> 300;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder10 = spec.comment("Amplifier of the Strength effect Shamans can apply to ally Raiders.");
            this.allyStrengthAmplifier_config = builder10.defineInRange("shaman_allyStrengthAmplifier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0;
                case RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.invisibilityDuration = (Integer)this.invisibilityDuration_config.get();
            this.maxDebuffCount = (Integer)this.maxDebuffCount_config.get();
            this.additionalDebuffChance = ((Double)this.additionalDebuffChance_config.get()).floatValue();
            this.debuffDuration = (Integer)this.debuffDuration_config.get();
            this.debuffAmplifier = (Integer)this.debuffAmplifier_config.get();
            this.allyBuffRadius = ((Double)this.allyBuffRadius_config.get()).floatValue();
            this.allyResistanceDuration = (Integer)this.allyResistanceDuration_config.get();
            this.allyResistanceAmplifier = (Integer)this.allyResistanceAmplifier_config.get();
            this.allyStrengthDuration = (Integer)this.allyStrengthDuration_config.get();
            this.allyStrengthAmplifier = (Integer)this.allyStrengthAmplifier_config.get();
        }

        public List<MobEffect> getEffectPool() {
            ITagManager iTagManager = ForgeRegistries.MOB_EFFECTS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_EFFECTS_HERO;
                case RaidDifficulty.LEGEND -> TAG_EFFECTS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_EFFECTS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_EFFECTS_GRANDMASTER;
            }).stream().toList();
        }
    }

    public static class Necromancer
    extends RaiderConfig {
        public static final TagKey<EntityType<?>> TAG_MINION_TYPES_HERO = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("difficultraids:necromancer/minion_types_hero"));
        public static final TagKey<EntityType<?>> TAG_MINION_TYPES_LEGEND = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("difficultraids:necromancer/minion_types_legend"));
        public static final TagKey<EntityType<?>> TAG_MINION_TYPES_MASTER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("difficultraids:necromancer/minion_types_master"));
        public static final TagKey<EntityType<?>> TAG_MINION_TYPES_GRANDMASTER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("difficultraids:necromancer/minion_types_grandmaster"));
        public static final TagKey<Item> TAG_HELMETS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/helmets_hero"));
        public static final TagKey<Item> TAG_HELMETS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/helmets_legend"));
        public static final TagKey<Item> TAG_HELMETS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/helmets_master"));
        public static final TagKey<Item> TAG_HELMETS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/helmets_grandmaster"));
        public static final TagKey<Item> TAG_CHESTPLATES_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/chestplates_hero"));
        public static final TagKey<Item> TAG_CHESTPLATES_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/chestplates_legend"));
        public static final TagKey<Item> TAG_CHESTPLATES_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/chestplates_master"));
        public static final TagKey<Item> TAG_CHESTPLATES_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/chestplates_grandmaster"));
        public static final TagKey<Item> TAG_LEGGINGS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/leggings_hero"));
        public static final TagKey<Item> TAG_LEGGINGS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/leggings_legend"));
        public static final TagKey<Item> TAG_LEGGINGS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/leggings_master"));
        public static final TagKey<Item> TAG_LEGGINGS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/leggings_grandmaster"));
        public static final TagKey<Item> TAG_BOOTS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/boots_hero"));
        public static final TagKey<Item> TAG_BOOTS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/boots_legend"));
        public static final TagKey<Item> TAG_BOOTS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/boots_master"));
        public static final TagKey<Item> TAG_BOOTS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:necromancer/boots_grandmaster"));
        private final ForgeConfigSpec.DoubleValue reflectedDamagePercentage_config;
        public float reflectedDamagePercentage;
        private final ForgeConfigSpec.IntValue minionChargeSummonCount_config;
        public int minionChargeSummonCount;
        private final ForgeConfigSpec.IntValue minionMaxProtectionLevel_config;
        public int minionMaxProtectionLevel;
        private final ForgeConfigSpec.IntValue hordeSize_config;
        public int hordeSize;
        private final ForgeConfigSpec.IntValue hordeLifetime_config;
        public int hordeLifetime;

        public Necromancer(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Percentage of damage taken that Necromancers will occasionally reflect onto alive minions.");
            this.reflectedDamagePercentage_config = builder.defineInRange("necromancer_reflectedDamagePercentage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> (double)0.4f;
                case RaidDifficulty.MASTER -> 0.5;
                case RaidDifficulty.GRANDMASTER -> 0.75;
            }, 0.0, 1.0);
            ForgeConfigSpec.Builder builder2 = spec.comment("Number of minions that Necromancers will summon at a time.");
            this.minionChargeSummonCount_config = builder2.defineInRange("necromancer_minionChargeSummonCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Maximum level of Protection that Necromancer minions' armor will be enchanted with.");
            this.minionMaxProtectionLevel_config = builder3.defineInRange("necromancer_minionMaxProtectionLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder4 = spec.comment("Number of skeletons that will spawn in a horde.");
            this.hordeSize_config = builder4.defineInRange("necromancer_hordeSize", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 10;
                case RaidDifficulty.LEGEND -> 15;
                case RaidDifficulty.MASTER -> 20;
                case RaidDifficulty.GRANDMASTER -> 30;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder5 = spec.comment("Number of ticks that a horde will remain alive for.");
            this.hordeLifetime_config = builder5.defineInRange("necromancer_hordeLifetime", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 300;
                case RaidDifficulty.LEGEND -> 400;
                case RaidDifficulty.MASTER -> 600;
                case RaidDifficulty.GRANDMASTER -> 900;
            }, 0, Integer.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.reflectedDamagePercentage = ((Double)this.reflectedDamagePercentage_config.get()).floatValue();
            this.minionChargeSummonCount = (Integer)this.minionChargeSummonCount_config.get();
            this.minionMaxProtectionLevel = (Integer)this.minionMaxProtectionLevel_config.get();
            this.hordeSize = (Integer)this.hordeSize_config.get();
            this.hordeLifetime = (Integer)this.hordeLifetime_config.get();
        }

        public EntityType<?> getMinionType() {
            ITagManager iTagManager = ForgeRegistries.ENTITY_TYPES.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_MINION_TYPES_HERO;
                case RaidDifficulty.LEGEND -> TAG_MINION_TYPES_LEGEND;
                case RaidDifficulty.MASTER -> TAG_MINION_TYPES_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_MINION_TYPES_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(EntityType.f_20501_);
        }

        public Item getMinionHelmet() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_HELMETS_HERO;
                case RaidDifficulty.LEGEND -> TAG_HELMETS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_HELMETS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_HELMETS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42468_);
        }

        public Item getMinionChestplate() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_CHESTPLATES_HERO;
                case RaidDifficulty.LEGEND -> TAG_CHESTPLATES_LEGEND;
                case RaidDifficulty.MASTER -> TAG_CHESTPLATES_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_CHESTPLATES_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42469_);
        }

        public Item getMinionLeggings() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_LEGGINGS_HERO;
                case RaidDifficulty.LEGEND -> TAG_LEGGINGS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_LEGGINGS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_LEGGINGS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42470_);
        }

        public Item getMinionBoots() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_BOOTS_HERO;
                case RaidDifficulty.LEGEND -> TAG_BOOTS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_BOOTS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_BOOTS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42471_);
        }
    }

    public static class Conductor
    extends RaiderConfig {
        private final ForgeConfigSpec.DoubleValue concentratedBoltDamage_config;
        public float concentratedBoltDamage;
        private final ForgeConfigSpec.IntValue genericLightningStrikeCount_config;
        public int genericLightningStrikeCount;
        private final ForgeConfigSpec.DoubleValue genericLightningDamage_config;
        public float genericLightningDamage;
        private final ForgeConfigSpec.BooleanValue ringExtraBolts_config;
        public boolean ringExtraBolts;
        private final ForgeConfigSpec.DoubleValue ringLightningDamage_config;
        public float ringLightningDamage;

        public Conductor(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Damage dealt by a Conductor's Concentrated Bolt attack.");
            this.concentratedBoltDamage_config = builder.defineInRange("conductor_concentratedBoltDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 19.0;
                case RaidDifficulty.LEGEND -> 20.0;
                case RaidDifficulty.MASTER -> 24.0;
                case RaidDifficulty.GRANDMASTER -> 30.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Number of lightning strikes that a Conductor will summon when using the Generic Lightning attack.");
            this.genericLightningStrikeCount_config = builder2.defineInRange("conductor_genericLightningStrikeCount", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 4;
                case RaidDifficulty.LEGEND -> 6;
                case RaidDifficulty.MASTER -> 8;
                case RaidDifficulty.GRANDMASTER -> 10;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Damage dealt by a Conductor's Generic Lightning attack.");
            this.genericLightningDamage_config = builder3.defineInRange("conductor_genericLightningDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 8.0;
                case RaidDifficulty.LEGEND -> 10.0;
                case RaidDifficulty.MASTER -> 12.0;
                case RaidDifficulty.GRANDMASTER -> 15.0;
            }, 0.0, Double.MAX_VALUE);
            this.ringExtraBolts_config = spec.comment("Whether Conductors will summon an extra ring of lightning bolts when using their Ring Lightning attack.").define("conductor_ringExtraBolts", rd.is(RaidDifficulty.LEGEND, RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER));
            ForgeConfigSpec.Builder builder4 = spec.comment("Damage dealt by each lightning bolt in a Conductor's Ring Lightning attack.");
            this.ringLightningDamage_config = builder4.defineInRange("conductor_ringLightningDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2.0;
                case RaidDifficulty.LEGEND -> 5.0;
                case RaidDifficulty.MASTER -> 7.0;
                case RaidDifficulty.GRANDMASTER -> 10.0;
            }, 0.0, Double.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.concentratedBoltDamage = ((Double)this.concentratedBoltDamage_config.get()).floatValue();
            this.genericLightningStrikeCount = (Integer)this.genericLightningStrikeCount_config.get();
            this.genericLightningDamage = ((Double)this.genericLightningDamage_config.get()).floatValue();
            this.ringExtraBolts = (Boolean)this.ringExtraBolts_config.get();
            this.ringLightningDamage = ((Double)this.ringLightningDamage_config.get()).floatValue();
        }
    }

    public static class Dart
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue sharpnessLevel_config;
        public int sharpnessLevel;
        private final ForgeConfigSpec.IntValue knockbackLevel_config;
        public int knockbackLevel;
        private final ForgeConfigSpec.DoubleValue swordDropChance_config;
        public float swordDropChance;

        public Dart(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Dart swords will be enchanted with. 0 to disable.");
            this.sharpnessLevel_config = builder.defineInRange("dart_sharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 4;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Knockback that Dart swords will be enchanted with. 0 to disable.");
            this.knockbackLevel_config = builder2.defineInRange("dart_knockbackLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            this.swordDropChance_config = spec.comment("Chance that a Dart will drop their sword. 0 to disable.").defineInRange("dart_swordDropChance", 0.1, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.sharpnessLevel = (Integer)this.sharpnessLevel_config.get();
            this.knockbackLevel = (Integer)this.knockbackLevel_config.get();
            this.swordDropChance = ((Double)this.swordDropChance_config.get()).floatValue();
        }
    }

    public static class Warrior
    extends RaiderConfig {
        public static final TagKey<Item> TAG_SWORDS_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:warrior/swords_hero"));
        public static final TagKey<Item> TAG_SWORDS_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:warrior/swords_legend"));
        public static final TagKey<Item> TAG_SWORDS_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:warrior/swords_master"));
        public static final TagKey<Item> TAG_SWORDS_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:warrior/swords_grandmaster"));
        private final ForgeConfigSpec.IntValue sharpnessLevel_config;
        public int sharpnessLevel;
        private final ForgeConfigSpec.DoubleValue fireAspectChance_config;
        public float fireAspectChance;
        private final ForgeConfigSpec.IntValue fireAspectLevel_config;
        public int fireAspectLevel;
        private final ForgeConfigSpec.DoubleValue knockbackChance_config;
        public float knockbackChance;
        private final ForgeConfigSpec.IntValue knockbackLevel_config;
        public int knockbackLevel;
        private final ForgeConfigSpec.IntValue criticalStrikeLevel_config;
        public int criticalStrikeLevel;
        private final ForgeConfigSpec.DoubleValue swordDropChance_config;
        public float swordDropChance;

        public Warrior(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Warrior swords will be enchanted with. 0 to disable.");
            this.sharpnessLevel_config = builder.defineInRange("warrior_sharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 0;
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Chance that a Warrior's sword will be enchanted with Fire Aspect. 0 to disable.");
            this.fireAspectChance_config = builder2.defineInRange("warrior_fireAspectChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0.0;
                case RaidDifficulty.LEGEND -> 0.25;
                case RaidDifficulty.MASTER -> 0.5;
                case RaidDifficulty.GRANDMASTER -> 1.0;
            }, 0.0, 1.0);
            ForgeConfigSpec.Builder builder3 = spec.comment("Level of Fire Aspect that Warrior swords will be enchanted with. 0 to disable.");
            this.fireAspectLevel_config = builder3.defineInRange("warrior_fireAspectLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0;
                case RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder4 = spec.comment("Chance that a Warrior's sword will be enchanted with Knockback. 0 to disable.");
            this.knockbackChance_config = builder4.defineInRange("warrior_knockbackChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 0.0;
                case RaidDifficulty.MASTER -> (double)0.2f;
                case RaidDifficulty.GRANDMASTER -> 1.0;
            }, 0.0, 1.0);
            ForgeConfigSpec.Builder builder5 = spec.comment("Level of Knockback that Warrior swords will be enchanted with. 0 to disable.");
            this.knockbackLevel_config = builder5.defineInRange("warrior_knockbackLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0;
                case RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 3;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder6 = spec.comment("Level of Critical Strike that Warrior swords will be enchanted with. 0 to disable.");
            this.criticalStrikeLevel_config = builder6.defineInRange("warrior_criticalStrikeLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 0;
                case RaidDifficulty.MASTER -> 2;
                case RaidDifficulty.GRANDMASTER -> 4;
            }, 0, Integer.MAX_VALUE);
            this.swordDropChance_config = spec.comment("Chance that a Warrior will drop their sword. 0 to disable.").defineInRange("warrior_swordDropChance", 0.0, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.sharpnessLevel = (Integer)this.sharpnessLevel_config.get();
            this.fireAspectChance = ((Double)this.fireAspectChance_config.get()).floatValue();
            this.fireAspectLevel = (Integer)this.fireAspectLevel_config.get();
            this.knockbackChance = ((Double)this.knockbackChance_config.get()).floatValue();
            this.knockbackLevel = (Integer)this.knockbackLevel_config.get();
            this.criticalStrikeLevel = (Integer)this.criticalStrikeLevel_config.get();
            this.swordDropChance = ((Double)this.swordDropChance_config.get()).floatValue();
        }

        public Item getSword() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_SWORDS_HERO;
                case RaidDifficulty.LEGEND -> TAG_SWORDS_LEGEND;
                case RaidDifficulty.MASTER -> TAG_SWORDS_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_SWORDS_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42383_);
        }
    }

    public static class Ravager
    extends RaiderConfig {
        private final ForgeConfigSpec.DoubleValue damageMultiplier_config;
        public float damageMultiplier;
        private final ForgeConfigSpec.DoubleValue speedMultiplier_config;
        public float speedMultiplier;

        public Ravager(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Damage dealt by Ravagers. The base damage will be multiplied by this value.");
            this.damageMultiplier_config = builder.defineInRange("ravager_damageMultiplier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> (double)1.05f;
                case RaidDifficulty.LEGEND -> 1.25;
                case RaidDifficulty.MASTER -> 1.5;
                case RaidDifficulty.GRANDMASTER -> 2.0;
            }, 0.0, Double.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Speed of Ravagers. The base speed will be multiplied by this value.");
            this.speedMultiplier_config = builder2.defineInRange("ravager_speedMultiplier", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> (double)1.05f;
                case RaidDifficulty.LEGEND -> (double)1.15f;
                case RaidDifficulty.MASTER -> 1.25;
                case RaidDifficulty.GRANDMASTER -> 1.5;
            }, 0.0, Double.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.damageMultiplier = ((Double)this.damageMultiplier_config.get()).floatValue();
            this.speedMultiplier = ((Double)this.speedMultiplier_config.get()).floatValue();
        }
    }

    public static class Pillager
    extends RaiderConfig {
        private final ForgeConfigSpec.IntValue powerLevel_config;
        public int powerLevel;
        private final ForgeConfigSpec.IntValue quickChargeLevel_config;
        public int quickChargeLevel;
        private final ForgeConfigSpec.DoubleValue multishotChance_config;
        public float multishotChance;
        private final ForgeConfigSpec.DoubleValue crossbowDropChance_config;
        public float crossbowDropChance;

        public Pillager(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Power that Pillager crossbows will be enchanted with. 0 to disable.");
            this.powerLevel_config = builder.defineInRange("pillager_powerLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Quick Charge that Pillager crossbows will be enchanted with. 0 to disable.");
            this.quickChargeLevel_config = builder2.defineInRange("pillager_quickChargeLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 1;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Chance that a Pillager's crossbow will be enchanted with Multishot. 0 to disable.");
            this.multishotChance_config = builder3.defineInRange("pillager_multishotChance", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0.25;
                case RaidDifficulty.LEGEND -> (double)0.33f;
                case RaidDifficulty.MASTER -> 0.5;
                case RaidDifficulty.GRANDMASTER -> 1.0;
            }, 0.0, 1.0);
            this.crossbowDropChance_config = spec.comment("Chance that a Pillager will drop their crossbow upon death. 0 to disable.").defineInRange("pillager_crossbowDropChance", 0.0, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.powerLevel = (Integer)this.powerLevel_config.get();
            this.quickChargeLevel = (Integer)this.quickChargeLevel_config.get();
            this.multishotChance = ((Double)this.multishotChance_config.get()).floatValue();
            this.crossbowDropChance = ((Double)this.crossbowDropChance_config.get()).floatValue();
        }
    }

    public static class Evoker
    extends RaiderConfig {
        private final ForgeConfigSpec.DoubleValue evokerFangDamage_config;
        public float evokerFangDamage;

        public Evoker(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Damage dealt by Evoker Fangs.");
            this.evokerFangDamage_config = builder.defineInRange("evoker_fangDamage", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 6.0;
                case RaidDifficulty.HERO -> 7.0;
                case RaidDifficulty.LEGEND -> 9.0;
                case RaidDifficulty.MASTER -> 13.0;
                case RaidDifficulty.GRANDMASTER -> 18.0;
            }, 0.0, Double.MAX_VALUE);
        }

        @Override
        public void initialize() {
            this.evokerFangDamage = ((Double)this.evokerFangDamage_config.get()).floatValue();
        }
    }

    public static class Vindicator
    extends RaiderConfig {
        public static final TagKey<Item> TAG_AXES_HERO = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:vindicator/axes_hero"));
        public static final TagKey<Item> TAG_AXES_LEGEND = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:vindicator/axes_legend"));
        public static final TagKey<Item> TAG_AXES_MASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:vindicator/axes_master"));
        public static final TagKey<Item> TAG_AXES_GRANDMASTER = ItemTags.create((ResourceLocation)new ResourceLocation("difficultraids:vindicator/axes_grandmaster"));
        private final ForgeConfigSpec.IntValue sharpnessLevel_config;
        public int sharpnessLevel;
        private final ForgeConfigSpec.IntValue criticalBurstLevel_config;
        public int criticalBurstLevel;
        private final ForgeConfigSpec.IntValue criticalStrikeLevel_config;
        public int criticalStrikeLevel;
        private final ForgeConfigSpec.DoubleValue axeDropChance_config;
        public float axeDropChance;

        public Vindicator(RaidDifficulty rd, ForgeConfigSpec.Builder spec) {
            super(rd);
            ForgeConfigSpec.Builder builder = spec.comment("Level of Sharpness that Vindicator axes will be enchanted with. 0 to disable.");
            this.sharpnessLevel_config = builder.defineInRange("vindicator_sharpnessLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 0;
                case RaidDifficulty.HERO -> 2;
                case RaidDifficulty.LEGEND -> 3;
                case RaidDifficulty.MASTER -> 4;
                case RaidDifficulty.GRANDMASTER -> 5;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = spec.comment("Level of Critical Burst that Vindicator axes will be enchanted with. 0 to disable.");
            this.criticalBurstLevel_config = builder2.defineInRange("vindicator_criticalBurstLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> 0;
                case RaidDifficulty.LEGEND -> 2;
                case RaidDifficulty.MASTER -> 3;
                case RaidDifficulty.GRANDMASTER -> 6;
            }, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder3 = spec.comment("Level of Critical Strike that Vindicator axes will be enchanted with. 0 to disable.");
            this.criticalStrikeLevel_config = builder3.defineInRange("vindicator_criticalStrikeLevel", switch (rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT -> 0;
                case RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 1;
                case RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER -> 2;
            }, 0, Integer.MAX_VALUE);
            this.axeDropChance_config = spec.comment("Chance that a Vindicator will drop their axe upon death. 0 to disable.").defineInRange("vindicator_axeDropChance", 0.0, 0.0, 1.0);
        }

        @Override
        public void initialize() {
            this.sharpnessLevel = (Integer)this.sharpnessLevel_config.get();
            this.criticalBurstLevel = (Integer)this.criticalBurstLevel_config.get();
            this.criticalStrikeLevel = (Integer)this.criticalStrikeLevel_config.get();
            this.axeDropChance = ((Double)this.axeDropChance_config.get()).floatValue();
        }

        public Item getAxe() {
            ITagManager iTagManager = ForgeRegistries.ITEMS.tags();
            return iTagManager.getTag(switch (this.rd) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> TAG_AXES_HERO;
                case RaidDifficulty.LEGEND -> TAG_AXES_LEGEND;
                case RaidDifficulty.MASTER -> TAG_AXES_MASTER;
                case RaidDifficulty.GRANDMASTER -> TAG_AXES_GRANDMASTER;
            }).getRandomElement(RandomSource.m_216327_()).orElse(Items.f_42386_);
        }
    }
}

