/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.component;

import com.calculusmaster.difficultraids.entity.entities.raider.AshenmancerIllagerEntity;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AshenadoObject {
    private final AshenmancerIllagerEntity owner;
    private final ServerLevel level;
    private final RaidDifficulty raidDifficulty;
    private Vec3i center;
    private int life;
    private AABB coreArea;
    private AABB fullArea;
    private List<Vec3> particlePositions;
    private boolean firstTick;

    public AshenadoObject(AshenmancerIllagerEntity owner, RaidDifficulty raidDifficulty, Vec3i center, int life) {
        this.owner = owner;
        this.level = (ServerLevel)owner.m_9236_();
        this.raidDifficulty = raidDifficulty;
        this.center = center;
        this.life = life;
        this.firstTick = true;
        this.generateArea();
    }

    public AshenadoObject(AshenmancerIllagerEntity owner, CompoundTag tag) {
        this.owner = owner;
        this.level = (ServerLevel)owner.m_9236_();
        this.raidDifficulty = RaidDifficulty.valueOf(tag.m_128461_("AshenadoRaidDifficulty"));
        Vec3 center = new Vec3(tag.m_128459_("AshenadoCenterX"), tag.m_128459_("AshenadoCenterY"), tag.m_128459_("AshenadoCenterZ"));
        this.center = new Vec3i((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_);
        this.life = tag.m_128451_("AshenadoLife");
        this.firstTick = true;
        this.generateArea();
    }

    public void save(CompoundTag tag) {
        tag.m_128359_("AshenadoRaidDifficulty", this.raidDifficulty.toString());
        tag.m_128347_("AshenadoCenterX", (double)this.center.m_123341_());
        tag.m_128347_("AshenadoCenterY", (double)this.center.m_123342_());
        tag.m_128347_("AshenadoCenterZ", (double)this.center.m_123343_());
        tag.m_128405_("AshenadoLife", this.life);
    }

    private void generateArea() {
        double radius = 0.75;
        int height = 8;
        this.coreArea = new AABB(new BlockPos(this.center)).m_82377_(0.375, 0.0, 0.375).m_165893_((double)(this.center.m_123342_() + 8));
        this.fullArea = new AABB(new BlockPos(this.center)).m_82377_(0.75, 0.0, 0.75).m_165893_((double)(this.center.m_123342_() + 8));
        this.particlePositions = new ArrayList<Vec3>();
        float y = 0.0f;
        while (y < 8.0f) {
            double currentY = this.fullArea.f_82289_ + (double)y;
            float x = 0.0f;
            while ((double)x <= this.fullArea.f_82291_ - this.fullArea.f_82288_) {
                double currentX = this.fullArea.f_82288_ + (double)x;
                this.particlePositions.add(new Vec3(currentX, currentY, this.fullArea.f_82290_));
                this.particlePositions.add(new Vec3(currentX, currentY, this.fullArea.f_82293_));
                x = (float)((double)x + 0.25);
            }
            float z = 0.0f;
            while ((double)z <= this.fullArea.f_82293_ - this.fullArea.f_82290_) {
                double currentZ = this.fullArea.f_82290_ + (double)z;
                this.particlePositions.add(new Vec3(this.fullArea.f_82288_, currentY, currentZ));
                this.particlePositions.add(new Vec3(this.fullArea.f_82291_, currentY, currentZ));
                z = (float)((double)z + 0.25);
            }
            y = (float)((double)y + 0.25);
        }
    }

    public void tick() {
        if (this.life > 0) {
            if (this.life % 8 == 0) {
                this.render();
            }
            if (this.life % 15 == 0) {
                this.applyEffects();
            }
            if (!this.firstTick && this.life % 100 == 0) {
                this.center = new Vec3i(this.center.m_123341_() + 5 - this.level.f_46441_.m_188503_(11), this.center.m_123342_(), this.center.m_123343_() + 5 - this.level.f_46441_.m_188503_(11));
                this.generateArea();
            }
            --this.life;
        }
        if (this.firstTick) {
            this.firstTick = false;
        }
    }

    private void render() {
        this.particlePositions.forEach(pos -> this.level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50505_.m_49966_()), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.0, 0.0, 0.0, 3.0));
    }

    private void applyEffects() {
        Predicate<LivingEntity> validTarget = l -> {
            Player p;
            return !(l instanceof Raider) && !l.m_7307_((Entity)this.owner) && (!(l instanceof Player) || !(p = (Player)l).m_7500_() && !p.m_5833_());
        };
        this.level.m_6443_(LivingEntity.class, this.fullArea, validTarget).forEach(l -> {
            l.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 140, 1, false, false));
            l.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 140, 1, false, false));
        });
        this.level.m_6443_(LivingEntity.class, this.coreArea, validTarget).forEach(l -> l.m_6469_(l.m_269291_().m_269104_((Entity)this.owner, (Entity)l), 2.0f));
    }

    public boolean isComplete() {
        return this.life == 0;
    }

    public Vec3i getCenter() {
        return this.center;
    }
}

