/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.core;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractIllagerVariant;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractEvokerVariant
extends AbstractIllagerVariant {
    private static final EntityDataAccessor<Byte> SPELL_DATA = SynchedEntityData.m_135353_(AbstractEvokerVariant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int spellTicks;
    private SpellType activeSpell = SpellType.NONE;

    protected AbstractEvokerVariant(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_DATA, (Object)0);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.spellTicks = pCompound.m_128451_("SpellTicks");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SpellTicks", this.spellTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean isCastingSpell() {
        if (this.m_9236_().f_46443_) {
            return (Byte)this.f_19804_.m_135370_(SPELL_DATA) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSpellType(SpellType spellType) {
        this.activeSpell = spellType;
        this.f_19804_.m_135381_(SPELL_DATA, (Object)((byte)spellType.ID));
    }

    protected SpellType getSpellType() {
        return !this.m_9236_().f_46443_ ? this.activeSpell : SpellType.getFromID(((Byte)this.f_19804_.m_135370_(SPELL_DATA)).byteValue());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
    }

    protected boolean spawnDefaultSpellcastingParticles() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.isCastingSpell() && this.spawnDefaultSpellcastingParticles()) {
            SpellType spellType = this.getSpellType();
            double d0 = spellType.spellColor[0];
            double d1 = spellType.spellColor[1];
            double d2 = spellType.spellColor[2];
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected SoundEvent getSpellSound() {
        return SoundEvents.f_11862_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11861_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_11866_;
    }

    public static enum SpellType {
        NONE(0, 0.0, 0.0, 0.0),
        ELECTRO_SUMMON_BASIC_LIGHTNING_BOLTS(1, 0.56, 0.89, 0.96),
        ELECTRO_LIGHTNING_RING(2, 0.2, 0.9, 0.8),
        ELECTRO_CONCENTRATED_BOLT(3, 0.9, 0.1, 0.1),
        ELECTRO_SLOWNESS_BOLT(4, 0.5, 0.5, 0.5),
        NECROMANCER_SUMMON_MINIONS(5, 0.1, 0.1, 0.1),
        NECROMANCER_SUMMON_HORDE(6, 0.5, 0.05, 0.5),
        NECROMANCER_BURY_TARGET(7, 0.0, 0.9, 0.2),
        SHAMAN_ATTACK_BOOST(8, 0.3, 0.9, 0.0),
        SHAMAN_DEFENSE_BOOST(9, 0.0, 0.9, 0.3),
        SHAMAN_DEBUFF(10, 0.1, 0.1, 0.1),
        SHAMAN_INVISIBILITY(11, 0.2, 0.3, 0.4),
        FROST_FREEZE(12, 0.5, 0.5, 1.0),
        FROST_BARRAGE(13, 0.5, 0.6, 1.0),
        FROST_SNOWBALL_BLAST(14, 0.9, 0.3, 1.0),
        XYDRAX_WIND_BLAST(15, 0.1, 0.1, 0.1),
        XYDRAX_ARROW_BARRAGE(16, 0.3, 0.0, 0.1),
        XYDRAX_HEAL(17, 0.9, 0.3, 0.2),
        XYDRAX_WIND_COLUMN(18, 1.0, 1.0, 1.0),
        XYDRAX_VORTEX(19, 0.7, 0.7, 1.0),
        MODUR_SUMMON_THUNDER(20, 0.5, 0.5, 0.5),
        MODUR_LIGHTNING_STORM(21, 1.0, 0.9, 0.9),
        MODUR_LIGHTNING_ZAP(22, 1.0, 0.2, 1.0),
        MODUR_CHARGED_BOLT(23, 1.0, 0.5, 1.0),
        MODUR_HOMING_BOLT(24, 0.5, 0.5, 0.5),
        VOLDON_SUMMON_FAMILIARS(25, 0.05, 0.05, 0.05),
        VOLDON_TELEPORT_FAMILIAR(26, 0.8, 0.1, 0.5),
        VOLDON_SACRIFICE_FAMILIAR(27, 0.6, 0.6, 0.1),
        ASHENMANCER_SUMMON_MINIONS(28, 0.1, 0.1, 0.1),
        ASHENMANCER_SHOOT_SKULL(29, 0.1, 0.1, 0.4),
        ASHENMANCER_ASHENADO(30, 0.05, 0.05, 0.05),
        ASHENMANCER_TURRET(31, 0.8, 0.35, 0.07);

        final int ID;
        final double[] spellColor;

        private SpellType(int ID, double spellColor1, double spellColor2, double spellColor3) {
            this.ID = ID;
            this.spellColor = new double[]{spellColor1, spellColor2, spellColor3};
        }

        public static SpellType getFromID(int ID) {
            for (SpellType type : SpellType.values()) {
                if (type.ID != ID) continue;
                return type;
            }
            return NONE;
        }

        public double getColor(int index) {
            return this.spellColor[index];
        }
    }

    public abstract class SpellcastingIllagerUseSpellGoal
    extends Goal {
        protected int spellWarmup;
        protected int spellCooldown;

        protected SpellcastingIllagerUseSpellGoal(Goal.Flag ... flags) {
            if (flags.length > 0) {
                this.m_7021_(EnumSet.copyOf(List.of(flags)));
            }
        }

        public boolean m_8036_() {
            LivingEntity entity = AbstractEvokerVariant.this.m_5448_();
            if (entity != null && entity.m_6084_()) {
                if (AbstractEvokerVariant.this.isCastingSpell()) {
                    return false;
                }
                return AbstractEvokerVariant.this.f_19797_ >= this.spellCooldown;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity entity = AbstractEvokerVariant.this.m_5448_();
            return entity != null && entity.m_6084_() && this.spellWarmup > 0;
        }

        public void m_8056_() {
            this.spellWarmup = this.getCastWarmupTime();
            AbstractEvokerVariant.this.spellTicks = this.getCastingTime();
            this.spellCooldown = AbstractEvokerVariant.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundEvent = this.getSpellPrepareSound();
            if (soundEvent != null) {
                AbstractEvokerVariant.this.m_5496_(soundEvent, 1.0f, 1.0f);
            }
            AbstractEvokerVariant.this.setSpellType(this.getSpellType());
        }

        public void m_8037_() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                AbstractEvokerVariant.this.m_5496_(AbstractEvokerVariant.this.getSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected abstract int getCastWarmupTime();

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SpellType getSpellType();
    }

    public abstract class SpellcastingIllagerCastSpellGoal
    extends Goal {
        public SpellcastingIllagerCastSpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return AbstractEvokerVariant.this.getSpellTicks() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            AbstractEvokerVariant.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            AbstractEvokerVariant.this.setSpellType(SpellType.NONE);
        }

        public void m_8037_() {
            super.m_8037_();
            if (AbstractEvokerVariant.this.m_5448_() != null) {
                AbstractEvokerVariant.this.m_21563_().m_24960_((Entity)AbstractEvokerVariant.this.m_5448_(), (float)AbstractEvokerVariant.this.m_8085_(), (float)AbstractEvokerVariant.this.m_8132_());
            }
        }
    }
}

