/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.elite;

import com.calculusmaster.difficultraids.config.RaiderConfigs;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.util.Compat;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class ModurEliteEntity
extends AbstractEvokerVariant
implements RangedAttackMob {
    private final Component ELITE_NAME = Component.m_237115_((String)"com.calculusmaster.difficultraids.elite_event.modur");
    private final ServerBossEvent ELITE_EVENT = new ServerBossEvent(this.ELITE_NAME, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    private int stormTicks = 0;
    private AABB stormAABB = new AABB(BlockPos.f_121853_);
    private int chargedBoltWarmup = 0;
    private int chargedBoltWarmupTotal = 0;
    private BlockPos chargedBoltPos = BlockPos.f_121853_;
    private int homingBoltTicks = 0;
    private BlockPos homingBoltPos = BlockPos.f_121853_;

    public ModurEliteEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ModurCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new ModurSummonThunderSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new ModurLightningStormSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new ModurChargedBoltSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new ModurHomingBoltSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new ModurLightningZapSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 0.6, 0.75));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 4.0f, 0.7, 0.75));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractRecruitEntity.class, 4.0f, 0.7, 0.75));
        }
        this.f_21345_.m_25352_(6, (Goal)new RangedAttackGoal((RangedAttackMob)this, (double)0.7f, 130, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Guard.class, true));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractRecruitEntity.class, true));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        if (Compat.WORKERS.isLoaded()) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractWorkerEntity.class, true).m_26146_(300));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof IronGolem || Compat.GUARD_VILLAGERS.isLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount *= this.config().modur.friendlyDamageReduction;
        }
        if (pSource.m_7640_() instanceof Projectile) {
            pAmount *= this.config().modur.projectileDamageReduction;
        }
        if (this.isStormActive()) {
            pAmount = (float)((double)pAmount * 1.2);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        this.spawnCustomBolt(pTarget.m_20183_(), this.config().modur.basicLightningStrikeDamage);
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        this.spawnCustomBolt(this.m_20183_(), 15.0f);
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46470_()) {
            ((ServerLevel)this.m_9236_()).m_8606_(6000, 0, false, false);
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("StormTicks", this.stormTicks);
        pCompound.m_128385_("StormAABB", new int[]{(int)this.stormAABB.f_82288_, (int)this.stormAABB.f_82291_, (int)this.stormAABB.f_82289_, (int)this.stormAABB.f_82292_, (int)this.stormAABB.f_82290_, (int)this.stormAABB.f_82293_});
        pCompound.m_128405_("ChargedBoltWarmup", this.chargedBoltWarmup);
        pCompound.m_128405_("ChargedBoltWarmupTotal", this.chargedBoltWarmupTotal);
        pCompound.m_128385_("ChargedBoltPos", new int[]{this.chargedBoltPos.m_123341_(), this.chargedBoltPos.m_123342_(), this.chargedBoltPos.m_123343_()});
        pCompound.m_128405_("HomingBoltTicks", this.homingBoltTicks);
        pCompound.m_128385_("HomingBoltPos", new int[]{this.homingBoltPos.m_123341_(), this.homingBoltPos.m_123342_(), this.homingBoltPos.m_123343_()});
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.stormTicks = pCompound.m_128451_("StormTicks");
        int[] dataAABB = pCompound.m_128465_("StormAABB");
        this.stormAABB = dataAABB.length == 6 ? new AABB((double)dataAABB[0], (double)dataAABB[1], (double)dataAABB[2], (double)dataAABB[3], (double)dataAABB[4], (double)dataAABB[5]) : new AABB(BlockPos.f_121853_);
        this.chargedBoltWarmup = pCompound.m_128451_("ChargedBoltWarmup");
        this.chargedBoltWarmupTotal = pCompound.m_128451_("ChargedBoltWarmupTotal");
        int[] dataBoltPos = pCompound.m_128465_("ChargedBoltPos");
        this.chargedBoltPos = dataBoltPos.length == 3 ? new BlockPos(dataBoltPos[0], dataBoltPos[1], dataBoltPos[2]) : BlockPos.f_121853_;
        this.homingBoltTicks = pCompound.m_128451_("HomingBoltTicks");
        int[] dataHomingBoltPos = pCompound.m_128465_("HomingBoltPos");
        this.homingBoltPos = dataHomingBoltPos.length == 3 ? new BlockPos(dataHomingBoltPos[0], dataHomingBoltPos[1], dataHomingBoltPos[2]) : BlockPos.f_121853_;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.ELITE_EVENT.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    public boolean isInExtendedSpellState() {
        return this.stormTicks > 0 || this.chargedBoltWarmup > 0 || this.homingBoltTicks > 0;
    }

    public boolean isStormActive() {
        return this.stormTicks > 0;
    }

    private void spawnCustomBolt(BlockPos spawn, float damage) {
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
        if (bolt == null) {
            return;
        }
        if (this.m_9236_().m_46470_()) {
            damage *= 1.25f;
        }
        bolt.m_6593_((Component)Component.m_237113_((String)"DifficultRaids_Electro_Bolt"));
        bolt.setDamage(damage);
        bolt.m_20035_(spawn, 0.0f, 0.0f);
        this.m_9236_().m_7967_((Entity)bolt);
    }

    @Override
    public void m_8119_() {
        int i;
        super.m_8119_();
        RaiderConfigs.Modur cfg = this.config().modur;
        if (this.isStormActive()) {
            int strikes = cfg.stormStrikesPerTick;
            if (this.stormTicks % 2 == 0) {
                for (i = 0; i < strikes; ++i) {
                    int strikeX = this.f_19796_.m_216339_((int)this.stormAABB.f_82288_, (int)(this.stormAABB.f_82291_ + 1.0));
                    int strikeY = (int)this.stormAABB.f_82289_;
                    int strikeZ = this.f_19796_.m_216339_((int)this.stormAABB.f_82290_, (int)(this.stormAABB.f_82293_ + 1.0));
                    BlockPos strikePos = new BlockPos(strikeX, strikeY, strikeZ);
                    int tries = 0;
                    while (!this.m_9236_().m_8055_(strikePos).m_60795_() && tries++ < 20) {
                        strikePos = strikePos.m_6630_(1);
                    }
                    this.spawnCustomBolt(strikePos, cfg.stormStrikeDamage);
                }
            }
            --this.stormTicks;
            if (this.stormTicks == 0) {
                this.stormAABB = new AABB(BlockPos.f_121853_);
            }
        }
        if (this.chargedBoltWarmup > 0) {
            if (this.chargedBoltWarmup % 30 == 0) {
                this.m_9236_().m_7785_((double)this.chargedBoltPos.m_123341_(), (double)this.chargedBoltPos.m_123342_(), (double)this.chargedBoltPos.m_123343_(), SoundEvents.f_11868_, SoundSource.HOSTILE, 2.0f, 0.7f, false);
            }
            int tiers = 2 + (this.chargedBoltWarmupTotal - this.chargedBoltWarmup) / 20;
            for (i = 0; i < tiers; ++i) {
                Stream.of(this.chargedBoltPos.m_7918_(0, i, 0), this.chargedBoltPos.m_7918_(1, i, 0), this.chargedBoltPos.m_7918_(0, i, 1), this.chargedBoltPos.m_7918_(1, i, 1)).forEach(pos -> ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50041_.m_49966_()), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2, 0.15, 0.0, 0.15, 2.0));
            }
            --this.chargedBoltWarmup;
            if (this.chargedBoltWarmup <= 0) {
                for (i = 0; i < cfg.chargedBoltCount; ++i) {
                    this.spawnCustomBolt(this.chargedBoltPos, cfg.chargedBoltDamage);
                }
                this.chargedBoltWarmup = 0;
                this.chargedBoltWarmupTotal = 0;
            }
        }
        if (this.homingBoltTicks > 0 && this.homingBoltTicks-- % 10 == 0 && this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            double x = target.m_20185_() - this.m_20185_();
            double z = target.m_20189_() - this.m_20189_();
            this.homingBoltPos = this.homingBoltPos.m_7918_(x == 0.0 ? 0 : (x < 0.0 ? -1 : 1), 0, z == 0.0 ? 0 : (z < 0.0 ? -1 : 1));
            this.spawnCustomBolt(this.homingBoltPos, cfg.homingBoltDamage);
        }
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)DifficultRaidsConfig.BOSS_BARS.get()).booleanValue()) {
            this.ELITE_EVENT.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.ELITE_EVENT.m_6539_(pPlayer);
    }

    private class ModurCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private ModurCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (ModurEliteEntity.this.m_5448_() != null) {
                ModurEliteEntity.this.m_21563_().m_24960_((Entity)ModurEliteEntity.this.m_5448_(), (float)ModurEliteEntity.this.m_8085_(), (float)ModurEliteEntity.this.m_8132_());
            }
        }
    }

    private class ModurSummonThunderSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ModurSummonThunderSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            ((ServerLevel)ModurEliteEntity.this.m_9236_()).m_8606_(0, 6000, true, true);
        }

        @Override
        public boolean m_8036_() {
            return !ModurEliteEntity.this.m_9236_().m_6106_().m_6534_();
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 500;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12090_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_SUMMON_THUNDER;
        }
    }

    private class ModurLightningStormSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ModurLightningStormSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            ModurEliteEntity modur = ModurEliteEntity.this;
            modur.stormTicks = modur.config().modur.stormDuration;
            modur.stormAABB = new AABB(modur.m_20183_()).m_82400_((double)modur.config().modur.stormRadius).m_165893_(modur.m_20188_() + (double)modur.m_20206_()).m_165887_((double)modur.m_20183_().m_123342_() + 0.4);
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && ModurEliteEntity.this.m_9236_().m_46470_() && !ModurEliteEntity.this.isInExtendedSpellState();
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 1400;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12089_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_LIGHTNING_STORM;
        }
    }

    private class ModurChargedBoltSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ModurChargedBoltSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            ModurEliteEntity.this.chargedBoltWarmupTotal = ModurEliteEntity.this.chargedBoltWarmup = 200;
            ModurEliteEntity.this.chargedBoltPos = ModurEliteEntity.this.m_5448_() != null ? ModurEliteEntity.this.m_5448_().m_20183_() : ModurEliteEntity.this.m_20183_().m_7918_(5 - ModurEliteEntity.this.f_19796_.m_216339_(1, 11), 0, 5 - ModurEliteEntity.this.f_19796_.m_216339_(1, 11));
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !ModurEliteEntity.this.isInExtendedSpellState();
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 400;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12090_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_CHARGED_BOLT;
        }
    }

    private class ModurHomingBoltSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ModurHomingBoltSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            ModurEliteEntity modur = ModurEliteEntity.this;
            modur.homingBoltPos = modur.m_20183_();
            modur.homingBoltTicks = modur.config().modur.homingBoltTime;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !ModurEliteEntity.this.isInExtendedSpellState();
        }

        @Override
        protected int getCastingTime() {
            return 70;
        }

        @Override
        protected int getCastingInterval() {
            return 500;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_HOMING_BOLT;
        }
    }

    private class ModurLightningZapSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private BlockPos targetPos;

        private ModurLightningZapSpellGoal() {
            super(new Goal.Flag[0]);
            this.targetPos = BlockPos.f_121853_;
        }

        @Override
        protected void castSpell() {
            if (!this.targetPos.equals((Object)BlockPos.f_121853_)) {
                for (int i = 0; i < 3; ++i) {
                    ModurEliteEntity.this.spawnCustomBolt(this.targetPos, ModurEliteEntity.this.config().modur.zapBoltDamage);
                }
            }
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            if (ModurEliteEntity.this.m_5448_() != null) {
                this.targetPos = new BlockPos((Vec3i)ModurEliteEntity.this.m_5448_().m_20183_());
            }
        }

        @Override
        public void m_8037_() {
            if (this.spellWarmup == 5 && ModurEliteEntity.this.m_5448_() != null) {
                this.targetPos = new BlockPos((Vec3i)ModurEliteEntity.this.m_5448_().m_20183_());
            }
            super.m_8037_();
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !ModurEliteEntity.this.isInExtendedSpellState();
        }

        @Override
        protected int getCastingTime() {
            return 30;
        }

        @Override
        protected int getCastingInterval() {
            return 160;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12521_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.MODUR_LIGHTNING_ZAP;
        }
    }
}

