/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.Compat;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class ElectroIllagerEntity
extends AbstractEvokerVariant {
    public ElectroIllagerEntity(EntityType<? extends AbstractEvokerVariant> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ElectroIllagerCastingSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.6, 1.0));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractRecruitEntity.class, 8.0f, 0.6, 1.0));
        }
        this.f_21345_.m_25352_(3, (Goal)new ElectroIllagerSummonLightningSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new ElectroIllagerConcentratedLightningBoltSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new ElectroIllagerRingLightningSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        if (Compat.WORKERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractWorkerEntity.class, true).m_26146_(300));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Guard.class, true).m_26146_(300));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractRecruitEntity.class, true).m_26146_(300));
        }
    }

    @Override
    protected boolean spawnDefaultSpellcastingParticles() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.isCastingSpell()) {
            AbstractEvokerVariant.SpellType spellType = this.getSpellType();
            double d0 = spellType.getColor(0);
            double d1 = spellType.getColor(1);
            double d2 = spellType.getColor(2);
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_() + Math.cos(f) * 0.6, this.m_20186_() + 1.8, this.m_20189_() + Math.sin(f) * 0.6, d0, d1, d2);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_() - Math.cos(f) * 0.6, this.m_20186_() + 1.8, this.m_20189_() - Math.sin(f) * 0.6, d0, d1, d2);
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    private class ElectroIllagerCastingSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private ElectroIllagerCastingSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (ElectroIllagerEntity.this.m_5448_() != null) {
                ElectroIllagerEntity.this.m_21563_().m_24960_((Entity)ElectroIllagerEntity.this.m_5448_(), (float)ElectroIllagerEntity.this.m_8085_(), (float)ElectroIllagerEntity.this.m_8132_());
            }
        }
    }

    private class ElectroIllagerSummonLightningSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ElectroIllagerSummonLightningSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = ElectroIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)ElectroIllagerEntity.this.m_9236_();
            boolean rain = level.m_46758_(ElectroIllagerEntity.this.m_20183_());
            boolean thunder = level.m_46470_();
            if (target != null) {
                BlockPos targetPos = target.m_20183_();
                Random random = new Random();
                int strikes = ElectroIllagerEntity.this.config().conductor.genericLightningStrikeCount;
                if (strikes > 2) {
                    strikes = Math.max(1, random.nextInt(strikes - 1, strikes + 2));
                }
                for (int i = 0; i < strikes; ++i) {
                    BlockPos offsetPos = targetPos.m_7918_(-2 + random.nextInt(5), 0, -2 + random.nextInt(5));
                    LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                    lightning.m_6593_((Component)Component.m_237113_((String)"DifficultRaids_Electro_Bolt"));
                    float damage = ElectroIllagerEntity.this.config().conductor.genericLightningDamage + (rain ? 1.0f : 0.0f) + (thunder ? 2.0f : 0.0f);
                    lightning.setDamage(damage);
                    lightning.m_20035_(offsetPos, 0.0f, 0.0f);
                    level.m_7967_((Entity)lightning);
                }
            }
        }

        @Override
        protected int getCastingTime() {
            return 10;
        }

        @Override
        protected int getCastingInterval() {
            return 200;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ELECTRO_SUMMON_BASIC_LIGHTNING_BOLTS;
        }
    }

    private class ElectroIllagerConcentratedLightningBoltSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ElectroIllagerConcentratedLightningBoltSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = ElectroIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)ElectroIllagerEntity.this.m_9236_();
            boolean rain = level.m_46758_(ElectroIllagerEntity.this.m_20183_());
            boolean thunder = level.m_46470_();
            if (target != null) {
                BlockPos targetPos = target.m_20183_();
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                lightning.m_6593_((Component)Component.m_237113_((String)"DifficultRaids_Electro_Bolt"));
                float damage = ElectroIllagerEntity.this.config().conductor.concentratedBoltDamage;
                if (rain) {
                    damage += 1.0f;
                }
                if (thunder) {
                    double d = damage;
                    damage = (float)(d * (switch (level.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.PEACEFUL -> 0.0;
                        case Difficulty.EASY -> 1.05;
                        case Difficulty.NORMAL -> 1.1;
                        case Difficulty.HARD -> 1.2;
                    }));
                }
                lightning.setDamage(damage);
                lightning.m_20035_(targetPos, 0.0f, 0.0f);
                level.m_7967_((Entity)lightning);
            }
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 400;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ELECTRO_CONCENTRATED_BOLT;
        }
    }

    private class ElectroIllagerRingLightningSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private ElectroIllagerRingLightningSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = ElectroIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)ElectroIllagerEntity.this.m_9236_();
            boolean thunder = level.m_46470_();
            if (target != null) {
                BlockPos targetPos = target.m_20183_();
                int dist = 10;
                ArrayList<BlockPos> offsets = new ArrayList<BlockPos>(List.of(targetPos.m_7918_(dist, 0, 0), targetPos.m_7918_(-dist, 0, 0), targetPos.m_7918_(0, 0, dist), targetPos.m_7918_(0, 0, dist), targetPos.m_7918_(dist, 0, dist), targetPos.m_7918_(dist, 0, -dist), targetPos.m_7918_(-dist, 0, dist), targetPos.m_7918_(-dist, 0, -dist)));
                if (ElectroIllagerEntity.this.m_37885_() != null) {
                    ArrayList extraOffsets = new ArrayList();
                    RaidDifficulty raidDifficulty = ElectroIllagerEntity.this.getRaidDifficulty();
                    if (ElectroIllagerEntity.this.config().conductor.ringExtraBolts) {
                        offsets.forEach(pos -> {
                            BlockPos farPos = new BlockPos((Vec3i)pos);
                            if (pos.m_123341_() != 0) {
                                farPos = pos.m_7918_(pos.m_123341_(), 0, 0);
                            }
                            if (pos.m_123343_() != 0) {
                                farPos = pos.m_7918_(0, 0, pos.m_123343_());
                            }
                            extraOffsets.add(farPos);
                        });
                    }
                    offsets.addAll(extraOffsets);
                }
                offsets.forEach(pos -> {
                    LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                    lightning.m_6593_((Component)Component.m_237113_((String)"DifficultRaids_Electro_Bolt"));
                    lightning.m_20035_(pos, 0.0f, 0.0f);
                    lightning.setDamage(ElectroIllagerEntity.this.config().conductor.ringLightningDamage + (thunder ? 3.0f : 0.0f));
                    level.m_7967_((Entity)lightning);
                });
            }
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastWarmupTime() {
            return 80;
        }

        @Override
        protected int getCastingInterval() {
            return 700;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.ELECTRO_LIGHTNING_RING;
        }
    }
}

