/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.DifficultRaidsEntityTypes;
import com.calculusmaster.difficultraids.entity.entities.component.FrostSnowballEntity;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.util.Compat;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class FrostIllagerEntity
extends AbstractEvokerVariant {
    private int barrageTicks = 0;

    public FrostIllagerEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FrostIllagerCastSpell());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.6, 1.0));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractRecruitEntity.class, 8.0f, 0.6, 1.0));
        }
        this.f_21345_.m_25352_(4, (Goal)new FrostIllagerFreezeSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new FrostIllagerBarrageSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new FrostIllagerSnowballBlastSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        if (Compat.WORKERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractWorkerEntity.class, true).m_26146_(300));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Guard.class, true).m_26146_(300));
        }
        if (Compat.RECRUITS.isLoaded()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractRecruitEntity.class, true).m_26146_(300));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, pSource.m_269533_(DamageTypeTags.f_268524_) ? pAmount * 2.0f : pAmount);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SnowballBarrageTicks", this.barrageTicks);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.barrageTicks = pCompound.m_128451_("SnowballBarrageTicks");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 80 == 0) {
            AABB aabb = this.m_20191_().m_82400_((double)this.config().frostmage.slownessAuraRadius);
            this.m_9236_().m_6443_(LivingEntity.class, aabb, e -> {
                Player p;
                return !e.m_7307_((Entity)this) && !e.m_21023_(MobEffects.f_19597_) && (!(e instanceof Player) || !(p = (Player)e).m_5833_() && !p.m_7500_());
            }).forEach(e -> e.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 3)));
        }
        if (this.barrageTicks > 0 && this.barrageTicks-- % 10 == 0) {
            LivingEntity target = this.m_5448_();
            if (target != null) {
                int size = this.f_19796_.m_216339_(15, 31);
                double targetY = target.m_20188_() - 1.1;
                double targetX = target.m_20185_() - this.m_20185_();
                double targetZ = target.m_20189_() - this.m_20189_();
                double distanceY = Math.sqrt(targetX * targetX + targetZ * targetZ) * (double)0.2f;
                for (int i = 0; i < size; ++i) {
                    FrostSnowballEntity snowball = (FrostSnowballEntity)((EntityType)DifficultRaidsEntityTypes.FROST_SNOWBALL.get()).m_20615_(this.m_9236_());
                    snowball.m_5602_((Entity)this);
                    snowball.m_6034_(this.m_146892_().m_7096_(), this.m_146892_().m_7098_() - 0.2, this.m_146892_().m_7094_());
                    snowball.setDamage(this.config().frostmage.barrageSnowballDamage);
                    if (this.f_19796_.m_188503_(100) < 40) {
                        snowball.m_6842_(true);
                    }
                    double targetSnowballY = targetY - snowball.m_20186_();
                    snowball.m_6686_(targetX, targetSnowballY + distanceY, targetZ, 1.6f, 14.0f);
                    this.m_9236_().m_7967_((Entity)snowball);
                }
                this.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
                if (target.m_21224_()) {
                    this.barrageTicks = 0;
                }
            } else {
                this.barrageTicks = 0;
            }
        }
    }

    private class FrostIllagerCastSpell
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private FrostIllagerCastSpell() {
        }

        @Override
        public void m_8037_() {
            if (FrostIllagerEntity.this.m_5448_() != null) {
                FrostIllagerEntity.this.m_21563_().m_24960_((Entity)FrostIllagerEntity.this.m_5448_(), (float)FrostIllagerEntity.this.m_8085_(), (float)FrostIllagerEntity.this.m_8132_());
            }
        }
    }

    private class FrostIllagerFreezeSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private FrostIllagerFreezeSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = FrostIllagerEntity.this.m_5448_();
            if (target != null) {
                int duration = FrostIllagerEntity.this.config().frostmage.freezeDuration;
                if (target.m_142079_()) {
                    target.m_146917_(target.m_146888_() + duration);
                }
            }
        }

        @Override
        protected int getCastingTime() {
            return 50;
        }

        @Override
        protected int getCastingInterval() {
            return 430;
        }

        @Override
        protected int getCastWarmupTime() {
            return 30;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11862_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.FROST_FREEZE;
        }
    }

    private class FrostIllagerBarrageSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private FrostIllagerBarrageSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            FrostIllagerEntity.this.barrageTicks = FrostIllagerEntity.this.config().frostmage.barrageDuration;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && FrostIllagerEntity.this.barrageTicks == 0;
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 600;
        }

        @Override
        protected int getCastWarmupTime() {
            return 50;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.FROST_BARRAGE;
        }
    }

    private class FrostIllagerSnowballBlastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private FrostIllagerSnowballBlastSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = FrostIllagerEntity.this.m_5448_();
            int size = 5;
            if (target != null) {
                float damage = FrostIllagerEntity.this.config().frostmage.snowballBlastDamage;
                for (int i = 0; i < size; ++i) {
                    FrostSnowballEntity snowball = (FrostSnowballEntity)((EntityType)DifficultRaidsEntityTypes.FROST_SNOWBALL.get()).m_20615_(FrostIllagerEntity.this.m_9236_());
                    snowball.m_5602_((Entity)FrostIllagerEntity.this);
                    snowball.m_6034_(FrostIllagerEntity.this.m_146892_().m_7096_(), FrostIllagerEntity.this.m_146892_().m_7098_() - 0.2, FrostIllagerEntity.this.m_146892_().m_7094_());
                    snowball.setDamage(damage);
                    double targetY = target.m_20188_() - 1.1;
                    double targetX = target.m_20185_() - FrostIllagerEntity.this.m_20185_();
                    double targetSnowballY = targetY - snowball.m_20186_();
                    double targetZ = target.m_20189_() - FrostIllagerEntity.this.m_20189_();
                    double distanceY = Math.sqrt(targetX * targetX + targetZ * targetZ) * (double)0.2f;
                    snowball.m_6686_(targetX, targetSnowballY + distanceY, targetZ, 1.6f, 3.0f);
                    FrostIllagerEntity.this.m_9236_().m_7967_((Entity)snowball);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && FrostIllagerEntity.this.barrageTicks == 0;
        }

        @Override
        protected int getCastingTime() {
            return 15;
        }

        @Override
        protected int getCastingInterval() {
            return 60;
        }

        @Override
        protected int getCastWarmupTime() {
            return 5;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.FROST_SNOWBALL_BLAST;
        }
    }
}

