/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.mixins;

import com.calculusmaster.difficultraids.setup.DifficultRaidsItems;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract ItemStack m_21205_();

    @Shadow
    public abstract ItemStack m_21206_();

    @Shadow
    public abstract void m_21153_(float var1);

    @Shadow
    public abstract boolean m_21219_();

    @Shadow
    public abstract boolean m_7292_(MobEffectInstance var1);

    @Shadow
    public abstract boolean m_21195_(MobEffect var1);

    @Shadow
    public abstract boolean m_20984_(double var1, double var3, double var5, boolean var7);

    @Inject(at={@At(value="HEAD")}, method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;)Z"}, cancellable=true)
    private void difficultraids_checkTotemImmunities(MobEffectInstance pEffectInstance, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Item totemOfSpeed = (Item)DifficultRaidsItems.TOTEM_OF_SPEED.get();
        if ((this.m_21205_().m_150930_(totemOfSpeed) || this.m_21206_().m_150930_(totemOfSpeed)) && pEffectInstance.m_19544_().equals(MobEffects.f_19597_)) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"checkTotemDeathProtection"}, cancellable=true)
    private void difficultraids_useCustomTotem(DamageSource damageSource, CallbackInfoReturnable<Boolean> callback) {
        if (damageSource.m_269533_(DamageTypeTags.f_268738_)) {
            callback.setReturnValue((Object)false);
        }
        Item totemInvisibility = (Item)DifficultRaidsItems.TOTEM_OF_INVISIBILITY.get();
        Item totemLightning = (Item)DifficultRaidsItems.TOTEM_OF_LIGHTNING.get();
        Item totemPoison = (Item)DifficultRaidsItems.TOTEM_OF_POISON.get();
        Item totemSpeed = (Item)DifficultRaidsItems.TOTEM_OF_SPEED.get();
        Item totemVengeance = (Item)DifficultRaidsItems.TOTEM_OF_VENGEANCE.get();
        Item totemDestiny = (Item)DifficultRaidsItems.TOTEM_OF_DESTINY.get();
        Item totemLevitation = (Item)DifficultRaidsItems.TOTEM_OF_LEVITATION.get();
        Item totemProtection = (Item)DifficultRaidsItems.TOTEM_OF_PROTECTION.get();
        Item totemFreezing = (Item)DifficultRaidsItems.TOTEM_OF_FREEZING.get();
        Item totemPersistence = (Item)DifficultRaidsItems.TOTEM_OF_PERSISTENCE.get();
        Item totemTeleportation = (Item)DifficultRaidsItems.TOTEM_OF_TELEPORTATION.get();
        Item totemFireball = (Item)DifficultRaidsItems.TOTEM_OF_FIREBALLS.get();
        ItemStack mainHand = this.m_21205_();
        ItemStack offHand = this.m_21206_();
        Predicate<Item> checkTotem = i -> List.of(totemInvisibility, totemLightning, totemPoison, totemSpeed, totemVengeance, totemDestiny, totemLevitation, totemProtection, totemFreezing, totemPersistence, totemTeleportation, totemFireball).contains(i);
        Object hand = checkTotem.test(mainHand.m_41720_()) ? mainHand : (checkTotem.test(offHand.m_41720_()) ? offHand : null);
        if (hand != null) {
            Vec3i eye_pos;
            boolean persistenceProc;
            ItemStack totem = hand.m_41777_();
            boolean bl = persistenceProc = totem.m_150930_(totemPersistence) && this.f_19796_.m_188503_(100) < 40;
            if (!persistenceProc) {
                hand.m_41774_(1);
            }
            this.m_21153_(1.0f);
            this.m_21219_();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            if (totem.m_150930_(totemInvisibility)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 600, 1));
                this.m_9236_().m_45976_(Monster.class, new AABB(this.m_20183_()).m_82400_(5.0)).stream().filter(LivingEntity::m_6084_).forEach(m -> m.m_6710_(null));
            }
            if (totem.m_150930_(totemLightning)) {
                this.m_9236_().m_45976_(Monster.class, new AABB(this.m_20183_()).m_82400_(6.0)).stream().filter(LivingEntity::m_6084_).map(Entity::m_20183_).forEach(pos -> {
                    LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                    bolt.setDamage(this.f_19796_.m_188501_() * 5.0f);
                    bolt.m_20035_(pos, 0.0f, 0.0f);
                    this.m_9236_().m_7967_((Entity)bolt);
                });
            }
            if (totem.m_150930_(totemPoison)) {
                this.m_9236_().m_45976_(Monster.class, new AABB(this.m_20183_()).m_82400_(5.0)).stream().filter(LivingEntity::m_6084_).forEach(m -> m.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 120, 2)));
            }
            if (totem.m_150930_(totemSpeed)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 4));
            }
            if (totem.m_150930_(totemVengeance)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 3));
                this.m_21195_(MobEffects.f_19605_);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 750, 3));
            }
            if (totem.m_150930_(totemDestiny)) {
                Entity entity = damageSource.m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    attacker.m_6469_(attacker.m_269291_().m_269425_(), attacker.m_21223_() + 1.0f);
                }
                this.m_9236_().m_45976_(Monster.class, new AABB(this.m_20183_()).m_82400_(10.0)).stream().filter(LivingEntity::m_6084_).forEach(m -> {
                    double distance = Math.pow(m.m_20183_().m_123331_((Vec3i)this.m_20183_()), 0.5);
                    float damage = (float)Math.max((double)0.1f, 6.0 - distance / 2.0);
                    m.m_6469_(m.m_269291_().m_269425_(), damage);
                });
            }
            if (totem.m_150930_(totemLevitation)) {
                this.m_9236_().m_45976_(Monster.class, new AABB(this.m_20183_()).m_82400_(6.0)).stream().filter(LivingEntity::m_6084_).forEach(m -> m.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 30, 3)));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 30, 4));
            }
            if (totem.m_150930_(totemProtection)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 120, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 120, 2));
                BlockPos offset1 = this.m_20183_().m_7918_(this.f_19796_.m_216339_(2, 6), 2, this.f_19796_.m_216339_(2, 6));
                BlockPos offset2 = this.m_20183_().m_7918_(this.f_19796_.m_216339_(2, 6) * -1, 2, this.f_19796_.m_216339_(2, 6) * -1);
                IronGolem golem1 = (IronGolem)EntityType.f_20460_.m_20615_(this.m_9236_());
                IronGolem golem2 = (IronGolem)EntityType.f_20460_.m_20615_(this.m_9236_());
                golem1.m_20035_(offset1, 0.0f, 0.0f);
                golem2.m_20035_(offset2, 0.0f, 0.0f);
                Entity entity = damageSource.m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    golem1.m_6710_(attacker);
                    golem1.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)golem1, attacker.getClass(), true));
                    golem2.m_6710_(attacker);
                    golem2.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)golem2, attacker.getClass(), true));
                }
                this.m_9236_().m_7967_((Entity)golem1);
                this.m_9236_().m_7967_((Entity)golem2);
            }
            if (totem.m_150930_(totemFreezing)) {
                this.m_9236_().m_45976_(Monster.class, new AABB(this.m_20183_()).m_82400_(6.0)).stream().filter(LivingEntity::m_6084_).filter(LivingEntity::m_142079_).forEach(m -> {
                    m.m_146917_(m.m_146888_() + 160);
                    m.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 140, 2));
                });
            }
            if (totem.m_150930_(totemTeleportation)) {
                BlockPos target;
                eye_pos = new Vec3i((int)this.m_146892_().f_82479_, (int)this.m_146892_().f_82480_, (int)this.m_146892_().f_82481_);
                BlockPos current = new BlockPos(eye_pos);
                int tries = 0;
                int maxTries = 10;
                Predicate<BlockPos> isInvalidPos = pos -> this.m_9236_().m_8055_(pos).m_60795_() || this.m_9236_().m_8055_(pos.m_7918_(0, (int)this.m_20192_(), 0)).m_60795_();
                do {
                    int x = (this.f_19796_.m_188503_(2) == 0 ? 1 : -1) * this.f_19796_.m_216339_(5, 16);
                    int z = (this.f_19796_.m_188503_(2) == 0 ? 1 : -1) * this.f_19796_.m_216339_(5, 16);
                    target = current.m_7918_(x, this.f_19796_.m_188503_(4), z);
                } while (++tries <= maxTries && isInvalidPos.test(target));
                if (tries == maxTries) {
                    target = current.m_7918_(0, 20, 0);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 80, 1));
                } else {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 10));
                }
                this.m_20984_(target.m_123341_(), target.m_123342_(), target.m_123343_(), true);
            }
            if (totem.m_150930_(totemFireball)) {
                eye_pos = new Vec3i((int)this.m_146892_().f_82479_, (int)this.m_146892_().f_82480_, (int)this.m_146892_().f_82481_);
                BlockPos source = new BlockPos(eye_pos);
                Stream.of(new Vec3(1.0, 0.33, 0.0), new Vec3(1.0, 0.33, 1.0), new Vec3(0.0, 0.33, 1.0), new Vec3(-1.0, 0.33, 0.0), new Vec3(-1.0, 0.33, -1.0), new Vec3(0.0, 0.33, -1.0), new Vec3(-1.0, 0.33, 1.0), new Vec3(1.0, 0.33, -1.0)).forEach(v -> {
                    Fireball fireball = (Fireball)EntityType.f_20463_.m_20615_(this.m_9236_());
                    fireball.m_20035_(source, 0.0f, 0.0f);
                    fireball.m_6686_(v.f_82479_, v.f_82480_, v.f_82481_, this.f_19796_.m_188501_() * 6.0f + 2.0f, 2.0f);
                    this.m_9236_().m_7967_((Entity)fireball);
                });
                this.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 1));
            }
            this.m_9236_().m_7605_((Entity)this, (byte)35);
            callback.setReturnValue((Object)true);
        }
    }
}

