/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.mixins.raider;

import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AbstractIllager.class})
public abstract class AbstractIllagerMixin
extends Raider {
    @Unique
    private static final String TAG_RAIDER_ARMOR_MODIFIER = "DifficultRaids Raider Armor Modifier";
    @Unique
    private static final String TAG_RAIDER_TOUGHNESS_MODIFIER = "DifficultRaids Raider Armor Toughness Modifier";
    @Unique
    private static final String TAG_RAIDER_DIFFICULTY_ARMOR_MODIFIER = "DifficultRaids Raider Armor Modifier (MC Difficulty-Dependent)";

    protected AbstractIllagerMixin(EntityType<? extends Raider> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        boolean isRaidSpawn = this.m_37885_() != null && mobSpawnType.equals((Object)MobSpawnType.EVENT);
        Random random = new Random();
        if (isRaidSpawn) {
            RaidDifficulty raidDifficulty = RaidDifficulty.get(this.m_37885_().m_37773_());
            boolean standard = DifficultRaidsUtil.STANDARD_RAIDERS.contains(this.m_6095_());
            boolean advanced = DifficultRaidsUtil.ADVANCED_RAIDERS.contains(this.m_6095_());
            boolean basicMagic = DifficultRaidsUtil.BASIC_MAGIC_RAIDERS.contains(this.m_6095_());
            boolean advMagic = DifficultRaidsUtil.ADVANCED_MAGIC_RAIDERS.contains(this.m_6095_());
            AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
            AttributeInstance toughness = this.m_21051_(Attributes.f_22285_);
            if (!raidDifficulty.isDefault() && (standard || advanced || basicMagic || advMagic) && armor != null && toughness != null) {
                int[] iron = new int[]{2, 6};
                int[] diamond = new int[]{3, 8};
                int[] netherite = new int[]{5, 8};
                if (standard) {
                    armorModifier = new AttributeModifier(TAG_RAIDER_ARMOR_MODIFIER, switch (raidDifficulty) {
                        default -> throw new IncompatibleClassChangeError();
                        case RaidDifficulty.DEFAULT -> 0.0;
                        case RaidDifficulty.HERO -> random.nextInt(iron[0], iron[1] + 1);
                        case RaidDifficulty.LEGEND -> (double)random.nextInt(diamond[0], diamond[1] + 1) * 1.25;
                        case RaidDifficulty.MASTER -> (double)random.nextInt(netherite[0], netherite[1] + 1) * 1.5;
                        case RaidDifficulty.GRANDMASTER -> random.nextInt(10, 21);
                    }, AttributeModifier.Operation.ADDITION);
                    armor.m_22125_(armorModifier);
                    if (raidDifficulty.is(RaidDifficulty.GRANDMASTER)) {
                        AttributeModifier toughnessModifier = new AttributeModifier(TAG_RAIDER_TOUGHNESS_MODIFIER, 10.0, AttributeModifier.Operation.ADDITION);
                        toughness.m_22125_(toughnessModifier);
                    }
                } else if (advanced) {
                    armorModifier = new AttributeModifier(TAG_RAIDER_ARMOR_MODIFIER, switch (raidDifficulty) {
                        default -> throw new IncompatibleClassChangeError();
                        case RaidDifficulty.DEFAULT -> 0.0;
                        case RaidDifficulty.HERO -> random.nextInt(iron[0], iron[1] + 1) - 1;
                        case RaidDifficulty.LEGEND -> (double)random.nextInt(diamond[0], diamond[1] + 1) * 1.25 - 2.0;
                        case RaidDifficulty.MASTER -> (double)random.nextInt(netherite[0], netherite[1] + 1) * 1.5 - 2.0;
                        case RaidDifficulty.GRANDMASTER -> random.nextInt(10, 21) - 2;
                    }, AttributeModifier.Operation.ADDITION);
                    armor.m_22125_(armorModifier);
                    if (raidDifficulty.is(RaidDifficulty.GRANDMASTER)) {
                        AttributeModifier toughnessModifier = new AttributeModifier(TAG_RAIDER_TOUGHNESS_MODIFIER, 5.0, AttributeModifier.Operation.ADDITION);
                        toughness.m_22125_(toughnessModifier);
                    }
                } else if (basicMagic) {
                    armorModifier = new AttributeModifier(TAG_RAIDER_ARMOR_MODIFIER, switch (raidDifficulty) {
                        default -> throw new IncompatibleClassChangeError();
                        case RaidDifficulty.DEFAULT -> 0.0;
                        case RaidDifficulty.HERO -> random.nextInt(0, 5);
                        case RaidDifficulty.LEGEND -> random.nextInt(1, 6);
                        case RaidDifficulty.MASTER -> random.nextInt(3, 7);
                        case RaidDifficulty.GRANDMASTER -> random.nextInt(5, 15);
                    }, AttributeModifier.Operation.ADDITION);
                    armor.m_22125_(armorModifier);
                    if (raidDifficulty.is(RaidDifficulty.GRANDMASTER)) {
                        AttributeModifier toughnessModifier = new AttributeModifier(TAG_RAIDER_TOUGHNESS_MODIFIER, 5.0, AttributeModifier.Operation.ADDITION);
                        toughness.m_22125_(toughnessModifier);
                    }
                } else {
                    armorModifier = new AttributeModifier(TAG_RAIDER_ARMOR_MODIFIER, switch (raidDifficulty) {
                        default -> throw new IncompatibleClassChangeError();
                        case RaidDifficulty.DEFAULT -> 0.0;
                        case RaidDifficulty.HERO -> random.nextInt(0, 3);
                        case RaidDifficulty.LEGEND -> random.nextInt(1, 4);
                        case RaidDifficulty.MASTER -> random.nextInt(4, 7);
                        case RaidDifficulty.GRANDMASTER -> random.nextInt(5, 10);
                    }, AttributeModifier.Operation.ADDITION);
                    armor.m_22125_(armorModifier);
                    if (raidDifficulty.is(RaidDifficulty.GRANDMASTER)) {
                        AttributeModifier toughnessModifier = new AttributeModifier(TAG_RAIDER_TOUGHNESS_MODIFIER, 5.0, AttributeModifier.Operation.ADDITION);
                        toughness.m_22125_(toughnessModifier);
                    }
                }
                Difficulty difficulty = this.m_9236_().m_46791_();
                if (difficulty.equals((Object)Difficulty.EASY) || difficulty.equals((Object)Difficulty.HARD)) {
                    armor.m_22125_(new AttributeModifier(TAG_RAIDER_DIFFICULTY_ARMOR_MODIFIER, difficulty.equals((Object)Difficulty.EASY) ? 0.9 : 1.1, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            }
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, tag);
    }
}

