/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.api.BedwarsAPI;
import org.screamingsandals.bedwars.api.TeamColor;
import org.screamingsandals.bedwars.api.events.BedwarsOpenShopEvent;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.api.game.GameStore;
import org.screamingsandals.bedwars.api.statistics.PlayerStatisticsManager;
import org.screamingsandals.bedwars.commands.AddholoCommand;
import org.screamingsandals.bedwars.commands.AdminCommand;
import org.screamingsandals.bedwars.commands.AllJoinCommand;
import org.screamingsandals.bedwars.commands.AutojoinCommand;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.commands.BwCommandsExecutor;
import org.screamingsandals.bedwars.commands.CheatCommand;
import org.screamingsandals.bedwars.commands.DumpCommand;
import org.screamingsandals.bedwars.commands.HelpCommand;
import org.screamingsandals.bedwars.commands.JoinCommand;
import org.screamingsandals.bedwars.commands.LeaderboardCommand;
import org.screamingsandals.bedwars.commands.LeaveCommand;
import org.screamingsandals.bedwars.commands.ListCommand;
import org.screamingsandals.bedwars.commands.MainlobbyCommand;
import org.screamingsandals.bedwars.commands.PartyCommand;
import org.screamingsandals.bedwars.commands.RejoinCommand;
import org.screamingsandals.bedwars.commands.ReloadCommand;
import org.screamingsandals.bedwars.commands.RemoveholoCommand;
import org.screamingsandals.bedwars.commands.StatsCommand;
import org.screamingsandals.bedwars.config.Configurator;
import org.screamingsandals.bedwars.database.DatabaseManager;
import org.screamingsandals.bedwars.game.CurrentTeam;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.ItemSpawnerType;
import org.screamingsandals.bedwars.holograms.LeaderboardHolograms;
import org.screamingsandals.bedwars.holograms.StatisticsHolograms;
import org.screamingsandals.bedwars.inventories.ShopInventory;
import org.screamingsandals.bedwars.lib.bstats.bukkit.Metrics;
import org.screamingsandals.bedwars.lib.bstats.charts.SimplePie;
import org.screamingsandals.bedwars.lib.debug.Debug;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.lib.nms.holograms.HologramManager;
import org.screamingsandals.bedwars.lib.nms.utils.ClassStorage;
import org.screamingsandals.bedwars.lib.nms.utils.TagApplier;
import org.screamingsandals.bedwars.lib.sgui.listeners.InventoryListener;
import org.screamingsandals.bedwars.lib.sgui.utils.MaterialSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;
import org.screamingsandals.bedwars.lib.signmanager.SignListener;
import org.screamingsandals.bedwars.lib.signmanager.SignManager;
import org.screamingsandals.bedwars.listener.BungeeMotdListener;
import org.screamingsandals.bedwars.listener.PartyListener;
import org.screamingsandals.bedwars.listener.PerWorldInventoryKotlinListener;
import org.screamingsandals.bedwars.listener.PerWorldInventoryLegacyListener;
import org.screamingsandals.bedwars.listener.Player112Listener;
import org.screamingsandals.bedwars.listener.Player18Listener;
import org.screamingsandals.bedwars.listener.Player19Listener;
import org.screamingsandals.bedwars.listener.PlayerBefore112Listener;
import org.screamingsandals.bedwars.listener.PlayerListener;
import org.screamingsandals.bedwars.listener.VillagerListener;
import org.screamingsandals.bedwars.listener.World113Listener;
import org.screamingsandals.bedwars.listener.WorldListener;
import org.screamingsandals.bedwars.placeholderapi.BedwarsExpansion;
import org.screamingsandals.bedwars.special.SpecialRegister;
import org.screamingsandals.bedwars.statistics.PlayerStatisticManager;
import org.screamingsandals.bedwars.tab.TabManager;
import org.screamingsandals.bedwars.utils.BedWarsSignOwner;
import org.screamingsandals.bedwars.utils.ColorChanger;
import org.screamingsandals.bedwars.utils.MiscUtils;
import org.screamingsandals.bedwars.utils.UpdateChecker;
import org.screamingsandals.bedwars.utils.VersionFallback;

public class Main
extends JavaPlugin
implements BedwarsAPI {
    private static Main instance;
    private String version;
    private boolean isDisabling = false;
    private boolean isSpigot;
    private boolean isPaper;
    private boolean isLegacy;
    private boolean isVault;
    private int versionNumber = 0;
    private Economy econ = null;
    private HashMap<String, Game> games = new HashMap();
    private HashMap<Player, GamePlayer> playersInGame = new HashMap();
    private HashMap<Entity, Game> entitiesInGame = new HashMap();
    private Configurator configurator;
    private ShopInventory menu;
    private HashMap<String, ItemSpawnerType> spawnerTypes = new HashMap();
    private DatabaseManager databaseManager;
    private PlayerStatisticManager playerStatisticsManager;
    private StatisticsHolograms hologramInteraction;
    private HashMap<String, BaseCommand> commands;
    private org.screamingsandals.bedwars.api.utils.ColorChanger colorChanger;
    private SignManager signManager;
    private HologramManager manager;
    private LeaderboardHolograms leaderboardHolograms;
    private TabManager tabManager;
    public static List<String> autoColoredMaterials;
    private Metrics metrics;
    private Game selectedGame;
    private boolean preSelectGames;

    public static Main getInstance() {
        return instance;
    }

    public static Configurator getConfigurator() {
        return Main.instance.configurator;
    }

    public static String getVersion() {
        return Main.instance.version;
    }

    public static boolean isSpigot() {
        return Main.instance.isSpigot;
    }

    public static boolean isPaper() {
        return Main.instance.isPaper;
    }

    public static boolean isVault() {
        return Main.instance.isVault;
    }

    public static boolean isLegacy() {
        return Main.instance.isLegacy;
    }

    public static void depositPlayer(Player player, double coins) {
        try {
            EconomyResponse response;
            if (Main.isVault() && Main.instance.configurator.config.getBoolean("vault.enable") && (response = Main.instance.econ.depositPlayer((OfflinePlayer)player, coins)).transactionSuccess()) {
                player.sendMessage(I18n.i18n("vault_deposite").replace("%coins%", Double.toString(coins)).replace("%currency%", coins == 1.0 ? Main.instance.econ.currencyNameSingular() : Main.instance.econ.currencyNamePlural()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getVaultKillReward() {
        return Main.instance.configurator.config.getInt("vault.reward.kill");
    }

    public static int getVaultFinalKillReward() {
        return Main.instance.configurator.config.getInt("vault.reward.final-kill");
    }

    public static int getVaultBedDestroyReward() {
        return Main.instance.configurator.config.getInt("vault.reward.bed-destroy");
    }

    public static int getVaultWinReward() {
        return Main.instance.configurator.config.getInt("vault.reward.win");
    }

    public static Game getGame(String string) {
        return Main.instance.games.get(string);
    }

    public static boolean isGameExists(String string) {
        return Main.instance.games.containsKey(string);
    }

    public static void addGame(Game game) {
        Main.instance.games.put(game.getName(), game);
    }

    public static void removeGame(Game game) {
        Main.instance.games.remove(game.getName());
        if (Main.instance.selectedGame == game) {
            Main.instance.selectedGame = null;
            instance.reselectGame();
        }
    }

    public static Game getInGameEntity(Entity entity) {
        return Main.instance.entitiesInGame.getOrDefault(entity, null);
    }

    public static void registerGameEntity(Entity entity, Game game) {
        Main.instance.entitiesInGame.put(entity, game);
    }

    public static void unregisterGameEntity(Entity entity) {
        Main.instance.entitiesInGame.remove(entity);
    }

    public static boolean isPlayerInGame(Player player) {
        if (Main.instance.playersInGame.containsKey(player)) {
            return Main.instance.playersInGame.get(player).isInGame();
        }
        return false;
    }

    public static GamePlayer getPlayerGameProfile(Player player) {
        if (Main.instance.playersInGame.containsKey(player)) {
            return Main.instance.playersInGame.get(player);
        }
        GamePlayer gPlayer = new GamePlayer(player);
        Main.instance.playersInGame.put(player, gPlayer);
        return gPlayer;
    }

    public static void unloadPlayerGameProfile(Player player) {
        if (Main.instance.playersInGame.containsKey(player)) {
            Main.instance.playersInGame.get(player).changeGame(null);
            Main.instance.playersInGame.remove(player);
        }
    }

    public static boolean isPlayerGameProfileRegistered(Player player) {
        return Main.instance.playersInGame.containsKey(player);
    }

    public static void sendGameListInfo(CommandSender player) {
        for (Game game : Main.instance.games.values()) {
            player.sendMessage((game.getStatus() == GameStatus.DISABLED ? "\u00a7c" : "\u00a7a") + game.getName() + "\u00a7f " + game.countPlayers());
        }
    }

    public static void openStore(Player player, org.screamingsandals.bedwars.game.GameStore store) {
        Main.instance.menu.show(player, store);
    }

    public static boolean isFarmBlock(Material mat) {
        if (Main.instance.configurator.config.getBoolean("farmBlocks.enable")) {
            List list = Main.instance.configurator.config.getList("farmBlocks.blocks");
            return list.contains(mat.name());
        }
        return false;
    }

    public static boolean isBreakableBlock(Material mat) {
        if (Main.instance.configurator.config.getBoolean("breakable.enabled")) {
            List list = Main.instance.configurator.config.getList("breakable.blocks");
            boolean asblacklist = Main.instance.configurator.config.getBoolean("breakable.asblacklist", false);
            return list.contains(mat.name()) ? !asblacklist : asblacklist;
        }
        return false;
    }

    public static boolean isCommandLeaveShortcut(String command) {
        if (Main.instance.configurator.config.getBoolean("leaveshortcuts.enabled")) {
            List commands = Main.instance.configurator.config.getList("leaveshortcuts.list");
            for (String comm : commands) {
                if (!comm.startsWith("/")) {
                    comm = "/" + comm;
                }
                if (!comm.equals(command)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCommandAllowedInGame(String commandPref) {
        if ("/bw".equals(commandPref) || "/bedwars".equals(commandPref)) {
            return true;
        }
        List commands = Main.instance.configurator.config.getStringList("allowed-commands");
        for (String comm : commands) {
            if (!comm.startsWith("/")) {
                comm = "/" + comm;
            }
            if (!comm.equals(commandPref)) continue;
            return !Main.instance.configurator.config.getBoolean("change-allowed-commands-to-blacklist", false);
        }
        return Main.instance.configurator.config.getBoolean("change-allowed-commands-to-blacklist", false);
    }

    public static ItemSpawnerType getSpawnerType(String key) {
        return Main.instance.spawnerTypes.get(key);
    }

    public static List<String> getAllSpawnerTypes() {
        return new ArrayList<String>(Main.instance.spawnerTypes.keySet());
    }

    public static List<String> getGameNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Game game : Main.instance.games.values()) {
            list.add(game.getName());
        }
        return list;
    }

    public static DatabaseManager getDatabaseManager() {
        return Main.instance.databaseManager;
    }

    public static PlayerStatisticManager getPlayerStatisticsManager() {
        return Main.instance.playerStatisticsManager;
    }

    public static boolean isPlayerStatisticsEnabled() {
        return Main.instance.configurator.config.getBoolean("statistics.enabled");
    }

    public static boolean isHologramsEnabled() {
        return Main.instance.configurator.config.getBoolean("holograms.enabled") && Main.instance.hologramInteraction != null;
    }

    public static StatisticsHolograms getHologramInteraction() {
        return Main.instance.hologramInteraction;
    }

    public static HashMap<String, BaseCommand> getCommands() {
        return Main.instance.commands;
    }

    public static List<Entity> getGameEntities(Game game) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (Map.Entry<Entity, Game> entry : Main.instance.entitiesInGame.entrySet()) {
            if (entry.getValue() != game) continue;
            entityList.add(entry.getKey());
        }
        return entityList;
    }

    public static int getVersionNumber() {
        return Main.instance.versionNumber;
    }

    public static SignManager getSignManager() {
        return Main.instance.signManager;
    }

    public static HologramManager getHologramManager() {
        return Main.instance.manager;
    }

    public static LeaderboardHolograms getLeaderboardHolograms() {
        return Main.instance.leaderboardHolograms;
    }

    public static TabManager getTabManager() {
        return Main.instance.tabManager;
    }

    public void onEnable() {
        instance = this;
        this.version = this.getDescription().getVersion();
        boolean snapshot = this.version.toLowerCase().contains("pre") || this.version.toLowerCase().contains("snapshot");
        this.isSpigot = ClassStorage.IS_SPIGOT_SERVER;
        this.isPaper = ClassStorage.IS_PAPER_SERVER;
        this.colorChanger = new ColorChanger();
        this.isVault = !this.getServer().getPluginManager().isPluginEnabled("Vault") ? false : this.setupEconomy();
        String[] bukkitVersion = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        this.versionNumber = 0;
        for (int i = 0; i < 2; ++i) {
            this.versionNumber += Integer.parseInt(bukkitVersion[i]) * (i == 0 ? 100 : 1);
        }
        this.isLegacy = this.versionNumber < 113;
        this.configurator = new Configurator(this);
        this.configurator.createFiles();
        Debug.init(this.getName());
        Debug.setDebug(this.configurator.config.getBoolean("debug"));
        I18n.load((Plugin)this, this.configurator.config.getString("locale"));
        this.databaseManager = new DatabaseManager(this.configurator.config.getString("database.host"), this.configurator.config.getInt("database.port"), this.configurator.config.getString("database.user"), this.configurator.config.getString("database.password"), this.configurator.config.getString("database.db"), this.configurator.config.getString("database.table-prefix", "bw_"), this.configurator.config.getConfigurationSection("database.params"), this.configurator.config.getString("database.type", "mysql"), this.configurator.config.getString("database.driver", "default"));
        if (Main.isPlayerStatisticsEnabled()) {
            this.playerStatisticsManager = new PlayerStatisticManager();
            this.playerStatisticsManager.initialize();
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new BedwarsExpansion().register();
            }
        }
        catch (Throwable i) {
            // empty catch block
        }
        try {
            if (this.configurator.config.getBoolean("holograms.enabled")) {
                this.hologramInteraction = new StatisticsHolograms();
                this.hologramInteraction.loadHolograms();
                this.leaderboardHolograms = new LeaderboardHolograms();
                this.leaderboardHolograms.loadHolograms();
            }
        }
        catch (Throwable exception) {
            this.getLogger().severe("Failed to load holograms");
            exception.printStackTrace();
        }
        this.commands = new HashMap();
        new AddholoCommand();
        new AdminCommand();
        new AutojoinCommand();
        new AllJoinCommand();
        new HelpCommand();
        new JoinCommand();
        new LeaveCommand();
        new ListCommand();
        new RejoinCommand();
        new ReloadCommand();
        new RemoveholoCommand();
        new StatsCommand();
        new MainlobbyCommand();
        new LeaderboardCommand();
        new DumpCommand();
        new CheatCommand("cheat", false);
        new CheatCommand("cheatIn", true);
        BwCommandsExecutor cmd = new BwCommandsExecutor();
        this.getCommand("bw").setExecutor((CommandExecutor)cmd);
        this.getCommand("bw").setTabCompleter((TabCompleter)cmd);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        if (this.versionNumber >= 109) {
            this.getServer().getPluginManager().registerEvents((Listener)new Player19Listener(), (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new Player18Listener(), (Plugin)this);
        }
        if (this.versionNumber >= 112) {
            this.getServer().getPluginManager().registerEvents((Listener)new Player112Listener(), (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerBefore112Listener(), (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new VillagerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)this);
        if (!Main.isLegacy()) {
            this.getServer().getPluginManager().registerEvents((Listener)new World113Listener(), (Plugin)this);
        }
        if (Main.getConfigurator().config.getBoolean("bungee.enabled") && Main.getConfigurator().config.getBoolean("bungee.motd.enabled")) {
            this.getServer().getPluginManager().registerEvents((Listener)new BungeeMotdListener(), (Plugin)this);
        }
        InventoryListener.init((Plugin)this);
        this.manager = new HologramManager((Plugin)this);
        SpecialRegister.onEnable((Plugin)this);
        this.getServer().getServicesManager().register(BedwarsAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        for (String spawnerN : this.configurator.config.getConfigurationSection("resources").getKeys(false)) {
            MaterialSearchEngine.Result result;
            String name = Main.getConfigurator().config.getString("resources." + spawnerN + ".name");
            String translate = Main.getConfigurator().config.getString("resources." + spawnerN + ".translate");
            int interval = Main.getConfigurator().config.getInt("resources." + spawnerN + ".interval", 1);
            double spread = Main.getConfigurator().config.getDouble("resources." + spawnerN + ".spread");
            int damage = Main.getConfigurator().config.getInt("resources." + spawnerN + ".damage");
            String materialName = Main.getConfigurator().config.getString("resources." + spawnerN + ".material", "AIR");
            String colorName = Main.getConfigurator().config.getString("resources." + spawnerN + ".color", "WHITE");
            if (damage != 0) {
                materialName = materialName + ":" + damage;
            }
            if ((result = MaterialSearchEngine.find(materialName)).getMaterial() == Material.AIR) continue;
            ChatColor color = ChatColor.valueOf((String)colorName);
            this.spawnerTypes.put(spawnerN.toLowerCase(), new ItemSpawnerType(spawnerN.toLowerCase(), name, translate, spread, result.getMaterial(), color, interval, result.getDamage()));
        }
        this.menu = new ShopInventory();
        if (Main.getConfigurator().config.getBoolean("bungee.enabled")) {
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        }
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "============" + ChatColor.RED + "===" + ChatColor.WHITE + "======  by ScreamingSandals <Misat11, Iamceph, Pronze, ZlataOvce>");
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "+ Screaming " + ChatColor.RED + "Bed" + ChatColor.WHITE + "Wars +  " + ChatColor.GOLD + "Version: " + this.version);
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "============" + ChatColor.RED + "===" + ChatColor.WHITE + "======  " + (snapshot ? ChatColor.RED + "SNAPSHOT VERSION (" + "branch-0.2.x/263" + ") - Use at your own risk" : ChatColor.GREEN + "STABLE VERSION"));
        if (this.isVault) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[B" + ChatColor.WHITE + "W] " + ChatColor.GOLD + "Found Vault");
        }
        if (!this.isSpigot) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[B" + ChatColor.WHITE + "W] " + ChatColor.RED + "WARNING: You are not using Spigot. Some features may not work properly.");
        }
        if (this.versionNumber < 108) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[B" + ChatColor.WHITE + "W] " + ChatColor.RED + "IMPORTANT WARNING: You are using version older than 1.8! This version is not officially supported, and some features may not work at all! Future versions of BedWars won't even start!");
        } else if (this.versionNumber == 108) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[B" + ChatColor.WHITE + "W] " + ChatColor.YELLOW + "You are using version 1.8! While this version is supported, it is a very old version and some features may not work as expected. Consider upgrading your server.");
        }
        try {
            float javaVer = Float.parseFloat(System.getProperty("java.class.version"));
            if (javaVer < 55.0f) {
                this.getLogger().warning("Bedwars 0.3.0 will require at least Java 11. Your server is not prepared for it. Update your Java or contact your hosting. ");
                this.getLogger().warning("https://docs.papermc.io/misc/java-install");
            }
        }
        catch (Throwable javaVer) {
            // empty catch block
        }
        File arenasFolder = new File(this.getDataFolder(), "arenas");
        if (arenasFolder.exists()) {
            try (Stream<Path> stream = Files.walk(Paths.get(arenasFolder.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
                List results = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
                if (results.isEmpty()) {
                    Debug.info("No arenas have been found!", true);
                } else {
                    for (String result : results) {
                        File file = new File(result);
                        if (!file.exists() || !file.isFile()) continue;
                        Game.loadGame(file);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BedWarsSignOwner signOwner = new BedWarsSignOwner();
        this.signManager = new SignManager(signOwner, this.configurator.signsFile);
        this.getServer().getPluginManager().registerEvents((Listener)new SignListener(signOwner, this.signManager), (Plugin)this);
        try {
            if (Bukkit.getPluginManager().isPluginEnabled("PerWorldInventory")) {
                Plugin pwi = Bukkit.getPluginManager().getPlugin("PerWorldInventory");
                if (pwi.getClass().getName().equals("me.ebonjaeger.perworldinventory.PerWorldInventory")) {
                    this.getServer().getPluginManager().registerEvents((Listener)new PerWorldInventoryKotlinListener(), (Plugin)this);
                } else {
                    this.getServer().getPluginManager().registerEvents((Listener)new PerWorldInventoryLegacyListener(), (Plugin)this);
                }
            }
        }
        catch (Throwable pwi) {
            // empty catch block
        }
        try {
            if (this.configurator.config.getBoolean("party.enabled") && Bukkit.getPluginManager().isPluginEnabled("Parties")) {
                new PartyCommand();
                this.getServer().getPluginManager().registerEvents((Listener)new PartyListener(), (Plugin)this);
            }
        }
        catch (Throwable pwi) {
            // empty catch block
        }
        this.tabManager = Main.getConfigurator().config.getBoolean("tab.enable") ? new TabManager() : null;
        if (Main.getConfigurator().config.getBoolean("update-checker.zero.console") || Main.getConfigurator().config.getBoolean("update-checker.zero.oped-players") || Main.getConfigurator().config.getBoolean("update-checker.one.console") || Main.getConfigurator().config.getBoolean("update-checker.one.oped-players")) {
            UpdateChecker.run();
        }
        int pluginId = 7147;
        this.metrics = new Metrics(this, 7147);
        this.metrics.addCustomChart(new SimplePie("edition", () -> "Free"));
        this.metrics.addCustomChart(new SimplePie("build_number", () -> "branch-0.2.x/263"));
        if (this.configurator.config.getBoolean("bungee.enabled") && this.configurator.config.getBoolean("bungee.random-game-selection.enabled") && this.configurator.config.getBoolean("bungee.random-game-selection.preselect-games")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                this.selectedGame = (Game)this.getRandomWaitingGameForBungeeMode();
                this.preSelectGames = true;
            }, 2L);
        }
        Bukkit.getConsoleSender().sendMessage("\u00a7fEverything is loaded! If you like our work, consider visiting our Patreon! <3");
        Bukkit.getConsoleSender().sendMessage("\u00a7fhttps://www.patreon.com/screamingsandals");
    }

    public void onDisable() {
        this.isDisabling = true;
        if (this.signManager != null) {
            this.signManager.save();
        }
        for (Game game : this.games.values()) {
            game.stop();
        }
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
        if (Main.isHologramsEnabled() && this.hologramInteraction != null) {
            this.hologramInteraction.unloadHolograms();
            this.leaderboardHolograms.unloadHolograms();
        }
        this.metrics = null;
        this.selectedGame = null;
        this.preSelectGames = false;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return true;
    }

    @Override
    public List<org.screamingsandals.bedwars.api.game.Game> getGames() {
        return new ArrayList<org.screamingsandals.bedwars.api.game.Game>(this.games.values());
    }

    @Override
    public org.screamingsandals.bedwars.api.game.Game getGameOfPlayer(Player player) {
        return Main.isPlayerInGame(player) ? Main.getPlayerGameProfile(player).getGame() : null;
    }

    @Override
    public boolean isGameWithNameExists(String name) {
        return this.games.containsKey(name);
    }

    @Override
    public org.screamingsandals.bedwars.api.game.Game getGameByName(String name) {
        return this.games.get(name);
    }

    private TreeMap<Integer, org.screamingsandals.bedwars.api.game.Game> filterGames0() {
        TreeMap<Integer, org.screamingsandals.bedwars.api.game.Game> gameList = new TreeMap<Integer, org.screamingsandals.bedwars.api.game.Game>();
        for (org.screamingsandals.bedwars.api.game.Game game : this.getGames()) {
            if (game.getStatus() != GameStatus.WAITING || game.getConnectedPlayers().size() >= game.getMaxPlayers()) continue;
            gameList.put(game.countConnectedPlayers(), game);
        }
        return gameList;
    }

    @Override
    public org.screamingsandals.bedwars.api.game.Game getGameWithHighestPlayers() {
        Map.Entry<Integer, org.screamingsandals.bedwars.api.game.Game> entry = this.filterGames0().lastEntry();
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public org.screamingsandals.bedwars.api.game.Game getGameWithLowestPlayers() {
        Map.Entry<Integer, org.screamingsandals.bedwars.api.game.Game> entry = this.filterGames0().firstEntry();
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public List<org.screamingsandals.bedwars.api.game.ItemSpawnerType> getItemSpawnerTypes() {
        return new ArrayList<org.screamingsandals.bedwars.api.game.ItemSpawnerType>(this.spawnerTypes.values());
    }

    @Override
    public org.screamingsandals.bedwars.api.game.ItemSpawnerType getItemSpawnerTypeByName(String name) {
        return this.spawnerTypes.get(name);
    }

    @Override
    public boolean isItemSpawnerTypeRegistered(String name) {
        return this.spawnerTypes.containsKey(name);
    }

    @Override
    public boolean isEntityInGame(Entity entity) {
        return this.entitiesInGame.containsKey(entity);
    }

    @Override
    public org.screamingsandals.bedwars.api.game.Game getGameOfEntity(Entity entity) {
        return this.entitiesInGame.get(entity);
    }

    @Override
    public void registerEntityToGame(Entity entity, org.screamingsandals.bedwars.api.game.Game game) {
        if (!(game instanceof Game)) {
            return;
        }
        this.entitiesInGame.put(entity, (Game)game);
    }

    @Override
    public void unregisterEntityFromGame(Entity entity) {
        if (this.entitiesInGame.containsKey(entity)) {
            this.entitiesInGame.remove(entity);
        }
    }

    @Override
    public boolean isPlayerPlayingAnyGame(Player player) {
        return Main.isPlayerInGame(player);
    }

    @Override
    public String getPluginVersion() {
        return this.version;
    }

    @Override
    public org.screamingsandals.bedwars.api.utils.ColorChanger getColorChanger() {
        return this.colorChanger;
    }

    public static ItemStack applyColor(org.screamingsandals.bedwars.game.TeamColor color, ItemStack itemStack) {
        return Main.applyColor(color, itemStack, false);
    }

    public static ItemStack applyColor(org.screamingsandals.bedwars.game.TeamColor color, ItemStack itemStack, boolean clone) {
        TeamColor teamColor = color.toApiColor();
        if (clone) {
            itemStack = itemStack.clone();
        }
        return instance.getColorChanger().applyColor(teamColor, itemStack);
    }

    public static ItemStack applyColor(TeamColor teamColor, ItemStack itemStack) {
        return instance.getColorChanger().applyColor(teamColor, itemStack);
    }

    @Override
    public org.screamingsandals.bedwars.api.game.Game getFirstWaitingGame() {
        TreeMap availableGames = new TreeMap();
        this.games.values().forEach(game -> {
            if (game.getStatus() != GameStatus.WAITING) {
                return;
            }
            availableGames.put(game.getConnectedPlayers().size(), game);
        });
        if (availableGames.isEmpty()) {
            return null;
        }
        return (org.screamingsandals.bedwars.api.game.Game)availableGames.lastEntry().getValue();
    }

    public org.screamingsandals.bedwars.api.game.Game getRandomWaitingGameForBungeeMode() {
        TreeMap availableGames = new TreeMap();
        this.games.values().forEach(game -> {
            if (game.getStatus() != GameStatus.WAITING) {
                return;
            }
            if (game.getConnectedPlayers().size() >= game.getMaxPlayers()) {
                return;
            }
            availableGames.computeIfAbsent(game.getConnectedPlayers().size(), ArrayList::new).add(game);
        });
        if (availableGames.isEmpty()) {
            return null;
        }
        List gamesWithMaximumPlayers = (List)availableGames.lastEntry().getValue();
        return (org.screamingsandals.bedwars.api.game.Game)gamesWithMaximumPlayers.get(MiscUtils.randInt(0, gamesWithMaximumPlayers.size() - 1));
    }

    @Override
    public org.screamingsandals.bedwars.api.game.Game getFirstRunningGame() {
        TreeMap availableGames = new TreeMap();
        this.games.values().forEach(game -> {
            if (game.getStatus() != GameStatus.RUNNING && game.getStatus() != GameStatus.GAME_END_CELEBRATING) {
                return;
            }
            availableGames.put(game.getConnectedPlayers().size(), game);
        });
        if (availableGames.isEmpty()) {
            return null;
        }
        return (org.screamingsandals.bedwars.api.game.Game)availableGames.lastEntry().getValue();
    }

    @Override
    public String getHubServerName() {
        return this.configurator.config.getString("bungee.server");
    }

    @Override
    public PlayerStatisticsManager getStatisticsManager() {
        return Main.isPlayerStatisticsEnabled() ? this.playerStatisticsManager : null;
    }

    @Override
    public void openCustomStore(Player player, @Nullable String fileName, boolean useParent) {
        if (fileName == null) {
            Main.instance.menu.show(player, null);
        } else {
            Main.instance.menu.show(player, new org.screamingsandals.bedwars.game.GameStore(null, fileName, useParent, null, false, false));
        }
    }

    @Override
    public @Nullable BedwarsOpenShopEvent.Result tryOpenStore(Player player, GameStore gameStore) {
        if (!(gameStore instanceof org.screamingsandals.bedwars.game.GameStore) || !Main.isPlayerInGame(player)) {
            return null;
        }
        Game game = Main.getPlayerGameProfile(player).getGame();
        if (game == null) {
            return null;
        }
        BedwarsOpenShopEvent openShopEvent = new BedwarsOpenShopEvent(game, player, gameStore, null);
        if (Main.getConfigurator().config.getBoolean("disable-opening-stores-of-other-teams") && gameStore.getTeam() != null && gameStore.getTeam() != ((CurrentTeam)game.getTeamOfPlayer((Player)player)).teamInfo) {
            openShopEvent.setResult(BedwarsOpenShopEvent.Result.DISALLOW_WRONG_TEAM);
        }
        Main.getInstance().getServer().getPluginManager().callEvent((Event)openShopEvent);
        if (openShopEvent.getResult() != BedwarsOpenShopEvent.Result.ALLOW) {
            return openShopEvent.getResult();
        }
        Main.instance.menu.show(player, (org.screamingsandals.bedwars.game.GameStore)gameStore);
        return BedwarsOpenShopEvent.Result.ALLOW;
    }

    @Override
    public @Nullable BedwarsOpenShopEvent.Result tryOpenCustomStore(Player player, String fileName, boolean useParent) {
        return this.tryOpenStore(player, new org.screamingsandals.bedwars.game.GameStore(null, fileName, useParent, null, false, false));
    }

    public static boolean isDisabling() {
        return Main.instance.isDisabling;
    }

    public void se(boolean bool) {
        this.setEnabled(bool);
    }

    public boolean isPreSelectGames() {
        return this.preSelectGames;
    }

    public Game getSelectedGame() {
        return this.selectedGame;
    }

    public void reselectGame() {
        if (this.preSelectGames) {
            this.selectedGame = (Game)this.getRandomWaitingGameForBungeeMode();
        }
    }

    static {
        autoColoredMaterials = new ArrayList<String>();
        autoColoredMaterials.add("WOOL");
        autoColoredMaterials.add("CARPET");
        autoColoredMaterials.add("CONCRETE");
        autoColoredMaterials.add("CONCRETE_POWDER");
        autoColoredMaterials.add("STAINED_CLAY");
        autoColoredMaterials.add("TERRACOTTA");
        autoColoredMaterials.add("STAINED_GLASS");
        autoColoredMaterials.add("STAINED_GLASS_PANE");
        StackParser.tagParser = TagApplier::applyTag;
        VersionFallback.applyFallbackIfNeeded();
    }
}

