/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.api;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.api.BedwarsAPI;

public class APIUtils {
    public static final String BEDWARS_NAMESPACED_KEY = "screaming-bedwars-hidden-api";

    public static void hashIntoInvisibleString(ItemStack stack, String hash) {
        ItemMeta meta = stack.getItemMeta();
        try {
            NamespacedKey key = new NamespacedKey((Plugin)BedwarsAPI.getInstance(), BEDWARS_NAMESPACED_KEY);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            ArrayList<String> propertyLines = new ArrayList<String>();
            if (container.has(key, PersistentDataType.STRING)) {
                String oldString = (String)container.get(key, PersistentDataType.STRING);
                propertyLines.addAll((List)new Gson().fromJson(oldString, List.class));
            }
            propertyLines.add(hash);
            container.set(key, PersistentDataType.STRING, (Object)new Gson().toJson(propertyLines));
        }
        catch (Throwable ignored) {
            List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            lore.add(APIUtils.convertToInvisibleString(hash));
            meta.setLore(lore);
        }
        stack.setItemMeta(meta);
    }

    public static String unhashFromInvisibleStringStartsWith(ItemStack stack, String startsWith) {
        ItemMeta meta = stack.getItemMeta();
        try {
            NamespacedKey key = new NamespacedKey((Plugin)BedwarsAPI.getInstance(), BEDWARS_NAMESPACED_KEY);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (container.has(key, PersistentDataType.STRING)) {
                String oldString = (String)container.get(key, PersistentDataType.STRING);
                List propertyLines = (List)new Gson().fromJson(oldString, List.class);
                for (String unhidden : propertyLines) {
                    if (!unhidden.startsWith(startsWith)) continue;
                    return unhidden;
                }
            }
        }
        catch (Throwable ignored) {
            try {
                if (meta.hasLore()) {
                    List lore = meta.getLore();
                    for (String s : lore) {
                        String unhidden = APIUtils.returnFromInvisibleString(s);
                        if (!unhidden.startsWith(startsWith)) continue;
                        return unhidden;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean unhashFromInvisibleString(ItemStack stack, String hash) {
        ItemMeta meta = stack.getItemMeta();
        try {
            NamespacedKey key = new NamespacedKey((Plugin)BedwarsAPI.getInstance(), BEDWARS_NAMESPACED_KEY);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (container.has(key, PersistentDataType.STRING)) {
                String oldString = (String)container.get(key, PersistentDataType.STRING);
                List propertyLines = (List)new Gson().fromJson(oldString, List.class);
                for (String unhidden : propertyLines) {
                    if (!unhidden.equals(hash)) continue;
                    return true;
                }
            }
        }
        catch (Throwable ignored) {
            try {
                if (meta.hasLore()) {
                    List lore = meta.getLore();
                    for (String s : lore) {
                        String unhidden = APIUtils.returnFromInvisibleString(s);
                        if (!unhidden.equals(hash)) continue;
                        return true;
                    }
                }
            }
            catch (NullPointerException ignored2) {
                return false;
            }
        }
        return false;
    }

    private static String convertToInvisibleString(String s) {
        StringBuilder hidden = new StringBuilder();
        for (char c : s.toCharArray()) {
            hidden.append("\u00a7").append(c);
        }
        return hidden.toString();
    }

    private static String returnFromInvisibleString(String s) {
        return s.replaceAll(String.valueOf('\u00a7'), "");
    }
}

