/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.api;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.api.events.BedwarsOpenShopEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStore;
import org.screamingsandals.bedwars.api.game.ItemSpawnerType;
import org.screamingsandals.bedwars.api.statistics.PlayerStatisticsManager;
import org.screamingsandals.bedwars.api.utils.ColorChanger;

public interface BedwarsAPI {
    public List<Game> getGames();

    public boolean isGameWithNameExists(String var1);

    public Game getGameByName(String var1);

    public Game getGameOfPlayer(Player var1);

    public Game getGameWithHighestPlayers();

    public Game getGameWithLowestPlayers();

    public boolean isPlayerPlayingAnyGame(Player var1);

    public List<ItemSpawnerType> getItemSpawnerTypes();

    public boolean isItemSpawnerTypeRegistered(String var1);

    public ItemSpawnerType getItemSpawnerTypeByName(String var1);

    public boolean isEntityInGame(Entity var1);

    public Game getGameOfEntity(Entity var1);

    public Game getFirstWaitingGame();

    public Game getFirstRunningGame();

    public void registerEntityToGame(Entity var1, Game var2);

    public void unregisterEntityFromGame(Entity var1);

    public String getPluginVersion();

    public ColorChanger getColorChanger();

    public String getHubServerName();

    public PlayerStatisticsManager getStatisticsManager();

    default public void openDefaultStore(Player player) {
        this.openCustomStore(player, null, false);
    }

    default public void openCustomStore(Player player, @Nullable String fileName) {
        this.openCustomStore(player, fileName, false);
    }

    public void openCustomStore(Player var1, @Nullable String var2, boolean var3);

    public @Nullable BedwarsOpenShopEvent.Result tryOpenStore(Player var1, GameStore var2);

    default public @Nullable BedwarsOpenShopEvent.Result tryOpenDefaultStore(Player player) {
        return this.tryOpenCustomStore(player, null, false);
    }

    default public @Nullable BedwarsOpenShopEvent.Result tryOpenCustomStore(Player player, String fileName) {
        return this.tryOpenCustomStore(player, fileName, false);
    }

    public @Nullable BedwarsOpenShopEvent.Result tryOpenCustomStore(Player var1, String var2, boolean var3);

    public static BedwarsAPI getInstance() {
        return (BedwarsAPI)Bukkit.getServicesManager().getRegistration(BedwarsAPI.class).getProvider();
    }
}

