/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.api.events;

import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;

public class BedwarsGameTickEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private Game game;
    private int previousCountdown;
    private GameStatus previousStatus;
    private int countdown;
    private GameStatus status;
    private int originalNextCountdown;
    private GameStatus originalNextStatus;
    private int nextCountdown;
    private GameStatus nextStatus;

    public BedwarsGameTickEvent(Game game, int previousCountdown, GameStatus previousStatus, int countdown, GameStatus status, int nextCountdown, GameStatus nextStatus) {
        this.game = game;
        this.previousCountdown = previousCountdown;
        this.previousStatus = previousStatus;
        this.countdown = countdown;
        this.status = status;
        this.nextCountdown = this.originalNextCountdown = nextCountdown;
        this.nextStatus = this.originalNextStatus = nextStatus;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public Game getGame() {
        return this.game;
    }

    public int getCountdown() {
        return this.countdown;
    }

    public GameStatus getStatus() {
        return this.status;
    }

    public int getNextCountdown() {
        return this.nextCountdown;
    }

    public void setNextCountdown(int nextCountdown) {
        this.nextCountdown = nextCountdown;
    }

    public GameStatus getNextStatus() {
        return this.nextStatus;
    }

    public void setNextStatus(GameStatus nextStatus) {
        this.nextStatus = nextStatus;
    }

    public int getPreviousCountdown() {
        return this.previousCountdown;
    }

    public GameStatus getPreviousStatus() {
        return this.previousStatus;
    }

    public void preventContinuation(boolean prevent) {
        if (prevent) {
            this.nextCountdown = this.countdown;
            this.nextStatus = this.status;
        } else {
            this.nextCountdown = this.originalNextCountdown;
            this.nextStatus = this.originalNextStatus;
        }
    }

    public boolean isNextCountdownChanged() {
        return this.nextCountdown != this.originalNextCountdown;
    }

    public boolean isNextStatusChanged() {
        return this.nextStatus != this.originalNextStatus;
    }

    public boolean isNextTickChanged() {
        return this.isNextCountdownChanged() || this.isNextStatusChanged();
    }
}

