/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.api.events;

import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.upgrades.Upgrade;
import org.screamingsandals.bedwars.api.upgrades.UpgradeStorage;

public class BedwarsUpgradeImprovedEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private Game game;
    private UpgradeStorage storage;
    private Upgrade upgrade;
    private double oldLevel;
    private double newLevel;

    public BedwarsUpgradeImprovedEvent(Game game, UpgradeStorage storage, Upgrade upgrade, double oldLevel, double newLevel) {
        this.game = game;
        this.storage = storage;
        this.upgrade = upgrade;
        this.oldLevel = oldLevel;
        this.newLevel = newLevel;
        upgrade.setLevel(newLevel);
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Game getGame() {
        return this.game;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.upgrade.getLevel() == this.oldLevel;
    }

    public void setCancelled(boolean cancel) {
        this.upgrade.setLevel(cancel ? this.oldLevel : this.newLevel);
    }

    public Upgrade getUpgrade() {
        return this.upgrade;
    }

    public UpgradeStorage getStorage() {
        return this.storage;
    }

    public double getNewLevel() {
        return this.upgrade.getLevel();
    }

    public double getOldLevel() {
        return this.oldLevel;
    }

    public double getOriginalNewLevel() {
        return this.newLevel;
    }

    public void setNewLevel(double newLevel) {
        this.upgrade.setLevel(newLevel);
    }
}

