/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.api.game;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.api.ArenaTime;
import org.screamingsandals.bedwars.api.InGameConfigBooleanConstants;
import org.screamingsandals.bedwars.api.Region;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.boss.StatusBar;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.api.game.GameStore;
import org.screamingsandals.bedwars.api.game.ItemSpawner;
import org.screamingsandals.bedwars.api.special.SpecialItem;
import org.screamingsandals.bedwars.api.utils.DelayFactory;

public interface Game {
    public String getName();

    public GameStatus getStatus();

    public void start();

    public void stop();

    default public boolean isActivated() {
        return this.getStatus() != GameStatus.DISABLED;
    }

    public void joinToGame(Player var1);

    public void leaveFromGame(Player var1);

    public void selectPlayerTeam(Player var1, Team var2);

    public void selectPlayerRandomTeam(Player var1);

    public World getGameWorld();

    public Location getPos1();

    public Location getPos2();

    public Location getSpectatorSpawn();

    public int getGameTime();

    public int getMinPlayers();

    public int getMaxPlayers();

    public int countConnectedPlayers();

    public List<Player> getConnectedPlayers();

    public List<GameStore> getGameStores();

    public int countGameStores();

    public Team getTeamFromName(String var1);

    public List<Team> getAvailableTeams();

    public int countAvailableTeams();

    public List<RunningTeam> getRunningTeams();

    public int countRunningTeams();

    public RunningTeam getTeamOfPlayer(Player var1);

    public boolean isPlayerInAnyTeam(Player var1);

    public boolean isPlayerInTeam(Player var1, RunningTeam var2);

    public boolean isLocationInArena(Location var1);

    public boolean isBlockAddedDuringGame(Location var1);

    public List<SpecialItem> getActivedSpecialItems();

    public List<SpecialItem> getActivedSpecialItems(Class<? extends SpecialItem> var1);

    public List<SpecialItem> getActivedSpecialItemsOfTeam(Team var1);

    public List<SpecialItem> getActivedSpecialItemsOfTeam(Team var1, Class<? extends SpecialItem> var2);

    public SpecialItem getFirstActivedSpecialItemOfTeam(Team var1);

    public SpecialItem getFirstActivedSpecialItemOfTeam(Team var1, Class<? extends SpecialItem> var2);

    public List<SpecialItem> getActivedSpecialItemsOfPlayer(Player var1);

    public List<SpecialItem> getActivedSpecialItemsOfPlayer(Player var1, Class<? extends SpecialItem> var2);

    public SpecialItem getFirstActivedSpecialItemOfPlayer(Player var1);

    public SpecialItem getFirstActivedSpecialItemOfPlayer(Player var1, Class<? extends SpecialItem> var2);

    public List<DelayFactory> getActiveDelays();

    public List<DelayFactory> getActiveDelaysOfPlayer(Player var1);

    public DelayFactory getActiveDelay(Player var1, Class<? extends SpecialItem> var2);

    public void registerDelay(DelayFactory var1);

    public void unregisterDelay(DelayFactory var1);

    public boolean isDelayActive(Player var1, Class<? extends SpecialItem> var2);

    public void registerSpecialItem(SpecialItem var1);

    public void unregisterSpecialItem(SpecialItem var1);

    public boolean isRegisteredSpecialItem(SpecialItem var1);

    public List<ItemSpawner> getItemSpawners();

    public Region getRegion();

    public StatusBar getStatusBar();

    public World getLobbyWorld();

    public Location getLobbySpawn();

    public int getLobbyCountdown();

    public int countTeamChests();

    public int countTeamChests(RunningTeam var1);

    public RunningTeam getTeamOfChest(Location var1);

    public RunningTeam getTeamOfChest(Block var1);

    public boolean isEntityShop(Entity var1);

    public InGameConfigBooleanConstants getCompassEnabled();

    public boolean getOriginalOrInheritedCompassEnabled();

    public InGameConfigBooleanConstants getJoinRandomTeamAfterLobby();

    public boolean getOriginalOrInheritedJoinRandomTeamAfterLobby();

    public InGameConfigBooleanConstants getJoinRandomTeamOnJoin();

    public boolean getOriginalOrInheritedJoinRandomTeamOnJoin();

    public InGameConfigBooleanConstants getAddWoolToInventoryOnJoin();

    public boolean getOriginalOrInheritedAddWoolToInventoryOnJoin();

    public InGameConfigBooleanConstants getPreventKillingVillagers();

    public boolean getOriginalOrInheritedPreventKillingVillagers();

    public InGameConfigBooleanConstants getPlayerDrops();

    public boolean getOriginalOrInheritedPlayerDrops();

    public InGameConfigBooleanConstants getFriendlyfire();

    public boolean getOriginalOrInheritedFriendlyfire();

    public InGameConfigBooleanConstants getColoredLeatherByTeamInLobby();

    public boolean getOriginalOrInheritedColoredLeatherByTeamInLobby();

    public InGameConfigBooleanConstants getKeepInventory();

    public boolean getOriginalOrInheritedKeepInventory();

    public InGameConfigBooleanConstants getCrafting();

    public boolean getOriginalOrInheritedCrafting();

    public InGameConfigBooleanConstants getLobbyBossbar();

    public boolean getOriginalOrInheritedLobbyBossbar();

    public InGameConfigBooleanConstants getGameBossbar();

    public boolean getOriginalOrInheritedGameBossbar();

    public InGameConfigBooleanConstants getScoreboard();

    public boolean getOriginalOrInheritedScoreaboard();

    public InGameConfigBooleanConstants getLobbyScoreboard();

    public boolean getOriginalOrInheritedLobbyScoreaboard();

    public InGameConfigBooleanConstants getPreventSpawningMobs();

    public boolean getOriginalOrInheritedPreventSpawningMobs();

    public InGameConfigBooleanConstants getSpawnerHolograms();

    public boolean getOriginalOrInheritedSpawnerHolograms();

    public InGameConfigBooleanConstants getSpawnerDisableMerge();

    public boolean getOriginalOrInheritedSpawnerDisableMerge();

    public InGameConfigBooleanConstants getGameStartItems();

    public boolean getOriginalOrInheritedGameStartItems();

    public InGameConfigBooleanConstants getPlayerRespawnItems();

    public boolean getOriginalOrInheritedPlayerRespawnItems();

    public InGameConfigBooleanConstants getSpawnerHologramsCountdown();

    public boolean getOriginalOrInheritedSpawnerHologramsCountdown();

    public InGameConfigBooleanConstants getDamageWhenPlayerIsNotInArena();

    public boolean getOriginalOrInheritedDamageWhenPlayerIsNotInArena();

    public InGameConfigBooleanConstants getRemoveUnusedTargetBlocks();

    public boolean getOriginalOrInheritedRemoveUnusedTargetBlocks();

    public InGameConfigBooleanConstants getAllowBlockFalling();

    public boolean getOriginalOrInheritedAllowBlockFalling();

    public InGameConfigBooleanConstants getHoloAboveBed();

    public boolean getOriginalOrInheritedHoloAboveBed();

    public InGameConfigBooleanConstants getSpectatorJoin();

    public boolean getOriginalOrInheritedSpectatorJoin();

    public InGameConfigBooleanConstants getStopTeamSpawnersOnDie();

    public boolean getOriginalOrInheritedStopTeamSpawnersOnDie();

    public boolean getBungeeEnabled();

    public ArenaTime getArenaTime();

    public WeatherType getArenaWeather();

    public BarColor getLobbyBossBarColor();

    public BarColor getGameBossBarColor();

    public boolean isProtectionActive(Player var1);

    public InGameConfigBooleanConstants getAnchorAutoFill();

    public boolean getOriginalOrInheritedAnchorAutoFill();

    public InGameConfigBooleanConstants getAnchorDecreasing();

    public boolean getOriginalOrInheritedAnchorDecreasing();

    public InGameConfigBooleanConstants getCakeTargetBlockEating();

    public boolean getOriginalOrInheritedCakeTargetBlockEating();

    public InGameConfigBooleanConstants getTargetBlockExplosions();

    public boolean getOriginalOrInheritedTargetBlockExplosions();

    public int getPostGameWaiting();

    default public boolean hasCustomPrefix() {
        return this.getCustomPrefix() != null;
    }

    public String getCustomPrefix();

    public boolean isSpectator(@NotNull Player var1);
}

