/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.api.upgrades;

import java.util.HashMap;
import java.util.Map;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.ItemSpawner;
import org.screamingsandals.bedwars.api.upgrades.Upgrade;
import org.screamingsandals.bedwars.api.upgrades.UpgradeStorage;

public final class UpgradeRegistry {
    private static final Map<String, UpgradeStorage> registeredUpgrades = new HashMap<String, UpgradeStorage>();

    public static UpgradeStorage registerUpgrade(String name, Class<? extends Upgrade> upgradeClass) {
        UpgradeStorage storage = new UpgradeStorage(name, upgradeClass);
        registeredUpgrades.put(name, storage);
        return storage;
    }

    public static void unregisterUpgrade(String name) {
        registeredUpgrades.remove(name);
    }

    public static boolean isUpgradeRegistered(String name) {
        return registeredUpgrades.containsKey(name);
    }

    public static UpgradeStorage getUpgrade(String name) {
        return registeredUpgrades.get(name);
    }

    public static void clearAll(Game game) {
        for (UpgradeStorage storage : registeredUpgrades.values()) {
            storage.resetUpgradesForGame(game);
        }
    }

    static {
        UpgradeRegistry.registerUpgrade("spawner", ItemSpawner.class);
    }
}

