/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.api.upgrades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.events.BedwarsUpgradeRegisteredEvent;
import org.screamingsandals.bedwars.api.events.BedwarsUpgradeUnregisteredEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.ItemSpawner;
import org.screamingsandals.bedwars.api.game.ItemSpawnerType;
import org.screamingsandals.bedwars.api.upgrades.Upgrade;

public final class UpgradeStorage {
    private final String upgradeName;
    private final Class<? extends Upgrade> upgradeClass;
    private final Map<Game, List<Upgrade>> upgradeRegistry = new HashMap<Game, List<Upgrade>>();

    UpgradeStorage(String upgradeName, Class<? extends Upgrade> upgradeClass) {
        this.upgradeName = upgradeName;
        this.upgradeClass = upgradeClass;
    }

    public String getUpgradeName() {
        return this.upgradeName;
    }

    public Class<? extends Upgrade> getUpgradeClass() {
        return this.upgradeClass;
    }

    public void addUpgrade(Game game, Upgrade upgrade) {
        if (!this.upgradeClass.isInstance(upgrade)) {
            return;
        }
        if (!this.upgradeRegistry.containsKey(game)) {
            this.upgradeRegistry.put(game, new ArrayList());
        }
        if (!this.upgradeRegistry.get(game).contains(upgrade)) {
            upgrade.onUpgradeRegistered(game);
            Bukkit.getPluginManager().callEvent((Event)new BedwarsUpgradeRegisteredEvent(game, this, upgrade));
            this.upgradeRegistry.get(game).add(upgrade);
        }
    }

    public void removeUpgrade(Game game, Upgrade upgrade) {
        if (!this.upgradeClass.isInstance(upgrade)) {
            return;
        }
        if (this.upgradeRegistry.containsKey(game) && this.upgradeRegistry.get(game).contains(upgrade)) {
            upgrade.onUpgradeUnregistered(game);
            Bukkit.getPluginManager().callEvent((Event)new BedwarsUpgradeUnregisteredEvent(game, this, upgrade));
            this.upgradeRegistry.get(game).remove(upgrade);
        }
    }

    public boolean isUpgradeRegistered(Game game, Upgrade upgrade) {
        if (!this.upgradeClass.isInstance(upgrade)) {
            return false;
        }
        return this.upgradeRegistry.containsKey(game) && this.upgradeRegistry.get(game).contains(upgrade);
    }

    public void resetUpgradesForGame(Game game) {
        if (this.upgradeRegistry.containsKey(game)) {
            for (Upgrade upgrade : this.upgradeRegistry.get(game)) {
                upgrade.onUpgradeUnregistered(game);
                Bukkit.getPluginManager().callEvent((Event)new BedwarsUpgradeUnregisteredEvent(game, this, upgrade));
            }
            this.upgradeRegistry.get(game).clear();
            this.upgradeRegistry.remove(game);
        }
    }

    public List<Upgrade> getAllUpgradesOfGame(Game game) {
        ArrayList<Upgrade> upgrade = new ArrayList<Upgrade>();
        if (this.upgradeRegistry.containsKey(game)) {
            upgrade.addAll((Collection<Upgrade>)this.upgradeRegistry.get(game));
        }
        return upgrade;
    }

    @Deprecated
    public List<Upgrade> findUpgradeByName(Game game, String instanceName) {
        ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
        if (this.upgradeRegistry.containsKey(game)) {
            for (Upgrade upgrade : this.upgradeRegistry.get(game)) {
                if (!instanceName.equals(upgrade.getInstanceName())) continue;
                upgrades.add(upgrade);
            }
        }
        return upgrades;
    }

    public List<Upgrade> findItemSpawnerUpgrades(Game game, String spawnerInstanceName) {
        ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
        if (this.upgradeRegistry.containsKey(game)) {
            for (Upgrade upgrade : this.upgradeRegistry.get(game)) {
                ItemSpawner itemSpawner;
                if (!(upgrade instanceof ItemSpawner) || !spawnerInstanceName.equals((itemSpawner = (ItemSpawner)upgrade).getInstanceName())) continue;
                upgrades.add(itemSpawner);
            }
        }
        return upgrades;
    }

    public List<Upgrade> findItemSpawnerUpgrades(Game game, Team team) {
        ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
        if (this.upgradeRegistry.containsKey(game)) {
            for (Upgrade upgrade : this.upgradeRegistry.get(game)) {
                ItemSpawner itemSpawner;
                if (!(upgrade instanceof ItemSpawner) || (itemSpawner = (ItemSpawner)upgrade).getTeam() == null || !team.getName().equals(itemSpawner.getTeam().getName())) continue;
                upgrades.add(upgrade);
            }
        }
        return upgrades;
    }

    public List<Upgrade> findItemSpawnerUpgrades(Game game, Team team, ItemSpawnerType itemSpawnerType) {
        ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
        if (this.upgradeRegistry.containsKey(game)) {
            for (Upgrade upgrade : this.upgradeRegistry.get(game)) {
                ItemSpawner itemSpawner;
                if (!(upgrade instanceof ItemSpawner) || (itemSpawner = (ItemSpawner)upgrade).getTeam() == null || !team.getName().equals(itemSpawner.getTeam().getName()) || !itemSpawnerType.getName().equals(itemSpawner.getItemSpawnerType().getName())) continue;
                upgrades.add(upgrade);
            }
        }
        return upgrades;
    }
}

