/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.boss;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.legacy.bossbar.BossBar;
import com.viaversion.viaversion.api.legacy.bossbar.BossColor;
import com.viaversion.viaversion.api.legacy.bossbar.BossStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.lib.nms.entity.BossBarDragon;
import org.screamingsandals.bedwars.lib.nms.entity.BossBarWither;
import org.screamingsandals.bedwars.lib.nms.entity.FakeEntityNMS;

public class BossBar18
implements org.screamingsandals.bedwars.api.boss.BossBar18 {
    private double progress = 0.0;
    public final FakeEntityNMS<?> bossbarEntity;
    public final boolean viaActive;
    public BossBar viaBossBar;
    public boolean viaAfterJsonUpdate;

    public BossBar18(Location location) {
        String backend = Main.getConfigurator().config.getString("bossbar.backend-entity");
        this.bossbarEntity = "dragon".equalsIgnoreCase(backend) || "ender_dragon".equalsIgnoreCase(backend) || "ender".equalsIgnoreCase(backend) ? new BossBarDragon(location) : new BossBarWither(location);
        boolean viaActive = false;
        if (Main.getConfigurator().config.getBoolean("bossbar.allow-via-hooks") && Bukkit.getPluginManager().isPluginEnabled("ViaVersion")) {
            try {
                String version = Bukkit.getPluginManager().getPlugin("ViaVersion").getDescription().getVersion();
                this.viaAfterJsonUpdate = Integer.parseInt(version.split("\\.", 2)[0]) >= 5 && !version.equals("5.0.0") && !version.equals("5.0.1");
                this.viaBossBar = Via.getAPI().legacyAPI().createLegacyBossBar(this.viaAfterJsonUpdate ? "{text: \"\"}" : "", 1.0f, BossColor.PURPLE, BossStyle.SOLID);
                viaActive = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.viaActive = viaActive;
    }

    @Override
    public String getMessage() {
        return this.bossbarEntity.getCustomName();
    }

    @Override
    public void setMessage(String message) {
        this.bossbarEntity.setCustomName(message);
        if (this.viaActive) {
            this.viaBossBar.setTitle(this.viaAfterJsonUpdate ? "{text: \"" + message.replace("\"", "\\\"") + "\"}" : message);
        }
    }

    public void setViaColor(String color) {
        if (this.viaActive) {
            try {
                this.viaBossBar.setColor(BossColor.valueOf((String)color.toUpperCase()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setViaStyle(String style) {
        if (this.viaActive) {
            try {
                this.viaBossBar.setStyle(BossStyle.valueOf((String)style.toUpperCase()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void addPlayer(Player player) {
        if (this.viaActive && Via.getAPI().getPlayerVersion(player.getUniqueId()) >= 107) {
            this.viaBossBar.addPlayer(player.getUniqueId());
            return;
        }
        this.bossbarEntity.addViewer(player);
    }

    @Override
    public void removePlayer(Player player) {
        if (this.viaActive && this.viaBossBar.getPlayers().contains(player.getUniqueId())) {
            this.viaBossBar.removePlayer(player.getUniqueId());
            return;
        }
        this.bossbarEntity.removeViewer(player);
    }

    public boolean isViaPlayer(Player player) {
        if (this.viaActive) {
            return this.viaBossBar.getPlayers().contains(player.getUniqueId());
        }
        return false;
    }

    @Override
    public void setProgress(double progress) {
        this.progress = progress;
        if (Double.isNaN(progress) || progress < 0.0) {
            progress = 0.0;
        } else if (progress > 1.0) {
            progress = 1.0;
        }
        this.bossbarEntity.setHealth(progress);
        if (this.viaActive) {
            this.viaBossBar.setHealth((float)progress);
        }
    }

    @Override
    public List<Player> getViewers() {
        Set viaViewers;
        if (this.viaActive && !(viaViewers = this.viaBossBar.getPlayers()).isEmpty()) {
            ArrayList<Player> allViewers = new ArrayList<Player>(this.bossbarEntity.getViewers());
            for (UUID viewer : viaViewers) {
                Player player = Bukkit.getPlayer((UUID)viewer);
                if (player == null || allViewers.contains(player)) continue;
                allViewers.add(player);
            }
            return allViewers;
        }
        return this.bossbarEntity.getViewers();
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public boolean isVisible() {
        return this.bossbarEntity.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.bossbarEntity.setVisible(visible);
        if (this.viaActive) {
            if (visible && !this.viaBossBar.isVisible()) {
                this.viaBossBar.show();
            } else if (!visible && this.viaBossBar.isVisible()) {
                this.viaBossBar.hide();
            }
        }
    }
}

