/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.boss;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.lib.nms.entity.PlayerUtils;

public class XPBar
implements org.screamingsandals.bedwars.api.boss.XPBar {
    private boolean visible = false;
    private float progress = 0.0f;
    private int seconds = 0;
    private List<Player> players = new ArrayList<Player>();

    @Override
    public void addPlayer(Player player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            if (this.visible) {
                PlayerUtils.fakeExp(player, this.progress, this.seconds);
            }
        }
    }

    @Override
    public void removePlayer(Player player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            PlayerUtils.fakeExp(player, player.getExp(), player.getLevel());
        }
    }

    @Override
    public void setProgress(double progress) {
        if (Double.isNaN(progress) || progress < 0.0) {
            progress = 0.0;
        } else if (progress > 1.0) {
            progress = 1.0;
        }
        this.progress = (float)progress;
        if (this.visible) {
            for (Player player : this.players) {
                PlayerUtils.fakeExp(player, this.progress, this.seconds);
            }
        }
    }

    @Override
    public List<Player> getViewers() {
        return this.players;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            if (visible) {
                for (Player player : this.players) {
                    PlayerUtils.fakeExp(player, this.progress, this.seconds);
                }
            } else {
                for (Player player : this.players) {
                    PlayerUtils.fakeExp(player, player.getExp(), player.getLevel());
                }
            }
        }
        this.visible = visible;
    }

    @Override
    public void setSeconds(int seconds) {
        this.seconds = seconds;
        if (this.visible) {
            for (Player player : this.players) {
                PlayerUtils.fakeExp(player, this.progress, seconds);
            }
        }
    }

    @Override
    public int getSeconds() {
        return this.seconds;
    }
}

