/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I18n;

public class BwCommandsExecutor
implements CommandExecutor,
TabCompleter {
    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> completionList = new ArrayList<String>();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                for (BaseCommand c : Main.getCommands().values()) {
                    if (!c.hasPermission((CommandSender)player)) continue;
                    completionList.add(c.getName());
                }
            } else if (args.length > 1) {
                ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
                arguments.remove(0);
                BaseCommand bCommand = Main.getCommands().get(args[0]);
                if (bCommand != null && bCommand.hasPermission((CommandSender)player)) {
                    bCommand.completeTab(completionList, sender, arguments);
                }
            }
        }
        ArrayList<String> finalCompletionList = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)args[args.length - 1], completionList, finalCompletionList);
        return finalCompletionList;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            args = new String[]{"help"};
        }
        String command = args[0];
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.remove(0);
        BaseCommand bCommand = Main.getCommands().get(command.toLowerCase());
        if (bCommand == null) {
            sender.sendMessage(I18n.i18n("unknown_command"));
            return true;
        }
        if (sender instanceof ConsoleCommandSender && !bCommand.isConsoleCommand()) {
            sender.sendMessage("\u00a7cConsole can't use this command!");
            return true;
        }
        if (!bCommand.hasPermission(sender)) {
            sender.sendMessage(I18n.i18n("no_permissions"));
            return true;
        }
        boolean result = bCommand.execute(sender, arguments);
        if (!result) {
            sender.sendMessage(I18n.i18n("unknown_usage"));
        }
        return true;
    }
}

