/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.commands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.game.CurrentTeam;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.ItemSpawnerType;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.utils.FakeDeath;

public class CheatCommand
extends BaseCommand {
    public CheatCommand(String commandName, boolean allowConsole) {
        super(commandName, ADMIN_PERMISSION, allowConsole, false);
    }

    @Override
    public boolean execute(CommandSender sender, List<String> args) {
        block61: {
            block60: {
                Player defaultPlayer;
                Game game;
                int offset;
                if (!Main.getConfigurator().config.getBoolean("enable-cheat-command-for-admins")) {
                    sender.sendMessage(I18n.i18n("cheat_disabled"));
                    return true;
                }
                int n = offset = this.isConsoleCommand() ? 1 : 0;
                if (offset == 1) {
                    if (args.isEmpty()) {
                        sender.sendMessage(I18n.i18n("unknown_usage"));
                        return true;
                    }
                    game = Main.getGame(args.get(0));
                    if (game == null) {
                        sender.sendMessage(I18n.i18n("no_arena_found"));
                        return true;
                    }
                    defaultPlayer = null;
                } else {
                    Player player = (Player)sender;
                    if (!Main.isPlayerInGame(player)) {
                        sender.sendMessage(I18n.i18n("you_arent_in_game"));
                        return true;
                    }
                    game = Main.getPlayerGameProfile(player).getGame();
                    defaultPlayer = player;
                }
                if (args.size() < offset + 1) break block60;
                if (args.get(offset).equalsIgnoreCase("startemptygame") && offset != 1) {
                    if (game.getStatus() == GameStatus.WAITING) {
                        game.forceGameToStart = true;
                        sender.sendMessage(I18n.i18n("game_forced"));
                    } else {
                        sender.sendMessage(I18n.i18n("cheat_not_waiting"));
                    }
                    return true;
                }
                switch (args.get(offset).toLowerCase()) {
                    case "give": {
                        if (game.getStatus() != GameStatus.RUNNING) {
                            sender.sendMessage(I18n.i18n("cheat_game_not_running"));
                            return true;
                        }
                        if (args.size() < offset + 2) {
                            sender.sendMessage(I18n.i18n("unknown_usage"));
                            return true;
                        }
                        String resource = args.get(offset + 1);
                        ItemSpawnerType type = Main.getSpawnerType(resource);
                        if (type == null) {
                            sender.sendMessage(I18n.i18n("admin_command_invalid_spawner_type"));
                            return true;
                        }
                        int stack = offset + 1;
                        if (args.size() > offset + 2) {
                            try {
                                stack = Integer.parseInt(args.get(offset + 2));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        Player player1 = defaultPlayer;
                        if (args.size() > offset + 3) {
                            player1 = Bukkit.getPlayer((String)args.get(offset + 3));
                            if (player1 == null || !game.isPlayerInAnyTeam(player1)) {
                                sender.sendMessage(I18n.i18n("cheat_invalid_player"));
                                return true;
                            }
                        } else if (defaultPlayer == null) {
                            sender.sendMessage(I18n.i18n("unknown_usage"));
                            return true;
                        }
                        GamePlayer gamePlayer = Main.getPlayerGameProfile(player1);
                        if (gamePlayer.isSpectator) {
                            sender.sendMessage(I18n.i18n("cheat_invalid_player"));
                            return true;
                        }
                        HashMap map = player1.getInventory().addItem(new ItemStack[]{type.getStack(stack)});
                        Player finalPlayer = player1;
                        map.forEach((integer, itemStack) -> finalPlayer.getLocation().getWorld().dropItem(finalPlayer.getLocation(), itemStack));
                        sender.sendMessage(I18n.i18n("cheat_received_give").replace("%player%", player1.getName()).replace("%amount%", String.valueOf(stack)).replace("%resource%", type.getItemName()));
                        break;
                    }
                    case "kill": {
                        if (game.getStatus() != GameStatus.RUNNING) {
                            sender.sendMessage(I18n.i18n("cheat_game_not_running"));
                            return true;
                        }
                        Player player1 = defaultPlayer;
                        if (args.size() > offset + 1) {
                            player1 = Bukkit.getPlayer((String)args.get(offset + 1));
                            if (player1 == null || !game.isPlayerInAnyTeam(player1)) {
                                sender.sendMessage(I18n.i18n("cheat_invalid_player"));
                                return true;
                            }
                        } else if (defaultPlayer == null) {
                            sender.sendMessage(I18n.i18n("unknown_usage"));
                            return true;
                        }
                        GamePlayer gamePlayer = Main.getPlayerGameProfile(player1);
                        if (gamePlayer.isSpectator) {
                            sender.sendMessage(I18n.i18n("cheat_invalid_player"));
                            return true;
                        }
                        if (Main.getConfigurator().config.getBoolean("allow-fake-death")) {
                            FakeDeath.die(gamePlayer, null);
                        } else {
                            player1.setHealth(0.0);
                        }
                        sender.sendMessage(I18n.i18n("cheat_received_kill").replace("%player%", player1.getName()));
                        break;
                    }
                    case "destroybed": {
                        if (game.getStatus() != GameStatus.RUNNING) {
                            sender.sendMessage(I18n.i18n("cheat_game_not_running"));
                            return true;
                        }
                        if (args.size() < offset + 2) {
                            sender.sendMessage(I18n.i18n("unknown_usage"));
                            return true;
                        }
                        String name = args.get(offset + 1);
                        Team team1 = game.getTeamFromName(name);
                        if (team1 == null) {
                            sender.sendMessage(I18n.i18n("admin_command_team_is_not_exists"));
                            return true;
                        }
                        CurrentTeam currentTeam = game.getCurrentTeamFromTeam(team1);
                        if (currentTeam == null) {
                            sender.sendMessage(I18n.i18n("team_not_in_game").replace("%name%", name));
                            return true;
                        }
                        if (!currentTeam.isBed) {
                            sender.sendMessage(I18n.i18n("team_bed_is_already_destroyed").replace("%name%", name));
                            return true;
                        }
                        game.targetBlockExplode(currentTeam);
                        sender.sendMessage(I18n.i18n("cheat_received_target_block_destroy").replace("%name%", name));
                        break;
                    }
                    case "destroyallbeds": {
                        if (game.getStatus() != GameStatus.RUNNING) {
                            sender.sendMessage(I18n.i18n("cheat_game_not_running"));
                            return true;
                        }
                        for (RunningTeam team : game.getRunningTeams()) {
                            if (!team.isTargetBlockExists()) continue;
                            game.targetBlockExplode(team);
                        }
                        sender.sendMessage(I18n.i18n("cheat_received_target_blocks_destroy"));
                        break;
                    }
                    case "jointeam": {
                        if (defaultPlayer == null) {
                            sender.sendMessage(I18n.i18n("cheat_please_provide_valid_cheat_type"));
                            return true;
                        }
                        if (args.size() >= offset + 2) {
                            String name = args.get(offset + 1);
                            Team team1 = game.getTeamFromName(name);
                            if (team1 == null) {
                                sender.sendMessage(I18n.i18n("admin_command_team_is_not_exists"));
                                return true;
                            }
                            if (game.getStatus() == GameStatus.WAITING) {
                                game.selectPlayerTeam(defaultPlayer, team1, true, true, false);
                                break;
                            }
                            if (game.getCurrentTeamFromTeam(team1) == null) {
                                sender.sendMessage(I18n.i18n("team_not_in_game").replace("%name%", name));
                                return true;
                            }
                            game.selectPlayerTeam(defaultPlayer, team1, true, false, true);
                            GamePlayer gP = Main.getPlayerGameProfile(defaultPlayer);
                            CurrentTeam team = game.getPlayerTeam(gP);
                            if (team != null) {
                                if (gP.isSpectator) {
                                    game.makePlayerFromSpectator(gP);
                                    break;
                                }
                                gP.teleport(team.getTeamSpawn());
                                break;
                            }
                        } else {
                            GamePlayer gP = Main.getPlayerGameProfile(defaultPlayer);
                            if (game.getStatus() == GameStatus.WAITING) {
                                game.joinRandomTeam(gP, true, true, false);
                                break;
                            }
                            game.joinRandomTeam(gP, true, false, true);
                            CurrentTeam team = game.getPlayerTeam(gP);
                            if (team != null) {
                                if (gP.isSpectator) {
                                    game.makePlayerFromSpectator(gP);
                                    break;
                                }
                                gP.teleport(team.getTeamSpawn());
                                break;
                            }
                        }
                        break block61;
                    }
                    default: {
                        sender.sendMessage(I18n.i18n("cheat_please_provide_valid_cheat_type"));
                    }
                }
                break block61;
            }
            sender.sendMessage(I18n.i18n("cheat_please_provide_valid_cheat_type"));
        }
        return true;
    }

    @Override
    public void completeTab(List<String> completion, CommandSender sender, List<String> args) {
        int offset;
        if (!Main.getConfigurator().config.getBoolean("enable-cheat-command-for-admins")) {
            return;
        }
        int n = offset = this.isConsoleCommand() ? 1 : 0;
        if (args.size() == 1 && offset == 1) {
            completion.addAll(Main.getGameNames());
            return;
        }
        if (args.size() == offset + 1) {
            if (offset == 1) {
                completion.addAll(Arrays.asList("give", "kill", "destroybed", "destroyallbeds"));
            } else {
                completion.addAll(Arrays.asList("give", "kill", "startemptygame", "destroybed", "destroyallbeds", "jointeam"));
            }
            return;
        }
        Game game = offset == 1 ? Main.getGame(args.get(0)) : (Game)Main.getInstance().getGameOfPlayer((Player)sender);
        if (game != null) {
            if (args.size() > offset + 1 && args.get(offset).equals("give")) {
                if (args.size() == offset + 2) {
                    completion.addAll(Main.getAllSpawnerTypes());
                } else if (args.size() == offset + 3) {
                    completion.addAll(Arrays.asList("1", "2", "4", "8", "16", "32", "64"));
                } else if (args.size() == offset + 4) {
                    completion.addAll(game.getConnectedPlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
                }
            }
            if (args.size() > offset + 1 && args.get(offset).equals("kill") && args.size() == offset + 2) {
                completion.addAll(game.getConnectedPlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
            }
            if (args.size() > offset + 1 && (args.get(offset).equalsIgnoreCase("destroybed") || args.get(offset).equalsIgnoreCase("jointeam")) && args.size() == offset + 2) {
                completion.addAll(game.getRunningTeams().stream().map(Team::getName).collect(Collectors.toList()));
            }
        }
    }
}

