/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.GameStore;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.inventories.ShopInventory;
import org.screamingsandals.bedwars.lib.debug.Debug;
import org.screamingsandals.bedwars.lib.lang.I;

public class DumpCommand
extends BaseCommand {
    public DumpCommand() {
        super("dump", ADMIN_PERMISSION, true, false);
    }

    @Override
    public boolean execute(CommandSender sender, List<String> args) {
        String service = args.size() > 0 ? args.get(0).toLowerCase(Locale.ROOT) : "pastes.dev";
        new Thread(() -> {
            try {
                URL url;
                Gson gson = new GsonBuilder().registerTypeAdapter(Location.class, (location, type, context) -> context.serialize(DumpCommand.nullValuesAllowingMap("x", location.getX(), "y", location.getY(), "z", location.getZ(), "world", location.getWorld().getName(), "pitch", Float.valueOf(location.getPitch()), "yaw", Float.valueOf(location.getYaw())))).registerTypeAdapter(World.class, (world, type, context) -> context.serialize((Object)world.getName())).registerTypeAdapter(File.class, (file, type, context) -> context.serialize((Object)file.getAbsolutePath())).setPrettyPrinting().create();
                ArrayList<AFile> files = new ArrayList<AFile>();
                files.add(new AFile("dump.json", "json", gson.toJson(DumpCommand.nullValuesAllowingMap("bedwars", DumpCommand.nullValuesAllowingMap("version", Main.getVersion(), "build", "branch-0.2.x/263", "edition", "free"), "server", DumpCommand.nullValuesAllowingMap("impl", Bukkit.getName(), "version", Bukkit.getVersion(), "javaVersion", System.getProperty("java.version"), "os", System.getProperty("os.name")), "worlds", Bukkit.getWorlds().stream().map(world -> DumpCommand.nullValuesAllowingMap("name", world.getName(), "difficulty", world.getDifficulty(), "spawning", DumpCommand.nullValuesAllowingMap("animals", world.getAllowAnimals(), "monsters", world.getAllowMonsters()), "maxHeight", world.getMaxHeight(), "keepSpawnInMemory", world.getKeepSpawnInMemory())).collect(Collectors.toList()), "plugins", Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(plugin -> DumpCommand.nullValuesAllowingMap("enabled", plugin.isEnabled(), "name", plugin.getName(), "version", plugin.getDescription().getVersion(), "main", plugin.getDescription().getMain(), "authors", plugin.getDescription().getAuthors())).collect(Collectors.toList()), "gamesInMemory", Main.getGameNames().stream().map(Main::getGame).map(game -> DumpCommand.nullValuesAllowingMap("file", game.getFile().getParentFile().getName() + "/" + game.getFile().getName(), "name", game.getName(), "minPlayers", game.getMinPlayers(), "maxPlayers", game.getMaxPlayers(), "lobby", DumpCommand.nullValuesAllowingMap("spawn", game.getLobbySpawn(), "countdown", game.getLobbyCountdown(), "bossbar", game.getLobbyBossBarColor()), "arena", DumpCommand.nullValuesAllowingMap(new Object[]{"spectator", game.getSpectatorSpawn(), "countdown", game.getGameTime(), "pos1", game.getPos1(), "pos2", game.getPos2(), "bossbar", game.getGameBossBarColor(), "arenaTime", game.getArenaTime(), "weather", game.getArenaWeather(), "customPrefix", game.getCustomPrefix(), "spawners", game.getSpawners().stream().map(itemSpawner -> DumpCommand.nullValuesAllowingMap("type", itemSpawner.getItemSpawnerType().getConfigKey(), "location", itemSpawner.getLocation(), "maxSpawnedResources", itemSpawner.getMaxSpawnedResources(), "startLevel", itemSpawner.getStartLevel(), "name", itemSpawner.getCustomName(), "team", itemSpawner.getTeam() != null ? itemSpawner.getTeam().getName() : "no team", "hologramEnabled", itemSpawner.getHologramEnabled())).collect(Collectors.toList()), "teams", game.getTeams().stream().map(team -> DumpCommand.nullValuesAllowingMap(new Object[]{"name", team.getName(), "color", team.getColor(), "spawn", team.getTeamSpawn(), "targetBlock", team.getTargetBlock(), "maxPlayers", team.getMaxPlayers()})).collect(Collectors.toList()), "stores", game.getGameStores().stream().map(gameStore -> DumpCommand.nullValuesAllowingMap("entityType", gameStore.getEntityType(), "location", gameStore.getStoreLocation(), "shopFile", gameStore.getShopFile(), "customName", gameStore.getShopCustomName(), "useParent", gameStore.getUseParent(), "baby", gameStore.isBaby(), "skinName", gameStore.getSkinName())).collect(Collectors.toList()), "configurationContainer", DumpCommand.nullValuesAllowingMap(new Object[]{"compass-enabled", game.getCompassEnabled(), "join-randomly-after-lobby-timeout", game.getJoinRandomTeamAfterLobby(), "join-randomly-on-lobby-join", game.getJoinRandomTeamOnJoin(), "add-wool-to-inventory-on-join", game.getAddWoolToInventoryOnJoin(), "prevent-killing-villagers", game.getPreventKillingVillagers(), "player-drops", game.getPlayerDrops(), "friendlyfire", game.getFriendlyfire(), "in-lobby-colored-leather-by-team", game.getColoredLeatherByTeamInLobby(), "keep-inventory-on-death", game.getKeepInventory(), "allow-crafting", game.getCrafting(), "lobbybossbar", game.getLobbyBossbar(), "bossbar", game.getGameBossbar(), "scoreboard", game.getScoreboard(), "lobbyscoreboard", game.getLobbyScoreboard(), "prevent-spawning-mobs", game.getPreventSpawningMobs(), "spawner-holograms", game.getSpawnerHolograms(), "spawner-disable-merge", game.getSpawnerDisableMerge(), "game-start-items", game.getGameStartItems(), "player-respawn-items", game.getPlayerRespawnItems(), "spawner-holograms-countdown", game.getSpawnerHologramsCountdown(), "damage-when-player-is-not-in-arena", game.getDamageWhenPlayerIsNotInArena(), "remove-unused-target-blocks", game.getRemoveUnusedTargetBlocks(), "allow-block-falling", game.getAllowBlockFalling(), "holo-above-bed", game.getHoloAboveBed(), "allow-spectator-join", game.getSpectatorJoin(), "stop-team-spawners-on-die", game.getStopTeamSpawnersOnDie(), "anchor-auto-fill", game.getAnchorAutoFill(), "anchor-decreasing", game.getAnchorDecreasing(), "cake-target-block-eating", game.getCakeTargetBlockEating(), "target-block-explosions", game.getTargetBlockExplosions()})}))).collect(Collectors.toList())))));
                for (String gameN : Main.getGameNames()) {
                    Game game2 = Main.getGame(gameN);
                    files.add(new AFile(game2.getFile().getParentFile().getName() + "/" + game2.getFile().getName(), "yaml", String.join((CharSequence)"\n", Files.readAllLines(game2.getFile().toPath(), StandardCharsets.UTF_8))));
                }
                YamlConfiguration config = new YamlConfiguration();
                try {
                    config.load(new File(Main.getInstance().getDataFolder(), "config.yml"));
                    config.set("database.host", (Object)"SECRET");
                    config.set("database.port", (Object)3306);
                    config.set("database.db", (Object)"SECRET");
                    config.set("database.user", (Object)"SECRET");
                    config.set("database.password", (Object)"SECRET");
                    config.set("database.table-prefix", (Object)"bw_");
                    config.set("database.useSSL", (Object)false);
                    files.add(new AFile("config.yml", "yaml", config.saveToString()));
                }
                catch (IOException | InvalidConfigurationException e) {
                    e.printStackTrace();
                }
                String mainShopName = Main.getConfigurator().config.getBoolean("turnOnExperimentalGroovyShop", false) ? "shop.groovy" : "shop.yml";
                files.add(new AFile(mainShopName, mainShopName.endsWith(".groovy") ? "groovy" : "yaml", String.join((CharSequence)"\n", Files.readAllLines(new File(Main.getInstance().getDataFolder(), mainShopName).toPath(), StandardCharsets.UTF_8))));
                Main.getGameNames().stream().map(Main::getGame).map(Game::getGameStores).flatMap(Collection::stream).map(GameStore::getShopFile).filter(Objects::nonNull).distinct().filter(s -> !mainShopName.equals(s)).forEach(s -> {
                    try {
                        File file = ShopInventory.normalizeShopFile(s);
                        if (!file.exists()) {
                            return;
                        }
                        files.add(new AFile(file.getName(), file.getName().endsWith(".groovy") ? "groovy" : "yaml", String.join((CharSequence)"\n", Files.readAllLines(file.toPath(), StandardCharsets.UTF_8))));
                    }
                    catch (IOException e) {
                        Debug.warn("Cannot add shop file to dump, it probably does not exists..", true);
                        e.printStackTrace();
                    }
                });
                if ("pastes.dev".equals(service)) {
                    url = new URL("https://api.pastes.dev/post");
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "text/plain");
                    connection.setRequestProperty("User-Agent", "ScreamingBedWars");
                    connection.setRequestProperty("Allow-Modification", "false");
                    connection.setDoOutput(true);
                    StringBuilder result = new StringBuilder("BedWars dump\n\nThis dump consists of multiple text files. All these files have names and have a special delimiter which marks the start and the end of the individual files (these are not really interesting for human beings).\n\nList of uploaded text files:\n");
                    for (AFile file2 : files) {
                        result.append("- ").append(file2.getName()).append("\n");
                    }
                    for (AFile file2 : files) {
                        String generatedString;
                        Random random = new Random();
                        do {
                            generatedString = random.ints(97, 123).limit(9L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
                        } while (file2.getContent().contains("-----" + generatedString));
                        String delimiter = "-----" + generatedString;
                        result.append("\n\nFile: ").append(file2.getName()).append("\n").append(delimiter).append("\n\n").append(file2.getContent()).append("\n\n").append(delimiter);
                    }
                    connection.getOutputStream().write(result.toString().getBytes(StandardCharsets.UTF_8));
                    connection.connect();
                    int code = connection.getResponseCode();
                    if (code >= 200 && code <= 299) {
                        String location2 = "https://pastes.dev/" + connection.getHeaderField("Location");
                        if (Main.isSpigot() && sender instanceof Player) {
                            try {
                                TextComponent msg1 = new TextComponent(location2);
                                msg1.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, location2));
                                msg1.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("").append("Click to open this link").create()));
                                ((Player)sender).spigot().sendMessage(new ComponentBuilder("").append(TextComponent.fromLegacyText((String)(I.i18n("dump_success") + ChatColor.GRAY))).append((BaseComponent)msg1).create());
                            }
                            catch (Throwable ignored) {
                                sender.sendMessage(I.i18n("dump_success") + ChatColor.GRAY + location2);
                            }
                        } else {
                            sender.sendMessage(I.i18n("dump_success") + ChatColor.GRAY + location2);
                        }
                    } else {
                        sender.sendMessage(I.i18n("dump_failed"));
                        Bukkit.getLogger().severe(code + " - " + gson.fromJson((Reader)new InputStreamReader(connection.getErrorStream()), Map.class));
                    }
                } else {
                    url = new URL("https://api.paste.gg/v1/pastes");
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setDoOutput(true);
                    String json = gson.toJson(DumpCommand.nullValuesAllowingMap("name", "Bedwars dump", "description", "Dump generated by ScreamingBedwars plugin", "visibility", "unlisted", "expires", LocalDateTime.now().plusDays(30L).format(DateTimeFormatter.ofPattern("YYYY-MM-dd'T'HH:mm:ss'Z'")), "files", files.stream().map(aFile -> DumpCommand.nullValuesAllowingMap("name", aFile.getName(), "content", DumpCommand.nullValuesAllowingMap("format", "text", "highlight_language", aFile.getLanguage(), "value", aFile.getContent()))).collect(Collectors.toList())));
                    connection.getOutputStream().write(json.getBytes(StandardCharsets.UTF_8));
                    connection.connect();
                    int code = connection.getResponseCode();
                    if (code >= 200 && code <= 299) {
                        Message message = (Message)gson.fromJson((Reader)new InputStreamReader(connection.getInputStream()), Message.class);
                        if (Main.isSpigot() && sender instanceof Player) {
                            try {
                                TextComponent msg1 = new TextComponent("https://paste.gg/" + message.getResult().getId());
                                msg1.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://paste.gg/" + message.getResult().getId()));
                                msg1.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("").append("Open this link").create()));
                                ((Player)sender).spigot().sendMessage(new ComponentBuilder("").append(TextComponent.fromLegacyText((String)(I.i18n("dump_success") + ChatColor.GRAY))).append((BaseComponent)msg1).create());
                            }
                            catch (Throwable ignored) {
                                sender.sendMessage(I.i18n("dump_success") + ChatColor.GRAY + "https://paste.gg/" + message.getResult().getId());
                            }
                        } else {
                            sender.sendMessage(I.i18n("dump_success") + ChatColor.GRAY + "https://paste.gg/" + message.getResult().getId());
                        }
                    } else {
                        sender.sendMessage(I.i18n("dump_failed"));
                        Bukkit.getLogger().severe(code + " - " + gson.fromJson((Reader)new InputStreamReader(connection.getErrorStream()), Map.class));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                sender.sendMessage(I.i18n("dump_failed"));
            }
        }).start();
        return true;
    }

    @Override
    public void completeTab(List<String> completion, CommandSender sender, List<String> args) {
        if (args.size() == 1) {
            completion.addAll(Arrays.asList("paste.gg", "pastes.dev"));
        }
    }

    public static Map<?, ?> nullValuesAllowingMap(Object ... objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object key = null;
        for (Object object : objects) {
            if (key == null) {
                key = Objects.requireNonNull(object);
                continue;
            }
            map.put(key, object);
            key = null;
        }
        return map;
    }

    public static class AFile {
        private final String name;
        private final String language;
        private final String content;

        @Generated
        public AFile(String name, String language, String content) {
            this.name = name;
            this.language = language;
            this.content = content;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getLanguage() {
            return this.language;
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AFile)) {
                return false;
            }
            AFile other = (AFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AFile;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DumpCommand.AFile(name=" + this.getName() + ", language=" + this.getLanguage() + ", content=" + this.getContent() + ")";
        }
    }

    public static class Message {
        private Result result;

        @Generated
        public Message() {
        }

        @Generated
        public Result getResult() {
            return this.result;
        }

        @Generated
        public void setResult(Result result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Result this$result = this.getResult();
            Result other$result = other.getResult();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Result $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DumpCommand.Message(result=" + this.getResult() + ")";
        }
    }

    public static class Result {
        private String id;

        @Generated
        public Result() {
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DumpCommand.Result(id=" + this.getId() + ")";
        }
    }
}

