/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.commands;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I18n;

public class HelpCommand
extends BaseCommand {
    public HelpCommand() {
        super("help", Collections.EMPTY_LIST, true, true);
    }

    @Override
    public boolean execute(CommandSender sender, List<String> args) {
        if (sender instanceof Player) {
            this.sendHelp((Player)sender);
        } else if (sender instanceof ConsoleCommandSender) {
            this.sendConsoleHelp((ConsoleCommandSender)sender);
        }
        return true;
    }

    @Override
    public void completeTab(List<String> completion, CommandSender sender, List<String> args) {
    }

    public void sendConsoleHelp(ConsoleCommandSender console) {
        console.sendMessage(I18n.i18nonly("help_title_console").replace("%version%", Main.getVersion()));
        console.sendMessage(I18n.i18nonly("help_bw_list"));
        console.sendMessage(I18n.i18nonly("help_bw_stats_other"));
        console.sendMessage(I18n.i18nonly("help_bw_alljoin"));
        console.sendMessage(I18n.i18nonly("help_bw_dump"));
        console.sendMessage(I18n.i18nonly("help_bw_reload"));
        if (Main.getConfigurator().config.getBoolean("enable-cheat-command-for-admins")) {
            console.sendMessage(I18n.i18nonly("help_bw_cheatin_give"));
            console.sendMessage(I18n.i18nonly("help_bw_cheatin_kill"));
            console.sendMessage(I18n.i18nonly("help_bw_cheatin_destroybed"));
            console.sendMessage(I18n.i18nonly("help_bw_cheatin_destroyallbeds"));
        }
    }

    public void sendHelp(Player player) {
        player.sendMessage(I18n.i18nonly("help_title").replace("%version%", Main.getVersion()));
        if (HelpCommand.hasPermission((CommandSender)player, JOIN_PERMISSION, Main.getConfigurator().config.getBoolean("default-permissions.join"))) {
            player.sendMessage(I18n.i18nonly("help_bw_join"));
        }
        if (HelpCommand.hasPermission((CommandSender)player, LEAVE_PERMISSION, Main.getConfigurator().config.getBoolean("default-permissions.leave"))) {
            player.sendMessage(I18n.i18nonly("help_bw_leave"));
        }
        if (HelpCommand.hasPermission((CommandSender)player, REJOIN_PERMISSION, Main.getConfigurator().config.getBoolean("default-permissions.rejoin"))) {
            player.sendMessage(I18n.i18nonly("help_bw_rejoin"));
        }
        if (HelpCommand.hasPermission((CommandSender)player, AUTOJOIN_PERMISSION, Main.getConfigurator().config.getBoolean("default-permissions.autojoin"))) {
            player.sendMessage(I18n.i18nonly("help_bw_autojoin"));
        }
        if (HelpCommand.hasPermission((CommandSender)player, LIST_PERMISSION, Main.getConfigurator().config.getBoolean("default-permissions.list"))) {
            player.sendMessage(I18n.i18nonly("help_bw_list"));
        }
        if (HelpCommand.hasPermission((CommandSender)player, LEADERBOARD_PERMISSION, Main.getConfigurator().config.getBoolean("default-permissions.leaderboard"))) {
            player.sendMessage(I18n.i18nonly("help_bw_leaderboard"));
        }
        if (HelpCommand.hasPermission((CommandSender)player, STATS_PERMISSION, Main.getConfigurator().config.getBoolean("default-permissions.stats"))) {
            if (HelpCommand.hasPermission((CommandSender)player, ADMIN_PERMISSION, false) || HelpCommand.hasPermission((CommandSender)player, OTHER_STATS_PERMISSION, false)) {
                player.sendMessage(I18n.i18nonly("help_bw_stats_other"));
            } else {
                player.sendMessage(I18n.i18nonly("help_bw_stats"));
            }
        }
        if (player.hasPermission("bw.admin.alljoin")) {
            player.sendMessage(I18n.i18nonly("help_bw_alljoin"));
        }
        if (HelpCommand.hasPermission((CommandSender)player, ADMIN_PERMISSION, false)) {
            player.sendMessage(I18n.i18nonly("help_bw_addholo"));
            player.sendMessage(I18n.i18nonly("help_bw_removeholo"));
            player.sendMessage(I18n.i18nonly("help_bw_mainlobby"));
            if (Main.getConfigurator().config.getBoolean("enable-cheat-command-for-admins")) {
                player.sendMessage(I18n.i18nonly("help_bw_cheat_give"));
                player.sendMessage(I18n.i18nonly("help_bw_cheat_kill"));
                player.sendMessage(I18n.i18nonly("help_bw_cheat_destroybed"));
                player.sendMessage(I18n.i18nonly("help_bw_cheat_destroyallbeds"));
                player.sendMessage(I18n.i18nonly("help_bw_cheat_jointeam"));
                player.sendMessage(I18n.i18nonly("help_bw_cheat_startemptygame"));
                player.sendMessage(I18n.i18nonly("help_bw_cheatin_give"));
                player.sendMessage(I18n.i18nonly("help_bw_cheatin_kill"));
                player.sendMessage(I18n.i18nonly("help_bw_cheatin_destroybed"));
                player.sendMessage(I18n.i18nonly("help_bw_cheatin_destroyallbeds"));
            }
            player.sendMessage(I18n.i18nonly("help_bw_admin_info"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_add"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_lobby"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_spec"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_pos1"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_pos2"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_pausecountdown"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_post_game_waiting"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_customprefix"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_minplayers"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_time"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_team_add"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_team_color"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_team_maxplayers"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_team_spawn"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_team_bed"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_jointeam"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_spawner_add"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_spawner_remove"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_spawner_reset"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_store_add"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_store_type"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_store_child"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_store_adult"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_store_remove"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_config"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_arena_time"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_arena_weather"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_remove"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_edit"));
            player.sendMessage(I18n.i18nonly("help_bw_admin_save"));
            player.sendMessage(I18n.i18nonly("help_bw_dump"));
            player.sendMessage(I18n.i18nonly("help_bw_reload"));
        }
    }
}

