/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.commands;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I18n;

public class JoinCommand
extends BaseCommand {
    public JoinCommand() {
        super("join", JOIN_PERMISSION, false, Main.getConfigurator().config.getBoolean("default-permissions.join"));
    }

    @Override
    public boolean execute(CommandSender sender, List<String> args) {
        Player player = (Player)sender;
        if (Main.isPlayerInGame(player)) {
            player.sendMessage(I18n.i18n("you_are_already_in_some_game"));
            return true;
        }
        if (args.size() >= 1) {
            String arenaN = args.get(0);
            if (Main.isGameExists(arenaN)) {
                Main.getGame(arenaN).joinToGame(player);
            } else {
                player.sendMessage(I18n.i18n("no_arena_found"));
            }
        } else {
            Game game = Main.getInstance().getRandomWaitingGameForBungeeMode();
            if (game != null) {
                game.joinToGame(player);
                return true;
            }
            player.sendMessage(I18n.i18n("there_is_no_empty_game"));
            return true;
        }
        return true;
    }

    @Override
    public void completeTab(List<String> completion, CommandSender sender, List<String> args) {
        if (args.size() == 1) {
            completion.addAll(Main.getGameNames());
        }
    }
}

