/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.commands;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.command.CommandSender;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.statistics.LeaderboardEntry;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I18n;

public class LeaderboardCommand
extends BaseCommand {
    public LeaderboardCommand() {
        super("leaderboard", LEADERBOARD_PERMISSION, true, Main.getConfigurator().config.getBoolean("default-permissions.leaderboard"));
    }

    @Override
    public boolean execute(CommandSender sender, List<String> args) {
        if (!Main.isPlayerStatisticsEnabled()) {
            I18n.mpr("statistics_is_disabled").send(sender);
        } else {
            int max = Main.getConfigurator().config.getInt("holograms.leaderboard.size");
            I18n.mpr("leaderboard_header").replace("number", max).send(sender);
            List<LeaderboardEntry> statistics = Main.getPlayerStatisticsManager().getLeaderboard(max);
            if (statistics.isEmpty()) {
                I18n.m("leaderboard_no_scores").send(sender);
            } else {
                AtomicInteger l = new AtomicInteger(1);
                statistics.forEach(leaderboardEntry -> I18n.m("leaderboard_line").replace("order", l.getAndIncrement()).replace("player", leaderboardEntry.getPlayer().getName() != null ? leaderboardEntry.getPlayer().getName() : (leaderboardEntry.getLatestKnownName() != null ? leaderboardEntry.getLatestKnownName() : leaderboardEntry.getPlayer().getUniqueId().toString())).replace("score", leaderboardEntry.getTotalScore()).send(sender));
            }
        }
        return true;
    }

    @Override
    public void completeTab(List<String> completion, CommandSender sender, List<String> args) {
    }
}

