/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.commands;

import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I18n;

public class ReloadCommand
extends BaseCommand {
    public ReloadCommand() {
        super("reload", ADMIN_PERMISSION, true, false);
    }

    @Override
    public boolean execute(final CommandSender sender, List<String> args) {
        sender.sendMessage(I18n.i18n("safe_reload"));
        for (String game : Main.getGameNames()) {
            Main.getGame(game).stop();
        }
        new BukkitRunnable(){
            public int timer = 60;

            public void run() {
                boolean gameRuns = false;
                for (String game : Main.getGameNames()) {
                    if (Main.getGame(game).getStatus() == GameStatus.DISABLED) continue;
                    gameRuns = true;
                    break;
                }
                if (gameRuns && this.timer == 0) {
                    sender.sendMessage(I18n.i18n("safe_reload_failed_to_stop_game"));
                }
                if (!gameRuns || this.timer == 0) {
                    this.cancel();
                    Main plugin = Main.getInstance();
                    try {
                        String message = String.format("Disabling %s", plugin.getDescription().getFullName());
                        plugin.getLogger().info(message);
                        Bukkit.getPluginManager().callEvent((Event)new PluginDisableEvent((Plugin)plugin));
                        Main.getInstance().se(false);
                    }
                    catch (Throwable ex) {
                        Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while disabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                    }
                    try {
                        Bukkit.getScheduler().cancelTasks((Plugin)plugin);
                    }
                    catch (Throwable ex) {
                        Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while cancelling tasks for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                    }
                    try {
                        Bukkit.getServicesManager().unregisterAll((Plugin)plugin);
                    }
                    catch (Throwable ex) {
                        Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering services for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                    }
                    try {
                        HandlerList.unregisterAll((Plugin)plugin);
                    }
                    catch (Throwable ex) {
                        Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering events for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                    }
                    try {
                        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)plugin);
                        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)plugin);
                    }
                    catch (Throwable ex) {
                        Bukkit.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering plugin channels for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                    }
                    try {
                        for (World world : Bukkit.getWorlds()) {
                            world.removePluginChunkTickets((Plugin)plugin);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Bukkit.getServer().getPluginManager().enablePlugin((Plugin)Main.getInstance());
                    sender.sendMessage("Plugin reloaded! Keep in mind that restarting the server is safer!");
                    return;
                }
                --this.timer;
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 20L);
        return true;
    }

    @Override
    public void completeTab(List<String> completion, CommandSender sender, List<String> args) {
    }
}

