/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.commands;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;

public class StatsCommand
extends BaseCommand {
    public StatsCommand() {
        super("stats", STATS_PERMISSION, true, Main.getConfigurator().config.getBoolean("default-permissions.stats"));
    }

    @Override
    public boolean execute(CommandSender sender, List<String> args) {
        if (!Main.isPlayerStatisticsEnabled()) {
            sender.sendMessage(I18n.i18n("statistics_is_disabled"));
        } else if (args.size() >= 1) {
            if (!StatsCommand.hasPermission(sender, OTHER_STATS_PERMISSION, false) && !StatsCommand.hasPermission(sender, ADMIN_PERMISSION, false)) {
                sender.sendMessage(I18n.i18n("no_permissions"));
            } else {
                String name = args.get(0);
                Player off = Main.getInstance().getServer().getPlayerExact(name);
                if (off == null) {
                    sender.sendMessage(I18n.i18n("statistics_player_is_not_exists"));
                } else {
                    PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)off);
                    if (statistic == null) {
                        sender.sendMessage(I18n.i18n("statistics_not_found"));
                    } else {
                        StatsCommand.sendStats(sender, statistic);
                    }
                }
            }
        } else if (sender instanceof Player) {
            Player player = (Player)sender;
            PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player);
            if (statistic == null) {
                player.sendMessage(I18n.i18n("statistics_not_found"));
            } else {
                StatsCommand.sendStats((CommandSender)player, statistic);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void completeTab(List<String> completion, CommandSender sender, List<String> args) {
        if (args.size() == 1 && Main.isPlayerStatisticsEnabled() && StatsCommand.hasPermission(sender, OTHER_STATS_PERMISSION, false) && StatsCommand.hasPermission(sender, ADMIN_PERMISSION, false)) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                completion.add(p.getName());
            }
        }
    }

    public static void sendStats(CommandSender player, PlayerStatistic statistic) {
        player.sendMessage(I18n.i18n("statistics_header").replace("%player%", statistic.getName()));
        player.sendMessage(I18n.i18n("statistics_kills", false).replace("%kills%", Integer.toString(statistic.getKills())));
        player.sendMessage(I18n.i18n("statistics_deaths", false).replace("%deaths%", Integer.toString(statistic.getDeaths())));
        player.sendMessage(I18n.i18n("statistics_kd", false).replace("%kd%", Double.toString(statistic.getKD())));
        player.sendMessage(I18n.i18n("statistics_wins", false).replace("%wins%", Integer.toString(statistic.getWins())));
        player.sendMessage(I18n.i18n("statistics_loses", false).replace("%loses%", Integer.toString(statistic.getLoses())));
        player.sendMessage(I18n.i18n("statistics_games", false).replace("%games%", Integer.toString(statistic.getGames())));
        player.sendMessage(I18n.i18n("statistics_beds", false).replace("%beds%", Integer.toString(statistic.getDestroyedBeds())));
        player.sendMessage(I18n.i18n("statistics_score", false).replace("%score%", Integer.toString(statistic.getScore())));
    }
}

