/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;

public class Configurator {
    public File configFile;
    public File shopFile;
    public File signsFile;
    public File recordFile;
    public File langFolder;
    public FileConfiguration config;
    public FileConfiguration recordConfig;
    public final File dataFolder;
    public final Main main;

    public Configurator(Main main) {
        this.dataFolder = main.getDataFolder();
        this.main = main;
    }

    public void createFiles() {
        this.dataFolder.mkdirs();
        this.configFile = new File(this.dataFolder, "config.yml");
        this.signsFile = new File(this.dataFolder, "sign.yml");
        this.recordFile = new File(this.dataFolder, "record.yml");
        this.langFolder = new File(this.dataFolder.toString(), "languages");
        this.config = new YamlConfiguration();
        this.recordConfig = new YamlConfiguration();
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.signsFile.exists()) {
            try {
                this.signsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.recordFile.exists()) {
            try {
                this.recordFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.langFolder.exists()) {
            this.langFolder.mkdirs();
            File[] listOfFiles = this.dataFolder.listFiles();
            if (listOfFiles != null && listOfFiles.length > 0) {
                for (File file : listOfFiles) {
                    if (!file.isFile() || !file.getName().startsWith("messages_") || !file.getName().endsWith(".yml")) continue;
                    File dest = new File(this.langFolder, "language_" + file.getName().substring(9));
                    file.renameTo(dest);
                }
            }
        }
        try {
            this.config.load(this.configFile);
            this.recordConfig.load(this.recordFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        String shopFileName = "shop.yml";
        if (this.config.getBoolean("turnOnExperimentalGroovyShop", false)) {
            shopFileName = "shop.groovy";
        }
        this.shopFile = new File(this.dataFolder, shopFileName);
        if (!this.shopFile.exists()) {
            this.main.saveResource(shopFileName, false);
        }
        AtomicBoolean modify = new AtomicBoolean(false);
        this.checkOrSetConfig(modify, "locale", "en");
        this.checkOrSetConfig(modify, "debug", false);
        this.checkOrSetConfig(modify, "allow-crafting", false);
        this.checkOrSetConfig(modify, "keep-inventory-on-death", false);
        this.checkOrSetConfig(modify, "in-lobby-colored-leather-by-team", true);
        this.checkOrSetConfig(modify, "jointeam-entity-show-name", true);
        this.checkOrSetConfig(modify, "friendlyfire", false);
        this.checkOrSetConfig(modify, "player-drops", true);
        this.checkOrSetConfig(modify, "join-randomly-after-lobby-timeout", false);
        this.checkOrSetConfig(modify, "prevent-killing-villagers", true);
        this.checkOrSetConfig(modify, "compass-enabled", true);
        this.checkOrSetConfig(modify, "join-randomly-on-lobby-join", false);
        this.checkOrSetConfig(modify, "add-wool-to-inventory-on-join", true);
        this.checkOrSetConfig(modify, "prevent-spawning-mobs", true);
        this.checkOrSetConfig(modify, "spawner-holograms", true);
        this.checkOrSetConfig(modify, "spawner-disable-merge", true);
        this.checkOrSetConfig(modify, "prevent-lobby-spawn-mobs-in-radius", 16);
        this.checkOrSetConfig(modify, "spawner-holo-height", 0.25);
        this.checkOrSetConfig(modify, "spawner-holograms-countdown", true);
        this.checkOrSetConfig(modify, "damage-when-player-is-not-in-arena", false);
        this.checkOrSetConfig(modify, "remove-unused-target-blocks", true);
        this.checkOrSetConfig(modify, "allow-block-falling", true);
        this.checkOrSetConfig(modify, "game-start-items", false);
        this.checkOrSetConfig(modify, "player-respawn-items", false);
        this.checkOrSetConfig(modify, "gived-game-start-items", new ArrayList());
        this.checkOrSetConfig(modify, "gived-player-respawn-items", new ArrayList());
        this.checkOrSetConfig(modify, "disable-hunger", false);
        this.checkOrSetConfig(modify, "automatic-coloring-in-shop", true);
        this.checkOrSetConfig(modify, "sell-max-64-per-click-in-shop", true);
        this.checkOrSetConfig(modify, "enable-cheat-command-for-admins", false);
        this.checkOrSetConfig(modify, "shopkeepers-are-silent", true);
        if (this.config.isSet("destroy-placed-blocks-by-explosion-except") && !this.config.isList("destroy-placed-blocks-by-explosion-except")) {
            this.config.set("destroy-placed-blocks-by-explosion-except", Arrays.asList(this.config.getString("destroy-placed-blocks-by-explosion-except")));
        }
        this.checkOrSetConfig(modify, "destroy-placed-blocks-by-explosion-except", new ArrayList());
        this.checkOrSetConfig(modify, "destroy-placed-blocks-by-explosion", true);
        this.checkOrSetConfig(modify, "holo-above-bed", true);
        this.checkOrSetConfig(modify, "allow-spectator-join", false);
        this.checkOrSetConfig(modify, "disable-server-message.player-join", false);
        this.checkOrSetConfig(modify, "disable-server-message.player-leave", false);
        this.checkOrSetConfig(modify, "disable-flight", true);
        this.checkOrSetConfig(modify, "respawn-cooldown.enabled", true);
        this.checkOrSetConfig(modify, "respawn-cooldown.time", 5);
        this.checkOrSetConfig(modify, "stop-team-spawners-on-die", false);
        this.checkOrSetConfig(modify, "allow-fake-death", false);
        this.checkOrSetConfig(modify, "prefer-1-19-4-display-entities", true);
        this.checkOrSetConfig(modify, "remember-what-scoreboards-players-had-before", false);
        this.checkOrSetConfig(modify, "use-chunk-tickets-if-available", true);
        this.checkOrSetConfig(modify, "reset-full-spawner-countdown-after-picking", true);
        this.checkOrSetConfig(modify, "players-can-win-game-only-after-seconds", 0);
        this.checkOrSetConfig(modify, "disable-locator-bars-in-arena-worlds", true);
        this.checkOrSetConfig(modify, "disable-opening-stores-of-other-teams", false);
        this.checkOrSetConfig(modify, "disable-waterlogging-of-original-blocks", false);
        this.checkOrSetConfig(modify, "kick-players-upon-final-death.enabled", false);
        this.checkOrSetConfig(modify, "kick-players-upon-final-death.delay", 5);
        this.checkOrSetConfig(modify, "allowed-commands", new ArrayList());
        this.checkOrSetConfig(modify, "change-allowed-commands-to-blacklist", false);
        this.checkOrSetConfig(modify, "bungee.enabled", false);
        this.checkOrSetConfig(modify, "bungee.serverRestart", true);
        this.checkOrSetConfig(modify, "bungee.serverStop", false);
        this.checkOrSetConfig(modify, "bungee.server", "hub");
        this.checkOrSetConfig(modify, "bungee.auto-game-connect", false);
        this.checkOrSetConfig(modify, "bungee.kick-when-proxy-too-slow", true);
        this.checkOrSetConfig(modify, "bungee.random-game-selection.enabled", this.config.getBoolean("bungee.select-random-game", true));
        this.checkOrSetConfig(modify, "bungee.random-game-selection.preselect-games", false);
        this.checkOrSetConfig(modify, "bungee.motd.enabled", false);
        this.checkOrSetConfig(modify, "bungee.motd.waiting", "%name%: Waiting for players [%current%/%max%]");
        this.checkOrSetConfig(modify, "bungee.motd.waiting_full", "%name%: Game is full [%current%/%max%]");
        this.checkOrSetConfig(modify, "bungee.motd.running", "%name%: Game is running [%current%/%max%]");
        this.checkOrSetConfig(modify, "bungee.motd.rebuilding", "%name%: Rebuilding...");
        this.checkOrSetConfig(modify, "bungee.motd.disabled", "%name%: Game is disabled");
        if (this.config.isSet("bungee.select-random-game")) {
            modify.set(true);
            this.config.set("bungee.select-random-game", null);
        }
        this.checkOrSetConfig(modify, "farmBlocks.enable", false);
        this.checkOrSetConfig(modify, "farmBlocks.blocks", new ArrayList());
        this.checkOrSetConfig(modify, "scoreboard.enable", true);
        this.checkOrSetConfig(modify, "scoreboard.title", "&a%game%&r - %time%");
        this.checkOrSetConfig(modify, "scoreboard.bedLost", "&c\u2718");
        this.checkOrSetConfig(modify, "scoreboard.anchorEmpty", "&e\u2718");
        this.checkOrSetConfig(modify, "scoreboard.bedExists", "&a\u2714");
        this.checkOrSetConfig(modify, "scoreboard.teamTitle", "%bed%%color%%team%");
        this.checkOrSetConfig(modify, "title.enabled", true);
        this.checkOrSetConfig(modify, "title.fadeIn", 0);
        this.checkOrSetConfig(modify, "title.stay", 20);
        this.checkOrSetConfig(modify, "title.fadeOut", 0);
        this.checkOrSetConfig(modify, "shop.rows", 4);
        this.checkOrSetConfig(modify, "shop.render-actual-rows", 6);
        this.checkOrSetConfig(modify, "shop.render-offset", 9);
        this.checkOrSetConfig(modify, "shop.render-header-start", 0);
        this.checkOrSetConfig(modify, "shop.render-footer-start", 45);
        this.checkOrSetConfig(modify, "shop.items-on-row", 9);
        this.checkOrSetConfig(modify, "shop.show-page-numbers", true);
        this.checkOrSetConfig(modify, "shop.inventory-type", "CHEST");
        this.checkOrSetConfig(modify, "shop.allow-execution-of-console-commands", true);
        this.checkOrSetConfig(modify, "shop.citizens-enabled", false);
        this.checkOrSetConfig(modify, "items.jointeam", "COMPASS");
        this.checkOrSetConfig(modify, "items.leavegame", "SLIME_BALL");
        this.checkOrSetConfig(modify, "items.startgame", "DIAMOND");
        this.checkOrSetConfig(modify, "items.shopback", "BARRIER");
        this.checkOrSetConfig(modify, "items.shopcosmetic", Main.isLegacy() ? new ItemStack(Material.getMaterial((String)"STAINED_GLASS_PANE"), 1, 7) : "GRAY_STAINED_GLASS_PANE");
        this.checkOrSetConfig(modify, "items.pageback", "ARROW");
        this.checkOrSetConfig(modify, "items.pageforward", "ARROW");
        this.checkOrSetConfig(modify, "items.team-select", Main.isLegacy() ? new ItemStack(Material.getMaterial((String)"WOOL"), 1, 1) : "WHITE_WOOL");
        this.checkOrSetConfig(modify, "vault.enable", true);
        this.checkOrSetConfig(modify, "vault.reward.kill", 5);
        this.checkOrSetConfig(modify, "vault.reward.win", 20);
        this.checkOrSetConfig(modify, "vault.reward.final-kill", this.config.getInt("vault.reward.kill", 5));
        this.checkOrSetConfig(modify, "vault.reward.bed-destroy", 0);
        this.checkOrSetConfig(modify, "resources", new HashMap<String, Object>(){
            {
                this.put("bronze", new HashMap<String, Object>(){
                    {
                        this.put("material", Main.isLegacy() ? "CLAY_BRICK" : "BRICK");
                        this.put("interval", Configurator.this.config.getInt("spawners.bronze", 1));
                        this.put("name", "Bronze");
                        this.put("translate", "resource_bronze");
                        this.put("color", "DARK_RED");
                        this.put("spread", 1.0);
                    }
                });
                this.put("iron", new HashMap<String, Object>(){
                    {
                        this.put("material", "IRON_INGOT");
                        this.put("interval", Configurator.this.config.getInt("spawners.iron", 10));
                        this.put("name", "Iron");
                        this.put("translate", "resource_iron");
                        this.put("color", "GRAY");
                        this.put("spread", 1.0);
                    }
                });
                this.put("gold", new HashMap<String, Object>(){
                    {
                        this.put("material", "GOLD_INGOT");
                        this.put("interval", Configurator.this.config.getInt("spawners.gold", 20));
                        this.put("name", "Gold");
                        this.put("translate", "resource_gold");
                        this.put("color", "GOLD");
                        this.put("spread", 1.0);
                    }
                });
            }
        });
        if (this.config.contains("spawners")) {
            modify.set(true);
            this.config.set("spawners", null);
        }
        this.checkOrSetConfig(modify, "respawn.protection-enabled", true);
        this.checkOrSetConfig(modify, "respawn.protection-time", 10);
        this.checkOrSetConfig(modify, "respawn.show-messages", true);
        this.checkOrSetConfig(modify, "specials.action-bar-messages", true);
        this.checkOrSetConfig(modify, "specials.dont-show-success-messages", false);
        this.checkOrSetConfig(modify, "specials.rescue-platform.is-breakable", false);
        this.checkOrSetConfig(modify, "specials.rescue-platform.delay", 0);
        this.checkOrSetConfig(modify, "specials.rescue-platform.break-time", 10);
        this.checkOrSetConfig(modify, "specials.rescue-platform.distance", 1);
        this.checkOrSetConfig(modify, "specials.rescue-platform.material", "GLASS");
        this.checkOrSetConfig(modify, "specials.protection-wall.is-breakable", false);
        this.checkOrSetConfig(modify, "specials.protection-wall.delay", 20);
        this.checkOrSetConfig(modify, "specials.protection-wall.break-time", 0);
        this.checkOrSetConfig(modify, "specials.protection-wall.width", 5);
        this.checkOrSetConfig(modify, "specials.protection-wall.height", 3);
        this.checkOrSetConfig(modify, "specials.protection-wall.distance", 2);
        this.checkOrSetConfig(modify, "specials.protection-wall.material", Main.isLegacy() ? "SANDSTONE" : "CUT_SANDSTONE");
        this.checkOrSetConfig(modify, "specials.tnt-sheep.speed", 0.25);
        this.checkOrSetConfig(modify, "specials.tnt-sheep.follow-range", 10.0);
        this.checkOrSetConfig(modify, "specials.tnt-sheep.max-target-distance", 32);
        this.checkOrSetConfig(modify, "specials.tnt-sheep.explosion-time", 8);
        this.checkOrSetConfig(modify, "specials.arrow-blocker.protection-time", 10);
        this.checkOrSetConfig(modify, "specials.arrow-blocker.delay", 5);
        this.checkOrSetConfig(modify, "specials.warp-powder.teleport-time", 6);
        this.checkOrSetConfig(modify, "specials.warp-powder.delay", 0);
        this.checkOrSetConfig(modify, "specials.magnet-shoes.probability", 75);
        this.checkOrSetConfig(modify, "specials.golem.speed", 0.25);
        this.checkOrSetConfig(modify, "specials.golem.follow-range", 10);
        this.checkOrSetConfig(modify, "specials.golem.health", 20);
        this.checkOrSetConfig(modify, "specials.golem.name-format", "%teamcolor%%team% Golem");
        this.checkOrSetConfig(modify, "specials.golem.show-name", true);
        this.checkOrSetConfig(modify, "specials.golem.delay", 0);
        this.checkOrSetConfig(modify, "specials.golem.collidable", false);
        this.checkOrSetConfig(modify, "specials.teamchest.turn-all-enderchests-to-teamchests", true);
        if (this.config.isSet("specials.throwable-fireball.explosion")) {
            this.checkOrSetConfig(modify, "specials.throwable-fireball.explosion", null);
        }
        this.checkOrSetConfig(modify, "specials.throwable-fireball.damage", this.config.getDouble("specials.throwable-fireball.explosion", 3.0));
        this.checkOrSetConfig(modify, "specials.throwable-fireball.incendiary", true);
        this.checkOrSetConfig(modify, "specials.throwable-fireball.damage-thrower", true);
        this.checkOrSetConfig(modify, "specials.auto-igniteable-tnt.explosion-time", this.config.getInt("tnt.explosion-time", 8));
        this.checkOrSetConfig(modify, "specials.auto-igniteable-tnt.damage-placer", !this.config.getBoolean("tnt.dont-damage-placer"));
        this.checkOrSetConfig(modify, "specials.auto-igniteable-tnt.damage", 4.0);
        if (this.config.isSet("tnt.auto-ignite")) {
            this.config.set("tnt.auto-ignite", null);
        }
        if (this.config.isSet("tnt.explosion-time")) {
            this.config.set("tnt.explosion-time", null);
        }
        if (this.config.isSet("tnt.dont-damage-placer")) {
            this.config.set("tnt.dont-damage-placer", null);
        }
        this.checkOrSetConfig(modify, "sounds.bed_destroyed.sound", this.config.getString("sounds.on_bed_destroyed", "ENTITY_ENDER_DRAGON_GROWL"));
        this.checkOrSetConfig(modify, "sounds.bed_destroyed.volume", 1);
        this.checkOrSetConfig(modify, "sounds.bed_destroyed.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.my_bed_destroyed.sound", this.config.getString("sounds.on_bed_destroyed", "ENTITY_ENDER_DRAGON_GROWL"));
        this.checkOrSetConfig(modify, "sounds.my_bed_destroyed.volume", 1);
        this.checkOrSetConfig(modify, "sounds.my_bed_destroyed.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.countdown.sound", this.config.getString("sounds.on_countdown", "UI_BUTTON_CLICK"));
        this.checkOrSetConfig(modify, "sounds.countdown.volume", 1);
        this.checkOrSetConfig(modify, "sounds.countdown.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.game_start.sound", this.config.getString("sounds.on_game_start", "ENTITY_PLAYER_LEVELUP"));
        this.checkOrSetConfig(modify, "sounds.game_start.volume", 1);
        this.checkOrSetConfig(modify, "sounds.game_start.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.team_kill.sound", this.config.getString("sounds.on_team_kill", "ENTITY_PLAYER_LEVELUP"));
        this.checkOrSetConfig(modify, "sounds.team_kill.volume", 1);
        this.checkOrSetConfig(modify, "sounds.team_kill.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.player_kill.sound", this.config.getString("sounds.on_player_kill", "ENTITY_PLAYER_BIG_FALL"));
        this.checkOrSetConfig(modify, "sounds.player_kill.volume", 1);
        this.checkOrSetConfig(modify, "sounds.player_kill.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.item_buy.sound", this.config.getString("sounds.on_item_buy", "ENTITY_ITEM_PICKUP"));
        this.checkOrSetConfig(modify, "sounds.item_buy.volume", 1);
        this.checkOrSetConfig(modify, "sounds.item_buy.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.upgrade_buy.sound", this.config.getString("sounds.on_upgrade_buy", "ENTITY_EXPERIENCE_ORB_PICKUP"));
        this.checkOrSetConfig(modify, "sounds.upgrade_buy.volume", 1);
        this.checkOrSetConfig(modify, "sounds.upgrade_buy.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.respawn_cooldown_wait.sound", this.config.getString("sounds.on_respawn_cooldown_wait", "UI_BUTTON_CLICK"));
        this.checkOrSetConfig(modify, "sounds.respawn_cooldown_wait.volume", 1);
        this.checkOrSetConfig(modify, "sounds.respawn_cooldown_wait.pitch", 1);
        this.checkOrSetConfig(modify, "sounds.respawn_cooldown_done.sound", this.config.getString("sounds.on_respawn_cooldown_done", "ENTITY_PLAYER_LEVELUP"));
        this.checkOrSetConfig(modify, "sounds.respawn_cooldown_done.volume", 1);
        this.checkOrSetConfig(modify, "sounds.respawn_cooldown_done.pitch", 1);
        if (this.config.isSet("sounds.on_bed_destroyed")) {
            this.config.set("sounds.on_bed_destroyed", null);
        }
        if (this.config.isSet("sounds.on_countdown")) {
            this.config.set("sounds.on_countdown", null);
        }
        if (this.config.isSet("sounds.on_game_start")) {
            this.config.set("sounds.on_game_start", null);
        }
        if (this.config.isSet("sounds.on_team_kill")) {
            this.config.set("sounds.on_team_kill", null);
        }
        if (this.config.isSet("sounds.on_player_kill")) {
            this.config.set("sounds.on_player_kill", null);
        }
        if (this.config.isSet("sounds.on_item_buy")) {
            this.config.set("sounds.on_item_buy", null);
        }
        if (this.config.isSet("sounds.on_upgrade_buy")) {
            this.config.set("sounds.on_upgrade_buy", null);
        }
        if (this.config.isSet("sounds.on_respawn_cooldown_wait")) {
            this.config.set("sounds.on_respawn_cooldown_wait", null);
        }
        if (this.config.isSet("sounds.on_respawn_cooldown_done")) {
            this.config.set("sounds.on_respawn_cooldown_done", null);
        }
        this.checkOrSetConfig(modify, "game-effects.end", new HashMap<String, Object>(){
            {
                this.put("type", "Firework");
                this.put("power", 1);
                this.put("effects", new ArrayList<Object>(){
                    {
                        this.add(FireworkEffect.builder().with(FireworkEffect.Type.BALL).trail(false).flicker(false).withColor(Color.WHITE).withFade(Color.WHITE).build());
                    }
                });
            }
        });
        this.checkOrSetConfig(modify, "game-effects.start", new HashMap());
        this.checkOrSetConfig(modify, "game-effects.kill", new HashMap());
        this.checkOrSetConfig(modify, "game-effects.teamkill", new HashMap());
        this.checkOrSetConfig(modify, "game-effects.lobbyjoin", new HashMap());
        this.checkOrSetConfig(modify, "game-effects.lobbyleave", new HashMap());
        this.checkOrSetConfig(modify, "game-effects.respawn", new HashMap());
        this.checkOrSetConfig(modify, "game-effects.beddestroy", new HashMap());
        this.checkOrSetConfig(modify, "game-effects.warppowdertick", new HashMap());
        this.checkOrSetConfig(modify, "lobby-scoreboard.enabled", true);
        this.checkOrSetConfig(modify, "lobby-scoreboard.title", "&eBEDWARS");
        this.checkOrSetConfig(modify, "lobby-scoreboard.content", Arrays.asList(" ", "&fMap: &2%arena%", "&fPlayers: &2%players%&f/&2%maxplayers%", " ", "&fWaiting ...", " "));
        this.checkOrSetConfig(modify, "statistics.enabled", true);
        this.checkOrSetConfig(modify, "statistics.type", "yaml");
        this.checkOrSetConfig(modify, "statistics.show-on-game-end", false);
        this.checkOrSetConfig(modify, "statistics.bed-destroyed-kills", false);
        this.checkOrSetConfig(modify, "statistics.scores.kill", 10);
        this.checkOrSetConfig(modify, "statistics.scores.final-kill", 0);
        this.checkOrSetConfig(modify, "statistics.scores.die", 0);
        this.checkOrSetConfig(modify, "statistics.scores.win", 50);
        this.checkOrSetConfig(modify, "statistics.scores.bed-destroy", 25);
        this.checkOrSetConfig(modify, "statistics.scores.lose", 0);
        this.checkOrSetConfig(modify, "statistics.scores.record", 100);
        this.checkOrSetConfig(modify, "database.host", "localhost");
        this.checkOrSetConfig(modify, "database.port", 3306);
        this.checkOrSetConfig(modify, "database.db", "database");
        this.checkOrSetConfig(modify, "database.user", "root");
        this.checkOrSetConfig(modify, "database.password", "secret");
        this.checkOrSetConfig(modify, "database.table-prefix", "bw_");
        this.checkOrSetConfig(modify, "database.type", "mysql");
        this.checkOrSetConfig(modify, "database.driver", "default");
        if (!this.config.isSet("database.params")) {
            this.checkOrSetConfig(modify, "database.params", new HashMap());
            this.checkOrSetConfig(modify, "database.params.useSSL", this.config.getBoolean("database.useSSL", false));
            if (this.config.getBoolean("database.add-timezone-to-connection-string", true)) {
                this.checkOrSetConfig(modify, "database.params.serverTimezone", this.config.getString("database.timezone-id", TimeZone.getDefault().getID()));
            }
            this.checkOrSetConfig(modify, "database.params.autoReconnect", true);
            this.checkOrSetConfig(modify, "database.params.cachePrepStmts", true);
            this.checkOrSetConfig(modify, "database.params.prepStmtCacheSize", 250);
            this.checkOrSetConfig(modify, "database.params.prepStmtCacheSqlLimit", 2048);
            if (this.config.isSet("database.useSSL")) {
                this.config.set("database.useSSL", null);
            }
            if (this.config.isSet("database.add-timezone-to-connection-string")) {
                this.config.set("database.add-timezone-to-connection-string", null);
            }
            if (this.config.isSet("database.timezone-id")) {
                this.config.set("database.timezone-id", null);
            }
        }
        this.checkOrSetConfig(modify, "bossbar.use-xp-bar", false);
        this.checkOrSetConfig(modify, "bossbar.lobby.enable", true);
        this.checkOrSetConfig(modify, "bossbar.lobby.color", "YELLOW");
        this.checkOrSetConfig(modify, "bossbar.lobby.style", "SEGMENTED_20");
        this.checkOrSetConfig(modify, "bossbar.game.enable", true);
        this.checkOrSetConfig(modify, "bossbar.game.color", "GREEN");
        this.checkOrSetConfig(modify, "bossbar.game.style", "SEGMENTED_20");
        if (Main.getVersionNumber() <= 108) {
            this.checkOrSetConfig(modify, "bossbar.backend-entity", "dragon");
            this.checkOrSetConfig(modify, "bossbar.allow-via-hooks", true);
        }
        this.checkOrSetConfig(modify, "holograms.enabled", true);
        this.checkOrSetConfig(modify, "holograms.headline", "Your &eBEDWARS&f stats");
        this.checkOrSetConfig(modify, "holograms.leaderboard.headline", "&6Bedwars Leaderboard");
        this.checkOrSetConfig(modify, "holograms.leaderboard.format", "&l%order%. &7%name% - &a%score%");
        this.checkOrSetConfig(modify, "holograms.leaderboard.size", 10);
        this.checkOrSetConfig(modify, "chat.override", true);
        this.checkOrSetConfig(modify, "chat.format", "<%teamcolor%%name%&r> ");
        this.checkOrSetConfig(modify, "chat.separate-chat.lobby", this.config.get("chat.separate-game-chat", (Object)false));
        this.checkOrSetConfig(modify, "chat.separate-chat.game", this.config.get("chat.separate-game-chat", (Object)false));
        if (this.config.isSet("chat.separate-game-chat")) {
            this.config.set("chat.separate-game-chat", null);
        }
        this.checkOrSetConfig(modify, "chat.send-death-messages-just-in-game", true);
        this.checkOrSetConfig(modify, "chat.send-custom-death-messages", true);
        this.checkOrSetConfig(modify, "chat.default-team-chat-while-running", true);
        this.checkOrSetConfig(modify, "chat.all-chat-prefix", "@a");
        this.checkOrSetConfig(modify, "chat.team-chat-prefix", "@t");
        this.checkOrSetConfig(modify, "chat.all-chat", "[ALL] ");
        this.checkOrSetConfig(modify, "chat.team-chat", "[TEAM] ");
        this.checkOrSetConfig(modify, "chat.death-chat", "[DEATH] ");
        this.checkOrSetConfig(modify, "chat.disable-all-chat-for-spectators", false);
        this.checkOrSetConfig(modify, "rewards.enabled", false);
        this.checkOrSetConfig(modify, "rewards.player-win", new ArrayList<String>(){
            {
                this.add("/example {player} 200");
            }
        });
        this.checkOrSetConfig(modify, "rewards.player-win-run-immediately", new ArrayList<String>(){
            {
                this.add("/example {player} 200");
            }
        });
        this.checkOrSetConfig(modify, "rewards.player-end-game", new ArrayList<String>(){
            {
                this.add("/example {player} {score}");
            }
        });
        this.checkOrSetConfig(modify, "rewards.player-destroy-bed", new ArrayList<String>(){
            {
                this.add("/example {player} {score}");
            }
        });
        this.checkOrSetConfig(modify, "rewards.player-kill", new ArrayList<String>(){
            {
                this.add("/example {player} 10");
            }
        });
        this.checkOrSetConfig(modify, "rewards.player-final-kill", new ArrayList<String>(){
            {
                this.add("/example {player} 10");
            }
        });
        this.checkOrSetConfig(modify, "rewards.player-game-start", new ArrayList<String>(){
            {
                this.add("/example {player} 10");
            }
        });
        this.checkOrSetConfig(modify, "rewards.player-early-leave", new ArrayList<String>(){
            {
                this.add("/example {player} {death} 10");
            }
        });
        this.checkOrSetConfig(modify, "rewards.team-win", new ArrayList<String>(){
            {
                this.add("/example {team} 10");
            }
        });
        this.checkOrSetConfig(modify, "rewards.player-team-win", new ArrayList<String>(){
            {
                this.add("/example {team} {death} 10");
            }
        });
        this.checkOrSetConfig(modify, "rewards.game-start", new ArrayList<String>(){
            {
                this.add("/example Hello World!");
            }
        });
        this.checkOrSetConfig(modify, "lore.generate-automatically", true);
        this.checkOrSetConfig(modify, "lore.text", Arrays.asList("&7Price:", "&7%price% %resource%", "&7Amount:", "&7%amount%"));
        this.checkOrSetConfig(modify, "sign.lines", this.config.getList("sign", Arrays.asList("&c&l[BedWars]", "%arena%", "%status%", "%players%")));
        this.checkOrSetConfig(modify, "sign.block-behind.enabled", false);
        this.checkOrSetConfig(modify, "sign.block-behind.waiting", "ORANGE_STAINED_GLASS");
        this.checkOrSetConfig(modify, "sign.block-behind.rebuilding", "BROWN_STAINED_GLASS");
        this.checkOrSetConfig(modify, "sign.block-behind.in-game", "GREEN_STAINED_GLASS");
        this.checkOrSetConfig(modify, "sign.block-behind.game-disabled", "RED_STAINED_GLASS");
        this.checkOrSetConfig(modify, "hotbar.selector", 0);
        this.checkOrSetConfig(modify, "hotbar.color", 1);
        this.checkOrSetConfig(modify, "hotbar.start", 2);
        this.checkOrSetConfig(modify, "hotbar.leave", 8);
        this.checkOrSetConfig(modify, "breakable.enabled", false);
        this.checkOrSetConfig(modify, "breakable.asblacklist", false);
        this.checkOrSetConfig(modify, "breakable.explosions", false);
        this.checkOrSetConfig(modify, "breakable.blocks", new ArrayList());
        this.checkOrSetConfig(modify, "leaveshortcuts.enabled", false);
        this.checkOrSetConfig(modify, "leaveshortcuts.list", new ArrayList<String>(){
            {
                this.add("leave");
            }
        });
        this.checkOrSetConfig(modify, "mainlobby.enabled", false);
        this.checkOrSetConfig(modify, "mainlobby.location", "");
        this.checkOrSetConfig(modify, "mainlobby.world", "");
        this.checkOrSetConfig(modify, "turnOnExperimentalGroovyShop", false);
        this.checkOrSetConfig(modify, "preventSpectatorFlyingAway", false);
        this.checkOrSetConfig(modify, "removePurchaseMessages", false);
        this.checkOrSetConfig(modify, "removePurchaseFailedMessages", this.config.getBoolean("removePurchaseMessages"));
        this.checkOrSetConfig(modify, "removeUpgradeMessages", this.config.getBoolean("removePurchaseMessages"));
        this.checkOrSetConfig(modify, "disableCakeEating", true);
        this.checkOrSetConfig(modify, "disableDragonEggTeleport", true);
        this.checkOrSetConfig(modify, "preventArenaFromGriefing", true);
        this.checkOrSetConfig(modify, "update-checker.zero.console", true);
        this.checkOrSetConfig(modify, "update-checker.zero.admins", true);
        this.checkOrSetConfig(modify, "update-checker.one.console", true);
        this.checkOrSetConfig(modify, "update-checker.one.admins", true);
        this.checkOrSetConfig(modify, "target-block.allow-destroying-with-explosions", false);
        this.checkOrSetConfig(modify, "target-block.respawn-anchor.fill-on-start", true);
        this.checkOrSetConfig(modify, "target-block.respawn-anchor.enable-decrease", true);
        this.checkOrSetConfig(modify, "target-block.respawn-anchor.sound.charge", "BLOCK_RESPAWN_ANCHOR_CHARGE");
        this.checkOrSetConfig(modify, "target-block.respawn-anchor.sound.used", "BLOCK_GLASS_BREAK");
        this.checkOrSetConfig(modify, "target-block.respawn-anchor.sound.deplete", "BLOCK_RESPAWN_ANCHOR_DEPLETE");
        this.checkOrSetConfig(modify, "target-block.cake.destroy-by-eating", true);
        this.checkOrSetConfig(modify, "event-hacks.damage", false);
        this.checkOrSetConfig(modify, "event-hacks.destroy", false);
        this.checkOrSetConfig(modify, "event-hacks.place", false);
        this.checkOrSetConfig(modify, "tab.enable", false);
        this.checkOrSetConfig(modify, "tab.header.enabled", true);
        this.checkOrSetConfig(modify, "tab.header.contents", Arrays.asList("&aMy awesome BedWars server", "&bMap: %map%", "&cPlayers: %respawnable%/%max%"));
        this.checkOrSetConfig(modify, "tab.footer.enabled", true);
        this.checkOrSetConfig(modify, "tab.footer.contents", Arrays.asList("&eexample.com", "&fWow!!", "&a%spectators% are watching this match"));
        this.checkOrSetConfig(modify, "tab.hide-spectators", true);
        this.checkOrSetConfig(modify, "tab.hide-foreign-players", false);
        this.checkOrSetConfig(modify, "default-permissions.join", true);
        this.checkOrSetConfig(modify, "default-permissions.leave", true);
        this.checkOrSetConfig(modify, "default-permissions.stats", true);
        this.checkOrSetConfig(modify, "default-permissions.list", true);
        this.checkOrSetConfig(modify, "default-permissions.rejoin", true);
        this.checkOrSetConfig(modify, "default-permissions.autojoin", true);
        this.checkOrSetConfig(modify, "default-permissions.leaderboard", true);
        this.checkOrSetConfig(modify, "default-permissions.party", true);
        this.checkOrSetConfig(modify, "party.enabled", false);
        this.checkOrSetConfig(modify, "party.autojoin-members", false);
        this.checkOrSetConfig(modify, "party.notify-when-warped", true);
        this.checkOrSetConfig(modify, "version", 2);
        if (modify.get()) {
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkOrSetConfig(AtomicBoolean modify, String path, Object value) {
        Configurator.checkOrSet(modify, this.config, path, value);
    }

    private static void checkOrSet(AtomicBoolean modify, FileConfiguration config, String path, Object value) {
        if (!config.isSet(path)) {
            if (value instanceof Map) {
                config.createSection(path, (Map)value);
            } else {
                config.set(path, value);
            }
            modify.set(true);
        }
    }

    public ItemStack readDefinedItem(String item, String def) {
        if (this.config.isSet("items." + item) && this.config.get("items." + item) != null) {
            Object obj = this.config.get("items." + item);
            return StackParser.parse(obj);
        }
        return StackParser.parse(def);
    }
}

