/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.database;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import org.bukkit.configuration.ConfigurationSection;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.lib.HikariCP.hikari.HikariConfig;
import org.screamingsandals.bedwars.lib.HikariCP.hikari.HikariDataSource;

public class DatabaseManager {
    private String tablePrefix;
    private String database;
    private HikariDataSource dataSource = null;
    private String host;
    private String password;
    private int port;
    private String user;
    private ConfigurationSection params;
    private String type;
    private String driver;

    public DatabaseManager(String host, int port, String user, String password, String database, String tablePrefix, ConfigurationSection params, String type, String driver) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.database = database;
        this.tablePrefix = tablePrefix;
        this.params = params;
        this.type = type;
        this.driver = driver;
    }

    public void initialize() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:" + this.type + "://" + this.host + ":" + this.port + "/" + this.database);
        config.setUsername(this.user);
        config.setPassword(this.password);
        for (String key : this.params.getKeys(false)) {
            config.addDataSourceProperty(key, this.params.getString(key));
        }
        ClassLoader contextCl = null;
        Class<?> driverClazz = null;
        if (this.driver != null && !"default".equalsIgnoreCase(this.driver)) {
            try {
                URLClassLoader cl = new URLClassLoader(new URL[]{Main.getInstance().getDataFolder().toPath().resolve(this.driver).toAbsolutePath().toUri().toURL()}, ClassLoader.getSystemClassLoader().getParent());
                try (InputStream is = cl.getResourceAsStream("META-INF/services/java.sql.Driver");){
                    if (is == null) {
                        throw new RuntimeException("Database driver JAR does not contain JDBC 4 compatible driver");
                    }
                    String driverClassName = null;
                    try (InputStreamReader isr = new InputStreamReader(is);
                         BufferedReader reader = new BufferedReader(isr);){
                        do {
                            if ((driverClassName = reader.readLine()) == null) continue;
                            driverClassName = driverClassName.split("#", 2)[0].trim();
                        } while (driverClassName != null && driverClassName.isEmpty());
                    }
                    if (driverClassName == null) {
                        throw new RuntimeException("Database driver JAR does not contain JDBC 4 compatible driver");
                    }
                    driverClazz = cl.loadClass(driverClassName);
                    contextCl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    config.setDriverClassName(driverClassName);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.dataSource = new HikariDataSource(config);
        if (contextCl != null) {
            Thread.currentThread().setContextClassLoader(contextCl);
        }
        if (driverClazz != null) {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                if (!driver.getClass().equals(driverClazz)) continue;
                try {
                    DriverManager.deregisterDriver(driver);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCreateTableSql() {
        return "CREATE TABLE IF NOT EXISTS `" + this.tablePrefix + "stats_players` (`kills` int(11) NOT NULL DEFAULT '0', `wins` int(11) NOT NULL DEFAULT '0', `score` int(11) NOT NULL DEFAULT '0', `loses` int(11) NOT NULL DEFAULT '0', `name` varchar(255) NOT NULL, `destroyedBeds` int(11) NOT NULL DEFAULT '0', `uuid` varchar(255) NOT NULL, `deaths` int(11) NOT NULL DEFAULT '0', PRIMARY KEY (`uuid`))";
    }

    public String getReadObjectSql() {
        return "SELECT * FROM " + this.tablePrefix + "stats_players WHERE uuid = ? LIMIT 1";
    }

    public String getWriteObjectSql() {
        return "INSERT INTO " + this.tablePrefix + "stats_players(uuid, name, deaths, destroyedBeds, kills, loses, score, wins) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE uuid=VALUES(uuid),name=VALUES(name),deaths=VALUES(deaths),destroyedBeds=VALUES(destroyedBeds),kills=VALUES(kills),loses=VALUES(loses),score=VALUES(score),wins=VALUES(wins)";
    }

    public String getScoresSql() {
        return "SELECT uuid, score, name FROM " + this.tablePrefix + "stats_players";
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }
}

