/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.game;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.TeamColor;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.Team;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.nms.holograms.Hologram;

public class CurrentTeam
implements RunningTeam {
    public final Team teamInfo;
    public final List<GamePlayer> players = new ArrayList<GamePlayer>();
    public final List<Member> teamMembers = new ArrayList<Member>();
    private org.bukkit.scoreboard.Team scoreboardTeam;
    private Inventory chestInventory;
    private List<Block> chests = new ArrayList<Block>();
    private Game game;
    private Hologram holo;
    private Hologram protectHolo;
    public boolean isBed = true;
    public boolean forced = false;

    public CurrentTeam(Team team, Game game) {
        this.teamInfo = team;
        this.game = game;
        this.chestInventory = Bukkit.createInventory(null, (InventoryType)InventoryType.ENDER_CHEST, (String)I.i18nc("team_chest", game.getCustomPrefix()));
    }

    @Override
    public boolean isDead() {
        return this.players.isEmpty();
    }

    @Override
    public boolean isAlive() {
        return !this.players.isEmpty();
    }

    @Override
    public org.bukkit.scoreboard.Team getScoreboardTeam() {
        return this.scoreboardTeam;
    }

    public void setScoreboardTeam(org.bukkit.scoreboard.Team scoreboardTeam) {
        this.scoreboardTeam = scoreboardTeam;
    }

    public void setBedHolo(Hologram holo) {
        this.holo = holo;
    }

    public Hologram getBedHolo() {
        return this.holo;
    }

    public boolean hasBedHolo() {
        return this.holo != null;
    }

    public void setProtectHolo(Hologram protectHolo) {
        this.protectHolo = protectHolo;
    }

    public Hologram getProtectHolo() {
        return this.protectHolo;
    }

    public boolean hasProtectHolo() {
        return this.protectHolo != null;
    }

    @Override
    public String getName() {
        return this.teamInfo.name;
    }

    @Override
    public TeamColor getColor() {
        return this.teamInfo.color.toApiColor();
    }

    @Override
    public boolean isNewColor() {
        return this.teamInfo.newColor;
    }

    @Override
    public Location getTeamSpawn() {
        return this.teamInfo.spawn;
    }

    @Override
    public Location getTargetBlock() {
        return this.teamInfo.bed;
    }

    @Override
    public int getMaxPlayers() {
        return this.teamInfo.maxPlayers;
    }

    @Override
    public int countConnectedPlayers() {
        return this.players.size();
    }

    @Override
    public List<Player> getConnectedPlayers() {
        ArrayList<Player> playerList = new ArrayList<Player>();
        for (GamePlayer gamePlayer : this.players) {
            playerList.add(gamePlayer.player);
        }
        return playerList;
    }

    @Override
    public boolean isPlayerInTeam(Player player) {
        for (GamePlayer gamePlayer : this.players) {
            if (!gamePlayer.player.equals(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTargetBlockExists() {
        return this.isBed;
    }

    @Override
    public void addTeamChest(Location location) {
        this.addTeamChest(location.getBlock());
    }

    @Override
    public void addTeamChest(Block block) {
        if (!this.chests.contains(block)) {
            this.chests.add(block);
        }
    }

    @Override
    public void removeTeamChest(Location location) {
        this.removeTeamChest(location.getBlock());
    }

    @Override
    public void removeTeamChest(Block block) {
        if (this.chests.contains(block)) {
            this.chests.remove(block);
        }
    }

    @Override
    public boolean isTeamChestRegistered(Location location) {
        return this.isTeamChestRegistered(location.getBlock());
    }

    @Override
    public boolean isTeamChestRegistered(Block block) {
        return this.chests.contains(block);
    }

    @Override
    public Inventory getTeamChestInventory() {
        return this.chestInventory;
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    @Override
    public int countTeamChests() {
        return this.chests.size();
    }

    public static class Member {
        private final UUID uuid;
        private final String name;

        @Generated
        public Member(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        @Generated
        public UUID getUuid() {
            return this.uuid;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Member)) {
                return false;
            }
            Member other = (Member)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Member;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CurrentTeam.Member(uuid=" + this.getUuid() + ", name=" + this.getName() + ")";
        }
    }
}

