/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.game;

import com.onarandombox.MultiverseCore.api.Core;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.ArenaTime;
import org.screamingsandals.bedwars.api.InGameConfigBooleanConstants;
import org.screamingsandals.bedwars.api.Region;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.boss.BossBar;
import org.screamingsandals.bedwars.api.boss.BossBar19;
import org.screamingsandals.bedwars.api.boss.StatusBar;
import org.screamingsandals.bedwars.api.events.BedWarsGameDisabledEvent;
import org.screamingsandals.bedwars.api.events.BedWarsGameEnabledEvent;
import org.screamingsandals.bedwars.api.events.BedWarsPlayerLastLeaveEvent;
import org.screamingsandals.bedwars.api.events.BedWarsServerRestartEvent;
import org.screamingsandals.bedwars.api.events.BedwarsBedDestroyedMessageSendEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameChangedStatusEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameEndEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameEndingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameStartEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameStartedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameTickEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerBreakBlock;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerBuildBlock;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinTeamEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerRespawnedIngameEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPostRebuildingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPreRebuildingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsResourceSpawnEvent;
import org.screamingsandals.bedwars.api.events.BedwarsTargetBlockDestroyedEvent;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.api.special.SpecialItem;
import org.screamingsandals.bedwars.api.upgrades.UpgradeRegistry;
import org.screamingsandals.bedwars.api.upgrades.UpgradeStorage;
import org.screamingsandals.bedwars.api.utils.DelayFactory;
import org.screamingsandals.bedwars.boss.BossBar18;
import org.screamingsandals.bedwars.boss.BossBarSelector;
import org.screamingsandals.bedwars.boss.XPBar;
import org.screamingsandals.bedwars.commands.StatsCommand;
import org.screamingsandals.bedwars.game.CurrentTeam;
import org.screamingsandals.bedwars.game.GameCreator;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.GameStore;
import org.screamingsandals.bedwars.game.ItemSpawner;
import org.screamingsandals.bedwars.game.ItemSpawnerType;
import org.screamingsandals.bedwars.game.RespawnProtection;
import org.screamingsandals.bedwars.game.Team;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.inventories.TeamSelectorInventory;
import org.screamingsandals.bedwars.lib.debug.Debug;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.nms.entity.EntityUtils;
import org.screamingsandals.bedwars.lib.nms.holograms.Hologram;
import org.screamingsandals.bedwars.lib.nms.utils.ClassStorage;
import org.screamingsandals.bedwars.lib.nms.utils.Version;
import org.screamingsandals.bedwars.lib.sgui.utils.MaterialSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;
import org.screamingsandals.bedwars.lib.signmanager.SignBlock;
import org.screamingsandals.bedwars.listener.Player116ListenerUtils;
import org.screamingsandals.bedwars.region.FlatteningRegion;
import org.screamingsandals.bedwars.region.LegacyRegion;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;
import org.screamingsandals.bedwars.utils.BungeeUtils;
import org.screamingsandals.bedwars.utils.MiscUtils;
import org.screamingsandals.bedwars.utils.Sounds;
import org.screamingsandals.bedwars.utils.SpawnEffects;
import org.screamingsandals.bedwars.utils.Title;

public class Game
implements org.screamingsandals.bedwars.api.game.Game {
    private File file;
    private String name;
    private Location pos1;
    private Location pos2;
    private Location lobbySpawn;
    private Location specSpawn;
    private List<Team> teams = new ArrayList<Team>();
    private List<ItemSpawner> spawners = new ArrayList<ItemSpawner>();
    private Map<Player, RespawnProtection> respawnProtectionMap = new HashMap<Player, RespawnProtection>();
    private int pauseCountdown;
    private int gameTime;
    private int minPlayers;
    private List<GamePlayer> players = new ArrayList<GamePlayer>();
    private World world;
    private List<GameStore> gameStore = new ArrayList<GameStore>();
    private ArenaTime arenaTime = ArenaTime.WORLD;
    private WeatherType arenaWeather = null;
    private BarColor lobbyBossBarColor = null;
    private String lobbyBossBarColorName = null;
    private BarColor gameBossBarColor = null;
    private String gameBossBarColorName = null;
    private String customPrefix = null;
    public static final String COMPASS_ENABLED = "compass-enabled";
    private InGameConfigBooleanConstants compassEnabled = InGameConfigBooleanConstants.INHERIT;
    public static final String JOIN_RANDOM_TEAM_AFTER_LOBBY = "join-randomly-after-lobby-timeout";
    private InGameConfigBooleanConstants joinRandomTeamAfterLobby = InGameConfigBooleanConstants.INHERIT;
    public static final String JOIN_RANDOM_TEAM_ON_JOIN = "join-randomly-on-lobby-join";
    private InGameConfigBooleanConstants joinRandomTeamOnJoin = InGameConfigBooleanConstants.INHERIT;
    public static final String ADD_WOOL_TO_INVENTORY_ON_JOIN = "add-wool-to-inventory-on-join";
    private InGameConfigBooleanConstants addWoolToInventoryOnJoin = InGameConfigBooleanConstants.INHERIT;
    public static final String PREVENT_KILLING_VILLAGERS = "prevent-killing-villagers";
    private InGameConfigBooleanConstants preventKillingVillagers = InGameConfigBooleanConstants.INHERIT;
    public static final String PLAYER_DROPS = "player-drops";
    private InGameConfigBooleanConstants playerDrops = InGameConfigBooleanConstants.INHERIT;
    public static final String FRIENDLY_FIRE = "friendlyfire";
    private InGameConfigBooleanConstants friendlyfire = InGameConfigBooleanConstants.INHERIT;
    public static final String COLORED_LEATHER_BY_TEAM_IN_LOBBY = "in-lobby-colored-leather-by-team";
    private InGameConfigBooleanConstants coloredLeatherByTeamInLobby = InGameConfigBooleanConstants.INHERIT;
    public static final String KEEP_INVENTORY = "keep-inventory-on-death";
    private InGameConfigBooleanConstants keepInventory = InGameConfigBooleanConstants.INHERIT;
    public static final String CRAFTING = "allow-crafting";
    private InGameConfigBooleanConstants crafting = InGameConfigBooleanConstants.INHERIT;
    public static final String GLOBAL_LOBBY_BOSSBAR = "bossbar.lobby.enable";
    public static final String LOBBY_BOSSBAR = "lobbybossbar";
    private InGameConfigBooleanConstants lobbybossbar = InGameConfigBooleanConstants.INHERIT;
    public static final String GLOBAL_GAME_BOSSBAR = "bossbar.game.enable";
    public static final String GAME_BOSSBAR = "bossbar";
    private InGameConfigBooleanConstants gamebossbar = InGameConfigBooleanConstants.INHERIT;
    public static final String GLOBAL_SCOREBOARD = "scoreboard.enable";
    public static final String SCOREBOARD = "scoreboard";
    private InGameConfigBooleanConstants ascoreboard = InGameConfigBooleanConstants.INHERIT;
    public static final String GLOBAL_LOBBY_SCOREBOARD = "lobby-scoreboard.enabled";
    public static final String LOBBY_SCOREBOARD = "lobbyscoreboard";
    private InGameConfigBooleanConstants lobbyscoreboard = InGameConfigBooleanConstants.INHERIT;
    public static final String PREVENT_SPAWNING_MOBS = "prevent-spawning-mobs";
    private InGameConfigBooleanConstants preventSpawningMobs = InGameConfigBooleanConstants.INHERIT;
    public static final String SPAWNER_HOLOGRAMS = "spawner-holograms";
    private InGameConfigBooleanConstants spawnerHolograms = InGameConfigBooleanConstants.INHERIT;
    public static final String SPAWNER_DISABLE_MERGE = "spawner-disable-merge";
    private InGameConfigBooleanConstants spawnerDisableMerge = InGameConfigBooleanConstants.INHERIT;
    public static final String GAME_START_ITEMS = "game-start-items";
    private InGameConfigBooleanConstants gameStartItems = InGameConfigBooleanConstants.INHERIT;
    public static final String PLAYER_RESPAWN_ITEMS = "player-respawn-items";
    private InGameConfigBooleanConstants playerRespawnItems = InGameConfigBooleanConstants.INHERIT;
    public static final String SPAWNER_HOLOGRAMS_COUNTDOWN = "spawner-holograms-countdown";
    private InGameConfigBooleanConstants spawnerHologramsCountdown = InGameConfigBooleanConstants.INHERIT;
    public static final String DAMAGE_WHEN_PLAYER_IS_NOT_IN_ARENA = "damage-when-player-is-not-in-arena";
    private InGameConfigBooleanConstants damageWhenPlayerIsNotInArena = InGameConfigBooleanConstants.INHERIT;
    public static final String REMOVE_UNUSED_TARGET_BLOCKS = "remove-unused-target-blocks";
    private InGameConfigBooleanConstants removeUnusedTargetBlocks = InGameConfigBooleanConstants.INHERIT;
    public static final String ALLOW_BLOCK_FALLING = "allow-block-falling";
    private InGameConfigBooleanConstants allowBlockFalling = InGameConfigBooleanConstants.INHERIT;
    public static final String HOLO_ABOVE_BED = "holo-above-bed";
    private InGameConfigBooleanConstants holoAboveBed = InGameConfigBooleanConstants.INHERIT;
    public static final String SPECTATOR_JOIN = "allow-spectator-join";
    private InGameConfigBooleanConstants spectatorJoin = InGameConfigBooleanConstants.INHERIT;
    public static final String STOP_TEAM_SPAWNERS_ON_DIE = "stop-team-spawners-on-die";
    private InGameConfigBooleanConstants stopTeamSpawnersOnDie = InGameConfigBooleanConstants.INHERIT;
    public static final String GLOBAL_ANCHOR_AUTO_FILL = "target-block.respawn-anchor.fill-on-start";
    public static final String ANCHOR_AUTO_FILL = "anchor-auto-fill";
    private InGameConfigBooleanConstants anchorAutoFill = InGameConfigBooleanConstants.INHERIT;
    public static final String GLOBAL_ANCHOR_DECREASING = "target-block.respawn-anchor.enable-decrease";
    public static final String ANCHOR_DECREASING = "anchor-decreasing";
    private InGameConfigBooleanConstants anchorDecreasing = InGameConfigBooleanConstants.INHERIT;
    public static final String GLOBAL_CAKE_TARGET_BLOCK_EATING = "target-block.cake.destroy-by-eating";
    public static final String CAKE_TARGET_BLOCK_EATING = "cake-target-block-eating";
    private InGameConfigBooleanConstants cakeTargetBlockEating = InGameConfigBooleanConstants.INHERIT;
    public static final String GLOBAL_TARGET_BLOCK_EXPLOSIONS = "target-block.allow-destroying-with-explosions";
    public static final String TARGET_BLOCK_EXPLOSIONS = "target-block-explosions";
    private InGameConfigBooleanConstants targetBlockExplosions = InGameConfigBooleanConstants.INHERIT;
    public boolean gameStartItem;
    public boolean forceGameToStart;
    private boolean preServerRestart = false;
    private GameStatus previousStatus = GameStatus.DISABLED;
    private GameStatus status = GameStatus.DISABLED;
    private GameStatus afterRebuild = GameStatus.WAITING;
    private int countdown = -1;
    private int previousCountdown = -1;
    private int calculatedMaxPlayers;
    private BukkitTask task;
    private List<CurrentTeam> teamsInGame = new ArrayList<CurrentTeam>();
    private Region region = Main.isLegacy() ? new LegacyRegion() : new FlatteningRegion();
    private Scoreboard gameScoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
    private StatusBar statusbar;
    private Map<Location, ItemStack[]> usedChests = new HashMap<Location, ItemStack[]>();
    private List<SpecialItem> activeSpecialItems = new ArrayList<SpecialItem>();
    private List<DelayFactory> activeDelays = new ArrayList<DelayFactory>();
    private List<Hologram> createdHolograms = new ArrayList<Hologram>();
    private Map<ItemSpawner, Hologram> countdownHolograms = new HashMap<ItemSpawner, Hologram>();
    private Map<GamePlayer, Inventory> fakeEnderChests = new HashMap<GamePlayer, Inventory>();
    private int postGameWaiting = 3;
    private boolean preparing = false;
    private TeamSelectorInventory teamSelectorInventory;
    private List<Chunk> chunksWithTickets = new ArrayList<Chunk>();

    private Game() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        if (this.world == null) {
            this.world = world;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Location getPos1() {
        return this.pos1;
    }

    public void setPos1(Location pos1) {
        this.pos1 = pos1;
    }

    @Override
    public Location getPos2() {
        return this.pos2;
    }

    public void setPos2(Location pos2) {
        this.pos2 = pos2;
    }

    @Override
    public Location getLobbySpawn() {
        return this.lobbySpawn;
    }

    public void setLobbySpawn(Location lobbySpawn) {
        this.lobbySpawn = lobbySpawn;
    }

    public int getPauseCountdown() {
        return this.pauseCountdown;
    }

    public void setPauseCountdown(int pauseCountdown) {
        this.pauseCountdown = pauseCountdown;
    }

    @Override
    public int getMinPlayers() {
        return this.minPlayers;
    }

    public boolean checkMinPlayers() {
        return this.players.size() >= this.getMinPlayers();
    }

    public void setMinPlayers(int minPlayers) {
        this.minPlayers = minPlayers;
    }

    public int countPlayers() {
        return this.players.size();
    }

    public int countSpectators() {
        return (int)this.players.stream().filter(t -> t.isSpectator && this.getPlayerTeam((GamePlayer)t) == null).count();
    }

    public int countSpectating() {
        return (int)this.players.stream().filter(t -> t.isSpectator).count();
    }

    public int countRespawnable() {
        return (int)this.players.stream().filter(t -> this.getPlayerTeam((GamePlayer)t) != null).count();
    }

    public int countAlive() {
        return (int)this.players.stream().filter(t -> !t.isSpectator).count();
    }

    @Override
    public List<org.screamingsandals.bedwars.api.game.GameStore> getGameStores() {
        return new ArrayList<org.screamingsandals.bedwars.api.game.GameStore>(this.gameStore);
    }

    public List<GameStore> getGameStoreList() {
        return this.gameStore;
    }

    public Location getSpecSpawn() {
        return this.specSpawn;
    }

    public void setSpecSpawn(Location specSpawn) {
        this.specSpawn = specSpawn;
    }

    @Override
    public int getGameTime() {
        return this.gameTime;
    }

    public void setGameTime(int gameTime) {
        this.gameTime = gameTime;
    }

    @Override
    public org.screamingsandals.bedwars.api.Team getTeamFromName(String name) {
        Team team = null;
        for (Team t : this.getTeams()) {
            if (!t.getName().equalsIgnoreCase(name)) continue;
            team = t;
        }
        return team;
    }

    public List<Team> getTeams() {
        return this.teams;
    }

    public List<ItemSpawner> getSpawners() {
        return this.spawners;
    }

    public void setGameStores(List<GameStore> gameStore) {
        this.gameStore = gameStore;
    }

    public TeamSelectorInventory getTeamSelectorInventory() {
        if (this.teamSelectorInventory == null) {
            this.teamSelectorInventory = new TeamSelectorInventory(Main.getInstance(), this);
        }
        return this.teamSelectorInventory;
    }

    public void openTeamSelectorInventory(Player player) {
        TeamSelectorInventory inventory = this.getTeamSelectorInventory();
        if (inventory != null) {
            inventory.openForPlayer(player);
        }
    }

    @Override
    public boolean isBlockAddedDuringGame(Location loc) {
        return this.status == GameStatus.RUNNING && this.region.isBlockAddedDuringGame(loc);
    }

    public boolean blockPlace(GamePlayer player, Block block, BlockState replaced, ItemStack itemInHand) {
        if (this.status != GameStatus.RUNNING) {
            return false;
        }
        if (player.isSpectator) {
            return false;
        }
        if (Main.isFarmBlock(block.getType())) {
            return true;
        }
        if (!GameCreator.isInArea(block.getLocation(), this.pos1, this.pos2)) {
            return false;
        }
        BedwarsPlayerBuildBlock event = new BedwarsPlayerBuildBlock(this, player.player, this.getPlayerTeam(player), block, itemInHand, replaced);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (replaced.getType() != Material.AIR) {
            if (this.region.isBlockAddedDuringGame(replaced.getLocation())) {
                return true;
            }
            if (Main.isBreakableBlock(replaced.getType()) || this.region.isLiquid(replaced.getType())) {
                this.region.putOriginalBlock(block.getLocation(), replaced);
            } else {
                return false;
            }
        }
        this.region.addBuiltDuringGame(block.getLocation());
        return true;
    }

    public boolean blockBreak(GamePlayer player, Block block, BlockBreakEvent event) {
        if (this.status != GameStatus.RUNNING) {
            return false;
        }
        if (player.isSpectator) {
            return false;
        }
        if (Main.isFarmBlock(block.getType())) {
            return true;
        }
        if (!GameCreator.isInArea(block.getLocation(), this.pos1, this.pos2)) {
            return false;
        }
        BedwarsPlayerBreakBlock breakEvent = new BedwarsPlayerBreakBlock(this, player.player, this.getPlayerTeam(player), block);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)breakEvent);
        if (breakEvent.isCancelled()) {
            return false;
        }
        if (this.region.isBlockAddedDuringGame(block.getLocation())) {
            CurrentTeam team;
            this.region.removeBlockBuiltDuringGame(block.getLocation());
            if (block.getType() == Material.ENDER_CHEST && (team = this.getTeamOfChest(block)) != null) {
                team.removeTeamChest(block);
                String message = I.i18nc("team_chest_broken", this.customPrefix);
                for (GamePlayer gp : team.players) {
                    gp.player.sendMessage(message);
                }
                if (breakEvent.isDrops()) {
                    try {
                        event.setDropItems(false);
                    }
                    catch (Throwable t) {
                        block.setType(Material.AIR);
                    }
                    player.player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENDER_CHEST)});
                }
            }
            if (!breakEvent.isDrops()) {
                try {
                    event.setDropItems(false);
                }
                catch (Throwable tr) {
                    block.setType(Material.AIR);
                }
            }
            return true;
        }
        Location loc = block.getLocation();
        if (this.region.isBedBlock(block.getState())) {
            if (!this.region.isBedHead(block.getState())) {
                loc = this.region.getBedNeighbor(block).getLocation();
            }
        } else if (this.region.isDoorBlock(block.getState()) && !this.region.isDoorBottomBlock(block.getState())) {
            loc.subtract(0.0, 1.0, 0.0);
        }
        if (this.isTargetBlock(loc)) {
            if (this.region.isBedBlock(block.getState())) {
                if (this.getPlayerTeam((GamePlayer)player).teamInfo.bed.equals((Object)loc)) {
                    return false;
                }
                this.bedDestroyed(loc, player.player, true, false, false, false);
                this.region.putOriginalBlock(block.getLocation(), block.getState());
                if (block.getLocation().equals((Object)loc)) {
                    Block neighbor = this.region.getBedNeighbor(block);
                    this.region.putOriginalBlock(neighbor.getLocation(), neighbor.getState());
                } else {
                    this.region.putOriginalBlock(loc, this.region.getBedNeighbor(block).getState());
                }
                try {
                    event.setDropItems(false);
                }
                catch (Throwable tr) {
                    if (this.region.isBedHead(block.getState())) {
                        this.region.getBedNeighbor(block).setType(Material.AIR);
                    }
                    block.setType(Material.AIR);
                }
                return true;
            }
            if (this.region.isDoorBlock(block.getState())) {
                if (this.getPlayerTeam((GamePlayer)player).teamInfo.bed.equals((Object)loc)) {
                    return false;
                }
                this.bedDestroyed(loc, player.player, false, false, false, true);
                this.region.putOriginalBlock(block.getLocation(), block.getState());
                if (block.getLocation().equals((Object)loc)) {
                    Block neighbor = loc.clone().add(0.0, 1.0, 0.0).getBlock();
                    this.region.putOriginalBlock(neighbor.getLocation(), neighbor.getState());
                } else {
                    this.region.putOriginalBlock(loc, loc.clone().add(0.0, 1.0, 0.0).getBlock().getState());
                }
                try {
                    event.setDropItems(false);
                }
                catch (Throwable tr) {
                    if (this.region.isDoorBottomBlock(block.getState())) {
                        loc.clone().add(0.0, 1.0, 0.0).getBlock().setType(Material.AIR);
                    }
                    block.setType(Material.AIR);
                }
                return true;
            }
            if (this.getOriginalOrInheritedCakeTargetBlockEating() && block.getType().name().contains("CAKE")) {
                return false;
            }
            if (this.getPlayerTeam((GamePlayer)player).teamInfo.bed.equals((Object)loc)) {
                return false;
            }
            this.bedDestroyed(loc, player.player, false, "RESPAWN_ANCHOR".equals(block.getType().name()), block.getType().name().contains("CAKE"), false);
            this.region.putOriginalBlock(loc, block.getState());
            try {
                event.setDropItems(false);
            }
            catch (Throwable tr) {
                block.setType(Material.AIR);
            }
            return true;
        }
        if (Main.isBreakableBlock(block.getType())) {
            this.region.putOriginalBlock(block.getLocation(), block.getState());
            return true;
        }
        return false;
    }

    public void targetBlockExplode(RunningTeam team) {
        Location loc = team.getTargetBlock();
        Block block = loc.getBlock();
        if (this.region.isBedBlock(block.getState())) {
            if (!this.region.isBedHead(block.getState())) {
                loc = this.region.getBedNeighbor(block).getLocation();
            }
        } else if (this.region.isDoorBlock(block.getState()) && !this.region.isDoorBottomBlock(block.getState())) {
            loc.subtract(0.0, 1.0, 0.0);
        }
        if (this.isTargetBlock(loc)) {
            if (this.region.isBedBlock(block.getState())) {
                this.bedDestroyed(loc, null, true, false, false, false);
                this.region.putOriginalBlock(block.getLocation(), block.getState());
                if (block.getLocation().equals((Object)loc)) {
                    Block neighbor = this.region.getBedNeighbor(block);
                    this.region.putOriginalBlock(neighbor.getLocation(), neighbor.getState());
                } else {
                    this.region.putOriginalBlock(loc, this.region.getBedNeighbor(block).getState());
                }
                this.region.getBedNeighbor(block).setType(Material.AIR, false);
                block.setType(Material.AIR, false);
            } else if (this.region.isDoorBlock(block.getState())) {
                this.bedDestroyed(loc, null, false, false, false, true);
                this.region.putOriginalBlock(block.getLocation(), block.getState());
                if (block.getLocation().equals((Object)loc)) {
                    Block neighbor = loc.clone().add(0.0, 1.0, 0.0).getBlock();
                    this.region.putOriginalBlock(neighbor.getLocation(), neighbor.getState());
                } else {
                    this.region.putOriginalBlock(loc, loc.clone().add(0.0, 1.0, 0.0).getBlock().getState());
                }
                loc.clone().add(0.0, 1.0, 0.0).getBlock().setType(Material.AIR, false);
                loc.getBlock().setType(Material.AIR, false);
            } else {
                this.bedDestroyed(loc, null, false, "RESPAWN_ANCHOR".equals(block.getType().name()), block.getType().name().contains("CAKE"), false);
                this.region.putOriginalBlock(loc, block.getState());
                block.setType(Material.AIR);
            }
        }
    }

    private boolean isTargetBlock(Location loc) {
        for (CurrentTeam team : this.teamsInGame) {
            if (!team.isBed || !team.teamInfo.bed.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public CurrentTeam getPlayerTeam(GamePlayer player) {
        for (CurrentTeam team : this.teamsInGame) {
            if (!team.players.contains(player)) continue;
            return team;
        }
        return null;
    }

    public CurrentTeam getCurrentTeamFromTeam(org.screamingsandals.bedwars.api.Team team) {
        for (CurrentTeam currentTeam : this.teamsInGame) {
            if (currentTeam.teamInfo != team) continue;
            return currentTeam;
        }
        return null;
    }

    public void bedDestroyed(Location loc, Player broker, boolean isItBedBlock, boolean isItAnchor, boolean isItCake, boolean isItDoor) {
        if (this.status == GameStatus.RUNNING) {
            for (CurrentTeam team : this.teamsInGame) {
                if (!team.teamInfo.bed.equals((Object)loc)) continue;
                team.isBed = false;
                this.updateScoreboard();
                String colored_broker = "explosion";
                if (broker != null) {
                    colored_broker = this.getPlayerTeam((GamePlayer)Main.getPlayerGameProfile((Player)broker)).teamInfo.color.chatColor + broker.getDisplayName();
                }
                for (GamePlayer player : this.players) {
                    String key = isItDoor ? "door_is_destroyed" : (isItBedBlock ? "bed_is_destroyed" : (isItAnchor ? "anchor_is_destroyed" : (isItCake ? "cake_is_destroyed" : "target_is_destroyed")));
                    Title.send(player.player, I.i18n(key, false).replace("%team%", team.teamInfo.color.chatColor + team.teamInfo.name).replace("%broker%", colored_broker), I.i18n(this.getPlayerTeam(player) == team ? "bed_is_destroyed_subtitle_for_victim" : "bed_is_destroyed_subtitle", false));
                    String destroyedMessage = I.i18nc(key, this.customPrefix).replace("%team%", team.teamInfo.color.chatColor + team.teamInfo.name).replace("%broker%", colored_broker);
                    BedwarsBedDestroyedMessageSendEvent bbdmsEvent = new BedwarsBedDestroyedMessageSendEvent(broker, player.player, this, team.teamInfo, destroyedMessage);
                    Bukkit.getServer().getPluginManager().callEvent((Event)bbdmsEvent);
                    if (!bbdmsEvent.isCancelled()) {
                        player.player.sendMessage(bbdmsEvent.getMessage());
                    }
                    SpawnEffects.spawnEffect(this, player.player, "game-effects.beddestroy");
                    if (this.getPlayerTeam(player) == team) {
                        Sounds.playSound(player.player, player.player.getLocation(), Main.getConfigurator().config.getString("sounds.my_bed_destroyed.sound"), Sounds.ENTITY_ENDER_DRAGON_GROWL, (float)Main.getConfigurator().config.getDouble("sounds.my_bed_destroyed.volume"), (float)Main.getConfigurator().config.getDouble("sounds.bed_destroyed.pitch"));
                        continue;
                    }
                    Sounds.playSound(player.player, player.player.getLocation(), Main.getConfigurator().config.getString("sounds.bed_destroyed.sound"), Sounds.ENTITY_ENDER_DRAGON_GROWL, (float)Main.getConfigurator().config.getDouble("sounds.bed_destroyed.volume"), (float)Main.getConfigurator().config.getDouble("sounds.bed_destroyed.pitch"));
                }
                if (team.hasBedHolo()) {
                    team.getBedHolo().setLine(0, I.i18nonly(isItDoor ? "protect_your_door_destroyed" : (isItBedBlock ? "protect_your_bed_destroyed" : (isItAnchor ? "protect_your_anchor_destroyed" : (isItCake ? "protect_your_cake_destroyed" : "protect_your_target_destroyed")))));
                    team.getBedHolo().addViewers(team.getConnectedPlayers());
                }
                if (team.hasProtectHolo()) {
                    team.getProtectHolo().destroy();
                }
                BedwarsTargetBlockDestroyedEvent targetBlockDestroyed = new BedwarsTargetBlockDestroyedEvent(this, broker, team);
                Main.getInstance().getServer().getPluginManager().callEvent((Event)targetBlockDestroyed);
                if (broker == null) continue;
                if (Main.isPlayerStatisticsEnabled()) {
                    PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)broker);
                    statistic.addDestroyedBeds(1);
                    statistic.addScore(Main.getConfigurator().config.getInt("statistics.scores.bed-destroy", 25));
                    Main.depositPlayer(broker, Main.getVaultBedDestroyReward());
                }
                this.dispatchRewardCommands("player-destroy-bed", broker, Main.getConfigurator().config.getInt("statistics.scores.bed-destroy", 25), (CurrentTeam)this.getTeamOfPlayer(broker), null, null);
            }
        }
    }

    public void internalJoinPlayer(GamePlayer gamePlayer) {
        BedwarsPlayerJoinEvent joinEvent = new BedwarsPlayerJoinEvent(this, gamePlayer.player);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)joinEvent);
        if (joinEvent.isCancelled()) {
            String message = joinEvent.getCancelMessage();
            if (message != null && !message.equals("")) {
                gamePlayer.player.sendMessage(message);
            }
            gamePlayer.changeGame(null);
            return;
        }
        boolean isEmpty = this.players.isEmpty();
        if (!this.players.contains(gamePlayer)) {
            this.players.add(gamePlayer);
        }
        this.updateSigns();
        if (Main.isPlayerStatisticsEnabled()) {
            Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)gamePlayer.player);
        }
        if (this.arenaTime.time >= 0) {
            gamePlayer.player.setPlayerTime((long)this.arenaTime.time, false);
        }
        if (this.arenaWeather != null) {
            gamePlayer.player.setPlayerWeather(this.arenaWeather);
        }
        if (Main.getTabManager() != null) {
            this.players.forEach(Main.getTabManager()::modifyForPlayer);
        }
        if (Main.getConfigurator().config.getBoolean("tab.enable") && Main.getConfigurator().config.getBoolean("tab.hide-foreign-players")) {
            Bukkit.getOnlinePlayers().stream().filter(p -> Main.getInstance().getGameOfPlayer((Player)p) != this).forEach(gamePlayer::hidePlayer);
            this.players.forEach(p -> p.showPlayer(gamePlayer.player));
        }
        if (this.status == GameStatus.WAITING) {
            I.mpr("join").prefix(this.customPrefix).replace("name", gamePlayer.player.getDisplayName()).replace("players", this.players.size()).replace("maxplayers", this.calculatedMaxPlayers).send(this.getConnectedPlayers());
            gamePlayer.teleport(this.lobbySpawn, () -> {
                int vipPosition;
                int leavePosition;
                int compassPosition;
                gamePlayer.invClean();
                SpawnEffects.spawnEffect(this, gamePlayer.player, "game-effects.lobbyjoin");
                if (this.getOriginalOrInheritedJoinRandomTeamOnJoin()) {
                    this.joinRandomTeam(gamePlayer);
                }
                if (this.getOriginalOrInheritedCompassEnabled() && (compassPosition = Main.getConfigurator().config.getInt("hotbar.selector", 0)) >= 0 && compassPosition <= 8) {
                    ItemStack compass = Main.getConfigurator().readDefinedItem("jointeam", "COMPASS");
                    ItemMeta metaCompass = compass.getItemMeta();
                    metaCompass.setDisplayName(I.i18n("compass_selector_team", false));
                    compass.setItemMeta(metaCompass);
                    gamePlayer.player.getInventory().setItem(compassPosition, compass);
                }
                if ((leavePosition = Main.getConfigurator().config.getInt("hotbar.leave", 8)) >= 0 && leavePosition <= 8) {
                    ItemStack leave = Main.getConfigurator().readDefinedItem("leavegame", "SLIME_BALL");
                    ItemMeta leaveMeta = leave.getItemMeta();
                    leaveMeta.setDisplayName(I.i18n("leave_from_game_item", false));
                    leave.setItemMeta(leaveMeta);
                    gamePlayer.player.getInventory().setItem(leavePosition, leave);
                }
                if ((gamePlayer.player.hasPermission("bw.vip.startitem") || gamePlayer.player.hasPermission("misat11.bw.vip.startitem")) && (vipPosition = Main.getConfigurator().config.getInt("hotbar.start", 1)) >= 0 && vipPosition <= 8) {
                    ItemStack startGame = Main.getConfigurator().readDefinedItem("startgame", "DIAMOND");
                    ItemMeta startGameMeta = startGame.getItemMeta();
                    startGameMeta.setDisplayName(I.i18n("start_game_item", false));
                    startGame.setItemMeta(startGameMeta);
                    gamePlayer.player.getInventory().setItem(vipPosition, startGame);
                }
            });
            if (isEmpty) {
                this.runTask();
            } else {
                this.statusbar.addPlayer(gamePlayer.player);
            }
        }
        if (this.status == GameStatus.RUNNING || this.status == GameStatus.GAME_END_CELEBRATING) {
            if (Main.getConfigurator().config.getBoolean("tab.enable") && Main.getConfigurator().config.getBoolean("tab.hide-spectators")) {
                this.players.stream().filter(p -> p.isSpectator && !this.isPlayerInAnyTeam(p.player)).forEach(p -> gamePlayer.hidePlayer(p.player));
            }
            this.makeSpectator(gamePlayer, true);
            this.createdHolograms.forEach(hologram -> {
                if (this.teamsInGame.stream().noneMatch(t -> t.getProtectHolo().equals(hologram))) {
                    hologram.addViewer(gamePlayer.player);
                }
            });
        }
        BedwarsPlayerJoinedEvent joinedEvent = new BedwarsPlayerJoinedEvent(this, this.getPlayerTeam(gamePlayer), gamePlayer.player);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)joinedEvent);
    }

    public void internalLeavePlayer(GamePlayer gamePlayer) {
        if (this.status == GameStatus.DISABLED) {
            return;
        }
        BedwarsPlayerLeaveEvent playerLeaveEvent = new BedwarsPlayerLeaveEvent(this, gamePlayer.player, this.getPlayerTeam(gamePlayer));
        Main.getInstance().getServer().getPluginManager().callEvent((Event)playerLeaveEvent);
        if (!gamePlayer.isSpectator) {
            String message = I.i18nc("leave", this.customPrefix).replace("%name%", gamePlayer.player.getDisplayName()).replace("%players%", Integer.toString(this.players.size())).replace("%maxplayers%", Integer.toString(this.calculatedMaxPlayers));
            if (!this.preServerRestart) {
                for (GamePlayer p2 : this.players) {
                    p2.player.sendMessage(message);
                }
            }
        } else if (gamePlayer.player.getSpectatorTarget() != null) {
            gamePlayer.player.setSpectatorTarget(null);
        }
        this.players.remove(gamePlayer);
        this.updateSigns();
        if (this.status == GameStatus.WAITING) {
            SpawnEffects.spawnEffect(this, gamePlayer.player, "game-effects.lobbyleave");
        }
        if (Main.getTabManager() != null) {
            Main.getTabManager().clear(gamePlayer);
            this.players.forEach(Main.getTabManager()::modifyForPlayer);
        }
        if (Main.getConfigurator().config.getBoolean("tab.enable") && Main.getConfigurator().config.getBoolean("tab.hide-foreign-players")) {
            this.players.forEach(p -> p.hidePlayer(gamePlayer.player));
        }
        this.statusbar.removePlayer(gamePlayer.player);
        this.createdHolograms.forEach(holo -> holo.removeViewer(gamePlayer.player));
        gamePlayer.player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        if (Main.getConfigurator().config.getBoolean("mainlobby.enabled") && !Main.getConfigurator().config.getBoolean("bungee.enabled")) {
            try {
                Location mainLobbyLocation = MiscUtils.readLocationFromString(Bukkit.getWorld((String)Main.getConfigurator().config.getString("mainlobby.world")), Main.getConfigurator().config.getString("mainlobby.location"));
                gamePlayer.teleport(mainLobbyLocation);
                gamePlayer.mainLobbyUsed = true;
            }
            catch (Throwable t) {
                Bukkit.getLogger().severe("You didn't setup properly the mainlobby! Do it via commands not directly in config.yml");
            }
        }
        if (this.status == GameStatus.RUNNING || this.status == GameStatus.WAITING) {
            CurrentTeam team = this.getPlayerTeam(gamePlayer);
            if (team != null) {
                team.players.remove(gamePlayer);
                if (this.status == GameStatus.WAITING) {
                    team.getScoreboardTeam().removeEntry(gamePlayer.player.getName());
                    if (team.players.isEmpty()) {
                        this.teamsInGame.remove(team);
                        team.getScoreboardTeam().unregister();
                    }
                } else {
                    this.updateScoreboard();
                }
            }
            if (this.status == GameStatus.RUNNING) {
                this.dispatchRewardCommands("player-early-leave", gamePlayer.player, 0, team, gamePlayer.isSpectator, null);
            }
        }
        if (Main.isPlayerStatisticsEnabled()) {
            PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)gamePlayer.player);
            Main.getPlayerStatisticsManager().storeStatistic(statistic);
            Main.getPlayerStatisticsManager().unloadStatistic((OfflinePlayer)gamePlayer.player);
        }
        if (this.players.isEmpty()) {
            if (!this.preServerRestart) {
                BedWarsPlayerLastLeaveEvent playerLastLeaveEvent = new BedWarsPlayerLastLeaveEvent(this, gamePlayer.player, this.getPlayerTeam(gamePlayer));
                Main.getInstance().getServer().getPluginManager().callEvent((Event)playerLastLeaveEvent);
            }
            if (this.status != GameStatus.WAITING) {
                this.afterRebuild = GameStatus.WAITING;
                this.updateSigns();
                this.rebuild();
            } else {
                this.status = GameStatus.WAITING;
                this.cancelTask();
            }
            this.countdown = -1;
            if (this.gameScoreboard.getObjective("display") != null) {
                this.gameScoreboard.getObjective("display").unregister();
            }
            if (this.gameScoreboard.getObjective("lobby") != null) {
                this.gameScoreboard.getObjective("lobby").unregister();
            }
            this.gameScoreboard.clearSlot(DisplaySlot.SIDEBAR);
            for (CurrentTeam team : this.teamsInGame) {
                team.getScoreboardTeam().unregister();
            }
            this.teamsInGame.clear();
            for (GameStore store : this.gameStore) {
                LivingEntity villager = store.kill();
                if (villager == null) continue;
                Main.unregisterGameEntity((Entity)villager);
            }
        }
    }

    public static Game loadGame(File file) {
        return Game.loadGame(file, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Game loadGame(File file, boolean firstAttempt) {
        try {
            World lobbySpawnWorld;
            Game game;
            YamlConfiguration configMap;
            block28: {
                String worldName;
                block27: {
                    if (!file.exists()) {
                        return null;
                    }
                    configMap = new YamlConfiguration();
                    try {
                        configMap.load(file);
                    }
                    catch (IOException | InvalidConfigurationException e) {
                        e.printStackTrace();
                        return null;
                    }
                    game = new Game();
                    game.file = file;
                    game.name = configMap.getString("name");
                    game.pauseCountdown = configMap.getInt("pauseCountdown");
                    game.gameTime = configMap.getInt("gameTime");
                    worldName = configMap.getString("world");
                    game.world = Bukkit.getWorld((String)worldName);
                    if (game.world == null) {
                        if (Bukkit.getPluginManager().isPluginEnabled("Multiverse-Core")) {
                            Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7cWorld " + worldName + " was not found, but we found Multiverse-Core, so we will try to load this world.");
                            Core multiverse = (Core)Bukkit.getPluginManager().getPlugin("Multiverse-Core");
                            if (multiverse != null && multiverse.getMVWorldManager().loadWorld(worldName)) {
                                Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7aWorld " + worldName + " was succesfully loaded with Multiverse-Core, continue in arena loading.");
                                game.world = Bukkit.getWorld((String)worldName);
                                break block27;
                            } else {
                                Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7cArena " + game.name + " can't be loaded, because world " + worldName + " is missing!");
                                return null;
                            }
                        }
                        if (firstAttempt) {
                            Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7eArena " + game.name + " can't be loaded, because world " + worldName + " is missing! We will try it again after all plugins will be loaded!");
                            Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> Game.loadGame(file, false), 10L);
                            return null;
                        }
                        Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7cArena " + game.name + " can't be loaded, because world " + worldName + " is missing!");
                        return null;
                    }
                }
                if (Main.getVersionNumber() >= 115) {
                    game.world.setGameRule(GameRule.DO_IMMEDIATE_RESPAWN, (Object)true);
                }
                if (Version.isVersion(1, 21, 6) && Main.getConfigurator().config.getBoolean("disable-locator-bars-in-arena-worlds")) {
                    game.world.setGameRule(GameRule.getByName((String)"locatorBar"), (Object)false);
                }
                game.pos1 = MiscUtils.readLocationFromString(game.world, configMap.getString("pos1"));
                game.pos2 = MiscUtils.readLocationFromString(game.world, configMap.getString("pos2"));
                game.specSpawn = MiscUtils.readLocationFromString(game.world, configMap.getString("specSpawn"));
                String spawnWorld = configMap.getString("lobbySpawnWorld");
                lobbySpawnWorld = Bukkit.getWorld((String)spawnWorld);
                if (lobbySpawnWorld == null) {
                    if (Bukkit.getPluginManager().isPluginEnabled("Multiverse-Core")) {
                        Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7cWorld " + spawnWorld + " was not found, but we found Multiverse-Core, so we will try to load this world.");
                        Core multiverse = (Core)Bukkit.getPluginManager().getPlugin("Multiverse-Core");
                        if (multiverse != null && multiverse.getMVWorldManager().loadWorld(spawnWorld)) {
                            Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7aWorld " + spawnWorld + " was succesfully loaded with Multiverse-Core, continue in arena loading.");
                            lobbySpawnWorld = Bukkit.getWorld((String)spawnWorld);
                            break block28;
                        } else {
                            Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7cArena " + game.name + " can't be loaded, because world " + spawnWorld + " is missing!");
                            return null;
                        }
                    }
                    if (firstAttempt) {
                        Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7eArena " + game.name + " can't be loaded, because world " + worldName + " is missing! We will try it again after all plugins will be loaded!");
                        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> Game.loadGame(file, false), 10L);
                        return null;
                    }
                    Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7cArena " + game.name + " can't be loaded, because world " + spawnWorld + " is missing!");
                    return null;
                }
            }
            game.lobbySpawn = MiscUtils.readLocationFromString(lobbySpawnWorld, configMap.getString("lobbySpawn"));
            game.minPlayers = configMap.getInt("minPlayers", 2);
            if (configMap.isSet("teams")) {
                for (String teamN : configMap.getConfigurationSection("teams").getKeys(false)) {
                    ConfigurationSection team = configMap.getConfigurationSection("teams").getConfigurationSection(teamN);
                    Team t = new Team();
                    t.newColor = team.getBoolean("isNewColor", false);
                    t.color = TeamColor.valueOf(MiscUtils.convertColorToNewFormat(team.getString("color"), t));
                    t.name = team.getString("actualName", teamN);
                    t.saveName = teamN;
                    t.bed = MiscUtils.readLocationFromString(game.world, team.getString("bed"));
                    t.maxPlayers = team.getInt("maxPlayers");
                    t.spawn = MiscUtils.readLocationFromString(game.world, team.getString("spawn"));
                    t.game = game;
                    t.newColor = true;
                    game.teams.add(t);
                }
            }
            if (configMap.isSet("spawners")) {
                List spawners = configMap.getList("spawners");
                for (Map spawner : spawners) {
                    ItemSpawner sa = new ItemSpawner(MiscUtils.readLocationFromString(game.world, (String)spawner.get("location")), Main.getSpawnerType(((String)spawner.get("type")).toLowerCase()), (String)spawner.get("customName"), spawner.getOrDefault("hologramEnabled", true), ((Number)spawner.getOrDefault("startLevel", 1)).doubleValue(), game.getTeamFromName((String)spawner.get("team")), spawner.getOrDefault("maxSpawnedResources", -1));
                    if (sa.type == null) {
                        sa.declaredSpawnerType = (String)spawner.get("type");
                        Main.getInstance().getLogger().warning("There is an unknown spawner type " + sa.declaredSpawnerType + " defined in game " + game.name + " on location " + spawner.get("location"));
                    }
                    game.spawners.add(sa);
                }
            }
            if (configMap.isSet("stores")) {
                List stores = configMap.getList("stores");
                for (Object store : stores) {
                    if (store instanceof Map) {
                        Map map = (Map)store;
                        game.gameStore.add(new GameStore(MiscUtils.readLocationFromString(game.world, (String)map.get("loc")), (String)map.get("shop"), "true".equals(map.getOrDefault("parent", "true")), EntityType.valueOf((String)map.getOrDefault("type", "VILLAGER").toUpperCase()), map.getOrDefault("name", ""), map.containsKey("name"), "true".equals(map.getOrDefault("isBaby", "false")), (String)map.get("skin"), game.getTeamFromName((String)map.get("team"))));
                        continue;
                    }
                    if (!(store instanceof String)) continue;
                    game.gameStore.add(new GameStore(MiscUtils.readLocationFromString(game.world, (String)store), null, true, EntityType.VILLAGER, "", false, false, null, null));
                }
            }
            game.compassEnabled = Game.readBooleanConstant(configMap.getString("constant.compass-enabled", "inherit"));
            game.addWoolToInventoryOnJoin = Game.readBooleanConstant(configMap.getString("constant.add-wool-to-inventory-on-join", "inherit"));
            game.coloredLeatherByTeamInLobby = Game.readBooleanConstant(configMap.getString("constant.in-lobby-colored-leather-by-team", "inherit"));
            game.crafting = Game.readBooleanConstant(configMap.getString("constant.allow-crafting", "inherit"));
            game.friendlyfire = Game.readBooleanConstant(configMap.getString("constant.friendlyfire", "inherit"));
            game.joinRandomTeamAfterLobby = Game.readBooleanConstant(configMap.getString("constant.join-randomly-after-lobby-timeout", "inherit"));
            game.joinRandomTeamOnJoin = Game.readBooleanConstant(configMap.getString("constant.join-randomly-on-lobby-join", "inherit"));
            game.keepInventory = Game.readBooleanConstant(configMap.getString("constant.keep-inventory-on-death", "inherit"));
            game.preventKillingVillagers = Game.readBooleanConstant(configMap.getString("constant.prevent-killing-villagers", "inherit"));
            game.playerDrops = Game.readBooleanConstant(configMap.getString("constant.player-drops", "inherit"));
            game.lobbybossbar = Game.readBooleanConstant(configMap.getString("constant.lobbybossbar", "inherit"));
            game.gamebossbar = Game.readBooleanConstant(configMap.getString("constant.bossbar", "inherit"));
            game.ascoreboard = Game.readBooleanConstant(configMap.getString("constant.scoreboard", "inherit"));
            game.lobbyscoreboard = Game.readBooleanConstant(configMap.getString("constant.lobbyscoreboard", "inherit"));
            game.preventSpawningMobs = Game.readBooleanConstant(configMap.getString("constant.prevent-spawning-mobs", "inherit"));
            game.spawnerHolograms = Game.readBooleanConstant(configMap.getString("constant.spawner-holograms", "inherit"));
            game.spawnerDisableMerge = Game.readBooleanConstant(configMap.getString("constant.spawner-disable-merge", "inherit"));
            game.gameStartItems = Game.readBooleanConstant(configMap.getString("constant.game-start-items", "inherit"));
            game.playerRespawnItems = Game.readBooleanConstant(configMap.getString("constant.player-respawn-items", "inherit"));
            game.spawnerHologramsCountdown = Game.readBooleanConstant(configMap.getString("constant.spawner-holograms-countdown", "inherit"));
            game.damageWhenPlayerIsNotInArena = Game.readBooleanConstant(configMap.getString("constant.damage-when-player-is-not-in-arena", "inherit"));
            game.removeUnusedTargetBlocks = Game.readBooleanConstant(configMap.getString("constant.remove-unused-target-blocks", "inherit"));
            game.allowBlockFalling = Game.readBooleanConstant(configMap.getString("constant.allow-block-falling", "inherit"));
            game.holoAboveBed = Game.readBooleanConstant(configMap.getString("constant.holo-above-bed", "inherit"));
            game.spectatorJoin = Game.readBooleanConstant(configMap.getString("constant.allow-spectator-join", "inherit"));
            game.anchorAutoFill = Game.readBooleanConstant(configMap.getString("constant.anchor-auto-fill", "inherit"));
            game.anchorDecreasing = Game.readBooleanConstant(configMap.getString("constant.anchor-decreasing", "inherit"));
            game.cakeTargetBlockEating = Game.readBooleanConstant(configMap.getString("constant.cake-target-block-eating", "inherit"));
            game.targetBlockExplosions = Game.readBooleanConstant(configMap.getString("constant.target-block-explosions", "inherit"));
            game.arenaTime = ArenaTime.valueOf(configMap.getString("arenaTime", ArenaTime.WORLD.name()).toUpperCase());
            game.arenaWeather = Game.loadWeather(configMap.getString("arenaWeather", "default").toUpperCase());
            game.postGameWaiting = configMap.getInt("postGameWaiting", 3);
            game.customPrefix = configMap.getString("customPrefix", null);
            game.lobbyBossBarColorName = configMap.getString("lobbyBossBarColor", "default");
            game.gameBossBarColorName = configMap.getString("gameBossBarColor", "default");
            try {
                game.lobbyBossBarColor = Game.loadBossBarColor(game.lobbyBossBarColorName.toUpperCase());
                game.gameBossBarColor = Game.loadBossBarColor(game.gameBossBarColorName.toUpperCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Main.addGame(game);
            game.start();
            Bukkit.getConsoleSender().sendMessage("\u00a7c[B\u00a7fW] \u00a7aArena \u00a7f" + game.name + "\u00a7a loaded!");
            return game;
        }
        catch (Throwable throwable) {
            Debug.warn("Something went wrong while loading arena file " + file.getName() + ". Please report this to our Discord or GitHub!", true);
            throwable.printStackTrace();
            return null;
        }
    }

    public static WeatherType loadWeather(String weather) {
        try {
            return WeatherType.valueOf((String)weather);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BarColor loadBossBarColor(String color) {
        try {
            return BarColor.valueOf((String)color);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InGameConfigBooleanConstants readBooleanConstant(String s) {
        if ("true".equalsIgnoreCase(s)) {
            return InGameConfigBooleanConstants.TRUE;
        }
        if ("false".equalsIgnoreCase(s)) {
            return InGameConfigBooleanConstants.FALSE;
        }
        return InGameConfigBooleanConstants.INHERIT;
    }

    public static String writeBooleanConstant(InGameConfigBooleanConstants constant) {
        switch (constant) {
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
        }
        return "inherit";
    }

    public void saveToConfig() {
        File dir = Main.getInstance().getDataFolder().toPath().resolve("arenas").toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (this.file == null) {
            do {
                this.file = new File(dir, UUID.randomUUID() + ".yml");
            } while (this.file.exists());
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration configMap = new YamlConfiguration();
        configMap.set("name", (Object)this.name);
        configMap.set("pauseCountdown", (Object)this.pauseCountdown);
        configMap.set("gameTime", (Object)this.gameTime);
        configMap.set("world", (Object)this.world.getName());
        configMap.set("pos1", (Object)MiscUtils.setLocationToString(this.pos1));
        configMap.set("pos2", (Object)MiscUtils.setLocationToString(this.pos2));
        configMap.set("specSpawn", (Object)MiscUtils.setLocationToString(this.specSpawn));
        configMap.set("lobbySpawn", (Object)MiscUtils.setLocationToString(this.lobbySpawn));
        configMap.set("lobbySpawnWorld", (Object)this.lobbySpawn.getWorld().getName());
        configMap.set("minPlayers", (Object)this.minPlayers);
        configMap.set("postGameWaiting", (Object)this.postGameWaiting);
        configMap.set("customPrefix", (Object)this.customPrefix);
        if (!this.teams.isEmpty()) {
            for (Team team : this.teams) {
                String name = team.getSaveName();
                configMap.set("teams." + name + ".isNewColor", (Object)team.isNewColor());
                configMap.set("teams." + name + ".color", (Object)team.color.name());
                configMap.set("teams." + name + ".maxPlayers", (Object)team.maxPlayers);
                configMap.set("teams." + name + ".bed", (Object)MiscUtils.setLocationToString(team.bed));
                configMap.set("teams." + name + ".spawn", (Object)MiscUtils.setLocationToString(team.spawn));
                configMap.set("teams." + name + ".actualName", (Object)team.name);
            }
        }
        ArrayList nS = new ArrayList();
        for (ItemSpawner spawner : this.spawners) {
            HashMap<String, Object> spawnerMap = new HashMap<String, Object>();
            spawnerMap.put("location", MiscUtils.setLocationToString(spawner.loc));
            spawnerMap.put("type", spawner.type != null ? spawner.type.getConfigKey() : spawner.declaredSpawnerType);
            spawnerMap.put("customName", spawner.customName);
            spawnerMap.put("startLevel", spawner.startLevel);
            spawnerMap.put("hologramEnabled", spawner.hologramEnabled);
            if (spawner.getTeam() != null) {
                spawnerMap.put("team", spawner.getTeam().getName());
            } else {
                spawnerMap.put("team", null);
            }
            spawnerMap.put("maxSpawnedResources", spawner.maxSpawnedResources);
            nS.add(spawnerMap);
        }
        configMap.set("spawners", nS);
        if (!this.gameStore.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            for (GameStore store : this.gameStore) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("loc", MiscUtils.setLocationToString(store.getStoreLocation()));
                map.put("shop", store.getShopFile());
                map.put("parent", store.getUseParent() ? "true" : "false");
                map.put("type", store.getEntityType().name());
                if (store.isShopCustomName()) {
                    map.put("name", store.getShopCustomName());
                }
                map.put("isBaby", store.isBaby() ? "true" : "false");
                map.put("skin", store.getSkinName());
                if (store.getTeam() != null) {
                    map.put("team", store.getTeam().getName());
                } else {
                    map.put("team", null);
                }
                arrayList.add(map);
            }
            configMap.set("stores", arrayList);
        }
        configMap.set("constant.compass-enabled", (Object)Game.writeBooleanConstant(this.compassEnabled));
        configMap.set("constant.add-wool-to-inventory-on-join", (Object)Game.writeBooleanConstant(this.addWoolToInventoryOnJoin));
        configMap.set("constant.in-lobby-colored-leather-by-team", (Object)Game.writeBooleanConstant(this.coloredLeatherByTeamInLobby));
        configMap.set("constant.allow-crafting", (Object)Game.writeBooleanConstant(this.crafting));
        configMap.set("constant.join-randomly-after-lobby-timeout", (Object)Game.writeBooleanConstant(this.joinRandomTeamAfterLobby));
        configMap.set("constant.join-randomly-on-lobby-join", (Object)Game.writeBooleanConstant(this.joinRandomTeamOnJoin));
        configMap.set("constant.keep-inventory-on-death", (Object)Game.writeBooleanConstant(this.keepInventory));
        configMap.set("constant.prevent-killing-villagers", (Object)Game.writeBooleanConstant(this.preventKillingVillagers));
        configMap.set("constant.player-drops", (Object)Game.writeBooleanConstant(this.playerDrops));
        configMap.set("constant.friendlyfire", (Object)Game.writeBooleanConstant(this.friendlyfire));
        configMap.set("constant.lobbybossbar", (Object)Game.writeBooleanConstant(this.lobbybossbar));
        configMap.set("constant.bossbar", (Object)Game.writeBooleanConstant(this.gamebossbar));
        configMap.set("constant.lobbyscoreboard", (Object)Game.writeBooleanConstant(this.lobbyscoreboard));
        configMap.set("constant.scoreboard", (Object)Game.writeBooleanConstant(this.ascoreboard));
        configMap.set("constant.prevent-spawning-mobs", (Object)Game.writeBooleanConstant(this.preventSpawningMobs));
        configMap.set("constant.spawner-holograms", (Object)Game.writeBooleanConstant(this.spawnerHolograms));
        configMap.set("constant.spawner-disable-merge", (Object)Game.writeBooleanConstant(this.spawnerDisableMerge));
        configMap.set("constant.game-start-items", (Object)Game.writeBooleanConstant(this.gameStartItems));
        configMap.set("constant.player-respawn-items", (Object)Game.writeBooleanConstant(this.playerRespawnItems));
        configMap.set("constant.spawner-holograms-countdown", (Object)Game.writeBooleanConstant(this.spawnerHologramsCountdown));
        configMap.set("constant.damage-when-player-is-not-in-arena", (Object)Game.writeBooleanConstant(this.damageWhenPlayerIsNotInArena));
        configMap.set("constant.remove-unused-target-blocks", (Object)Game.writeBooleanConstant(this.removeUnusedTargetBlocks));
        configMap.set("constant.allow-block-falling", (Object)Game.writeBooleanConstant(this.allowBlockFalling));
        configMap.set("constant.holo-above-bed", (Object)Game.writeBooleanConstant(this.holoAboveBed));
        configMap.set("constant.allow-spectator-join", (Object)Game.writeBooleanConstant(this.spectatorJoin));
        configMap.set("constant.anchor-auto-fill", (Object)Game.writeBooleanConstant(this.anchorAutoFill));
        configMap.set("constant.anchor-decreasing", (Object)Game.writeBooleanConstant(this.anchorDecreasing));
        configMap.set("constant.cake-target-block-eating", (Object)Game.writeBooleanConstant(this.cakeTargetBlockEating));
        configMap.set("constant.target-block-explosions", (Object)Game.writeBooleanConstant(this.targetBlockExplosions));
        configMap.set("arenaTime", (Object)this.arenaTime.name());
        configMap.set("arenaWeather", (Object)(this.arenaWeather == null ? "default" : this.arenaWeather.name()));
        try {
            configMap.set("lobbyBossBarColor", (Object)(this.lobbyBossBarColor == null ? "default" : this.lobbyBossBarColor.name()));
            configMap.set("gameBossBarColor", (Object)(this.gameBossBarColor == null ? "default" : this.gameBossBarColor.name()));
        }
        catch (Throwable throwable) {
            configMap.set("lobbyBossBarColor", (Object)(this.lobbyBossBarColorName == null ? "default" : this.lobbyBossBarColorName));
            configMap.set("gameBossBarColor", (Object)(this.gameBossBarColorName == null ? "default" : this.gameBossBarColorName));
        }
        try {
            configMap.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Game createGame(String name) {
        Game game = new Game();
        game.name = name;
        game.pauseCountdown = 60;
        game.gameTime = 3600;
        game.minPlayers = 2;
        return game;
    }

    @Override
    public void start() {
        if (this.status == GameStatus.DISABLED) {
            this.preparing = true;
            this.status = GameStatus.WAITING;
            this.countdown = -1;
            this.calculatedMaxPlayers = 0;
            for (Team team : this.teams) {
                this.calculatedMaxPlayers += team.maxPlayers;
            }
            new BukkitRunnable(){

                public void run() {
                    Game.this.updateSigns();
                }
            }.runTask((Plugin)Main.getInstance());
            this.statusbar = Main.getConfigurator().config.getBoolean("bossbar.use-xp-bar", false) ? new XPBar() : BossBarSelector.getBossBar(this.lobbySpawn);
            this.preparing = false;
            Bukkit.getPluginManager().callEvent((Event)new BedWarsGameEnabledEvent(this));
        }
    }

    @Override
    public void stop() {
        if (this.status == GameStatus.DISABLED) {
            return;
        }
        List clonedPlayers = (List)((ArrayList)this.players).clone();
        for (GamePlayer p : clonedPlayers) {
            p.changeGame(null);
        }
        if (this.status != GameStatus.REBUILDING) {
            this.status = GameStatus.DISABLED;
            this.updateSigns();
        } else {
            this.afterRebuild = GameStatus.DISABLED;
        }
        Bukkit.getPluginManager().callEvent((Event)new BedWarsGameDisabledEvent(this));
    }

    @Override
    public void joinToGame(final Player player) {
        if (this.status == GameStatus.DISABLED) {
            return;
        }
        if (this.preparing) {
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> this.joinToGame(player), 1L);
            return;
        }
        if (this.status == GameStatus.REBUILDING) {
            if (Game.isBungeeEnabled()) {
                BungeeUtils.movePlayerToBungeeServer(player, false);
                BungeeUtils.sendPlayerBungeeMessage(player, I.i18n("game_is_rebuilding").replace("%arena%", this.name));
            } else {
                player.sendMessage(I.i18n("game_is_rebuilding").replace("%arena%", this.name));
            }
            return;
        }
        if (!(this.status != GameStatus.RUNNING && this.status != GameStatus.GAME_END_CELEBRATING || this.getOriginalOrInheritedSpectatorJoin())) {
            if (Game.isBungeeEnabled()) {
                BungeeUtils.movePlayerToBungeeServer(player, false);
                BungeeUtils.sendPlayerBungeeMessage(player, I.i18n("game_already_running").replace("%arena%", this.name));
            } else {
                player.sendMessage(I.i18n("game_already_running").replace("%arena%", this.name));
            }
            return;
        }
        if (this.players.size() >= this.calculatedMaxPlayers && this.status == GameStatus.WAITING) {
            if (Main.getPlayerGameProfile(player).canJoinFullGame()) {
                List<GamePlayer> withoutVIP = this.getPlayersWithoutVIP();
                if (withoutVIP.size() == 0) {
                    player.sendMessage(I.i18n("vip_game_is_full"));
                    return;
                }
                GamePlayer kickPlayer = withoutVIP.size() == 1 ? withoutVIP.get(0) : withoutVIP.get(MiscUtils.randInt(0, this.players.size() - 1));
                if (Game.isBungeeEnabled()) {
                    BungeeUtils.sendPlayerBungeeMessage(kickPlayer.player, I.i18n("game_kicked_by_vip").replace("%arena%", this.name));
                } else {
                    kickPlayer.player.sendMessage(I.i18n("game_kicked_by_vip").replace("%arena%", this.name));
                }
                kickPlayer.changeGame(null);
            } else {
                if (Game.isBungeeEnabled()) {
                    BungeeUtils.movePlayerToBungeeServer(player, false);
                    new BukkitRunnable(){

                        public void run() {
                            BungeeUtils.sendPlayerBungeeMessage(player, I.i18n("game_is_full").replace("%arena%", Game.this.name));
                        }
                    }.runTaskLater((Plugin)Main.getInstance(), 5L);
                } else {
                    player.sendMessage(I.i18n("game_is_full").replace("%arena%", this.name));
                }
                return;
            }
        }
        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
        gPlayer.changeGame(this);
    }

    @Override
    public void leaveFromGame(Player player) {
        GamePlayer gPlayer;
        if (this.status == GameStatus.DISABLED) {
            return;
        }
        if (Main.isPlayerInGame(player) && (gPlayer = Main.getPlayerGameProfile(player)).getGame() == this) {
            gPlayer.changeGame(null);
            if (this.status == GameStatus.RUNNING || this.status == GameStatus.GAME_END_CELEBRATING) {
                this.updateScoreboard();
            }
        }
    }

    public CurrentTeam getCurrentTeamByTeam(Team team) {
        for (CurrentTeam current : this.teamsInGame) {
            if (current.teamInfo != team) continue;
            return current;
        }
        return null;
    }

    public Team getFirstTeamThatIsntInGame() {
        for (Team team : this.teams) {
            if (this.getCurrentTeamByTeam(team) != null) continue;
            return team;
        }
        return null;
    }

    public List<GamePlayer> getPlayersInTeam(Team team) {
        CurrentTeam currentTeam = null;
        for (CurrentTeam cTeam : this.teamsInGame) {
            if (cTeam.teamInfo != team) continue;
            currentTeam = cTeam;
        }
        if (currentTeam != null) {
            return currentTeam.players;
        }
        return new ArrayList<GamePlayer>();
    }

    private void internalTeamJoin(GamePlayer player, Team teamForJoin, boolean ignoreTeamSize, boolean addCosmetics) {
        CurrentTeam current = null;
        for (CurrentTeam t : this.teamsInGame) {
            if (t.teamInfo != teamForJoin) continue;
            current = t;
            break;
        }
        CurrentTeam cur = this.getPlayerTeam(player);
        BedwarsPlayerJoinTeamEvent event = new BedwarsPlayerJoinTeamEvent(current, player.player, this, cur);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (current == null) {
            current = new CurrentTeam(teamForJoin, this);
            org.bukkit.scoreboard.Team scoreboardTeam = this.gameScoreboard.getTeam(teamForJoin.name);
            if (scoreboardTeam == null) {
                scoreboardTeam = this.gameScoreboard.registerNewTeam(teamForJoin.name);
            }
            if (!Main.isLegacy()) {
                scoreboardTeam.setColor(teamForJoin.color.chatColor);
            } else {
                scoreboardTeam.setPrefix(teamForJoin.color.chatColor.toString());
            }
            scoreboardTeam.setAllowFriendlyFire(this.getOriginalOrInheritedFriendlyfire());
            current.setScoreboardTeam(scoreboardTeam);
        }
        if (cur == current) {
            player.player.sendMessage(I.i18nc("team_already_selected", this.customPrefix).replace("%team%", teamForJoin.color.chatColor + teamForJoin.name).replace("%players%", Integer.toString(current.players.size())).replace("%maxplayers%", Integer.toString(current.teamInfo.maxPlayers)));
            return;
        }
        if (!ignoreTeamSize && current.players.size() >= current.teamInfo.maxPlayers) {
            if (cur != null) {
                player.player.sendMessage(I.i18nc("team_is_full_you_are_staying", this.customPrefix).replace("%team%", teamForJoin.color.chatColor + teamForJoin.name).replace("%oldteam%", cur.teamInfo.color.chatColor + cur.teamInfo.name));
            } else {
                player.player.sendMessage(I.i18nc("team_is_full", this.customPrefix).replace("%team%", teamForJoin.color.chatColor + teamForJoin.name));
            }
            return;
        }
        if (cur != null) {
            cur.players.remove(player);
            cur.getScoreboardTeam().removeEntry(player.player.getName());
            if (cur.players.isEmpty()) {
                this.teamsInGame.remove(cur);
                cur.getScoreboardTeam().unregister();
            }
        }
        current.players.add(player);
        current.getScoreboardTeam().addEntry(player.player.getName());
        player.player.sendMessage(I.i18nc("team_selected", this.customPrefix).replace("%team%", teamForJoin.color.chatColor + teamForJoin.name).replace("%players%", Integer.toString(current.players.size())).replace("%maxplayers%", Integer.toString(current.teamInfo.maxPlayers)));
        if (addCosmetics) {
            int colorPosition;
            if (this.getOriginalOrInheritedAddWoolToInventoryOnJoin() && (colorPosition = Main.getConfigurator().config.getInt("hotbar.color", 1)) >= 0 && colorPosition <= 8) {
                ItemStack stack = teamForJoin.color.getWool();
                ItemMeta stackMeta = stack.getItemMeta();
                stackMeta.setDisplayName(teamForJoin.color.chatColor + teamForJoin.name);
                stack.setItemMeta(stackMeta);
                player.player.getInventory().setItem(colorPosition, stack);
            }
            if (this.getOriginalOrInheritedColoredLeatherByTeamInLobby()) {
                ItemStack chestplate = new ItemStack(Material.LEATHER_CHESTPLATE);
                LeatherArmorMeta meta = (LeatherArmorMeta)chestplate.getItemMeta();
                meta.setColor(teamForJoin.color.leatherColor);
                chestplate.setItemMeta((ItemMeta)meta);
                player.player.getInventory().setChestplate(chestplate);
            }
        }
        if (!this.teamsInGame.contains(current)) {
            this.teamsInGame.add(current);
        }
        if (Main.getTabManager() != null) {
            this.players.forEach(Main.getTabManager()::modifyForPlayer);
        }
    }

    public void joinRandomTeam(GamePlayer player) {
        this.joinRandomTeam(player, false, true, false);
    }

    public void joinRandomTeam(GamePlayer player, boolean ignoreTeamSize, boolean addCosmetics, boolean onlyCurrentTeams) {
        Team teamForJoin = null;
        if (!onlyCurrentTeams && this.teamsInGame.size() < 2) {
            teamForJoin = this.getFirstTeamThatIsntInGame();
        } else {
            CurrentTeam lowest = null;
            for (CurrentTeam team : this.teamsInGame) {
                if (!ignoreTeamSize && team.players.size() >= team.getMaxPlayers()) continue;
                if (lowest == null) {
                    lowest = team;
                }
                if (lowest.players.size() <= team.players.size()) continue;
                lowest = team;
            }
            if (lowest != null) {
                teamForJoin = lowest.teamInfo;
            } else if (!onlyCurrentTeams) {
                teamForJoin = this.getFirstTeamThatIsntInGame();
            }
        }
        if (teamForJoin == null) {
            return;
        }
        this.internalTeamJoin(player, teamForJoin, ignoreTeamSize, addCosmetics);
    }

    public Location makeSpectator(GamePlayer gamePlayer, boolean leaveItem) {
        Player player = gamePlayer.player;
        gamePlayer.isSpectator = true;
        gamePlayer.teleport(this.specSpawn, () -> {
            if (!this.getOriginalOrInheritedKeepInventory() || leaveItem) {
                gamePlayer.invClean();
            }
            player.setAllowFlight(true);
            player.setFlying(true);
            player.setGameMode(GameMode.SPECTATOR);
            if (leaveItem) {
                int leavePosition;
                if (Main.getConfigurator().config.getBoolean("tab.enable") && Main.getConfigurator().config.getBoolean("tab.hide-spectators")) {
                    this.players.forEach(p -> p.hidePlayer(player));
                }
                if ((leavePosition = Main.getConfigurator().config.getInt("hotbar.leave", 8)) >= 0 && leavePosition <= 8) {
                    ItemStack leave = Main.getConfigurator().readDefinedItem("leavegame", "SLIME_BALL");
                    ItemMeta leaveMeta = leave.getItemMeta();
                    leaveMeta.setDisplayName(I.i18n("leave_from_game_item", false));
                    leave.setItemMeta(leaveMeta);
                    gamePlayer.player.getInventory().setItem(leavePosition, leave);
                }
            }
            if (Main.getTabManager() != null) {
                this.players.forEach(Main.getTabManager()::modifyForPlayer);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
                if (gamePlayer.isSpectator && player.getGameMode() != GameMode.SPECTATOR) {
                    player.setGameMode(GameMode.SPECTATOR);
                }
            }, 2L);
        });
        return this.specSpawn;
    }

    public void makePlayerFromSpectator(GamePlayer gamePlayer) {
        Player player = gamePlayer.player;
        CurrentTeam currentTeam = this.getPlayerTeam(gamePlayer);
        if (gamePlayer.getGame() == this && currentTeam != null) {
            gamePlayer.isSpectator = false;
            if (player.getSpectatorTarget() != null) {
                player.setSpectatorTarget(null);
            }
            gamePlayer.teleport(MiscUtils.findEmptyLocation(currentTeam.getTeamSpawn()), () -> {
                player.setAllowFlight(false);
                player.setFlying(false);
                player.setGameMode(GameMode.SURVIVAL);
                if (Main.getConfigurator().config.getBoolean("tab.enable") && Main.getConfigurator().config.getBoolean("tab.hide-spectators")) {
                    this.players.forEach(p -> p.showPlayer(player));
                }
                if (Main.getConfigurator().config.getBoolean("respawn.protection-enabled", true)) {
                    RespawnProtection respawnProtection = this.addProtectedPlayer(player);
                    respawnProtection.runProtection();
                }
                if (gamePlayer.getGame().getOriginalOrInheritedPlayerRespawnItems()) {
                    List<ItemStack> givedGameStartItems = StackParser.parseAll(Main.getConfigurator().config.getList("gived-player-respawn-items"));
                    if (givedGameStartItems != null) {
                        MiscUtils.giveItemsToPlayer(givedGameStartItems, player, currentTeam.getColor());
                    } else {
                        Debug.warn("You have wrongly configured gived-player-respawn-items!", true);
                    }
                }
                if (Main.getTabManager() != null) {
                    this.players.forEach(Main.getTabManager()::modifyForPlayer);
                }
                BedwarsPlayerRespawnedIngameEvent event = new BedwarsPlayerRespawnedIngameEvent(this, currentTeam, player);
                Bukkit.getPluginManager().callEvent((Event)event);
            });
        }
    }

    public void setBossbarProgress(int count, int max) {
        double progress = (double)count / (double)max;
        this.statusbar.setProgress(progress);
        if (this.statusbar instanceof XPBar) {
            XPBar xpbar = (XPBar)this.statusbar;
            xpbar.setSeconds(count);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        if (this.status == GameStatus.DISABLED) {
            this.cancelTask();
            return;
        }
        BedwarsGameChangedStatusEvent statusE = new BedwarsGameChangedStatusEvent(this);
        if (this.countdown == -1 && this.status == GameStatus.WAITING) {
            this.previousCountdown = this.countdown = this.pauseCountdown;
            this.previousStatus = GameStatus.WAITING;
            String title = I.i18nonly("bossbar_waiting");
            this.statusbar.setProgress(0.0);
            this.statusbar.setVisible(this.getOriginalOrInheritedLobbyBossbar());
            for (GamePlayer p2 : this.players) {
                this.statusbar.addPlayer(p2.player);
            }
            if (this.statusbar instanceof BossBar) {
                BossBar bossbar = (BossBar)this.statusbar;
                bossbar.setMessage(title);
                if (bossbar instanceof BossBar19) {
                    BossBar19 bossbar19 = (BossBar19)bossbar;
                    bossbar19.setColor(this.lobbyBossBarColor != null ? this.lobbyBossBarColor : BarColor.valueOf((String)Main.getConfigurator().config.getString("bossbar.lobby.color")));
                    bossbar19.setStyle(BarStyle.valueOf((String)Main.getConfigurator().config.getString("bossbar.lobby.style")));
                } else if (bossbar instanceof BossBar18) {
                    BossBar18 bossBar18 = (BossBar18)bossbar;
                    if (this.lobbyBossBarColorName != null && !this.lobbyBossBarColorName.equals("default")) {
                        bossBar18.setViaColor(this.lobbyBossBarColorName);
                    } else {
                        bossBar18.setViaColor(Main.getConfigurator().config.getString("bossbar.lobby.color"));
                    }
                    bossBar18.setViaStyle(Main.getConfigurator().config.getString("bossbar.lobby.style"));
                }
            }
            this.updateSigns();
        }
        int nextCountdown = this.countdown;
        GameStatus nextStatus = this.status;
        if (this.status == GameStatus.WAITING) {
            if (this.gameStartItem) {
                if (this.players.size() >= this.getMinPlayers()) {
                    for (GamePlayer player : this.players) {
                        if (this.getPlayerTeam(player) != null) continue;
                        this.joinRandomTeam(player);
                    }
                }
                if (this.players.size() > 1) {
                    this.countdown = 0;
                    this.gameStartItem = false;
                }
            }
            if (this.forceGameToStart) {
                nextCountdown = this.gameTime;
                nextStatus = GameStatus.RUNNING;
                this.forceGameToStart = false;
                for (GamePlayer player : this.players) {
                    if (this.getPlayerTeam(player) != null) continue;
                    this.joinRandomTeam(player);
                }
                if (this.teamsInGame.size() == 1) {
                    for (Team team : this.teams) {
                        void var7_14;
                        if (this.getCurrentTeamByTeam(team) != null) continue;
                        CurrentTeam current = new CurrentTeam(team, this);
                        org.bukkit.scoreboard.Team team2 = this.gameScoreboard.getTeam(team.name);
                        if (team2 == null) {
                            org.bukkit.scoreboard.Team team3 = this.gameScoreboard.registerNewTeam(team.name);
                        }
                        current.setScoreboardTeam((org.bukkit.scoreboard.Team)var7_14);
                        current.forced = true;
                        this.teamsInGame.add(current);
                        break;
                    }
                }
            } else if (this.players.size() >= this.getMinPlayers() && (this.teamsInGame.size() > 1 || this.getOriginalOrInheritedJoinRandomTeamAfterLobby() && this.countRespawnable() < this.players.size())) {
                if (this.countdown == 0) {
                    nextCountdown = this.gameTime;
                    nextStatus = GameStatus.RUNNING;
                } else {
                    --nextCountdown;
                    if (this.countdown <= 10 && this.countdown >= 1 && this.countdown != this.previousCountdown) {
                        for (GamePlayer player : this.players) {
                            Title.send(player.player, ChatColor.YELLOW + Integer.toString(this.countdown), "");
                            Sounds.playSound(player.player, player.player.getLocation(), Main.getConfigurator().config.getString("sounds.countdown.sound"), Sounds.UI_BUTTON_CLICK, (float)Main.getConfigurator().config.getDouble("sounds.countdown.volume"), (float)Main.getConfigurator().config.getDouble("sounds.countdown.pitch"));
                        }
                    }
                }
            } else {
                nextCountdown = this.countdown = this.pauseCountdown;
            }
            this.setBossbarProgress(this.countdown, this.pauseCountdown);
            this.updateLobbyScoreboard();
        } else if (this.status == GameStatus.RUNNING) {
            if (this.countdown == 0) {
                nextCountdown = this.postGameWaiting;
                nextStatus = GameStatus.GAME_END_CELEBRATING;
            } else {
                --nextCountdown;
            }
            this.setBossbarProgress(this.countdown, this.gameTime);
            this.updateScoreboardTimer();
        } else if (this.status == GameStatus.GAME_END_CELEBRATING) {
            if (this.countdown == 0) {
                nextStatus = GameStatus.REBUILDING;
                nextCountdown = 0;
            } else {
                --nextCountdown;
            }
            this.setBossbarProgress(this.countdown, this.postGameWaiting);
        }
        BedwarsGameTickEvent tick = new BedwarsGameTickEvent(this, this.previousCountdown, this.previousStatus, this.countdown, this.status, nextCountdown, nextStatus);
        Bukkit.getPluginManager().callEvent((Event)tick);
        this.previousCountdown = this.countdown;
        this.previousStatus = this.status;
        if (this.status != tick.getNextStatus()) {
            if (tick.getNextStatus() == GameStatus.RUNNING) {
                this.preparing = true;
                BedwarsGameStartEvent startE = new BedwarsGameStartEvent(this);
                Main.getInstance().getServer().getPluginManager().callEvent((Event)startE);
                Main.getInstance().getServer().getPluginManager().callEvent((Event)statusE);
                if (startE.isCancelled()) {
                    tick.setNextCountdown(this.pauseCountdown);
                    tick.setNextStatus(GameStatus.WAITING);
                    this.preparing = false;
                } else {
                    if (this.getOriginalOrInheritedJoinRandomTeamAfterLobby()) {
                        for (GamePlayer gamePlayer : this.players) {
                            if (this.getPlayerTeam(gamePlayer) != null) continue;
                            this.joinRandomTeam(gamePlayer);
                        }
                    }
                    this.statusbar.setProgress(0.0);
                    this.statusbar.setVisible(this.getOriginalOrInheritedGameBossbar());
                    if (this.statusbar instanceof BossBar) {
                        BossBar bossbar = (BossBar)this.statusbar;
                        bossbar.setMessage(I.i18n("bossbar_running", false));
                        if (bossbar instanceof BossBar19) {
                            BossBar19 bossBar19 = (BossBar19)bossbar;
                            bossBar19.setColor(this.gameBossBarColor != null ? this.gameBossBarColor : BarColor.valueOf((String)Main.getConfigurator().config.getString("bossbar.game.color")));
                            bossBar19.setStyle(BarStyle.valueOf((String)Main.getConfigurator().config.getString("bossbar.game.style")));
                        } else if (bossbar instanceof BossBar18) {
                            BossBar18 bossBar18 = (BossBar18)bossbar;
                            if (this.gameBossBarColorName != null && !this.gameBossBarColorName.equals("default")) {
                                bossBar18.setViaColor(this.gameBossBarColorName);
                            } else {
                                bossBar18.setViaColor(Main.getConfigurator().config.getString("bossbar.game.color"));
                            }
                            bossBar18.setViaStyle(Main.getConfigurator().config.getString("bossbar.game.style"));
                        }
                    }
                    if (this.teamSelectorInventory != null) {
                        this.teamSelectorInventory.destroy();
                        this.teamSelectorInventory = null;
                    }
                    if (this.gameScoreboard.getObjective("lobby") != null) {
                        this.gameScoreboard.getObjective("lobby").unregister();
                    }
                    this.gameScoreboard.clearSlot(DisplaySlot.SIDEBAR);
                    Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), this::updateSigns, 3L);
                    if (ClassStorage.HAS_CHUNK_TICKETS && Main.getConfigurator().config.getBoolean("use-chunk-tickets-if-available")) {
                        int minX = Math.min(this.pos1.getBlockX(), this.pos2.getBlockX()) >> 4;
                        int n = Math.max(this.pos1.getBlockX(), this.pos2.getBlockX()) >> 4;
                        int minZ = Math.min(this.pos1.getBlockZ(), this.pos2.getBlockZ()) >> 4;
                        int maxZ = Math.max(this.pos1.getBlockZ(), this.pos2.getBlockZ()) >> 4;
                        Main main = Main.getInstance();
                        try {
                            for (int x = minX; x <= n; ++x) {
                                for (int z = minZ; z <= maxZ; ++z) {
                                    Chunk chunk = this.world.getChunkAt(x, z);
                                    if (!chunk.addPluginChunkTicket((Plugin)main)) continue;
                                    this.chunksWithTickets.add(chunk);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            main.getLogger().warning("Failed to claim chunk tickets, skipping");
                        }
                    }
                    for (GameStore gameStore : this.gameStore) {
                        LivingEntity villager = gameStore.spawn();
                        if (villager == null) continue;
                        Main.registerGameEntity((Entity)villager, this);
                        EntityUtils.disableEntityAI(villager);
                        villager.getLocation().getWorld().getNearbyEntities(villager.getLocation(), 1.0, 1.0, 1.0).forEach(entity -> {
                            if (entity.getType() == villager.getType() && entity.getLocation().getBlock().equals(villager.getLocation().getBlock()) && !villager.equals(entity)) {
                                entity.remove();
                            }
                        });
                    }
                    for (ItemSpawner itemSpawner : this.spawners) {
                        if (itemSpawner.type == null) continue;
                        itemSpawner.countdownDelay = 0;
                        itemSpawner.currentCycle = itemSpawner.type.getInterval();
                        UpgradeStorage storage = UpgradeRegistry.getUpgrade("spawner");
                        if (storage == null) continue;
                        storage.addUpgrade(this, itemSpawner);
                    }
                    if (this.getOriginalOrInheritedSpawnerHolograms()) {
                        for (ItemSpawner itemSpawner : this.spawners) {
                            if (itemSpawner.type == null) continue;
                            CurrentTeam spawnerTeam = this.getCurrentTeamFromTeam(itemSpawner.getTeam());
                            if (this.getOriginalOrInheritedStopTeamSpawnersOnDie() && itemSpawner.getTeam() != null && spawnerTeam == null || !itemSpawner.getHologramEnabled()) continue;
                            Location loc = itemSpawner.loc.clone().add(0.0, Main.getConfigurator().config.getDouble("spawner-holo-height", 0.25), 0.0);
                            Hologram holo = Main.getHologramManager().spawnHologram(this.getConnectedPlayers(), loc, itemSpawner.type.getItemBoldName());
                            this.createdHolograms.add(holo);
                            if (!this.getOriginalOrInheritedSpawnerHologramsCountdown()) continue;
                            holo.addLine(itemSpawner.type.getInterval() < 2 ? I.i18nonly("every_second_spawning") : I.i18nonly("countdown_spawning").replace("%seconds%", Integer.toString(itemSpawner.type.getInterval())));
                            this.countdownHolograms.put(itemSpawner, holo);
                        }
                    }
                    String gameStartTitle = I.i18nonly("game_start_title");
                    String string = I.i18nonly("game_start_subtitle").replace("%arena%", this.name);
                    for (GamePlayer player : this.players) {
                        CurrentTeam team = this.getPlayerTeam(player);
                        player.player.getInventory().clear();
                        player.player.getInventory().setHelmet(null);
                        player.player.getInventory().setChestplate(null);
                        player.player.getInventory().setLeggings(null);
                        player.player.getInventory().setBoots(null);
                        Title.send(player.player, gameStartTitle, string);
                        if (team == null) {
                            this.makeSpectator(player, true);
                            Sounds.playSound(player.player, player.player.getLocation(), Main.getConfigurator().config.getString("sounds.game_start.sound"), Sounds.ENTITY_PLAYER_LEVELUP, (float)Main.getConfigurator().config.getDouble("sounds.game_start.volume"), (float)Main.getConfigurator().config.getDouble("sounds.game_start.pitch"));
                            continue;
                        }
                        player.teleport(team.teamInfo.spawn, () -> {
                            player.player.setGameMode(GameMode.SURVIVAL);
                            if (this.getOriginalOrInheritedGameStartItems()) {
                                List<ItemStack> givedGameStartItems = StackParser.parseAll(Main.getConfigurator().config.getList("gived-game-start-items"));
                                if (givedGameStartItems != null) {
                                    MiscUtils.giveItemsToPlayer(givedGameStartItems, player.player, team.getColor());
                                } else {
                                    Debug.warn("You have wrongly configured gived-player-start-items!", true);
                                }
                            }
                            SpawnEffects.spawnEffect(this, player.player, "game-effects.start");
                            Sounds.playSound(player.player, player.player.getLocation(), Main.getConfigurator().config.getString("sounds.game_start.sound"), Sounds.ENTITY_PLAYER_LEVELUP, (float)Main.getConfigurator().config.getDouble("sounds.game_start.volume"), (float)Main.getConfigurator().config.getDouble("sounds.game_start.pitch"));
                        });
                        team.teamMembers.add(new CurrentTeam.Member(player.player.getUniqueId(), player.player.getName()));
                    }
                    if (this.getOriginalOrInheritedRemoveUnusedTargetBlocks()) {
                        for (Team team : this.teams) {
                            Block neighbor;
                            CurrentTeam ct = null;
                            for (CurrentTeam curt : this.teamsInGame) {
                                if (curt.teamInfo != team) continue;
                                ct = curt;
                                break;
                            }
                            if (ct != null) continue;
                            Location loc = team.bed;
                            Block block = team.bed.getBlock();
                            if (this.region.isBedBlock(block.getState())) {
                                this.region.putOriginalBlock(block.getLocation(), block.getState());
                                neighbor = this.region.getBedNeighbor(block);
                                this.region.putOriginalBlock(neighbor.getLocation(), neighbor.getState());
                                neighbor.setType(Material.AIR, false);
                                block.setType(Material.AIR);
                                continue;
                            }
                            if (this.region.isDoorBlock(block.getState())) {
                                this.region.putOriginalBlock(block.getLocation(), block.getState());
                                neighbor = this.region.isDoorBottomBlock(block.getState()) ? block.getLocation().add(0.0, 1.0, 0.0).getBlock() : block.getLocation().subtract(0.0, 1.0, 0.0).getBlock();
                                this.region.putOriginalBlock(neighbor.getLocation(), neighbor.getState());
                                neighbor.setType(Material.AIR, false);
                                block.setType(Material.AIR, false);
                                continue;
                            }
                            this.region.putOriginalBlock(loc, block.getState());
                            block.setType(Material.AIR);
                        }
                    }
                    for (final CurrentTeam team : this.teamsInGame) {
                        final Block block = team.getTargetBlock().getBlock();
                        if (block == null || !"RESPAWN_ANCHOR".equals(block.getType().name())) continue;
                        new BukkitRunnable(){

                            public void run() {
                                final RespawnAnchor anchor = (RespawnAnchor)block.getBlockData();
                                anchor.setCharges(0);
                                block.setBlockData((BlockData)anchor);
                                if (Game.this.getOriginalOrInheritedAnchorAutoFill()) {
                                    new BukkitRunnable(){

                                        public void run() {
                                            anchor.setCharges(anchor.getCharges() + 1);
                                            Sounds.playSound(team.getTargetBlock(), Main.getConfigurator().config.getString("target-block.respawn-anchor.sound.charge"), Sounds.BLOCK_RESPAWN_ANCHOR_CHARGE, 1.0f, 1.0f);
                                            block.setBlockData((BlockData)anchor);
                                            if (anchor.getCharges() >= anchor.getMaximumCharges()) {
                                                Game.this.updateScoreboard();
                                                this.cancel();
                                            }
                                        }
                                    }.runTaskTimer((Plugin)Main.getInstance(), 50L, 10L);
                                }
                            }
                        }.runTask((Plugin)Main.getInstance());
                    }
                    if (this.getOriginalOrInheritedHoloAboveBed()) {
                        for (CurrentTeam team : this.teamsInGame) {
                            Block bed = team.teamInfo.bed.getBlock();
                            Location loc = team.teamInfo.bed.clone().add(0.5, 1.5, 0.5);
                            boolean isBlockTypeBed = this.region.isBedBlock(bed.getState());
                            boolean isAnchor = "RESPAWN_ANCHOR".equals(bed.getType().name());
                            boolean isCake = bed.getType().name().contains("CAKE");
                            boolean isDoor = this.region.isDoorBlock(bed.getState());
                            if (this.region.isDoorBottomBlock(bed.getState())) {
                                loc.add(0.0, 0.5, 0.0);
                            }
                            List<Player> enemies = this.getConnectedPlayers();
                            enemies.removeAll(team.getConnectedPlayers());
                            Hologram holo = Main.getHologramManager().spawnHologram(enemies, loc, I.i18nonly(isDoor ? "destroy_this_door" : (isBlockTypeBed ? "destroy_this_bed" : (isAnchor ? "destroy_this_anchor" : (isCake ? "destroy_this_cake" : "destroy_this_target")))).replace("%teamcolor%", team.teamInfo.color.chatColor.toString()));
                            this.createdHolograms.add(holo);
                            team.setBedHolo(holo);
                            Hologram protectHolo = Main.getHologramManager().spawnHologram(team.getConnectedPlayers(), loc, I.i18nonly(isDoor ? "protect_your_door" : (isBlockTypeBed ? "protect_your_bed" : (isAnchor ? "protect_your_anchor" : (isCake ? "protect_your_cake" : "protect_your_target")))).replace("%teamcolor%", team.teamInfo.color.chatColor.toString()));
                            this.createdHolograms.add(protectHolo);
                            team.setProtectHolo(protectHolo);
                        }
                    }
                    for (CurrentTeam team : this.teamsInGame) {
                        Location targetLocation = team.getTargetBlock();
                        if (targetLocation.getBlock().getType() != Material.AIR) continue;
                        ItemStack stack = team.teamInfo.color.getWool();
                        Block placedBlock = targetLocation.getBlock();
                        placedBlock.setType(stack.getType());
                        if (Main.isLegacy()) continue;
                        try {
                            Block.class.getMethod("setData", Byte.TYPE).invoke((Object)placedBlock, (byte)stack.getDurability());
                        }
                        catch (Exception isAnchor) {}
                    }
                    if (Main.getVersionNumber() >= 115 && !Main.getConfigurator().config.getBoolean("allow-fake-death")) {
                        this.world.setGameRule(GameRule.DO_IMMEDIATE_RESPAWN, (Object)true);
                    }
                    if (Version.isVersion(1, 21, 6) && Main.getConfigurator().config.getBoolean("disable-locator-bars-in-arena-worlds")) {
                        this.world.setGameRule(GameRule.getByName((String)"locatorBar"), (Object)false);
                    }
                    this.preparing = false;
                    BedwarsGameStartedEvent startedEvent = new BedwarsGameStartedEvent(this);
                    Main.getInstance().getServer().getPluginManager().callEvent((Event)startedEvent);
                    Main.getInstance().getServer().getPluginManager().callEvent((Event)statusE);
                    this.updateScoreboard();
                    for (GamePlayer player : this.players) {
                        this.dispatchRewardCommands("player-game-start", player.player, 0, this.getPlayerTeam(player), null, null);
                    }
                    this.dispatchRewardCommands("game-start", null, 0);
                }
            }
        } else if (this.status == GameStatus.RUNNING && tick.getNextStatus() == GameStatus.RUNNING) {
            int runningTeams = 0;
            for (CurrentTeam currentTeam : this.teamsInGame) {
                if (currentTeam.forced) {
                    runningTeams += currentTeam.isBed ? 1 : 0;
                    continue;
                }
                runningTeams += currentTeam.isAlive() ? 1 : 0;
            }
            if (runningTeams <= 1) {
                if (runningTeams == 1) {
                    if (this.gameTime - this.countdown < Main.getConfigurator().config.getInt("players-can-win-game-only-after-seconds")) {
                        for (GamePlayer gamePlayer : this.players) {
                            Title.send(gamePlayer.player, I.i18n("you_lost", false), I.i18n("game_ended_too_early", false));
                        }
                        BedwarsGameEndingEvent endingEvent = new BedwarsGameEndingEvent(this, null);
                        Bukkit.getPluginManager().callEvent((Event)endingEvent);
                    } else {
                        Object winner = null;
                        for (final CurrentTeam t : this.teamsInGame) {
                            if (!t.isAlive()) continue;
                            winner = t;
                            String time = Game.getFormattedTimeLeftS(this.gameTime - this.countdown);
                            String message = I.i18nc("team_win", this.customPrefix).replace("%team%", TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)t.getColor()).chatColor + t.getName()).replace("%time%", time);
                            String subtitle = I.i18n("team_win", false).replace("%team%", TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)t.getColor()).chatColor + t.getName()).replace("%time%", time);
                            boolean madeRecord = this.processRecord(t, this.gameTime - this.countdown);
                            for (final GamePlayer player : this.players) {
                                player.player.sendMessage(message);
                                if (this.getPlayerTeam(player) == t) {
                                    PlayerStatistic statistic;
                                    Title.send(player.player, I.i18nonly("you_won"), subtitle);
                                    Main.depositPlayer(player.player, Main.getVaultWinReward());
                                    SpawnEffects.spawnEffect(this, player.player, "game-effects.end");
                                    if (Main.isPlayerStatisticsEnabled()) {
                                        statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player.player);
                                        statistic.addWins(1);
                                        statistic.addScore(Main.getConfigurator().config.getInt("statistics.scores.win", 50));
                                        if (madeRecord) {
                                            statistic.addScore(Main.getConfigurator().config.getInt("statistics.scores.record", 100));
                                        }
                                        if (Main.isHologramsEnabled()) {
                                            Main.getHologramInteraction().updateHolograms(player.player);
                                        }
                                        if (Main.getConfigurator().config.getBoolean("statistics.show-on-game-end")) {
                                            StatsCommand.sendStats((CommandSender)player.player, Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player.player));
                                        }
                                    }
                                    if (!Main.getConfigurator().config.getBoolean("rewards.enabled")) continue;
                                    if (Main.isPlayerStatisticsEnabled()) {
                                        statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player.player);
                                        this.dispatchRewardCommands("player-win-run-immediately", player.player, statistic.getScore(), t, null, null);
                                    } else {
                                        this.dispatchRewardCommands("player-win-run-immediately", player.player, 0, t, null, null);
                                    }
                                    final Player pl = player.player;
                                    new BukkitRunnable(){

                                        public void run() {
                                            if (Main.isPlayerStatisticsEnabled()) {
                                                PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player.player);
                                                Game.this.dispatchRewardCommands("player-win", pl, statistic.getScore(), t, null, null);
                                            } else {
                                                Game.this.dispatchRewardCommands("player-win", pl, 0, t, null, null);
                                            }
                                        }
                                    }.runTaskLater((Plugin)Main.getInstance(), (long)((2 + this.postGameWaiting) * 20));
                                    continue;
                                }
                                Title.send(player.player, I.i18n("you_lost", false), subtitle);
                                if (!Main.isPlayerStatisticsEnabled() || !Main.isHologramsEnabled()) continue;
                                Main.getHologramInteraction().updateHolograms(player.player);
                            }
                            this.dispatchRewardCommands("team-win", null, 0, t, null, null);
                            for (CurrentTeam.Member member : t.teamMembers) {
                                this.dispatchRewardCommands("player-team-win", null, 0, t, t.getConnectedPlayers().stream().anyMatch(p -> p.getUniqueId().equals(member.getUuid())), member);
                            }
                        }
                        BedwarsGameEndingEvent bedwarsGameEndingEvent = new BedwarsGameEndingEvent(this, (RunningTeam)winner);
                        Bukkit.getPluginManager().callEvent((Event)bedwarsGameEndingEvent);
                    }
                    Main.getInstance().getServer().getPluginManager().callEvent((Event)statusE);
                    tick.setNextCountdown(this.postGameWaiting);
                    tick.setNextStatus(GameStatus.GAME_END_CELEBRATING);
                } else {
                    tick.setNextStatus(GameStatus.REBUILDING);
                    tick.setNextCountdown(0);
                }
            } else if (this.countdown != this.gameTime) {
                for (ItemSpawner itemSpawner : this.spawners) {
                    if (itemSpawner.type == null) continue;
                    Iterator<org.screamingsandals.bedwars.api.Team> spawnerTeam = this.getCurrentTeamFromTeam(itemSpawner.getTeam());
                    if (this.getOriginalOrInheritedStopTeamSpawnersOnDie() && itemSpawner.getTeam() != null && spawnerTeam == null) continue;
                    int cycle = itemSpawner.currentCycle;
                    int elapsedTime = this.gameTime - this.countdown - itemSpawner.countdownDelay;
                    boolean preventSpawn = false;
                    if (Main.getConfigurator().config.getBoolean("reset-full-spawner-countdown-after-picking") && itemSpawner.spawnerLockedFull) {
                        itemSpawner.flushDeathItems();
                        if (itemSpawner.getMaxSpawnedResources() <= itemSpawner.getSpawnedItemsCount()) continue;
                        itemSpawner.countdownDelay = (elapsedTime += itemSpawner.countdownDelay) % cycle;
                        elapsedTime -= itemSpawner.countdownDelay;
                        itemSpawner.spawnerLockedFull = false;
                        preventSpawn = true;
                    }
                    if (itemSpawner.getHologramEnabled() && this.getOriginalOrInheritedSpawnerHolograms() && this.getOriginalOrInheritedSpawnerHologramsCountdown() && !itemSpawner.spawnerIsFullHologram) {
                        if (cycle > 1) {
                            int modulo = cycle - elapsedTime % cycle;
                            this.countdownHolograms.get(itemSpawner).setLine(1, I.i18nonly("countdown_spawning").replace("%seconds%", Integer.toString(modulo)));
                        } else if (itemSpawner.rerenderHologram) {
                            this.countdownHolograms.get(itemSpawner).setLine(1, I.i18nonly("every_second_spawning"));
                            itemSpawner.rerenderHologram = false;
                        }
                    }
                    if (spawnerTeam != null && this.getOriginalOrInheritedStopTeamSpawnersOnDie() && ((CurrentTeam)((Object)spawnerTeam)).isDead() || preventSpawn || elapsedTime % cycle != 0) continue;
                    int calculatedStack = 1;
                    double currentLevel = itemSpawner.getCurrentLevel();
                    calculatedStack = (int)currentLevel;
                    if (currentLevel % 1.0 != 0.0 && Math.random() < currentLevel % 1.0) {
                        ++calculatedStack;
                    }
                    ItemSpawnerType type = itemSpawner.type;
                    BedwarsResourceSpawnEvent resourceSpawnEvent = new BedwarsResourceSpawnEvent(this, itemSpawner, type.getStack(calculatedStack));
                    Main.getInstance().getServer().getPluginManager().callEvent((Event)resourceSpawnEvent);
                    if (resourceSpawnEvent.isCancelled()) continue;
                    ItemStack resource = resourceSpawnEvent.getResource();
                    resource.setAmount(itemSpawner.nextMaxSpawn(resource.getAmount(), this.countdownHolograms.get(itemSpawner)));
                    if (resource.getAmount() <= 0) continue;
                    Location loc = itemSpawner.getLocation().clone().add(0.0, 0.05, 0.0);
                    Item item = loc.getWorld().dropItem(loc, resource);
                    double spread = type.getSpread();
                    if (spread != 1.0) {
                        item.setVelocity(item.getVelocity().multiply(spread));
                    }
                    item.setPickupDelay(0);
                    itemSpawner.add(item);
                }
            }
        }
        this.countdown = tick.getNextCountdown();
        this.status = tick.getNextStatus();
        if (this.status == GameStatus.GAME_END_CELEBRATING && this.previousStatus != this.status && this.statusbar instanceof BossBar) {
            BossBar bossbar = (BossBar)this.statusbar;
            bossbar.setMessage(" ");
        }
        if (this.status == GameStatus.REBUILDING) {
            BedwarsGameEndEvent event = new BedwarsGameEndEvent(this);
            Main.getInstance().getServer().getPluginManager().callEvent((Event)event);
            Main.getInstance().getServer().getPluginManager().callEvent((Event)statusE);
            String message = I.i18nc("game_end", this.customPrefix);
            for (final GamePlayer player : (List)((ArrayList)this.players).clone()) {
                player.player.sendMessage(message);
                player.changeGame(null);
                if (!Main.getConfigurator().config.getBoolean("rewards.enabled")) continue;
                final Player pl = player.player;
                new BukkitRunnable(){

                    public void run() {
                        if (Main.isPlayerStatisticsEnabled()) {
                            PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player.player);
                            Game.this.dispatchRewardCommands("player-end-game", pl, statistic.getScore());
                        } else {
                            Game.this.dispatchRewardCommands("player-end-game", pl, 0);
                        }
                    }
                }.runTaskLater((Plugin)Main.getInstance(), 40L);
            }
            if (this.status == GameStatus.REBUILDING) {
                this.rebuild();
            }
            if (Game.isBungeeEnabled()) {
                Main.getInstance().reselectGame();
                this.preServerRestart = true;
                if (!this.getConnectedPlayers().isEmpty()) {
                    this.kickAllPlayers();
                }
                new BukkitRunnable(){

                    public void run() {
                        if (Main.getConfigurator().config.getBoolean("bungee.serverRestart")) {
                            BedWarsServerRestartEvent serverRestartEvent = new BedWarsServerRestartEvent();
                            Main.getInstance().getServer().getPluginManager().callEvent((Event)serverRestartEvent);
                            Main.getInstance().getServer().dispatchCommand((CommandSender)Main.getInstance().getServer().getConsoleSender(), "restart");
                        } else if (Main.getConfigurator().config.getBoolean("bungee.serverStop")) {
                            Bukkit.shutdown();
                        } else {
                            Game.this.preServerRestart = false;
                        }
                    }
                }.runTaskLater((Plugin)Main.getInstance(), 30L);
            }
        }
    }

    public void rebuild() {
        this.teamsInGame.clear();
        this.activeSpecialItems.clear();
        this.activeDelays.clear();
        BedwarsPreRebuildingEvent preRebuildingEvent = new BedwarsPreRebuildingEvent(this);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)preRebuildingEvent);
        for (ItemSpawner itemSpawner : this.spawners) {
            if (itemSpawner.type == null) continue;
            itemSpawner.currentLevel = itemSpawner.startLevel;
            itemSpawner.spawnedItems.clear();
        }
        for (GameStore gameStore : this.gameStore) {
            LivingEntity villager = gameStore.kill();
            if (villager == null) continue;
            Main.unregisterGameEntity((Entity)villager);
        }
        this.region.regen();
        for (Entity entity : this.world.getEntities()) {
            if (!GameCreator.isInArea(entity.getLocation(), this.pos1, this.pos2) || !(entity instanceof Item)) continue;
            Chunk chunk3 = entity.getLocation().getChunk();
            if (!chunk3.isLoaded()) {
                chunk3.load();
            }
            entity.remove();
        }
        for (Map.Entry entry : this.usedChests.entrySet()) {
            Location location = (Location)entry.getKey();
            Chunk chunk2 = location.getChunk();
            if (!chunk2.isLoaded()) {
                chunk2.load();
            }
            Block block = location.getBlock();
            ItemStack[] contents = (ItemStack[])entry.getValue();
            if (!(block.getState() instanceof InventoryHolder)) continue;
            InventoryHolder chest = (InventoryHolder)block.getState();
            chest.getInventory().setContents(contents);
        }
        this.usedChests.clear();
        for (Inventory inventory : this.fakeEnderChests.values()) {
            inventory.clear();
        }
        this.fakeEnderChests.clear();
        for (Entity entity : Main.getGameEntities(this)) {
            Chunk chunk = entity.getLocation().getChunk();
            if (!chunk.isLoaded()) {
                chunk.load();
            }
            entity.remove();
            Main.unregisterGameEntity(entity);
        }
        for (Hologram hologram : this.createdHolograms) {
            hologram.destroy();
        }
        this.createdHolograms.clear();
        this.countdownHolograms.clear();
        UpgradeRegistry.clearAll(this);
        if (!this.chunksWithTickets.isEmpty()) {
            Main main = Main.getInstance();
            for (Chunk chunk : this.chunksWithTickets) {
                try {
                    chunk.removePluginChunkTicket((Plugin)main);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.chunksWithTickets.clear();
        }
        BedwarsPostRebuildingEvent postRebuildingEvent = new BedwarsPostRebuildingEvent(this);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)postRebuildingEvent);
        this.status = this.afterRebuild;
        this.countdown = -1;
        this.updateSigns();
        this.cancelTask();
    }

    public boolean processRecord(CurrentTeam t, int wonTime) {
        int time = Main.getConfigurator().recordConfig.getInt("record." + this.getName() + ".time", Integer.MAX_VALUE);
        if (time > wonTime) {
            Main.getConfigurator().recordConfig.set("record." + this.getName() + ".time", (Object)wonTime);
            Main.getConfigurator().recordConfig.set("record." + this.getName() + ".team", (Object)(t.teamInfo.color.chatColor + t.teamInfo.name));
            ArrayList<String> winners = new ArrayList<String>();
            for (GamePlayer p : t.players) {
                winners.add(p.player.getName());
            }
            Main.getConfigurator().recordConfig.set("record." + this.getName() + ".winners", winners);
            try {
                Main.getConfigurator().recordConfig.save(Main.getConfigurator().recordFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public GameStatus getStatus() {
        return this.status;
    }

    public void runTask() {
        if (this.task != null) {
            if (Bukkit.getScheduler().isQueued(this.task.getTaskId())) {
                this.task.cancel();
            }
            this.task = null;
        }
        this.task = new BukkitRunnable(){

            public void run() {
                Game.this.run();
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 20L);
    }

    private void cancelTask() {
        if (this.task != null) {
            if (Bukkit.getScheduler().isQueued(this.task.getTaskId())) {
                this.task.cancel();
            }
            this.task = null;
        }
    }

    public void selectTeam(GamePlayer playerGameProfile, String displayName) {
        this.selectTeam(playerGameProfile, displayName, false, true, false);
    }

    public void selectTeam(GamePlayer playerGameProfile, String displayName, boolean ignoreTeamSize, boolean addCosmetics, boolean ignoreGameState) {
        if (this.status == GameStatus.WAITING || ignoreGameState) {
            displayName = ChatColor.stripColor((String)displayName);
            playerGameProfile.player.closeInventory();
            for (Team team : this.teams) {
                if (!displayName.equals(team.name)) continue;
                this.internalTeamJoin(playerGameProfile, team, ignoreTeamSize, addCosmetics);
                break;
            }
        }
    }

    public void updateScoreboard() {
        if (!this.getOriginalOrInheritedScoreaboard()) {
            return;
        }
        Objective obj = this.gameScoreboard.getObjective("display");
        if (obj == null) {
            obj = this.gameScoreboard.registerNewObjective("display", "dummy");
        }
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        obj.setDisplayName(this.formatScoreboardTitle());
        for (CurrentTeam team : this.teamsInGame) {
            Score score;
            String teamLine = this.formatScoreboardTeam(team, !team.isBed, team.isBed && "RESPAWN_ANCHOR".equals(team.teamInfo.bed.getBlock().getType().name()) && Player116ListenerUtils.isAnchorEmpty(team.teamInfo.bed.getBlock()));
            if (!this.gameScoreboard.getEntries().contains(teamLine)) {
                this.gameScoreboard.resetScores(this.formatScoreboardTeam(team, false, false));
                this.gameScoreboard.resetScores(this.formatScoreboardTeam(team, false, true));
                this.gameScoreboard.resetScores(this.formatScoreboardTeam(team, true, false));
            }
            if ((score = obj.getScore(teamLine)).getScore() == team.players.size()) continue;
            score.setScore(team.players.size());
        }
        for (GamePlayer player : this.players) {
            player.player.setScoreboard(this.gameScoreboard);
        }
    }

    private String formatScoreboardTeam(CurrentTeam team, boolean destroy, boolean empty) {
        if (team == null) {
            return "";
        }
        return Main.getConfigurator().config.getString("scoreboard.teamTitle").replace("%color%", team.teamInfo.color.chatColor.toString()).replace("%team%", team.teamInfo.name).replace("%bed%", destroy ? Game.bedLostString() : (empty ? Game.anchorEmptyString() : Game.bedExistString()));
    }

    public static String bedExistString() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getConfigurator().config.getString("scoreboard.bedExists"));
    }

    public static String bedLostString() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getConfigurator().config.getString("scoreboard.bedLost"));
    }

    public static String anchorEmptyString() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getConfigurator().config.getString("scoreboard.anchorEmpty"));
    }

    private void updateScoreboardTimer() {
        if (this.status != GameStatus.RUNNING || !this.getOriginalOrInheritedScoreaboard()) {
            return;
        }
        Objective obj = this.gameScoreboard.getObjective("display");
        if (obj == null) {
            obj = this.gameScoreboard.registerNewObjective("display", "dummy");
        }
        obj.setDisplayName(this.formatScoreboardTitle());
        for (GamePlayer player : this.players) {
            player.player.setScoreboard(this.gameScoreboard);
        }
    }

    private String formatScoreboardTitle() {
        return Objects.requireNonNull(ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getConfigurator().config.getString("scoreboard.title")).replace("%game%", this.name).replace("%time%", this.getFormattedTimeLeft()));
    }

    public String getFormattedTimeLeft() {
        return Game.getFormattedTimeLeftS(this.countdown);
    }

    public String getFormattedTimeLeft(int countdown) {
        return Game.getFormattedTimeLeftS(countdown);
    }

    public static String getFormattedTimeLeftS(int countdown) {
        int min = (int)Math.floor(countdown / 60);
        int sec = countdown % 60;
        String minStr = min < 10 ? "0" + min : String.valueOf(min);
        String secStr = sec < 10 ? "0" + sec : String.valueOf(sec);
        return minStr + ":" + secStr;
    }

    public void updateSigns() {
        FileConfiguration config = Main.getConfigurator().config;
        List<SignBlock> gameSigns = Main.getSignManager().getSignsForName(this.name);
        if (gameSigns.isEmpty()) {
            return;
        }
        String statusLine = "";
        String playersLine = "";
        MaterialSearchEngine.Result blockBehindMaterial = null;
        switch (this.status) {
            case DISABLED: {
                statusLine = I.i18nonly("sign_status_disabled");
                playersLine = I.i18nonly("sign_status_disabled_players");
                blockBehindMaterial = MiscUtils.getMaterialFromString(config.getString("sign.block-behind.game-disabled"), "RED_STAINED_GLASS");
                break;
            }
            case REBUILDING: {
                statusLine = I.i18nonly("sign_status_rebuilding");
                playersLine = I.i18nonly("sign_status_rebuilding_players");
                blockBehindMaterial = MiscUtils.getMaterialFromString(config.getString("sign.block-behind.rebuilding"), "BROWN_STAINED_GLASS");
                break;
            }
            case RUNNING: 
            case GAME_END_CELEBRATING: {
                statusLine = I.i18nonly("sign_status_running");
                playersLine = I.i18nonly("sign_status_running_players");
                blockBehindMaterial = MiscUtils.getMaterialFromString(config.getString("sign.block-behind.in-game"), "GREEN_STAINED_GLASS");
                break;
            }
            case WAITING: {
                statusLine = I.i18nonly("sign_status_waiting");
                playersLine = I.i18nonly("sign_status_waiting_players");
                blockBehindMaterial = MiscUtils.getMaterialFromString(config.getString("sign.block-behind.waiting"), "ORANGE_STAINED_GLASS");
            }
        }
        playersLine = playersLine.replace("%players%", Integer.toString(this.players.size()));
        playersLine = playersLine.replace("%maxplayers%", Integer.toString(this.calculatedMaxPlayers));
        ArrayList<String> texts = new ArrayList<String>(Main.getConfigurator().config.getStringList("sign.lines").stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList()));
        for (int i = 0; i < texts.size(); ++i) {
            String text = (String)texts.get(i);
            texts.set(i, text.replace("%arena%", this.getName()).replace("%status%", statusLine).replace("%players%", playersLine));
        }
        for (SignBlock signBlock : gameSigns) {
            Optional<Block> optionalBlock;
            if (signBlock.getLocation() == null || !signBlock.getLocation().getChunk().isLoaded()) continue;
            BlockState blockState = signBlock.getLocation().getBlock().getState();
            if (blockState instanceof Sign) {
                Sign sign = (Sign)blockState;
                for (int i = 0; i < texts.size() && i < 4; ++i) {
                    sign.setLine(i, (String)texts.get(i));
                }
                sign.update();
            }
            if (!config.getBoolean("sign.block-behind.enabled", false) || !(optionalBlock = signBlock.getBlockBehindSign()).isPresent()) continue;
            Block glassBlock = optionalBlock.get();
            glassBlock.setType(blockBehindMaterial.getMaterial());
            if (!Main.isLegacy()) continue;
            try {
                Block.class.getMethod("setData", Byte.TYPE).invoke((Object)glassBlock, (byte)blockBehindMaterial.getDamage());
            }
            catch (Exception exception) {}
        }
    }

    private void updateLobbyScoreboard() {
        if (this.status != GameStatus.WAITING || !this.getOriginalOrInheritedLobbyScoreaboard()) {
            return;
        }
        Objective obj = this.gameScoreboard.getObjective("lobby");
        if (obj == null) {
            obj = this.gameScoreboard.registerNewObjective("lobby", "dummy");
            obj.setDisplaySlot(DisplaySlot.SIDEBAR);
            obj.setDisplayName(this.formatLobbyScoreboardString(ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getConfigurator().config.getString("lobby-scoreboard.title", "&eBEDWARS"))));
        }
        this.gameScoreboard.getEntries().forEach(arg_0 -> ((Scoreboard)this.gameScoreboard).resetScores(arg_0));
        List rows = Main.getConfigurator().config.getStringList("lobby-scoreboard.content").stream().map(content -> ChatColor.translateAlternateColorCodes((char)'&', (String)content)).collect(Collectors.toList());
        int rowMax = rows.size();
        if (rows.isEmpty()) {
            return;
        }
        for (String row : rows) {
            if (row.trim().equals("")) {
                for (int i = 0; i <= rowMax; ++i) {
                    row = row + " ";
                }
            }
            Score score = obj.getScore(this.formatLobbyScoreboardString(row));
            score.setScore(rowMax);
            --rowMax;
        }
        this.players.forEach(player -> player.player.setScoreboard(this.gameScoreboard));
    }

    private String formatLobbyScoreboardString(String str) {
        String finalStr = str;
        finalStr = finalStr.replace("%arena%", this.name);
        finalStr = finalStr.replace("%players%", String.valueOf(this.players.size()));
        finalStr = finalStr.replace("%maxplayers%", String.valueOf(this.calculatedMaxPlayers));
        finalStr = finalStr.replace("%countdown%", String.valueOf(this.countdown));
        finalStr = finalStr.replace("%countdownwaiting%", this.players.size() >= this.getMinPlayers() && (this.teamsInGame.size() > 1 || this.getOriginalOrInheritedJoinRandomTeamAfterLobby() && this.countRespawnable() < this.players.size()) ? String.valueOf(this.countdown) : I.i18nonly("waiting_placeholder_lobby_scoreboard"));
        return finalStr;
    }

    @Override
    public void selectPlayerTeam(Player player, org.screamingsandals.bedwars.api.Team team) {
        this.selectPlayerTeam(player, team, false, true, false);
    }

    public void selectPlayerTeam(Player player, org.screamingsandals.bedwars.api.Team team, boolean ignoreTeamSize, boolean addCosmetics, boolean ignoreGameState) {
        if (!Main.isPlayerInGame(player)) {
            return;
        }
        GamePlayer profile = Main.getPlayerGameProfile(player);
        if (profile.getGame() != this) {
            return;
        }
        if (team instanceof Team) {
            if (this.status == GameStatus.WAITING || ignoreGameState) {
                player.closeInventory();
                this.internalTeamJoin(profile, (Team)team, ignoreTeamSize, addCosmetics);
            }
            return;
        }
        this.selectTeam(profile, team.getName(), ignoreTeamSize, addCosmetics, ignoreGameState);
    }

    @Override
    public World getGameWorld() {
        return this.world;
    }

    @Override
    public Location getSpectatorSpawn() {
        return this.specSpawn;
    }

    @Override
    public int countConnectedPlayers() {
        return this.players.size();
    }

    @Override
    public List<Player> getConnectedPlayers() {
        ArrayList<Player> playerList = new ArrayList<Player>();
        for (GamePlayer player : this.players) {
            playerList.add(player.player);
        }
        return playerList;
    }

    @Override
    public List<org.screamingsandals.bedwars.api.Team> getAvailableTeams() {
        return new ArrayList<org.screamingsandals.bedwars.api.Team>(this.teams);
    }

    @Override
    public List<RunningTeam> getRunningTeams() {
        return new ArrayList<RunningTeam>(this.teamsInGame);
    }

    @Override
    public RunningTeam getTeamOfPlayer(Player player) {
        if (!Main.isPlayerInGame(player)) {
            return null;
        }
        return this.getPlayerTeam(Main.getPlayerGameProfile(player));
    }

    @Override
    public boolean isLocationInArena(Location location) {
        return GameCreator.isInArea(location, this.pos1, this.pos2);
    }

    @Override
    public World getLobbyWorld() {
        return this.lobbySpawn.getWorld();
    }

    @Override
    public int getLobbyCountdown() {
        return this.pauseCountdown;
    }

    @Override
    public CurrentTeam getTeamOfChest(Location location) {
        for (CurrentTeam team : this.teamsInGame) {
            if (!team.isTeamChestRegistered(location)) continue;
            return team;
        }
        return null;
    }

    @Override
    public CurrentTeam getTeamOfChest(Block block) {
        for (CurrentTeam team : this.teamsInGame) {
            if (!team.isTeamChestRegistered(block)) continue;
            return team;
        }
        return null;
    }

    public void addChestForFutureClear(Location loc, Inventory inventory) {
        if (!this.usedChests.containsKey(loc)) {
            ItemStack[] contents = inventory.getContents();
            ItemStack[] clone = new ItemStack[contents.length];
            for (int i = 0; i < contents.length; ++i) {
                ItemStack stack = contents[i];
                if (stack == null) continue;
                clone[i] = stack.clone();
            }
            this.usedChests.put(loc, clone);
        }
    }

    @Override
    public int getMaxPlayers() {
        return this.calculatedMaxPlayers;
    }

    @Override
    public int countGameStores() {
        return this.gameStore.size();
    }

    @Override
    public int countAvailableTeams() {
        return this.teams.size();
    }

    @Override
    public int countRunningTeams() {
        return this.teamsInGame.size();
    }

    @Override
    public boolean isPlayerInAnyTeam(Player player) {
        return this.getTeamOfPlayer(player) != null;
    }

    @Override
    public boolean isPlayerInTeam(Player player, RunningTeam team) {
        return this.getTeamOfPlayer(player) == team;
    }

    @Override
    public int countTeamChests() {
        int total = 0;
        for (CurrentTeam team : this.teamsInGame) {
            total += team.countTeamChests();
        }
        return total;
    }

    @Override
    public int countTeamChests(RunningTeam team) {
        return team.countTeamChests();
    }

    @Override
    public List<SpecialItem> getActivedSpecialItems() {
        return new ArrayList<SpecialItem>(this.activeSpecialItems);
    }

    @Override
    public List<SpecialItem> getActivedSpecialItems(Class<? extends SpecialItem> type) {
        ArrayList<SpecialItem> items = new ArrayList<SpecialItem>();
        for (SpecialItem item : this.activeSpecialItems) {
            if (!type.isInstance(item)) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public List<SpecialItem> getActivedSpecialItemsOfTeam(org.screamingsandals.bedwars.api.Team team) {
        ArrayList<SpecialItem> items = new ArrayList<SpecialItem>();
        for (SpecialItem item : this.activeSpecialItems) {
            if (item.getTeam() != team) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public List<SpecialItem> getActivedSpecialItemsOfTeam(org.screamingsandals.bedwars.api.Team team, Class<? extends SpecialItem> type) {
        ArrayList<SpecialItem> items = new ArrayList<SpecialItem>();
        for (SpecialItem item : this.activeSpecialItems) {
            if (!type.isInstance(item) || item.getTeam() != team) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public SpecialItem getFirstActivedSpecialItemOfTeam(org.screamingsandals.bedwars.api.Team team) {
        for (SpecialItem item : this.activeSpecialItems) {
            if (item.getTeam() != team) continue;
            return item;
        }
        return null;
    }

    @Override
    public SpecialItem getFirstActivedSpecialItemOfTeam(org.screamingsandals.bedwars.api.Team team, Class<? extends SpecialItem> type) {
        for (SpecialItem item : this.activeSpecialItems) {
            if (item.getTeam() != team || !type.isInstance(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public List<SpecialItem> getActivedSpecialItemsOfPlayer(Player player) {
        ArrayList<SpecialItem> items = new ArrayList<SpecialItem>();
        for (SpecialItem item : this.activeSpecialItems) {
            if (item.getPlayer() != player) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public List<SpecialItem> getActivedSpecialItemsOfPlayer(Player player, Class<? extends SpecialItem> type) {
        ArrayList<SpecialItem> items = new ArrayList<SpecialItem>();
        for (SpecialItem item : this.activeSpecialItems) {
            if (item.getPlayer() != player || !type.isInstance(item)) continue;
            items.add(item);
        }
        return items;
    }

    @Override
    public SpecialItem getFirstActivedSpecialItemOfPlayer(Player player) {
        for (SpecialItem item : this.activeSpecialItems) {
            if (item.getPlayer() != player) continue;
            return item;
        }
        return null;
    }

    @Override
    public SpecialItem getFirstActivedSpecialItemOfPlayer(Player player, Class<? extends SpecialItem> type) {
        for (SpecialItem item : this.activeSpecialItems) {
            if (item.getPlayer() != player || !type.isInstance(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public void registerSpecialItem(SpecialItem item) {
        if (!this.activeSpecialItems.contains(item)) {
            this.activeSpecialItems.add(item);
        }
    }

    @Override
    public void unregisterSpecialItem(SpecialItem item) {
        if (this.activeSpecialItems.contains(item)) {
            this.activeSpecialItems.remove(item);
        }
    }

    @Override
    public boolean isRegisteredSpecialItem(SpecialItem item) {
        return this.activeSpecialItems.contains(item);
    }

    @Override
    public List<DelayFactory> getActiveDelays() {
        return new ArrayList<DelayFactory>(this.activeDelays);
    }

    @Override
    public List<DelayFactory> getActiveDelaysOfPlayer(Player player) {
        ArrayList<DelayFactory> delays = new ArrayList<DelayFactory>();
        for (DelayFactory delay : this.activeDelays) {
            if (delay.getPlayer() != player) continue;
            delays.add(delay);
        }
        return delays;
    }

    @Override
    public DelayFactory getActiveDelay(Player player, Class<? extends SpecialItem> specialItem) {
        for (DelayFactory delayFactory : this.getActiveDelaysOfPlayer(player)) {
            if (!specialItem.isInstance(delayFactory.getSpecialItem())) continue;
            return delayFactory;
        }
        return null;
    }

    @Override
    public void registerDelay(DelayFactory delayFactory) {
        if (!this.activeDelays.contains(delayFactory)) {
            this.activeDelays.add(delayFactory);
        }
    }

    @Override
    public void unregisterDelay(DelayFactory delayFactory) {
        this.activeDelays.remove(delayFactory);
    }

    @Override
    public boolean isDelayActive(Player player, Class<? extends SpecialItem> specialItem) {
        for (DelayFactory delayFactory : this.getActiveDelaysOfPlayer(player)) {
            if (!specialItem.isInstance(delayFactory.getSpecialItem())) continue;
            return delayFactory.getDelayActive();
        }
        return false;
    }

    @Override
    public InGameConfigBooleanConstants getCompassEnabled() {
        return this.compassEnabled;
    }

    public void setCompassEnabled(InGameConfigBooleanConstants compassEnabled) {
        this.compassEnabled = compassEnabled;
    }

    @Override
    public InGameConfigBooleanConstants getJoinRandomTeamAfterLobby() {
        return this.joinRandomTeamAfterLobby;
    }

    public void setJoinRandomTeamAfterLobby(InGameConfigBooleanConstants joinRandomTeamAfterLobby) {
        this.joinRandomTeamAfterLobby = joinRandomTeamAfterLobby;
    }

    @Override
    public InGameConfigBooleanConstants getJoinRandomTeamOnJoin() {
        return this.joinRandomTeamOnJoin;
    }

    public void setJoinRandomTeamOnJoin(InGameConfigBooleanConstants joinRandomTeamOnJoin) {
        this.joinRandomTeamOnJoin = joinRandomTeamOnJoin;
    }

    @Override
    public InGameConfigBooleanConstants getAddWoolToInventoryOnJoin() {
        return this.addWoolToInventoryOnJoin;
    }

    public void setAddWoolToInventoryOnJoin(InGameConfigBooleanConstants addWoolToInventoryOnJoin) {
        this.addWoolToInventoryOnJoin = addWoolToInventoryOnJoin;
    }

    @Override
    public InGameConfigBooleanConstants getPreventKillingVillagers() {
        return this.preventKillingVillagers;
    }

    public void setPreventKillingVillagers(InGameConfigBooleanConstants preventKillingVillagers) {
        this.preventKillingVillagers = preventKillingVillagers;
    }

    @Override
    public InGameConfigBooleanConstants getPlayerDrops() {
        return this.playerDrops;
    }

    public void setPlayerDrops(InGameConfigBooleanConstants playerDrops) {
        this.playerDrops = playerDrops;
    }

    @Override
    public InGameConfigBooleanConstants getFriendlyfire() {
        return this.friendlyfire;
    }

    public void setFriendlyfire(InGameConfigBooleanConstants friendlyfire) {
        this.friendlyfire = friendlyfire;
    }

    @Override
    public InGameConfigBooleanConstants getColoredLeatherByTeamInLobby() {
        return this.coloredLeatherByTeamInLobby;
    }

    public void setColoredLeatherByTeamInLobby(InGameConfigBooleanConstants coloredLeatherByTeamInLobby) {
        this.coloredLeatherByTeamInLobby = coloredLeatherByTeamInLobby;
    }

    @Override
    public InGameConfigBooleanConstants getKeepInventory() {
        return this.keepInventory;
    }

    public void setKeepInventory(InGameConfigBooleanConstants keepInventory) {
        this.keepInventory = keepInventory;
    }

    @Override
    public InGameConfigBooleanConstants getCrafting() {
        return this.crafting;
    }

    public void setCrafting(InGameConfigBooleanConstants crafting) {
        this.crafting = crafting;
    }

    @Override
    public boolean getOriginalOrInheritedCompassEnabled() {
        return this.compassEnabled.isOriginal() ? this.compassEnabled.getValue() : Main.getConfigurator().config.getBoolean(COMPASS_ENABLED);
    }

    @Override
    public boolean getOriginalOrInheritedJoinRandomTeamAfterLobby() {
        return this.joinRandomTeamAfterLobby.isOriginal() ? this.joinRandomTeamAfterLobby.getValue() : Main.getConfigurator().config.getBoolean(JOIN_RANDOM_TEAM_AFTER_LOBBY);
    }

    @Override
    public boolean getOriginalOrInheritedJoinRandomTeamOnJoin() {
        return this.joinRandomTeamOnJoin.isOriginal() ? this.joinRandomTeamOnJoin.getValue() : Main.getConfigurator().config.getBoolean(JOIN_RANDOM_TEAM_ON_JOIN);
    }

    @Override
    public boolean getOriginalOrInheritedAddWoolToInventoryOnJoin() {
        return this.addWoolToInventoryOnJoin.isOriginal() ? this.addWoolToInventoryOnJoin.getValue() : Main.getConfigurator().config.getBoolean(ADD_WOOL_TO_INVENTORY_ON_JOIN);
    }

    @Override
    public boolean getOriginalOrInheritedPreventKillingVillagers() {
        return this.preventKillingVillagers.isOriginal() ? this.preventKillingVillagers.getValue() : Main.getConfigurator().config.getBoolean(PREVENT_KILLING_VILLAGERS);
    }

    @Override
    public boolean getOriginalOrInheritedPlayerDrops() {
        return this.playerDrops.isOriginal() ? this.playerDrops.getValue() : Main.getConfigurator().config.getBoolean(PLAYER_DROPS);
    }

    @Override
    public boolean getOriginalOrInheritedFriendlyfire() {
        return this.friendlyfire.isOriginal() ? this.friendlyfire.getValue() : Main.getConfigurator().config.getBoolean(FRIENDLY_FIRE);
    }

    @Override
    public boolean getOriginalOrInheritedColoredLeatherByTeamInLobby() {
        return this.coloredLeatherByTeamInLobby.isOriginal() ? this.coloredLeatherByTeamInLobby.getValue() : Main.getConfigurator().config.getBoolean(COLORED_LEATHER_BY_TEAM_IN_LOBBY);
    }

    @Override
    public boolean getOriginalOrInheritedKeepInventory() {
        return this.keepInventory.isOriginal() ? this.keepInventory.getValue() : Main.getConfigurator().config.getBoolean(KEEP_INVENTORY);
    }

    @Override
    public boolean getOriginalOrInheritedCrafting() {
        return this.crafting.isOriginal() ? this.crafting.getValue() : Main.getConfigurator().config.getBoolean(CRAFTING);
    }

    @Override
    public InGameConfigBooleanConstants getLobbyBossbar() {
        return this.lobbybossbar;
    }

    @Override
    public boolean getOriginalOrInheritedLobbyBossbar() {
        return this.lobbybossbar.isOriginal() ? this.lobbybossbar.getValue() : Main.getConfigurator().config.getBoolean(GLOBAL_LOBBY_BOSSBAR);
    }

    @Override
    public InGameConfigBooleanConstants getGameBossbar() {
        return this.gamebossbar;
    }

    @Override
    public boolean getOriginalOrInheritedGameBossbar() {
        return this.gamebossbar.isOriginal() ? this.gamebossbar.getValue() : Main.getConfigurator().config.getBoolean(GLOBAL_GAME_BOSSBAR);
    }

    @Override
    public InGameConfigBooleanConstants getScoreboard() {
        return this.ascoreboard;
    }

    @Override
    public boolean getOriginalOrInheritedScoreaboard() {
        return this.ascoreboard.isOriginal() ? this.ascoreboard.getValue() : Main.getConfigurator().config.getBoolean(GLOBAL_SCOREBOARD);
    }

    @Override
    public InGameConfigBooleanConstants getLobbyScoreboard() {
        return this.lobbyscoreboard;
    }

    @Override
    public boolean getOriginalOrInheritedLobbyScoreaboard() {
        return this.lobbyscoreboard.isOriginal() ? this.lobbyscoreboard.getValue() : Main.getConfigurator().config.getBoolean(GLOBAL_LOBBY_SCOREBOARD);
    }

    public void setLobbyBossbar(InGameConfigBooleanConstants lobbybossbar) {
        this.lobbybossbar = lobbybossbar;
    }

    public void setGameBossbar(InGameConfigBooleanConstants gamebossbar) {
        this.gamebossbar = gamebossbar;
    }

    public void setAscoreboard(InGameConfigBooleanConstants ascoreboard) {
        this.ascoreboard = ascoreboard;
    }

    public void setLobbyScoreboard(InGameConfigBooleanConstants lobbyscoreboard) {
        this.lobbyscoreboard = lobbyscoreboard;
    }

    public void setPreventSpawningMobs(InGameConfigBooleanConstants preventSpawningMobs) {
        this.preventSpawningMobs = preventSpawningMobs;
    }

    @Override
    public InGameConfigBooleanConstants getPreventSpawningMobs() {
        return this.preventSpawningMobs;
    }

    @Override
    public boolean getOriginalOrInheritedPreventSpawningMobs() {
        return this.preventSpawningMobs.isOriginal() ? this.preventSpawningMobs.getValue() : Main.getConfigurator().config.getBoolean(PREVENT_SPAWNING_MOBS);
    }

    @Override
    public ArenaTime getArenaTime() {
        return this.arenaTime;
    }

    public void setArenaTime(ArenaTime arenaTime) {
        this.arenaTime = arenaTime;
    }

    @Override
    public WeatherType getArenaWeather() {
        return this.arenaWeather;
    }

    public void setArenaWeather(WeatherType arenaWeather) {
        this.arenaWeather = arenaWeather;
    }

    @Override
    public BarColor getLobbyBossBarColor() {
        return this.lobbyBossBarColor;
    }

    public void setLobbyBossBarColor(BarColor color) {
        this.lobbyBossBarColor = color;
    }

    @Override
    public BarColor getGameBossBarColor() {
        return this.gameBossBarColor;
    }

    public void setGameBossBarColor(BarColor color) {
        this.gameBossBarColor = color;
    }

    @Override
    public InGameConfigBooleanConstants getSpawnerHolograms() {
        return this.spawnerHolograms;
    }

    @Override
    public boolean getOriginalOrInheritedSpawnerHolograms() {
        return this.spawnerHolograms.isOriginal() ? this.spawnerHolograms.getValue() : Main.getConfigurator().config.getBoolean(SPAWNER_HOLOGRAMS);
    }

    public void setSpawnerHolograms(InGameConfigBooleanConstants spawnerHolograms) {
        this.spawnerHolograms = spawnerHolograms;
    }

    @Override
    public List<org.screamingsandals.bedwars.api.game.ItemSpawner> getItemSpawners() {
        return new ArrayList<org.screamingsandals.bedwars.api.game.ItemSpawner>(this.spawners);
    }

    @Override
    public InGameConfigBooleanConstants getSpawnerDisableMerge() {
        return this.spawnerDisableMerge;
    }

    @Override
    public boolean getOriginalOrInheritedSpawnerDisableMerge() {
        return this.spawnerDisableMerge.isOriginal() ? this.spawnerDisableMerge.getValue() : Main.getConfigurator().config.getBoolean(SPAWNER_DISABLE_MERGE);
    }

    public void setSpawnerDisableMerge(InGameConfigBooleanConstants spawnerDisableMerge) {
        this.spawnerDisableMerge = spawnerDisableMerge;
    }

    public void dispatchRewardCommands(String type, Player player, int score) {
        this.dispatchRewardCommands(type, player, score, null, null, null);
    }

    public void dispatchRewardCommands(String type, Player player, int score, CurrentTeam team, Boolean deathStatus, CurrentTeam.Member member) {
        if (!Main.getConfigurator().config.getBoolean("rewards.enabled")) {
            return;
        }
        List list = Main.getConfigurator().config.getStringList("rewards." + type);
        for (String command : list) {
            if (command.startsWith("/example ")) continue;
            if (player != null) {
                command = command.replace("{player}", player.getName());
                command = command.replace("{playerUuid}", player.getUniqueId().toString());
            }
            if (member != null) {
                command = command.replace("{player}", member.getName());
                command = command.replace("{playerUuid}", member.getUuid().toString());
            }
            command = command.replace("{game}", this.name);
            command = command.replace("{score}", Integer.toString(score));
            if (team != null) {
                command = command.replace("{team}", team.teamInfo.name);
            }
            if (deathStatus != null) {
                command = command.replace("{death}", deathStatus != false ? "true" : "false");
            }
            command = command.startsWith("/") ? command.substring(1) : command;
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
    }

    @Override
    public InGameConfigBooleanConstants getGameStartItems() {
        return this.gameStartItems;
    }

    @Override
    public boolean getOriginalOrInheritedGameStartItems() {
        return this.gameStartItems.isOriginal() ? this.gameStartItems.getValue() : Main.getConfigurator().config.getBoolean(GAME_START_ITEMS);
    }

    @Override
    public InGameConfigBooleanConstants getPlayerRespawnItems() {
        return this.playerRespawnItems;
    }

    @Override
    public boolean getOriginalOrInheritedPlayerRespawnItems() {
        return this.playerRespawnItems.isOriginal() ? this.playerRespawnItems.getValue() : Main.getConfigurator().config.getBoolean(PLAYER_RESPAWN_ITEMS);
    }

    public void setGameStartItems(InGameConfigBooleanConstants gameStartItems) {
        this.gameStartItems = gameStartItems;
    }

    public void setPlayerRespawnItems(InGameConfigBooleanConstants playerRespawnItems) {
        this.playerRespawnItems = playerRespawnItems;
    }

    @Override
    public InGameConfigBooleanConstants getSpawnerHologramsCountdown() {
        return this.spawnerHologramsCountdown;
    }

    @Override
    public boolean getOriginalOrInheritedSpawnerHologramsCountdown() {
        return this.spawnerHologramsCountdown.isOriginal() ? this.spawnerHologramsCountdown.getValue() : Main.getConfigurator().config.getBoolean(SPAWNER_HOLOGRAMS_COUNTDOWN);
    }

    public void setSpawnerHologramsCountdown(InGameConfigBooleanConstants spawnerHologramsCountdown) {
        this.spawnerHologramsCountdown = spawnerHologramsCountdown;
    }

    @Override
    public InGameConfigBooleanConstants getDamageWhenPlayerIsNotInArena() {
        return this.damageWhenPlayerIsNotInArena;
    }

    @Override
    public boolean getOriginalOrInheritedDamageWhenPlayerIsNotInArena() {
        return this.damageWhenPlayerIsNotInArena.isOriginal() ? this.damageWhenPlayerIsNotInArena.getValue() : Main.getConfigurator().config.getBoolean(DAMAGE_WHEN_PLAYER_IS_NOT_IN_ARENA);
    }

    public void setDamageWhenPlayerIsNotInArena(InGameConfigBooleanConstants damageWhenPlayerIsNotInArena) {
        this.damageWhenPlayerIsNotInArena = damageWhenPlayerIsNotInArena;
    }

    @Override
    public InGameConfigBooleanConstants getRemoveUnusedTargetBlocks() {
        return this.removeUnusedTargetBlocks;
    }

    @Override
    public boolean getOriginalOrInheritedRemoveUnusedTargetBlocks() {
        return this.removeUnusedTargetBlocks.isOriginal() ? this.removeUnusedTargetBlocks.getValue() : Main.getConfigurator().config.getBoolean(REMOVE_UNUSED_TARGET_BLOCKS);
    }

    public void setRemoveUnusedTargetBlocks(InGameConfigBooleanConstants removeUnusedTargetBlocks) {
        this.removeUnusedTargetBlocks = removeUnusedTargetBlocks;
    }

    @Override
    public InGameConfigBooleanConstants getAllowBlockFalling() {
        return this.allowBlockFalling;
    }

    @Override
    public boolean getOriginalOrInheritedAllowBlockFalling() {
        return this.allowBlockFalling.isOriginal() ? this.allowBlockFalling.getValue() : Main.getConfigurator().config.getBoolean(ALLOW_BLOCK_FALLING);
    }

    public void setAllowBlockFalling(InGameConfigBooleanConstants allowBlockFalling) {
        this.allowBlockFalling = allowBlockFalling;
    }

    @Override
    public void selectPlayerRandomTeam(Player player) {
        this.joinRandomTeam(Main.getPlayerGameProfile(player));
    }

    @Override
    public StatusBar getStatusBar() {
        return this.statusbar;
    }

    public void kickAllPlayers() {
        for (Player player : this.getConnectedPlayers()) {
            this.leaveFromGame(player);
        }
    }

    public static boolean isBungeeEnabled() {
        return Main.getConfigurator().config.getBoolean("bungee.enabled");
    }

    @Override
    public boolean getBungeeEnabled() {
        return Main.getConfigurator().config.getBoolean("bungee.enabled");
    }

    @Override
    public boolean isEntityShop(Entity entity) {
        for (GameStore store : this.gameStore) {
            if (!entity.equals(store.getEntity())) continue;
            return true;
        }
        return false;
    }

    public RespawnProtection addProtectedPlayer(Player player) {
        int time = Main.getConfigurator().config.getInt("respawn.protection-time", 10);
        RespawnProtection respawnProtection = new RespawnProtection(this, player, time);
        this.respawnProtectionMap.put(player, respawnProtection);
        return respawnProtection;
    }

    public void removeProtectedPlayer(Player player) {
        RespawnProtection respawnProtection = this.respawnProtectionMap.get(player);
        if (respawnProtection == null) {
            return;
        }
        try {
            respawnProtection.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.respawnProtectionMap.remove(player);
    }

    @Override
    public boolean isProtectionActive(Player player) {
        return this.respawnProtectionMap.containsKey(player);
    }

    @Override
    public InGameConfigBooleanConstants getAnchorAutoFill() {
        return this.anchorAutoFill;
    }

    @Override
    public boolean getOriginalOrInheritedAnchorAutoFill() {
        return this.anchorAutoFill.isOriginal() ? this.anchorAutoFill.getValue() : Main.getConfigurator().config.getBoolean(GLOBAL_ANCHOR_AUTO_FILL);
    }

    @Override
    public InGameConfigBooleanConstants getAnchorDecreasing() {
        return this.anchorDecreasing;
    }

    @Override
    public boolean getOriginalOrInheritedAnchorDecreasing() {
        return this.anchorDecreasing.isOriginal() ? this.anchorDecreasing.getValue() : Main.getConfigurator().config.getBoolean(GLOBAL_ANCHOR_DECREASING);
    }

    @Override
    public InGameConfigBooleanConstants getCakeTargetBlockEating() {
        return this.cakeTargetBlockEating;
    }

    @Override
    public boolean getOriginalOrInheritedCakeTargetBlockEating() {
        return this.cakeTargetBlockEating.isOriginal() ? this.cakeTargetBlockEating.getValue() : Main.getConfigurator().config.getBoolean(GLOBAL_CAKE_TARGET_BLOCK_EATING);
    }

    @Override
    public InGameConfigBooleanConstants getTargetBlockExplosions() {
        return this.targetBlockExplosions;
    }

    @Override
    public boolean getOriginalOrInheritedTargetBlockExplosions() {
        return this.targetBlockExplosions.isOriginal() ? this.targetBlockExplosions.getValue() : Main.getConfigurator().config.getBoolean(GLOBAL_TARGET_BLOCK_EXPLOSIONS);
    }

    public void setAnchorAutoFill(InGameConfigBooleanConstants anchorAutoFill) {
        this.anchorAutoFill = anchorAutoFill;
    }

    public void setAnchorDecreasing(InGameConfigBooleanConstants anchorDecreasing) {
        this.anchorDecreasing = anchorDecreasing;
    }

    public void setCakeTargetBlockEating(InGameConfigBooleanConstants cakeTargetBlockEating) {
        this.cakeTargetBlockEating = cakeTargetBlockEating;
    }

    public void setTargetBlockExplosions(InGameConfigBooleanConstants targetBlockExplosions) {
        this.targetBlockExplosions = targetBlockExplosions;
    }

    public List<GamePlayer> getPlayersWithoutVIP() {
        ArrayList<GamePlayer> gamePlayerList = new ArrayList<GamePlayer>(this.players);
        gamePlayerList.removeIf(GamePlayer::canJoinFullGame);
        return gamePlayerList;
    }

    @Override
    public InGameConfigBooleanConstants getHoloAboveBed() {
        return this.holoAboveBed;
    }

    @Override
    public boolean getOriginalOrInheritedHoloAboveBed() {
        return this.holoAboveBed.isOriginal() ? this.holoAboveBed.getValue() : Main.getConfigurator().config.getBoolean(HOLO_ABOVE_BED);
    }

    public void setHoloAboveBed(InGameConfigBooleanConstants holoAboveBed) {
        this.holoAboveBed = holoAboveBed;
    }

    @Override
    public InGameConfigBooleanConstants getSpectatorJoin() {
        return this.spectatorJoin;
    }

    @Override
    public boolean getOriginalOrInheritedSpectatorJoin() {
        return this.spectatorJoin.isOriginal() ? this.spectatorJoin.getValue() : Main.getConfigurator().config.getBoolean(SPECTATOR_JOIN);
    }

    public void setSpectatorJoin(InGameConfigBooleanConstants spectatorJoin) {
        this.spectatorJoin = spectatorJoin;
    }

    @Override
    public InGameConfigBooleanConstants getStopTeamSpawnersOnDie() {
        return this.stopTeamSpawnersOnDie;
    }

    @Override
    public boolean getOriginalOrInheritedStopTeamSpawnersOnDie() {
        return this.stopTeamSpawnersOnDie.isOriginal() ? this.stopTeamSpawnersOnDie.getValue() : Main.getConfigurator().config.getBoolean(STOP_TEAM_SPAWNERS_ON_DIE);
    }

    public void setStopTeamSpawnersOnDie(InGameConfigBooleanConstants stopTeamSpawnersOnDie) {
        this.stopTeamSpawnersOnDie = stopTeamSpawnersOnDie;
    }

    public Inventory getFakeEnderChest(GamePlayer player) {
        if (!this.fakeEnderChests.containsKey(player)) {
            this.fakeEnderChests.put(player, Bukkit.createInventory((InventoryHolder)player.player, (InventoryType)InventoryType.ENDER_CHEST));
        }
        return this.fakeEnderChests.get(player);
    }

    public void setPostGameWaiting(int time) {
        this.postGameWaiting = time;
    }

    @Override
    public int getPostGameWaiting() {
        return this.postGameWaiting;
    }

    @Override
    public String getCustomPrefix() {
        return this.customPrefix;
    }

    @Override
    public boolean isSpectator(@NotNull Player player) {
        if (!Main.isPlayerInGame(player)) {
            return false;
        }
        GamePlayer gamePlayer = Main.getPlayerGameProfile(player);
        return gamePlayer.getGame() == this && gamePlayer.isSpectator;
    }

    public void setCustomPrefix(String customPrefix) {
        this.customPrefix = customPrefix;
    }

    public int getCountdown() {
        return this.countdown;
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

