/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.game;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.WeatherType;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Bed;
import org.bukkit.boss.BarColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.material.Bed;
import org.bukkit.material.Door;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.ArenaTime;
import org.screamingsandals.bedwars.api.InGameConfigBooleanConstants;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GameStore;
import org.screamingsandals.bedwars.game.ItemSpawner;
import org.screamingsandals.bedwars.game.ItemSpawnerType;
import org.screamingsandals.bedwars.game.Team;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.region.FlatteningBedUtils;
import org.screamingsandals.bedwars.region.LegacyBedUtils;
import org.screamingsandals.bedwars.utils.TeamJoinMetaDataValue;

public class GameCreator {
    public static final String BEDWARS_TEAM_JOIN_METADATA = "bw-addteamjoin";
    private Game game;
    private HashMap<String, GameStore> villagerstores = new HashMap();

    public GameCreator(Game game) {
        this.game = game;
        List<GameStore> gs = game.getGameStoreList();
        if (!gs.isEmpty()) {
            for (GameStore store : gs) {
                this.villagerstores.put(store.getStoreLocation().getBlockX() + ";" + store.getStoreLocation().getBlockY() + ";" + store.getStoreLocation().getBlockZ(), store);
            }
        }
    }

    public Game getGame() {
        return this.game;
    }

    public boolean cmd(Player player, String action, String[] args) {
        boolean isArenaSaved = false;
        String response = null;
        String response2 = null;
        if (action.equalsIgnoreCase("lobby")) {
            response = this.setLobbySpawn(player.getLocation());
        } else if (action.equalsIgnoreCase("spec")) {
            response = this.setSpecSpawn(player.getLocation());
        } else if (action.equalsIgnoreCase("pos1")) {
            response = this.setPos1(player.getLocation(), args.length > 0 && "force".equalsIgnoreCase(args[0]));
        } else if (action.equalsIgnoreCase("pos2")) {
            response = this.setPos2(player.getLocation(), args.length > 0 && "force".equalsIgnoreCase(args[0]));
        } else if (action.equalsIgnoreCase("pausecountdown")) {
            if (args.length >= 1) {
                response = this.setPauseCountdown(Integer.parseInt(args[0]));
            }
        } else if (action.equalsIgnoreCase("time")) {
            if (args.length >= 1) {
                response = this.setGameTime(Integer.parseInt(args[0]));
            }
        } else if (action.equalsIgnoreCase("postgamewaiting")) {
            if (args.length >= 1) {
                response = this.setPostGameWaiting(Integer.parseInt(args[0]));
            }
        } else if (action.equalsIgnoreCase("arenatime")) {
            if (args.length >= 1) {
                response = this.setArenaTime(args[0]);
            }
        } else if (action.equalsIgnoreCase("arenaweather")) {
            if (args.length >= 1) {
                response = this.setArenaWeather(args[0]);
            }
        } else if (action.equalsIgnoreCase("minplayers")) {
            if (args.length >= 1) {
                response = this.setMinPlayers(Integer.parseInt(args[0]));
            }
        } else if (action.equalsIgnoreCase("config")) {
            if (args.length >= 2) {
                response = this.setLocalConfigVariable(args[0], args[1]);
            }
        } else if (action.equalsIgnoreCase("team")) {
            if (args.length >= 2) {
                if (args[0].equalsIgnoreCase("add")) {
                    if (args.length >= 4) {
                        response = this.addTeam(args[1], args[2], Integer.parseInt(args[3]));
                    }
                } else if (args[0].equalsIgnoreCase("remove")) {
                    response = this.removeTeam(args[1]);
                } else if (args[0].equalsIgnoreCase("color")) {
                    if (args.length >= 3) {
                        response = this.setTeamColor(args[1], args[2]);
                    }
                } else if (args[0].equalsIgnoreCase("maxplayers")) {
                    if (args.length >= 3) {
                        response = this.setTeamMaxPlayers(args[1], Integer.parseInt(args[2]));
                    }
                } else if (args[0].equalsIgnoreCase("spawn")) {
                    response = this.setTeamSpawn(args[1], player.getLocation());
                } else if (args[0].equalsIgnoreCase("bed")) {
                    response = this.setTeamBed(player, args[1], player.getTargetBlock(null, 5), args.length >= 3 && args[2].equalsIgnoreCase("standing_on"));
                }
            }
        } else if (action.equalsIgnoreCase("spawner")) {
            if (args.length >= 1) {
                if (args[0].equalsIgnoreCase("add")) {
                    if (args.length >= 3) {
                        if (args[2].equalsIgnoreCase("true") || args[2].equalsIgnoreCase("false")) {
                            if (args.length >= 4) {
                                double customLevel;
                                try {
                                    customLevel = Double.parseDouble(args[3]);
                                }
                                catch (NumberFormatException e) {
                                    player.sendMessage(I18n.i18n("admin_command_invalid_spawner_level"));
                                    customLevel = 1.0;
                                }
                                if (args.length >= 5) {
                                    if (args.length >= 6) {
                                        Team newTeam = null;
                                        for (Team team : this.game.getTeams()) {
                                            if (!team.name.equals(args[5])) continue;
                                            newTeam = team;
                                        }
                                        int maxSpawnedResources = -1;
                                        if (newTeam == null) {
                                            boolean error = true;
                                            if (args.length == 6) {
                                                try {
                                                    maxSpawnedResources = Integer.parseInt(args[5]);
                                                    error = false;
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    // empty catch block
                                                }
                                            }
                                            if (error) {
                                                player.sendMessage(I18n.i18n("admin_command_invalid_team").replace("%team%", args[5]));
                                                return false;
                                            }
                                        } else if (args.length >= 7) {
                                            maxSpawnedResources = Integer.parseInt(args[6]);
                                        }
                                        response = this.addSpawner(args[1], player.getLocation(), args[4], Boolean.parseBoolean(args[2]), customLevel, newTeam, maxSpawnedResources);
                                    } else {
                                        response = this.addSpawner(args[1], player.getLocation(), args[4], Boolean.parseBoolean(args[2]), customLevel, null, -1);
                                    }
                                } else {
                                    response = this.addSpawner(args[1], player.getLocation(), null, Boolean.parseBoolean(args[2]), customLevel, null, -1);
                                }
                            } else {
                                response = this.addSpawner(args[1], player.getLocation(), null, Boolean.parseBoolean(args[2]), 1.0, null, -1);
                            }
                        } else {
                            response = null;
                        }
                    } else if (args.length == 2) {
                        response = this.addSpawner(args[1], player.getLocation(), null, true, 1.0, null, -1);
                    }
                } else if (args[0].equalsIgnoreCase("remove")) {
                    response = this.removeSpawner(player.getLocation());
                } else if (args[0].equalsIgnoreCase("reset")) {
                    response = this.resetAllSpawners();
                }
            }
        } else if (action.equalsIgnoreCase("store")) {
            if (args.length >= 1) {
                if (args[0].equalsIgnoreCase("add")) {
                    if (args.length >= 2) {
                        if (args.length >= 3) {
                            if (args.length >= 4) {
                                if (!"true".equalsIgnoreCase(args[3]) && !"false".equalsIgnoreCase(args[3])) {
                                    Team newTeam = null;
                                    for (Team team : this.game.getTeams()) {
                                        if (!team.name.equals(args[3])) continue;
                                        newTeam = team;
                                    }
                                    response = args.length >= 5 ? this.addStore(player.getLocation(), args[2], Boolean.parseBoolean(args[4]), args[1], newTeam) : this.addStore(player.getLocation(), args[2], false, args[1], newTeam);
                                } else {
                                    response = this.addStore(player.getLocation(), args[2], Boolean.parseBoolean(args[3]), args[1], null);
                                }
                            } else {
                                response = this.addStore(player.getLocation(), args[2], false, args[1], null);
                            }
                        } else {
                            response = this.addStore(player.getLocation(), null, true, args[1], null);
                        }
                    } else {
                        response = this.addStore(player.getLocation(), null, true, null, null);
                    }
                } else if (args[0].equalsIgnoreCase("remove")) {
                    response = this.removeStore(player.getLocation());
                } else if (args[0].equalsIgnoreCase("child")) {
                    response = this.setStoreAge(player.getLocation(), true);
                } else if (args[0].equalsIgnoreCase("adult")) {
                    response = this.setStoreAge(player.getLocation(), false);
                } else if (args[0].equalsIgnoreCase("type") && args.length >= 2) {
                    response = this.changeStoreEntityType(player.getLocation(), args[1]);
                }
            }
        } else if (action.equalsIgnoreCase("jointeam")) {
            if (args.length >= 1) {
                response = this.addTeamJoinEntity(player, args[0]);
            }
        } else if (action.equalsIgnoreCase("lobbybossbarcolor")) {
            if (args.length >= 1) {
                response = this.setLobbyBossBarColor(args[0]);
            }
        } else if (action.equalsIgnoreCase("gamebossbarcolor")) {
            if (args.length >= 1) {
                response = this.setGameBossBarColor(args[0]);
            }
        } else if (action.equalsIgnoreCase("customprefix")) {
            if (args.length >= 1) {
                response = this.setCustomPrefix(String.join((CharSequence)" ", args));
            }
        } else if (action.equalsIgnoreCase("save")) {
            boolean force = args.length >= 1 && "force".equalsIgnoreCase(args[0]);
            ArrayList<GameStore> gamestores = new ArrayList<GameStore>();
            for (Map.Entry<String, GameStore> vloc : this.villagerstores.entrySet()) {
                gamestores.add(vloc.getValue());
            }
            boolean isTeamsSetCorrectly = true;
            for (Team team : this.game.getTeams()) {
                if (team.bed == null) {
                    response = I18n.i18n("admin_command_set_bed_for_team_before_save").replace("%team%", team.name);
                    isTeamsSetCorrectly = false;
                    break;
                }
                if (team.spawn != null) continue;
                response = I18n.i18n("admin_command_set_spawn_for_team_before_save").replace("%team%", team.name);
                isTeamsSetCorrectly = false;
                break;
            }
            if (isTeamsSetCorrectly) {
                this.game.setGameStores(gamestores);
                if (this.game.getTeams().size() < 2) {
                    response = I18n.i18n("admin_command_need_min_2_teems");
                } else if (this.game.getPos1() == null || this.game.getPos2() == null) {
                    response = I18n.i18n("admin_command_set_pos1_pos2_before_save");
                } else if (this.game.getLobbySpawn() == null) {
                    response = I18n.i18n("admin_command_set_lobby_before_save");
                } else if (this.game.getSpecSpawn() == null) {
                    response = I18n.i18n("admin_command_set_spec_before_save");
                } else if (!force && this.game.getGameStoreList().isEmpty()) {
                    response = I18n.i18n("admin_command_set_stores_before_save");
                    response2 = I18n.i18n("admin_arena_force_save").replace("%game%", this.game.getName()).replace("%command%", "/bw admin " + this.game.getName() + " save force");
                } else if (!force && this.game.getSpawners().isEmpty()) {
                    response = I18n.i18n("admin_command_set_spawners_before_save");
                    response2 = I18n.i18n("admin_arena_force_save").replace("%game%", this.game.getName()).replace("%command%", "/bw admin " + this.game.getName() + " save force");
                } else {
                    this.game.saveToConfig();
                    this.game.start();
                    Main.addGame(this.game);
                    response = I18n.i18n("admin_command_game_saved_and_started");
                    isArenaSaved = true;
                }
            }
        }
        if (response == null) {
            response = I18n.i18n("unknown_command");
        }
        player.sendMessage(response);
        if (response2 != null) {
            player.sendMessage(response2);
        }
        return isArenaSaved;
    }

    private String setCustomPrefix(String arg) {
        if (arg.equalsIgnoreCase("off")) {
            this.game.setCustomPrefix(null);
            return I18n.i18n("admin_command_customprefix_disabled");
        }
        this.game.setCustomPrefix(arg);
        return I18n.i18n("admin_command_customprefix_enabled").replace("%prefix%", arg);
    }

    private String setPostGameWaiting(int time) {
        if (time >= 0) {
            this.game.setPostGameWaiting(time);
            return I18n.i18n("admin_command_post_game_waiting").replace("%number%", String.valueOf(time));
        }
        return I18n.i18n("admin_command_invalid_time").replace("%number%", String.valueOf(time));
    }

    private String setGameBossBarColor(String color) {
        color = color.toUpperCase();
        BarColor c = null;
        if (!color.equalsIgnoreCase("default")) {
            try {
                c = BarColor.valueOf((String)color);
            }
            catch (Exception e) {
                return I18n.i18n("admin_command_invalid_bar_color");
            }
        }
        this.game.setGameBossBarColor(c);
        return I18n.i18n("admin_command_bar_color_set").replace("%color%", c == null ? "default" : c.name()).replace("%type%", "GAME");
    }

    private String setLobbyBossBarColor(String color) {
        color = color.toUpperCase();
        BarColor c = null;
        if (!color.equalsIgnoreCase("default")) {
            try {
                c = BarColor.valueOf((String)color);
            }
            catch (Exception e) {
                return I18n.i18n("admin_command_invalid_bar_color");
            }
        }
        this.game.setLobbyBossBarColor(c);
        return I18n.i18n("admin_command_bar_color_set").replace("%color%", c == null ? "default" : c.name()).replace("%type%", "LOBBY");
    }

    private String setArenaWeather(String arenaWeather) {
        arenaWeather = arenaWeather.toUpperCase();
        WeatherType c = null;
        if (!arenaWeather.equalsIgnoreCase("default")) {
            try {
                c = WeatherType.valueOf((String)arenaWeather);
            }
            catch (Exception e) {
                return I18n.i18n("admin_command_invalid_arena_weather");
            }
        }
        this.game.setArenaWeather(c);
        return I18n.i18n("admin_command_arena_weather_set").replace("%weather%", c == null ? "default" : c.name());
    }

    private String setArenaTime(String arenaTime) {
        ArenaTime c;
        arenaTime = arenaTime.toUpperCase();
        try {
            c = ArenaTime.valueOf(arenaTime);
        }
        catch (Exception e) {
            return I18n.i18n("admin_command_invalid_arena_time");
        }
        this.game.setArenaTime(c);
        return I18n.i18n("admin_command_arena_time_set").replace("%time%", c.name());
    }

    private String setLocalConfigVariable(String config, String value) {
        InGameConfigBooleanConstants cons;
        switch (value = value.toLowerCase()) {
            case "t": 
            case "tr": 
            case "tru": 
            case "true": 
            case "y": 
            case "ye": 
            case "yes": 
            case "1": {
                cons = InGameConfigBooleanConstants.TRUE;
                value = "true";
                break;
            }
            case "f": 
            case "fa": 
            case "fal": 
            case "fals": 
            case "false": 
            case "n": 
            case "no": 
            case "0": {
                cons = InGameConfigBooleanConstants.FALSE;
                value = "false";
                break;
            }
            case "i": 
            case "in": 
            case "inh": 
            case "inhe": 
            case "inher": 
            case "inheri": 
            case "inherit": 
            case "d": 
            case "de": 
            case "def": 
            case "defa": 
            case "defau": 
            case "defaul": 
            case "default": {
                cons = InGameConfigBooleanConstants.INHERIT;
                value = "inherit";
                break;
            }
            default: {
                return I18n.i18n("admin_command_invalid_config_value");
            }
        }
        switch (config = config.toLowerCase().replace("-", "")) {
            case "compassenabled": {
                this.game.setCompassEnabled(cons);
                break;
            }
            case "joinrandomteamafterlobby": 
            case "joinrandomlyafterlobbytimeout": {
                this.game.setJoinRandomTeamAfterLobby(cons);
                break;
            }
            case "joinrandomteamonjoin": 
            case "joinrandomlyonlobbyjoin": {
                this.game.setJoinRandomTeamOnJoin(cons);
                break;
            }
            case "addwooltoinventoryonjoin": {
                this.game.setAddWoolToInventoryOnJoin(cons);
                break;
            }
            case "preventkillingvillagers": {
                this.game.setPreventKillingVillagers(cons);
                break;
            }
            case "playerdrops": {
                this.game.setPlayerDrops(cons);
                break;
            }
            case "friendlyfire": {
                this.game.setFriendlyfire(cons);
                break;
            }
            case "coloredleatherbyteaminlobby": 
            case "inlobbycoloredleatherbyteam": {
                this.game.setColoredLeatherByTeamInLobby(cons);
                break;
            }
            case "keepinventory": 
            case "keepinventoryondeath": {
                this.game.setKeepInventory(cons);
                break;
            }
            case "crafting": 
            case "allowcrafting": {
                this.game.setCrafting(cons);
                break;
            }
            case "bossbar": 
            case "gamebossbar": {
                this.game.setGameBossbar(cons);
                break;
            }
            case "lobbybossbar": {
                this.game.setLobbyBossbar(cons);
                break;
            }
            case "scoreboard": 
            case "gamescoreboard": {
                this.game.setAscoreboard(cons);
                break;
            }
            case "lobbyscoreboard": {
                this.game.setLobbyScoreboard(cons);
                break;
            }
            case "preventspawningmobs": 
            case "preventmobs": 
            case "mobs": {
                this.game.setPreventSpawningMobs(cons);
                break;
            }
            case "spawnerholograms": {
                this.game.setSpawnerHolograms(cons);
                break;
            }
            case "spawnerdisablemerge": {
                this.game.setSpawnerDisableMerge(cons);
                break;
            }
            case "gamestartitems": 
            case "giveitemsongamestart": {
                this.game.setGameStartItems(cons);
                break;
            }
            case "playerrespawnitems": 
            case "giveitemsonplayerrespawn": {
                this.game.setPlayerRespawnItems(cons);
                break;
            }
            case "spawnerhologramscountdown": {
                this.game.setSpawnerHologramsCountdown(cons);
                break;
            }
            case "damagewhenplayerisnotinarena": {
                this.game.setDamageWhenPlayerIsNotInArena(cons);
                break;
            }
            case "removeunusedtargetblocks": {
                this.game.setRemoveUnusedTargetBlocks(cons);
                break;
            }
            case "allowblockfall": 
            case "allowblockfalling": {
                this.game.setAllowBlockFalling(cons);
                break;
            }
            case "holoabovebed": 
            case "hologramabovebed": 
            case "holobed": 
            case "hologrambed": {
                this.game.setHoloAboveBed(cons);
                break;
            }
            case "spectatorjoin": 
            case "allowspectatorjoin": {
                this.game.setSpectatorJoin(cons);
                break;
            }
            case "stopteamspawnersondie": 
            case "stopdeathspawners": {
                this.game.setStopTeamSpawnersOnDie(cons);
                break;
            }
            case "anchorautofill": 
            case "anchorfillonstart": {
                this.game.setAnchorAutoFill(cons);
                break;
            }
            case "anchordecreasing": 
            case "anchorenabledescrease": {
                this.game.setAnchorDecreasing(cons);
                break;
            }
            case "caketargetblockeating": 
            case "cakeeating": {
                this.game.setCakeTargetBlockEating(cons);
                break;
            }
            case "targetblockexplosions": {
                this.game.setTargetBlockExplosions(cons);
                break;
            }
            default: {
                return I18n.i18n("admin_command_invalid_config_variable_name");
            }
        }
        return I18n.i18n("admin_command_config_variable_set_to").replace("%config%", config).replace("%value%", value);
    }

    private String setMinPlayers(int minPlayers) {
        if (minPlayers < 2) {
            return I18n.i18n("admin_command_invalid_min_players");
        }
        this.game.setMinPlayers(minPlayers);
        return I18n.i18n("admin_command_min_players_set").replace("%min%", Integer.toString(minPlayers));
    }

    private String addTeamJoinEntity(final Player player, String name) {
        for (Team t : this.game.getTeams()) {
            if (!t.name.equals(name)) continue;
            if (player.hasMetadata(BEDWARS_TEAM_JOIN_METADATA)) {
                player.removeMetadata(BEDWARS_TEAM_JOIN_METADATA, (Plugin)Main.getInstance());
            }
            player.setMetadata(BEDWARS_TEAM_JOIN_METADATA, (MetadataValue)new TeamJoinMetaDataValue(t));
            new BukkitRunnable(){

                public void run() {
                    if (!player.hasMetadata(GameCreator.BEDWARS_TEAM_JOIN_METADATA)) {
                        return;
                    }
                    player.removeMetadata(GameCreator.BEDWARS_TEAM_JOIN_METADATA, (Plugin)Main.getInstance());
                }
            }.runTaskLater((Plugin)Main.getInstance(), 200L);
            return I18n.i18n("admin_command_click_right_on_entity_to_set_join").replace("%team%", t.name);
        }
        return I18n.i18n("admin_command_team_is_not_exists");
    }

    private String setTeamBed(Player player, String name, Block block, boolean standingOn) {
        for (Team t : this.game.getTeams()) {
            Door door;
            Bed bed;
            if (!t.name.equals(name)) continue;
            if (standingOn) {
                block = player.getLocation().getBlock().getLocation().subtract(0.0, 0.5, 0.0).getBlock();
            }
            Location loc = block.getLocation();
            if (this.game.getPos1() == null || this.game.getPos2() == null) {
                return I18n.i18n("admin_command_set_pos1_pos2_first");
            }
            if (this.game.getWorld() != loc.getWorld()) {
                return I18n.i18n("admin_command_must_be_in_same_world");
            }
            if (!GameCreator.isInArea(loc, this.game.getPos1(), this.game.getPos2())) {
                return I18n.i18n("admin_command_spawn_must_be_in_area");
            }
            t.bed = Main.isLegacy() ? (block.getState().getData() instanceof Bed ? (!(bed = (Bed)block.getState().getData()).isHeadOfBed() ? LegacyBedUtils.getBedNeighbor(block).getLocation() : loc) : (block.getState().getData() instanceof Door ? ((door = (Door)block.getState().getData()).isTopHalf() ? loc.subtract(0.0, 1.0, 0.0) : loc) : loc)) : (block.getBlockData() instanceof org.bukkit.block.data.type.Bed ? ((bed = (org.bukkit.block.data.type.Bed)block.getBlockData()).getPart() != Bed.Part.HEAD ? FlatteningBedUtils.getBedNeighbor(block).getLocation() : loc) : (block.getBlockData() instanceof org.bukkit.block.data.type.Door ? ((door = (org.bukkit.block.data.type.Door)block.getBlockData()).getHalf() == Bisected.Half.TOP ? loc.subtract(0.0, 1.0, 0.0) : loc) : loc));
            try {
                player.spawnParticle(Particle.VILLAGER_HAPPY, t.bed.clone().add(0.0, 0.0, 0.0), 1);
                player.spawnParticle(Particle.VILLAGER_HAPPY, t.bed.clone().add(0.0, 0.0, 1.0), 1);
                player.spawnParticle(Particle.VILLAGER_HAPPY, t.bed.clone().add(1.0, 0.0, 0.0), 1);
                player.spawnParticle(Particle.VILLAGER_HAPPY, t.bed.clone().add(1.0, 0.0, 1.0), 1);
                player.spawnParticle(Particle.VILLAGER_HAPPY, t.bed.clone().add(0.0, 1.0, 0.0), 1);
                player.spawnParticle(Particle.VILLAGER_HAPPY, t.bed.clone().add(0.0, 1.0, 1.0), 1);
                player.spawnParticle(Particle.VILLAGER_HAPPY, t.bed.clone().add(1.0, 1.0, 0.0), 1);
                player.spawnParticle(Particle.VILLAGER_HAPPY, t.bed.clone().add(1.0, 1.0, 1.0), 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return I18n.i18n("admin_command_bed_setted").replace("%team%", t.name).replace("%x%", Integer.toString(t.bed.getBlockX())).replace("%y%", Integer.toString(t.bed.getBlockY())).replace("%z%", Integer.toString(t.bed.getBlockZ()));
        }
        return I18n.i18n("admin_command_team_is_not_exists");
    }

    private String setTeamSpawn(String name, Location loc) {
        for (Team t : this.game.getTeams()) {
            if (!t.name.equals(name)) continue;
            if (this.game.getPos1() == null || this.game.getPos2() == null) {
                return I18n.i18n("admin_command_set_pos1_pos2_first");
            }
            if (this.game.getWorld() != loc.getWorld()) {
                return I18n.i18n("admin_command_must_be_in_same_world");
            }
            if (!GameCreator.isInArea(loc, this.game.getPos1(), this.game.getPos2())) {
                return I18n.i18n("admin_command_spawn_must_be_in_area");
            }
            t.spawn = loc;
            return I18n.i18n("admin_command_team_spawn_setted").replace("%team%", t.name).replace("%x%", Double.toString(t.spawn.getX())).replace("%y%", Double.toString(t.spawn.getY())).replace("%z%", Double.toString(t.spawn.getZ())).replace("%yaw%", Float.toString(t.spawn.getYaw())).replace("%pitch%", Float.toString(t.spawn.getPitch()));
        }
        return I18n.i18n("admin_command_team_is_not_exists");
    }

    private String setTeamMaxPlayers(String name, int maxPlayers) {
        for (Team t : this.game.getTeams()) {
            if (!t.name.equals(name)) continue;
            if (maxPlayers < 1) {
                return I18n.i18n("admin_command_max_players_fail");
            }
            t.maxPlayers = maxPlayers;
            return I18n.i18n("admin_command_team_maxplayers_setted").replace("%team%", t.name).replace("%maxplayers%", Integer.toString(t.maxPlayers));
        }
        return I18n.i18n("admin_command_team_is_not_exists");
    }

    private String setTeamColor(String name, String color) {
        color = color.toUpperCase();
        for (Team t : this.game.getTeams()) {
            TeamColor c;
            if (!t.name.equals(name)) continue;
            try {
                c = TeamColor.valueOf(color);
            }
            catch (Exception e) {
                return I18n.i18n("admin_command_invalid_color");
            }
            t.color = c;
            return I18n.i18n("admin_command_team_color_setted").replace("%team%", t.name).replace("%teamcolor%", t.color.chatColor + t.color.name());
        }
        return I18n.i18n("admin_command_team_is_not_exists");
    }

    private String removeTeam(String name) {
        Team forRemove = null;
        for (Team t : this.game.getTeams()) {
            if (!t.name.equals(name)) continue;
            forRemove = t;
            break;
        }
        if (forRemove != null) {
            this.game.getTeams().remove(forRemove);
            return I18n.i18n("admin_command_team_removed").replace("%team%", forRemove.name);
        }
        return I18n.i18n("admin_command_team_is_not_exists");
    }

    private String addTeam(String name, String color, int maxPlayers) {
        TeamColor c;
        String saveName = name.replace('.', '_').replace(' ', '_');
        for (Team t : this.game.getTeams()) {
            if (!t.name.equals(name) && !t.getSaveName().equals(saveName)) continue;
            return I18n.i18n("admin_command_team_is_already_exists");
        }
        color = color.toUpperCase();
        try {
            c = TeamColor.valueOf(color);
        }
        catch (Exception e) {
            return I18n.i18n("admin_command_invalid_color");
        }
        if (maxPlayers < 1) {
            return I18n.i18n("admin_command_max_players_fail");
        }
        Team team = new Team();
        team.name = name;
        team.color = c;
        team.maxPlayers = maxPlayers;
        team.game = this.game;
        team.saveName = saveName;
        this.game.getTeams().add(team);
        return I18n.i18n("admin_command_team_created").replace("%team%", team.name).replace("%teamcolor%", team.color.chatColor + team.color.name()).replace("%maxplayers%", Integer.toString(team.maxPlayers));
    }

    private String resetAllSpawners() {
        this.game.getSpawners().clear();
        return I18n.i18n("admin_command_spawners_reseted").replace("%arena%", this.game.getName());
    }

    private String addSpawner(String type, Location loc, String customName, boolean hologramEnabled, double startLevel, org.screamingsandals.bedwars.api.Team team, int maxSpawnedResources) {
        if (this.game.getPos1() == null || this.game.getPos2() == null) {
            return I18n.i18n("admin_command_set_pos1_pos2_first");
        }
        if (this.game.getWorld() != loc.getWorld()) {
            return I18n.i18n("admin_command_must_be_in_same_world");
        }
        if (!GameCreator.isInArea(loc, this.game.getPos1(), this.game.getPos2())) {
            return I18n.i18n("admin_command_spawn_must_be_in_area");
        }
        loc.setYaw(0.0f);
        loc.setPitch(0.0f);
        ItemSpawnerType spawnerType = Main.getSpawnerType(type);
        if (spawnerType != null) {
            this.game.getSpawners().add(new ItemSpawner(loc, spawnerType, customName, hologramEnabled, startLevel, team, maxSpawnedResources));
            return I18n.i18n("admin_command_spawner_added").replace("%resource%", spawnerType.getItemName()).replace("%x%", Integer.toString(loc.getBlockX())).replace("%y%", Integer.toString(loc.getBlockY())).replace("%z%", Integer.toString(loc.getBlockZ()));
        }
        return I18n.i18n("admin_command_invalid_spawner_type");
    }

    private String removeSpawner(Location loc) {
        if (this.game.getPos1() == null || this.game.getPos2() == null) {
            return I18n.i18n("admin_command_set_pos1_pos2_first");
        }
        if (this.game.getWorld() != loc.getWorld()) {
            return I18n.i18n("admin_command_must_be_in_same_world");
        }
        if (!GameCreator.isInArea(loc, this.game.getPos1(), this.game.getPos2())) {
            return I18n.i18n("admin_command_spawn_must_be_in_area");
        }
        int count = 0;
        for (ItemSpawner spawner : new ArrayList<ItemSpawner>(this.game.getSpawners())) {
            if (!spawner.getLocation().getBlock().equals(loc.getBlock())) continue;
            this.game.getSpawners().remove(spawner);
            ++count;
        }
        return I18n.i18n("admin_command_removed_spawners").replace("%count%", Integer.toString(count)).replace("%x%", Integer.toString(loc.getBlockX())).replace("%y%", Integer.toString(loc.getBlockY())).replace("%z%", Integer.toString(loc.getBlockZ()));
    }

    public String addStore(Location loc, String shop, boolean useParent, String name, Team team) {
        if (this.game.getPos1() == null || this.game.getPos2() == null) {
            return I18n.i18n("admin_command_set_pos1_pos2_first");
        }
        if (this.game.getWorld() != loc.getWorld()) {
            return I18n.i18n("admin_command_must_be_in_same_world");
        }
        if (!GameCreator.isInArea(loc, this.game.getPos1(), this.game.getPos2())) {
            return I18n.i18n("admin_command_spawn_must_be_in_area");
        }
        String location = loc.getBlockX() + ";" + loc.getBlockY() + ";" + loc.getBlockZ();
        if (this.villagerstores.containsKey(location)) {
            return I18n.i18n("admin_command_store_already_exists");
        }
        if (name != null) {
            name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        }
        GameStore gameStore = new GameStore(loc, shop, useParent, name, name != null, false);
        if (team != null) {
            gameStore.setTeam(team);
        }
        this.villagerstores.put(location, gameStore);
        return I18n.i18n("admin_command_store_added").replace("%x%", Double.toString(loc.getX())).replace("%y%", Double.toString(loc.getY())).replace("%z%", Double.toString(loc.getZ())).replace("%yaw%", Float.toString(loc.getYaw())).replace("%pitch%", Float.toString(loc.getPitch()));
    }

    private String changeStoreEntityType(Location loc, String type) {
        String location = loc.getBlockX() + ";" + loc.getBlockY() + ";" + loc.getBlockZ();
        if (this.villagerstores.containsKey(location)) {
            EntityType t = null;
            try {
                t = EntityType.valueOf((String)type.split(":", 2)[0].toUpperCase());
                if (!t.isAlive()) {
                    t = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (t == EntityType.PLAYER) {
                String[] splitted = type.split(":", 2);
                if (splitted.length != 2 || splitted[1].trim().equals("")) {
                    return I18n.i18n("admin_command_npc_must_have_skinname");
                }
                this.villagerstores.get(location).setEntityTypeNPC(splitted[1]);
                return I18n.i18n("admin_command_store_living_entity_type_set").replace("%type%", splitted[1]);
            }
            if (t == null) {
                return I18n.i18n("admin_command_wrong_living_entity_type");
            }
            this.villagerstores.get(location).setEntityType(t);
            return I18n.i18n("admin_command_store_living_entity_type_set").replace("%type%", t.toString());
        }
        return I18n.i18n("admin_command_store_not_exists");
    }

    private String setStoreAge(Location loc, boolean child) {
        String location = loc.getBlockX() + ";" + loc.getBlockY() + ";" + loc.getBlockZ();
        if (this.villagerstores.containsKey(location)) {
            this.villagerstores.get(location).setBaby(child);
            return I18n.i18n("admin_command_store_child_state").replace("%value%", I.i18nonly(child ? "arena_info_config_true" : "arena_info_config_false"));
        }
        return I18n.i18n("admin_command_store_not_exists");
    }

    public String removeStore(Location loc) {
        if (this.game.getWorld() != loc.getWorld()) {
            return I18n.i18n("admin_command_must_be_in_same_world");
        }
        String location = loc.getBlockX() + ";" + loc.getBlockY() + ";" + loc.getBlockZ();
        if (!this.villagerstores.containsKey(location)) {
            return I18n.i18n("admin_command_store_not_exists");
        }
        this.villagerstores.remove(location);
        return I18n.i18n("admin_command_store_removed").replace("%x%", Double.toString(loc.getX())).replace("%y%", Double.toString(loc.getY())).replace("%z%", Double.toString(loc.getZ())).replace("%yaw%", Float.toString(loc.getYaw())).replace("%pitch%", Float.toString(loc.getPitch()));
    }

    public String setLobbySpawn(Location loc) {
        this.game.setLobbySpawn(loc);
        return I18n.i18n("admin_command_lobby_spawn_setted").replace("%x%", Double.toString(loc.getX())).replace("%y%", Double.toString(loc.getY())).replace("%z%", Double.toString(loc.getZ())).replace("%yaw%", Float.toString(loc.getYaw())).replace("%pitch%", Float.toString(loc.getPitch()));
    }

    public String setSpecSpawn(Location loc) {
        if (this.game.getPos1() == null || this.game.getPos2() == null) {
            return I18n.i18n("admin_command_set_pos1_pos2_first");
        }
        if (this.game.getWorld() != loc.getWorld()) {
            return I18n.i18n("admin_command_must_be_in_same_world");
        }
        if (!GameCreator.isInArea(loc, this.game.getPos1(), this.game.getPos2())) {
            return I18n.i18n("admin_command_spawn_must_be_in_area");
        }
        this.game.setSpecSpawn(loc);
        return I18n.i18n("admin_command_spec_spawn_setted").replace("%x%", Double.toString(loc.getX())).replace("%y%", Double.toString(loc.getY())).replace("%z%", Double.toString(loc.getZ())).replace("%yaw%", Float.toString(loc.getYaw())).replace("%pitch%", Float.toString(loc.getPitch()));
    }

    public String setPos1(Location loc, boolean force) {
        if (this.game.getWorld() == null) {
            this.game.setWorld(loc.getWorld());
        }
        if (this.game.getWorld() != loc.getWorld()) {
            return I18n.i18n("admin_command_must_be_in_same_world");
        }
        if (this.game.getPos2() != null && Math.abs(this.game.getPos2().getBlockY() - loc.getBlockY()) <= 5) {
            return I18n.i18n("admin_command_pos1_pos2_difference_must_be_higher");
        }
        if (!force) {
            for (String gameN : Main.getGameNames()) {
                Game game1 = Main.getGame(gameN);
                if (game1 == this.game || (this.game.getPos2() == null || !GameCreator.arenaOverlaps(game1.getPos1(), game1.getPos2(), loc, this.game.getPos2())) && (this.game.getPos2() != null || !GameCreator.isInArea(loc, game1.getPos1(), game1.getPos2()))) continue;
                return I18n.i18n("admin_arena_overlaps").replace("%arena%", this.game.getName()).replace("%position%", "pos1");
            }
        }
        this.game.setPos1(loc);
        return I18n.i18n("admin_command_pos1_setted").replace("%arena%", this.game.getName()).replace("%x%", Integer.toString(loc.getBlockX())).replace("%y%", Integer.toString(loc.getBlockY())).replace("%z%", Integer.toString(loc.getBlockZ()));
    }

    public String setPos2(Location loc, boolean force) {
        if (this.game.getWorld() == null) {
            this.game.setWorld(loc.getWorld());
        }
        if (this.game.getWorld() != loc.getWorld()) {
            return I18n.i18n("admin_command_must_be_in_same_world");
        }
        if (this.game.getPos1() != null && Math.abs(this.game.getPos1().getBlockY() - loc.getBlockY()) <= 5) {
            return I18n.i18n("admin_command_pos1_pos2_difference_must_be_higher");
        }
        if (!force) {
            for (String gameN : Main.getGameNames()) {
                Game game1 = Main.getGame(gameN);
                if (game1 == this.game || (this.game.getPos1() == null || !GameCreator.arenaOverlaps(game1.getPos1(), game1.getPos2(), this.game.getPos1(), loc)) && (this.game.getPos1() != null || !GameCreator.isInArea(loc, game1.getPos1(), game1.getPos2()))) continue;
                return I18n.i18n("admin_arena_overlaps").replace("%arena%", this.game.getName()).replace("%position%", "pos2");
            }
        }
        this.game.setPos2(loc);
        return I18n.i18n("admin_command_pos2_setted").replace("%arena%", this.game.getName()).replace("%x%", Integer.toString(loc.getBlockX())).replace("%y%", Integer.toString(loc.getBlockY())).replace("%z%", Integer.toString(loc.getBlockZ()));
    }

    public String setPauseCountdown(int countdown) {
        if (countdown >= 10 && countdown <= 600) {
            this.game.setPauseCountdown(countdown);
            return I18n.i18n("admin_command_pausecontdown_setted").replace("%countdown%", Integer.toString(countdown));
        }
        return I18n.i18n("admin_command_invalid_countdown");
    }

    public String setGameTime(int countdown) {
        if (countdown >= 10 && countdown <= 3600) {
            this.game.setGameTime(countdown);
            return I18n.i18n("admin_command_gametime_setted").replace("%time%", Integer.toString(countdown));
        }
        return I18n.i18n("admin_command_invalid_countdown2");
    }

    public static boolean isInArea(Location l, Location p1, Location p2) {
        if (!p1.getWorld().equals(l.getWorld())) {
            return false;
        }
        Location min = new Location(p1.getWorld(), Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
        Location max = new Location(p1.getWorld(), Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
        return min.getX() <= l.getX() && min.getY() <= l.getY() && min.getZ() <= l.getZ() && max.getX() >= l.getX() && max.getY() >= l.getY() && max.getZ() >= l.getZ();
    }

    public static boolean arenaOverlaps(Location l1, Location l2, Location p1, Location p2) {
        if (!p1.getWorld().equals(l1.getWorld())) {
            return false;
        }
        double minLX = Math.min(l1.getX(), l2.getX());
        double minLY = Math.min(l1.getY(), l2.getY());
        double minLZ = Math.min(l1.getZ(), l2.getZ());
        double maxLX = Math.max(l1.getX(), l2.getX());
        double maxLY = Math.max(l1.getY(), l2.getY());
        double maxLZ = Math.max(l1.getZ(), l2.getZ());
        double minPX = Math.min(p1.getX(), p2.getX());
        double minPY = Math.min(p1.getY(), p2.getY());
        double minPZ = Math.min(p1.getZ(), p2.getZ());
        double maxPX = Math.max(p1.getX(), p2.getX());
        double maxPY = Math.max(p1.getY(), p2.getY());
        double maxPZ = Math.max(p1.getZ(), p2.getZ());
        return minLX < maxPX && maxLX > minPX && minLY < maxPY && maxLY > minPY && minLZ < maxPZ && maxLZ > minPZ;
    }

    public static boolean isChunkInArea(Chunk l, Location p1, Location p2) {
        if (!p1.getWorld().equals(l.getWorld())) {
            return false;
        }
        Chunk min = new Location(p1.getWorld(), Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ())).getChunk();
        Chunk max = new Location(p1.getWorld(), Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ())).getChunk();
        return min.getX() <= l.getX() && min.getZ() <= l.getZ() && max.getX() >= l.getX() && max.getZ() >= l.getZ();
    }
}

