/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.game;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scoreboard.Scoreboard;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.StoredInventory;
import org.screamingsandals.bedwars.lib.nms.entity.PlayerUtils;
import org.screamingsandals.bedwars.utils.BungeeUtils;

public class GamePlayer {
    public final Player player;
    private Game game = null;
    private String latestGame = null;
    private StoredInventory oldInventory = new StoredInventory();
    private List<Player> hiddenPlayers = new ArrayList<Player>();
    private Scoreboard scoreboard;
    public boolean isSpectator = false;
    public boolean isTeleportingFromGame_justForInventoryPlugins = false;
    public boolean mainLobbyUsed = false;
    public boolean forceSynchronousTeleportation = false;

    public GamePlayer(Player player) {
        this.player = player;
    }

    public void changeGame(Game game) {
        if (this.game != null && game == null) {
            this.game.internalLeavePlayer(this);
            this.game = null;
            this.isSpectator = false;
            this.clean();
            if (Game.isBungeeEnabled()) {
                BungeeUtils.movePlayerToBungeeServer(this.player, Main.isDisabling());
            } else {
                this.restoreInv();
            }
        } else if (this.game == null && game != null) {
            this.storeInv();
            this.clean();
            this.game = game;
            this.isSpectator = false;
            this.mainLobbyUsed = false;
            this.game.internalJoinPlayer(this);
            if (this.game != null) {
                this.latestGame = this.game.getName();
            }
        } else if (this.game != null) {
            this.game.internalLeavePlayer(this);
            this.game = game;
            this.isSpectator = false;
            this.clean();
            this.mainLobbyUsed = false;
            this.game.internalJoinPlayer(this);
            if (this.game != null) {
                this.latestGame = this.game.getName();
            }
        }
    }

    public Game getGame() {
        return this.game;
    }

    public String getLatestGameName() {
        return this.latestGame;
    }

    public boolean isInGame() {
        return this.game != null;
    }

    public boolean canJoinFullGame() {
        return this.player.hasPermission("bw.vip.forcejoin") || this.player.hasPermission("misat11.bw.vip.forcejoin");
    }

    public void storeInv() {
        this.oldInventory.inventory = this.player.getInventory().getContents();
        this.oldInventory.armor = this.player.getInventory().getArmorContents();
        this.oldInventory.xp = this.player.getExp();
        this.oldInventory.effects = this.player.getActivePotionEffects();
        this.oldInventory.mode = this.player.getGameMode();
        this.oldInventory.leftLocation = this.player.getLocation();
        this.oldInventory.level = this.player.getLevel();
        this.oldInventory.listName = this.player.getPlayerListName();
        this.oldInventory.displayName = this.player.getDisplayName();
        this.oldInventory.foodLevel = this.player.getFoodLevel();
        if (Main.getConfigurator().config.getBoolean("remember-what-scoreboards-players-had-before")) {
            this.scoreboard = this.player.getScoreboard();
        }
    }

    public void restoreInv() {
        this.isTeleportingFromGame_justForInventoryPlugins = true;
        if (!this.mainLobbyUsed) {
            this.teleport(this.oldInventory.leftLocation, this::restoreRest);
        } else {
            this.mainLobbyUsed = false;
            this.restoreRest();
        }
    }

    private void restoreRest() {
        this.player.getInventory().setContents(this.oldInventory.inventory);
        this.player.getInventory().setArmorContents(this.oldInventory.armor);
        this.player.setLevel(this.oldInventory.level);
        this.player.setExp(this.oldInventory.xp);
        this.player.setFoodLevel(this.oldInventory.foodLevel);
        for (PotionEffect e : this.player.getActivePotionEffects()) {
            this.player.removePotionEffect(e.getType());
        }
        this.player.addPotionEffects(this.oldInventory.effects);
        this.player.setPlayerListName(this.oldInventory.listName);
        this.player.setDisplayName(this.oldInventory.displayName);
        this.player.setGameMode(this.oldInventory.mode);
        this.player.setAllowFlight(this.oldInventory.mode == GameMode.CREATIVE || this.oldInventory.mode == GameMode.SPECTATOR);
        this.player.updateInventory();
        this.player.resetPlayerTime();
        this.player.resetPlayerWeather();
        if (this.scoreboard != null) {
            this.player.setScoreboard(this.scoreboard);
            this.scoreboard = null;
        }
    }

    public void resetLife() {
        this.player.setAllowFlight(false);
        this.player.setFlying(false);
        this.player.setExp(0.0f);
        this.player.setLevel(0);
        this.player.setSneaking(false);
        this.player.setSprinting(false);
        this.player.setFoodLevel(20);
        this.player.setSaturation(10.0f);
        this.player.setExhaustion(0.0f);
        this.player.setMaxHealth(20.0);
        this.player.setHealth(this.player.getMaxHealth());
        this.player.setFireTicks(0);
        this.player.setFallDistance(0.0f);
        this.player.setGameMode(GameMode.SURVIVAL);
        if (this.player.isInsideVehicle()) {
            this.player.leaveVehicle();
        }
        for (PotionEffect e : this.player.getActivePotionEffects()) {
            this.player.removePotionEffect(e.getType());
        }
    }

    public void invClean() {
        PlayerInventory inv = this.player.getInventory();
        inv.setArmorContents(new ItemStack[4]);
        inv.setContents(new ItemStack[0]);
        this.player.updateInventory();
    }

    public void clean() {
        this.invClean();
        this.resetLife();
        new ArrayList<Player>(this.hiddenPlayers).forEach(this::showPlayer);
    }

    public boolean teleport(Location location) {
        if (this.forceSynchronousTeleportation) {
            return this.player.teleport(location);
        }
        return PlayerUtils.teleportPlayer(this.player, location);
    }

    public boolean teleport(Location location, Runnable runnable) {
        if (this.forceSynchronousTeleportation) {
            boolean result = this.player.teleport(location);
            runnable.run();
            return result;
        }
        return PlayerUtils.teleportPlayer(this.player, location, runnable);
    }

    public void hidePlayer(Player player) {
        if (!this.hiddenPlayers.contains(player) && !player.equals(this.player)) {
            this.hiddenPlayers.add(player);
            try {
                this.player.hidePlayer((Plugin)Main.getInstance(), player);
            }
            catch (Throwable t) {
                this.player.hidePlayer(player);
            }
        }
    }

    public void showPlayer(Player player) {
        if (this.hiddenPlayers.contains(player) && !player.equals(this.player)) {
            this.hiddenPlayers.remove(player);
            try {
                this.player.showPlayer((Plugin)Main.getInstance(), player);
            }
            catch (Throwable t) {
                this.player.showPlayer(player);
            }
        }
    }
}

