/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.game;

import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.utils.CitizensUtils;

public class GameStore
implements org.screamingsandals.bedwars.api.game.GameStore {
    private final Location loc;
    private final String shop;
    private final String shopName;
    private final boolean enableCustomName;
    private final boolean useParent;
    private Team team;
    private LivingEntity entity;
    private EntityType type;
    private boolean isBaby;
    private String skinName;

    public GameStore(Location loc, String shop, boolean useParent, String shopName, boolean enableCustomName, boolean isBaby) {
        this(loc, shop, useParent, EntityType.VILLAGER, shopName, enableCustomName, isBaby, null, null);
    }

    public GameStore(Location loc, String shop, boolean useParent, EntityType type, String shopName, boolean enableCustomName, boolean isBaby, String skinName, Team team) {
        if (type == null || !type.isAlive()) {
            type = EntityType.VILLAGER;
        }
        this.loc = loc;
        this.shop = shop;
        this.useParent = useParent;
        this.type = type;
        this.shopName = shopName;
        this.enableCustomName = enableCustomName;
        this.isBaby = isBaby;
        this.skinName = skinName;
        this.team = team;
    }

    public LivingEntity spawn() {
        if (this.entity == null && this.loc != null) {
            EntityType typ = this.type;
            if (typ == EntityType.PLAYER) {
                LivingEntity npc;
                if (Bukkit.getPluginManager().isPluginEnabled("Citizens") && (npc = CitizensUtils.spawnNPC(this)) != null) {
                    this.entity = npc;
                    return npc;
                }
                typ = EntityType.VILLAGER;
            }
            try {
                this.entity = (LivingEntity)this.loc.getWorld().spawnEntity(this.loc, typ, CreatureSpawnEvent.SpawnReason.CUSTOM);
            }
            catch (Throwable throwable) {
                this.entity = (LivingEntity)this.loc.getWorld().spawnEntity(this.loc, typ);
            }
            this.entity.setRemoveWhenFarAway(false);
            try {
                this.entity.setSilent(Main.getConfigurator().config.getBoolean("shopkeepers-are-silent"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.enableCustomName) {
                this.entity.setCustomName(this.shopName);
                this.entity.setCustomNameVisible(true);
            }
            if (this.entity instanceof Villager) {
                ((Villager)this.entity).setProfession(Villager.Profession.FARMER);
            }
            if (this.entity instanceof Ageable) {
                if (this.isBaby) {
                    ((Ageable)this.entity).setBaby();
                } else {
                    ((Ageable)this.entity).setAdult();
                }
            } else {
                try {
                    this.entity.getClass().getMethod("setBaby", Boolean.TYPE).invoke((Object)this.entity, this.isBaby);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.entity;
    }

    public LivingEntity kill() {
        LivingEntity livingEntity = this.entity;
        if (this.entity != null) {
            Chunk chunk = this.entity.getLocation().getChunk();
            if (!chunk.isLoaded()) {
                chunk.load();
            }
            this.entity.remove();
            if (Bukkit.getPluginManager().isPluginEnabled("Citizens")) {
                CitizensUtils.remove((Entity)this.entity);
            }
            this.entity = null;
        }
        return livingEntity;
    }

    @Override
    @Nullable
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public EntityType getEntityType() {
        return this.type;
    }

    public void setEntityType(EntityType type) {
        if (type != null && type.isAlive()) {
            this.type = type;
        }
    }

    public void setEntityTypeNPC(String skinName) {
        this.type = EntityType.PLAYER;
        this.skinName = skinName;
    }

    @Override
    public Location getStoreLocation() {
        return this.loc;
    }

    @Override
    @Nullable
    public String getShopFile() {
        return this.shop;
    }

    @Override
    @Nullable
    public String getShopCustomName() {
        return this.shopName;
    }

    @Override
    public boolean getUseParent() {
        return this.useParent && this.shop != null;
    }

    @Override
    public boolean isShopCustomName() {
        return this.enableCustomName;
    }

    @Override
    public boolean isBaby() {
        return this.isBaby;
    }

    public void setBaby(boolean isBaby) {
        this.isBaby = isBaby;
    }

    @Override
    @Nullable
    public String getSkinName() {
        return this.skinName;
    }

    @Override
    @Nullable
    public Team getTeam() {
        return this.team;
    }

    public void setTeam(@Nullable Team team) {
        this.team = team;
    }
}

